/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.Aggregation;
import ai.rapids.cudf.AggregationOverWindow;
import ai.rapids.cudf.WindowOptions;

public class AggregationOnColumn<T extends Aggregation>
extends Aggregation {
    protected final T wrapped;
    protected final int columnIndex;

    AggregationOnColumn(T wrapped, int columnIndex) {
        super(((Aggregation)wrapped).kind);
        this.wrapped = wrapped;
        this.columnIndex = columnIndex;
    }

    @Override
    public AggregationOnColumn<T> onColumn(int columnIndex) {
        if (columnIndex == this.getColumnIndex()) {
            return this;
        }
        return new AggregationOnColumn<T>(this.wrapped, columnIndex);
    }

    public <R extends Aggregation> AggregationOverWindow<R> overWindow(WindowOptions windowOptions) {
        return new AggregationOverWindow<T>(this.wrapped, this.columnIndex, windowOptions);
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    long createNativeInstance() {
        return ((Aggregation)this.wrapped).createNativeInstance();
    }

    @Override
    long getDefaultOutput() {
        return ((Aggregation)this.wrapped).getDefaultOutput();
    }

    @Override
    public int hashCode() {
        return 31 * ((Aggregation)this.wrapped).hashCode() + this.columnIndex;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof AggregationOnColumn) {
            AggregationOnColumn o = (AggregationOnColumn)other;
            return ((Aggregation)this.wrapped).equals(o.wrapped) && this.columnIndex == o.columnIndex;
        }
        return false;
    }
}

