/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.Aggregation;
import ai.rapids.cudf.AggregationOnColumn;
import ai.rapids.cudf.WindowOptions;

public class AggregationOverWindow<T extends Aggregation>
extends AggregationOnColumn<T> {
    protected final WindowOptions windowOptions;

    AggregationOverWindow(T wrapped, int columnIndex, WindowOptions windowOptions) {
        super(wrapped, columnIndex);
        this.windowOptions = windowOptions;
        if (windowOptions == null) {
            throw new IllegalArgumentException("WindowOptions cannot be null!");
        }
        if (windowOptions.getPrecedingCol() != null || windowOptions.getFollowingCol() != null) {
            throw new UnsupportedOperationException("Dynamic windows (via columns) are currently unsupported!");
        }
    }

    public WindowOptions getWindowOptions() {
        return this.windowOptions;
    }

    @Override
    public AggregationOnColumn<T> onColumn(int columnIndex) {
        if (columnIndex == this.getColumnIndex()) {
            return this;
        }
        return new AggregationOverWindow<Aggregation>(this.wrapped, columnIndex, this.windowOptions);
    }

    @Override
    public AggregationOverWindow<T> overWindow(WindowOptions windowOptions) {
        if (this.windowOptions.equals(windowOptions)) {
            return this;
        }
        return new AggregationOverWindow<Aggregation>(this.wrapped, this.columnIndex, windowOptions);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.windowOptions.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof AggregationOnColumn) {
            AggregationOnColumn o = (AggregationOnColumn)other;
            return this.wrapped.equals(o.wrapped) && this.columnIndex == o.columnIndex;
        }
        return false;
    }
}

