/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.HostColumnVector;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public final class ArrowColumnBuilder
implements AutoCloseable {
    private DType type;
    private final ArrayList<ByteBuffer> data = new ArrayList();
    private final ArrayList<ByteBuffer> validity = new ArrayList();
    private final ArrayList<ByteBuffer> offsets = new ArrayList();
    private final ArrayList<Long> nullCount = new ArrayList();
    private final ArrayList<Long> rows = new ArrayList();

    public ArrowColumnBuilder(HostColumnVector.DataType type) {
        this.type = type.getType();
    }

    public void addBatch(long rows, long nullCount, ByteBuffer data, ByteBuffer validity, ByteBuffer offsets) {
        this.rows.add(rows);
        this.nullCount.add(nullCount);
        this.data.add(data);
        this.validity.add(validity);
        this.offsets.add(offsets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ColumnVector buildAndPutOnDevice() {
        ColumnVector vecRet;
        block7: {
            int numBatches = this.rows.size();
            ArrayList<ColumnVector> allVecs = new ArrayList<ColumnVector>(numBatches);
            try {
                for (int i = 0; i < numBatches; ++i) {
                    allVecs.add(ColumnVector.fromArrow(this.type, (long)this.rows.get(i), (long)this.nullCount.get(i), this.data.get(i), this.validity.get(i), this.offsets.get(i)));
                }
                if (numBatches == 1) {
                    vecRet = (ColumnVector)allVecs.get(0);
                    break block7;
                }
                if (numBatches > 1) {
                    vecRet = ColumnVector.concatenate(allVecs.toArray(new ColumnVector[0]));
                    break block7;
                }
                throw new IllegalStateException("Can't build a ColumnVector when no Arrow batches specified");
            }
            finally {
                if (numBatches > 1) {
                    allVecs.forEach(cv -> cv.close());
                }
            }
        }
        return vecRet;
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "ArrowColumnBuilder{type=" + this.type + ", data=" + this.data + ", validity=" + this.validity + ", offsets=" + this.offsets + ", nullCount=" + this.nullCount + ", rows=" + this.rows + '}';
    }
}

