/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.Table;
import ai.rapids.cudf.WriterOptions;

public class ArrowIPCWriterOptions
extends WriterOptions {
    private final long size;
    private final DoneOnGpu callback;
    public static final ArrowIPCWriterOptions DEFAULT = new ArrowIPCWriterOptions(new Builder());

    private ArrowIPCWriterOptions(Builder builder) {
        super(builder);
        this.size = builder.size;
        this.callback = builder.callback;
    }

    public long getMaxChunkSize() {
        return this.size;
    }

    public DoneOnGpu getCallback() {
        return this.callback;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends WriterOptions.WriterBuilder<Builder> {
        private long size = -1L;
        private DoneOnGpu callback = ignored -> {};

        public Builder withMaxChunkSize(long size) {
            this.size = size;
            return this;
        }

        public Builder withCallback(DoneOnGpu callback) {
            this.callback = callback == null ? ignored -> {} : callback;
            return this;
        }

        @Override
        public Builder withColumnNames(String ... columnNames) {
            return (Builder)super.withColumnNames(columnNames);
        }

        @Override
        public Builder withNotNullableColumnNames(String ... columnNames) {
            return (Builder)super.withNotNullableColumnNames(columnNames);
        }

        public ArrowIPCWriterOptions build() {
            return new ArrowIPCWriterOptions(this);
        }
    }

    public static interface DoneOnGpu {
        public void doneWithTheGpu(Table var1);
    }
}

