/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.BinaryOp;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.ColumnView;
import ai.rapids.cudf.DType;

public interface BinaryOperable {
    public static DType implicitConversion(BinaryOp op, BinaryOperable lhs, BinaryOperable rhs) {
        DType a = lhs.getType();
        DType b = rhs.getType();
        if (a.equals(DType.FLOAT64) || b.equals(DType.FLOAT64)) {
            return DType.FLOAT64;
        }
        if (a.equals(DType.FLOAT32) || b.equals(DType.FLOAT32)) {
            return DType.FLOAT32;
        }
        if (a.equals(DType.UINT64) || b.equals(DType.UINT64)) {
            return DType.UINT64;
        }
        if (a.equals(DType.INT64) || b.equals(DType.INT64) || a.equals(DType.TIMESTAMP_MILLISECONDS) || b.equals(DType.TIMESTAMP_MILLISECONDS) || a.equals(DType.TIMESTAMP_MICROSECONDS) || b.equals(DType.TIMESTAMP_MICROSECONDS) || a.equals(DType.TIMESTAMP_SECONDS) || b.equals(DType.TIMESTAMP_SECONDS) || a.equals(DType.TIMESTAMP_NANOSECONDS) || b.equals(DType.TIMESTAMP_NANOSECONDS)) {
            return DType.INT64;
        }
        if (a.equals(DType.UINT32) || b.equals(DType.UINT32)) {
            return DType.UINT32;
        }
        if (a.equals(DType.INT32) || b.equals(DType.INT32) || a.equals(DType.TIMESTAMP_DAYS) || b.equals(DType.TIMESTAMP_DAYS)) {
            return DType.INT32;
        }
        if (a.equals(DType.UINT16) || b.equals(DType.UINT16)) {
            return DType.UINT16;
        }
        if (a.equals(DType.INT16) || b.equals(DType.INT16)) {
            return DType.INT16;
        }
        if (a.equals(DType.UINT8) || b.equals(DType.UINT8)) {
            return DType.UINT8;
        }
        if (a.equals(DType.INT8) || b.equals(DType.INT8)) {
            return DType.INT8;
        }
        if (a.equals(DType.BOOL8) || b.equals(DType.BOOL8)) {
            return DType.BOOL8;
        }
        if (a.isDecimalType() && b.isDecimalType()) {
            boolean scale = false;
            if (a.typeId == DType.DTypeEnum.DECIMAL32) {
                if (b.typeId == DType.DTypeEnum.DECIMAL32) {
                    return DType.create(DType.DTypeEnum.DECIMAL32, ColumnView.getFixedPointOutputScale(op, lhs.getType(), rhs.getType()));
                }
                throw new IllegalArgumentException("Both columns must be of the same fixed_point type");
            }
            if (a.typeId == DType.DTypeEnum.DECIMAL64) {
                if (b.typeId == DType.DTypeEnum.DECIMAL64) {
                    return DType.create(DType.DTypeEnum.DECIMAL64, ColumnView.getFixedPointOutputScale(op, lhs.getType(), rhs.getType()));
                }
                throw new IllegalArgumentException("Both columns must be of the same fixed_point type");
            }
        }
        throw new IllegalArgumentException("Unsupported types " + a + " and " + b);
    }

    public DType getType();

    public ColumnVector binaryOp(BinaryOp var1, BinaryOperable var2, DType var3);

    default public ColumnVector add(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.ADD, rhs, outType);
    }

    default public ColumnVector add(BinaryOperable rhs) {
        return this.add(rhs, BinaryOperable.implicitConversion(BinaryOp.ADD, this, rhs));
    }

    default public ColumnVector sub(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.SUB, rhs, outType);
    }

    default public ColumnVector sub(BinaryOperable rhs) {
        return this.sub(rhs, BinaryOperable.implicitConversion(BinaryOp.SUB, this, rhs));
    }

    default public ColumnVector mul(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.MUL, rhs, outType);
    }

    default public ColumnVector mul(BinaryOperable rhs) {
        return this.mul(rhs, BinaryOperable.implicitConversion(BinaryOp.MUL, this, rhs));
    }

    default public ColumnVector div(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.DIV, rhs, outType);
    }

    default public ColumnVector div(BinaryOperable rhs) {
        return this.div(rhs, BinaryOperable.implicitConversion(BinaryOp.DIV, this, rhs));
    }

    default public ColumnVector trueDiv(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.TRUE_DIV, rhs, outType);
    }

    default public ColumnVector trueDiv(BinaryOperable rhs) {
        return this.trueDiv(rhs, BinaryOperable.implicitConversion(BinaryOp.TRUE_DIV, this, rhs));
    }

    default public ColumnVector floorDiv(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.FLOOR_DIV, rhs, outType);
    }

    default public ColumnVector floorDiv(BinaryOperable rhs) {
        return this.floorDiv(rhs, BinaryOperable.implicitConversion(BinaryOp.FLOOR_DIV, this, rhs));
    }

    default public ColumnVector mod(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.MOD, rhs, outType);
    }

    default public ColumnVector mod(BinaryOperable rhs) {
        return this.mod(rhs, BinaryOperable.implicitConversion(BinaryOp.MOD, this, rhs));
    }

    default public ColumnVector pow(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.POW, rhs, outType);
    }

    default public ColumnVector pow(BinaryOperable rhs) {
        return this.pow(rhs, BinaryOperable.implicitConversion(BinaryOp.POW, this, rhs));
    }

    default public ColumnVector equalTo(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.EQUAL, rhs, outType);
    }

    default public ColumnVector equalTo(BinaryOperable rhs) {
        return this.equalTo(rhs, DType.BOOL8);
    }

    default public ColumnVector notEqualTo(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.NOT_EQUAL, rhs, outType);
    }

    default public ColumnVector notEqualTo(BinaryOperable rhs) {
        return this.notEqualTo(rhs, DType.BOOL8);
    }

    default public ColumnVector lessThan(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.LESS, rhs, outType);
    }

    default public ColumnVector lessThan(BinaryOperable rhs) {
        return this.lessThan(rhs, DType.BOOL8);
    }

    default public ColumnVector greaterThan(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.GREATER, rhs, outType);
    }

    default public ColumnVector greaterThan(BinaryOperable rhs) {
        return this.greaterThan(rhs, DType.BOOL8);
    }

    default public ColumnVector lessOrEqualTo(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.LESS_EQUAL, rhs, outType);
    }

    default public ColumnVector lessOrEqualTo(BinaryOperable rhs) {
        return this.lessOrEqualTo(rhs, DType.BOOL8);
    }

    default public ColumnVector greaterOrEqualTo(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.GREATER_EQUAL, rhs, outType);
    }

    default public ColumnVector greaterOrEqualTo(BinaryOperable rhs) {
        return this.greaterOrEqualTo(rhs, DType.BOOL8);
    }

    default public ColumnVector bitAnd(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.BITWISE_AND, rhs, outType);
    }

    default public ColumnVector bitAnd(BinaryOperable rhs) {
        return this.bitAnd(rhs, BinaryOperable.implicitConversion(BinaryOp.BITWISE_AND, this, rhs));
    }

    default public ColumnVector bitOr(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.BITWISE_OR, rhs, outType);
    }

    default public ColumnVector bitOr(BinaryOperable rhs) {
        return this.bitOr(rhs, BinaryOperable.implicitConversion(BinaryOp.BITWISE_OR, this, rhs));
    }

    default public ColumnVector bitXor(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.BITWISE_XOR, rhs, outType);
    }

    default public ColumnVector bitXor(BinaryOperable rhs) {
        return this.bitXor(rhs, BinaryOperable.implicitConversion(BinaryOp.BITWISE_XOR, this, rhs));
    }

    default public ColumnVector and(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.LOGICAL_AND, rhs, outType);
    }

    default public ColumnVector and(BinaryOperable rhs) {
        return this.and(rhs, BinaryOperable.implicitConversion(BinaryOp.LOGICAL_AND, this, rhs));
    }

    default public ColumnVector or(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.LOGICAL_OR, rhs, outType);
    }

    default public ColumnVector or(BinaryOperable rhs) {
        return this.or(rhs, BinaryOperable.implicitConversion(BinaryOp.LOGICAL_OR, this, rhs));
    }

    default public ColumnVector shiftLeft(BinaryOperable shiftBy, DType outType) {
        return this.binaryOp(BinaryOp.SHIFT_LEFT, shiftBy, outType);
    }

    default public ColumnVector shiftLeft(BinaryOperable shiftBy) {
        return this.shiftLeft(shiftBy, BinaryOperable.implicitConversion(BinaryOp.SHIFT_LEFT, this, shiftBy));
    }

    default public ColumnVector shiftRight(BinaryOperable shiftBy, DType outType) {
        return this.binaryOp(BinaryOp.SHIFT_RIGHT, shiftBy, outType);
    }

    default public ColumnVector shiftRight(BinaryOperable shiftBy) {
        return this.shiftRight(shiftBy, BinaryOperable.implicitConversion(BinaryOp.SHIFT_RIGHT, this, shiftBy));
    }

    default public ColumnVector shiftRightUnsigned(BinaryOperable shiftBy, DType outType) {
        return this.binaryOp(BinaryOp.SHIFT_RIGHT_UNSIGNED, shiftBy, outType);
    }

    default public ColumnVector shiftRightUnsigned(BinaryOperable shiftBy) {
        return this.shiftRightUnsigned(shiftBy, BinaryOperable.implicitConversion(BinaryOp.SHIFT_RIGHT_UNSIGNED, this, shiftBy));
    }

    default public ColumnVector log(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.LOG_BASE, rhs, outType);
    }

    default public ColumnVector log(BinaryOperable rhs) {
        return this.log(rhs, this.getType());
    }

    default public ColumnVector arctan2(BinaryOperable xCoordinate, DType outType) {
        return this.binaryOp(BinaryOp.ATAN2, xCoordinate, outType);
    }

    default public ColumnVector arctan2(BinaryOperable xCoordinate) {
        return this.arctan2(xCoordinate, BinaryOperable.implicitConversion(BinaryOp.ATAN2, this, xCoordinate));
    }

    default public ColumnVector pmod(BinaryOperable rhs, DType outputType) {
        return this.binaryOp(BinaryOp.PMOD, rhs, outputType);
    }

    default public ColumnVector pmod(BinaryOperable rhs) {
        return this.pmod(rhs, BinaryOperable.implicitConversion(BinaryOp.PMOD, this, rhs));
    }

    default public ColumnVector equalToNullAware(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.NULL_EQUALS, rhs, outType);
    }

    default public ColumnVector equalToNullAware(BinaryOperable rhs) {
        return this.equalToNullAware(rhs, DType.BOOL8);
    }

    default public ColumnVector maxNullAware(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.NULL_MAX, rhs, outType);
    }

    default public ColumnVector maxNullAware(BinaryOperable rhs) {
        return this.maxNullAware(rhs, BinaryOperable.implicitConversion(BinaryOp.NULL_MAX, this, rhs));
    }

    default public ColumnVector minNullAware(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.NULL_MIN, rhs, outType);
    }

    default public ColumnVector minNullAware(BinaryOperable rhs) {
        return this.minNullAware(rhs, BinaryOperable.implicitConversion(BinaryOp.NULL_MIN, this, rhs));
    }
}

