/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.ColumnFilterOptions;
import java.util.HashSet;
import java.util.Set;

public class CSVOptions
extends ColumnFilterOptions {
    public static CSVOptions DEFAULT = new CSVOptions(new Builder());
    private final int headerRow;
    private final byte delim;
    private final byte quote;
    private final byte comment;
    private final String[] nullValues;
    private final String[] trueValues;
    private final String[] falseValues;

    private CSVOptions(Builder builder) {
        super(builder);
        this.headerRow = builder.headerRow;
        this.delim = builder.delim;
        this.quote = builder.quote;
        this.comment = builder.comment;
        this.nullValues = builder.nullValues.toArray(new String[builder.nullValues.size()]);
        this.trueValues = builder.trueValues.toArray(new String[builder.trueValues.size()]);
        this.falseValues = builder.falseValues.toArray(new String[builder.falseValues.size()]);
    }

    String[] getNullValues() {
        return this.nullValues;
    }

    String[] getTrueValues() {
        return this.trueValues;
    }

    String[] getFalseValues() {
        return this.falseValues;
    }

    int getHeaderRow() {
        return this.headerRow;
    }

    byte getDelim() {
        return this.delim;
    }

    byte getQuote() {
        return this.quote;
    }

    byte getComment() {
        return this.comment;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ColumnFilterOptions.Builder<Builder> {
        private static final int NO_HEADER_ROW = -1;
        private final Set<String> nullValues = new HashSet<String>();
        private final Set<String> trueValues = new HashSet<String>();
        private final Set<String> falseValues = new HashSet<String>();
        private byte comment = 0;
        private int headerRow = -1;
        private byte delim = (byte)44;
        private byte quote = (byte)34;

        public Builder withHeaderAtRow(int index) {
            this.headerRow = index;
            return this;
        }

        public Builder hasHeader(boolean hasHeader) {
            return this.withHeaderAtRow(hasHeader ? 0 : -1);
        }

        public Builder hasHeader() {
            return this.withHeaderAtRow(0);
        }

        public Builder withDelim(char delim) {
            if (Character.getNumericValue(delim) > 127) {
                throw new IllegalArgumentException("Only ASCII characters are currently supported");
            }
            this.delim = (byte)delim;
            return this;
        }

        public Builder withQuote(char quote) {
            if (Character.getNumericValue(quote) > 127) {
                throw new IllegalArgumentException("Only ASCII characters are currently supported");
            }
            this.quote = (byte)quote;
            return this;
        }

        public Builder withComment(char comment) {
            if (Character.getNumericValue(this.quote) > 127) {
                throw new IllegalArgumentException("Only ASCII characters are currently supported");
            }
            this.comment = (byte)comment;
            return this;
        }

        public Builder withoutComments() {
            this.comment = 0;
            return this;
        }

        public Builder withNullValue(String ... nvs) {
            for (String nv : nvs) {
                this.nullValues.add(nv);
            }
            return this;
        }

        public Builder withTrueValue(String ... tvs) {
            for (String tv : tvs) {
                this.trueValues.add(tv);
            }
            return this;
        }

        public Builder withFalseValue(String ... fvs) {
            for (String fv : fvs) {
                this.falseValues.add(fv);
            }
            return this;
        }

        public CSVOptions build() {
            return new CSVOptions(this);
        }
    }
}

