/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class ColumnFilterOptions {
    private final String[] includeColumnNames;

    protected ColumnFilterOptions(Builder<?> builder) {
        this.includeColumnNames = builder.includeColumnNames.toArray(new String[builder.includeColumnNames.size()]);
    }

    String[] getIncludeColumnNames() {
        return this.includeColumnNames;
    }

    public static class Builder<T extends Builder> {
        final List<String> includeColumnNames = new ArrayList<String>();

        public T includeColumn(String ... names) {
            for (String name : names) {
                this.includeColumnNames.add(name);
            }
            return (T)this;
        }

        public T includeColumn(Collection<String> names) {
            this.includeColumnNames.addAll(names);
            return (T)this;
        }
    }
}

