/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.BaseDeviceMemoryBuffer;
import ai.rapids.cudf.BufferType;
import ai.rapids.cudf.ColumnView;
import ai.rapids.cudf.CudfException;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.DeviceMemoryBuffer;
import ai.rapids.cudf.HashType;
import ai.rapids.cudf.HostColumnVector;
import ai.rapids.cudf.MemoryBuffer;
import ai.rapids.cudf.MemoryCleaner;
import ai.rapids.cudf.NativeDepsLoader;
import ai.rapids.cudf.Scalar;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ColumnVector
extends ColumnView {
    private static final Logger log = LoggerFactory.getLogger(ColumnVector.class);
    private final OffHeapState offHeap;
    private Optional<Long> nullCount = Optional.empty();
    private int refCount;

    public ColumnVector(long nativePointer) {
        super(ColumnVector.getColumnViewFromColumn(nativePointer));
        assert (nativePointer != 0L);
        this.offHeap = new OffHeapState(nativePointer);
        MemoryCleaner.register(this, (MemoryCleaner.Cleaner)this.offHeap);
        this.refCount = 0;
        this.incRefCountInternal(true);
    }

    public ColumnVector(DType type, long rows, Optional<Long> nullCount, DeviceMemoryBuffer dataBuffer, DeviceMemoryBuffer validityBuffer, DeviceMemoryBuffer offsetBuffer) {
        super(ColumnVector.initViewHandle(type, (int)rows, nullCount.orElse(-1L).intValue(), dataBuffer, validityBuffer, offsetBuffer, null));
        assert (!type.equals(DType.LIST)) : "This constructor should not be used for list type";
        if (!type.equals(DType.STRING)) assert (offsetBuffer == null) : "offsets are only supported for STRING";
        assert (nullCount.isPresent() && nullCount.get() <= Integer.MAX_VALUE || !nullCount.isPresent());
        this.offHeap = new OffHeapState(type, (int)rows, dataBuffer, validityBuffer, offsetBuffer, null, this.viewHandle);
        MemoryCleaner.register(this, (MemoryCleaner.Cleaner)this.offHeap);
        this.nullCount = nullCount;
        this.refCount = 0;
        this.incRefCountInternal(true);
    }

    public ColumnVector(DType type, long rows, Optional<Long> nullCount, DeviceMemoryBuffer dataBuffer, DeviceMemoryBuffer validityBuffer, DeviceMemoryBuffer offsetBuffer, List<DeviceMemoryBuffer> toClose, long[] childHandles) {
        super(ColumnVector.initViewHandle(type, (int)rows, nullCount.orElse(-1L).intValue(), dataBuffer, validityBuffer, offsetBuffer, childHandles));
        if (!type.equals(DType.STRING) && !type.equals(DType.LIST)) assert (offsetBuffer == null) : "offsets are only supported for STRING, LISTS";
        assert (nullCount.isPresent() && nullCount.get() <= Integer.MAX_VALUE || !nullCount.isPresent());
        this.offHeap = new OffHeapState(type, (int)rows, dataBuffer, validityBuffer, offsetBuffer, toClose, this.viewHandle);
        MemoryCleaner.register(this, (MemoryCleaner.Cleaner)this.offHeap);
        this.refCount = 0;
        this.incRefCountInternal(true);
    }

    private ColumnVector(long viewAddress, DeviceMemoryBuffer contiguousBuffer) {
        super(viewAddress);
        this.offHeap = new OffHeapState(viewAddress, contiguousBuffer);
        MemoryCleaner.register(this, (MemoryCleaner.Cleaner)this.offHeap);
        this.nullCount = Optional.empty();
        this.refCount = 0;
        this.incRefCountInternal(true);
    }

    private static long getColumnViewFromColumn(long nativePointer) {
        try {
            return ColumnVector.getNativeColumnView(nativePointer);
        }
        catch (CudfException ce) {
            ColumnVector.deleteCudfColumn(nativePointer);
            throw ce;
        }
    }

    static long initViewHandle(DType type, int rows, int nc, BaseDeviceMemoryBuffer dataBuffer, BaseDeviceMemoryBuffer validityBuffer, BaseDeviceMemoryBuffer offsetBuffer, long[] childHandles) {
        long cd = dataBuffer == null ? 0L : dataBuffer.address;
        long cdSize = dataBuffer == null ? 0L : dataBuffer.length;
        long od = offsetBuffer == null ? 0L : offsetBuffer.address;
        long vd = validityBuffer == null ? 0L : validityBuffer.address;
        return ColumnVector.makeCudfColumnView(type.typeId.getNativeId(), type.getScale(), cd, cdSize, od, vd, nc, rows, childHandles);
    }

    static ColumnVector fromViewWithContiguousAllocation(long columnViewAddress, DeviceMemoryBuffer buffer) {
        return new ColumnVector(columnViewAddress, buffer);
    }

    public void noWarnLeakExpected() {
        this.offHeap.noWarnLeakExpected();
    }

    @Override
    public synchronized void close() {
        --this.refCount;
        this.offHeap.delRef();
        if (this.refCount == 0) {
            this.offHeap.clean(false);
        } else if (this.refCount < 0) {
            this.offHeap.logRefCountDebug("double free " + this);
            throw new IllegalStateException("Close called too many times " + this);
        }
    }

    @Override
    public String toString() {
        return "ColumnVector{rows=" + this.rows + ", type=" + this.type + ", nullCount=" + this.nullCount + ", offHeap=" + this.offHeap + '}';
    }

    public ColumnVector incRefCount() {
        return this.incRefCountInternal(false);
    }

    private synchronized ColumnVector incRefCountInternal(boolean isFirstTime) {
        this.offHeap.addRef();
        if (this.refCount <= 0 && !isFirstTime) {
            this.offHeap.logRefCountDebug("INC AFTER CLOSE " + this);
            throw new IllegalStateException("Column is already closed");
        }
        ++this.refCount;
        return this;
    }

    @Override
    public long getNullCount() {
        if (!this.nullCount.isPresent()) {
            this.nullCount = Optional.of(this.offHeap.getNativeNullCount());
        }
        return this.nullCount.get();
    }

    synchronized int getRefCount() {
        return this.refCount;
    }

    public boolean hasValidityVector() {
        return this.offHeap.getValid() != null;
    }

    public boolean hasNulls() {
        return this.getNullCount() > 0L;
    }

    public BaseDeviceMemoryBuffer getDeviceBufferFor(BufferType type) {
        BaseDeviceMemoryBuffer srcBuffer;
        switch (type) {
            case VALIDITY: {
                srcBuffer = this.offHeap.getValid();
                break;
            }
            case DATA: {
                srcBuffer = this.offHeap.getData();
                break;
            }
            case OFFSET: {
                srcBuffer = this.offHeap.getOffsets();
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)type) + " is not a supported buffer type.");
            }
        }
        return srcBuffer;
    }

    private static ByteBuffer bufferAsDirect(ByteBuffer buf) {
        ByteBuffer bufferOut = buf;
        if (bufferOut != null && !bufferOut.isDirect()) {
            bufferOut = ByteBuffer.allocateDirect(buf.remaining());
            bufferOut.put(buf);
            bufferOut.flip();
        }
        return bufferOut;
    }

    public static ColumnVector fromArrow(DType type, long numRows, long nullCount, ByteBuffer data, ByteBuffer validity, ByteBuffer offsets) {
        long columnHandle = ColumnVector.fromArrow(type.typeId.getNativeId(), numRows, nullCount, ColumnVector.bufferAsDirect(data), ColumnVector.bufferAsDirect(validity), ColumnVector.bufferAsDirect(offsets));
        ColumnVector vec = new ColumnVector(columnHandle);
        return vec;
    }

    public static ColumnVector fromScalar(Scalar scalar, int rows) {
        long columnHandle = ColumnVector.fromScalar(scalar.getScalarHandle(), rows);
        return new ColumnVector(columnHandle);
    }

    public static ColumnVector makeStruct(ColumnView ... columns) {
        try (ColumnView cv = ColumnView.makeStructView(columns);){
            ColumnVector columnVector = cv.copyToColumnVector();
            return columnVector;
        }
    }

    public static ColumnVector makeStruct(long rows, ColumnView ... columns) {
        try (ColumnView cv = ColumnView.makeStructView(rows, columns);){
            ColumnVector columnVector = cv.copyToColumnVector();
            return columnVector;
        }
    }

    public static ColumnVector makeList(ColumnView ... columns) {
        if (columns.length <= 0) {
            throw new IllegalArgumentException("At least one column is needed to get the row count");
        }
        return ColumnVector.makeList(columns[0].getRowCount(), columns[0].getType(), columns);
    }

    public static ColumnVector makeList(long rows, DType type, ColumnView ... columns) {
        long[] handles = new long[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            ColumnView cv = columns[i];
            if (rows != cv.getRowCount()) {
                throw new IllegalArgumentException("All columns must have the same number of rows");
            }
            if (!type.equals(cv.getType())) {
                throw new IllegalArgumentException("All columns must have the same type");
            }
            handles[i] = cv.getNativeView();
        }
        if (columns.length == 0 && type.isNestedType()) {
            throw new IllegalArgumentException("Creating an empty list column of nested types is not currently supported");
        }
        return new ColumnVector(ColumnVector.makeList(handles, type.typeId.nativeId, type.getScale(), rows));
    }

    public static ColumnVector sequence(Scalar initialValue, Scalar step, int rows) {
        if (!initialValue.isValid() || !step.isValid()) {
            throw new IllegalArgumentException("nulls are not supported in sequence");
        }
        return new ColumnVector(ColumnVector.sequence(initialValue.getScalarHandle(), step.getScalarHandle(), rows));
    }

    public static ColumnVector sequence(Scalar initialValue, int rows) {
        if (!initialValue.isValid()) {
            throw new IllegalArgumentException("nulls are not supported in sequence");
        }
        return new ColumnVector(ColumnVector.sequence(initialValue.getScalarHandle(), 0L, rows));
    }

    public static ColumnVector concatenate(ColumnView ... columns) {
        if (columns.length < 2) {
            throw new IllegalArgumentException("Concatenate requires 2 or more columns");
        }
        long[] columnHandles = new long[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            columnHandles[i] = columns[i].getNativeView();
        }
        return new ColumnVector(ColumnVector.concatenate(columnHandles));
    }

    /*
     * Exception decompiling
     */
    public static ColumnVector stringConcatenate(ColumnView[] columns) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ColumnVector stringConcatenate(Scalar separator, Scalar narep, ColumnView[] columns) {
        return ColumnVector.stringConcatenate(separator, narep, columns, true);
    }

    public static ColumnVector stringConcatenate(Scalar separator, Scalar narep, ColumnView[] columns, boolean separateNulls) {
        assert (columns != null) : "input columns should not be null";
        assert (columns.length > 0) : "input columns should not be empty";
        assert (separator != null) : "separator scalar provided may not be null";
        assert (separator.getType().equals(DType.STRING)) : "separator scalar must be a string scalar";
        assert (narep != null) : "narep scalar provided may not be null";
        assert (narep.getType().equals(DType.STRING)) : "narep scalar must be a string scalar";
        long[] columnViews = new long[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            assert (columns[i] != null) : "Column vectors passed may not be null";
            columnViews[i] = columns[i].getNativeView();
        }
        return new ColumnVector(ColumnVector.stringConcatenation(columnViews, separator.getScalarHandle(), narep.getScalarHandle(), separateNulls));
    }

    /*
     * Exception decompiling
     */
    public static ColumnVector stringConcatenate(ColumnView[] columns, ColumnView sepCol) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ColumnVector stringConcatenate(ColumnView[] columns, ColumnView sepCol, Scalar separatorNarep, Scalar colNarep, boolean separateNulls) {
        assert (columns.length >= 1) : ".stringConcatenate() operation requires at least 1 column";
        assert (separatorNarep != null) : "separator narep scalar provided may not be null";
        assert (colNarep != null) : "column narep scalar provided may not be null";
        assert (separatorNarep.getType().equals(DType.STRING)) : "separator naprep scalar must be a string scalar";
        assert (colNarep.getType().equals(DType.STRING)) : "column narep scalar must be a string scalar";
        long[] columnViews = new long[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            assert (columns[i] != null) : "Column vectors passed may not be null";
            columnViews[i] = columns[i].getNativeView();
        }
        return new ColumnVector(ColumnVector.stringConcatenationSepCol(columnViews, sepCol.getNativeView(), separatorNarep.getScalarHandle(), colNarep.getScalarHandle(), separateNulls));
    }

    public static ColumnVector listConcatenateByRow(ColumnView ... columns) {
        return ColumnVector.listConcatenateByRow(false, columns);
    }

    public static ColumnVector listConcatenateByRow(boolean ignoreNull, ColumnView ... columns) {
        assert (columns != null) : "input columns should not be null";
        assert (columns.length > 0) : "input columns should not be empty";
        long[] columnViews = new long[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            columnViews[i] = columns[i].getNativeView();
        }
        return new ColumnVector(ColumnVector.concatListByRow(columnViews, ignoreNull));
    }

    public static ColumnVector md5Hash(ColumnView ... columns) {
        if (columns.length < 1) {
            throw new IllegalArgumentException("MD5 hashing requires at least 1 column of input");
        }
        long[] columnViews = new long[columns.length];
        long size = columns[0].getRowCount();
        for (int i = 0; i < columns.length; ++i) {
            assert (columns[i] != null) : "Column vectors passed may not be null";
            assert (columns[i].getRowCount() == size) : "Row count mismatch, all columns must be the same size";
            assert (!columns[i].getType().isDurationType()) : "Unsupported column type Duration";
            assert (!columns[i].getType().isTimestampType()) : "Unsupported column type Timestamp";
            assert (!columns[i].getType().isNestedType() || columns[i].getType().equals(DType.LIST)) : "Unsupported nested type column";
            columnViews[i] = columns[i].getNativeView();
        }
        return new ColumnVector(ColumnVector.hash(columnViews, HashType.HASH_MD5.getNativeId(), new int[0], 0));
    }

    public static ColumnVector serial32BitMurmurHash3(int seed, ColumnView[] columns) {
        if (columns.length < 1) {
            throw new IllegalArgumentException("Murmur3 hashing requires at least 1 column of input");
        }
        long[] columnViews = new long[columns.length];
        long size = columns[0].getRowCount();
        for (int i = 0; i < columns.length; ++i) {
            assert (columns[i] != null) : "Column vectors passed may not be null";
            assert (columns[i].getRowCount() == size) : "Row count mismatch, all columns must be the same size";
            assert (!columns[i].getType().isDurationType()) : "Unsupported column type Duration";
            assert (!columns[i].getType().equals(DType.LIST)) : "List columns are not supported";
            columnViews[i] = columns[i].getNativeView();
        }
        return new ColumnVector(ColumnVector.hash(columnViews, HashType.HASH_SERIAL_MURMUR3.getNativeId(), new int[0], seed));
    }

    public static ColumnVector serial32BitMurmurHash3(ColumnView[] columns) {
        return ColumnVector.serial32BitMurmurHash3(0, columns);
    }

    public static ColumnVector spark32BitMurmurHash3(int seed, ColumnView[] columns) {
        if (columns.length < 1) {
            throw new IllegalArgumentException("Murmur3 hashing requires at least 1 column of input");
        }
        long[] columnViews = new long[columns.length];
        long size = columns[0].getRowCount();
        for (int i = 0; i < columns.length; ++i) {
            assert (columns[i] != null) : "Column vectors passed may not be null";
            assert (columns[i].getRowCount() == size) : "Row count mismatch, all columns must be the same size";
            assert (!columns[i].getType().isDurationType()) : "Unsupported column type Duration";
            assert (!columns[i].getType().equals(DType.LIST)) : "List columns are not supported";
            columnViews[i] = columns[i].getNativeView();
        }
        return new ColumnVector(ColumnVector.hash(columnViews, HashType.HASH_SPARK_MURMUR3.getNativeId(), new int[0], seed));
    }

    public static ColumnVector spark32BitMurmurHash3(ColumnView[] columns) {
        return ColumnVector.spark32BitMurmurHash3(0, columns);
    }

    @Override
    public ColumnVector castTo(DType type) {
        if (this.type.equals(type)) {
            return this.incRefCount();
        }
        return super.castTo(type);
    }

    private static native long sequence(long var0, long var2, int var4);

    private static native long fromArrow(int var0, long var1, long var3, ByteBuffer var5, ByteBuffer var6, ByteBuffer var7) throws CudfException;

    private static native long fromScalar(long var0, int var2) throws CudfException;

    private static native long makeList(long[] var0, long var1, int var3, long var4) throws CudfException;

    private static native long concatenate(long[] var0) throws CudfException;

    private static native long concatListByRow(long[] var0, boolean var1);

    private static native long stringConcatenation(long[] var0, long var1, long var3, boolean var5);

    private static native long stringConcatenationSepCol(long[] var0, long var1, long var3, long var5, boolean var7);

    private static native long hash(long[] var0, int var1, int[] var2, int var3) throws CudfException;

    static void closeBuffers(AutoCloseable buffer) {
        Throwable toThrow = null;
        if (buffer != null) {
            try {
                buffer.close();
            }
            catch (Throwable t) {
                toThrow = t;
            }
        }
        if (toThrow != null) {
            throw new RuntimeException(toThrow);
        }
    }

    static native void deleteCudfColumn(long var0) throws CudfException;

    private static native int getNativeNullCountColumn(long var0) throws CudfException;

    private static native void setNativeNullCountColumn(long var0, int var2) throws CudfException;

    static native long getNativeColumnView(long var0) throws CudfException;

    static native long makeEmptyCudfColumn(int var0, int var1);

    public static ColumnVector build(DType type, int rows, Consumer<HostColumnVector.Builder> init) {
        try (HostColumnVector.Builder builder = HostColumnVector.builder(type, rows);){
            init.accept(builder);
            ColumnVector columnVector = builder.buildAndPutOnDevice();
            return columnVector;
        }
    }

    public static ColumnVector build(int rows, long stringBufferSize, Consumer<HostColumnVector.Builder> init) {
        try (HostColumnVector.Builder builder = HostColumnVector.builder(rows, stringBufferSize);){
            init.accept(builder);
            ColumnVector columnVector = builder.buildAndPutOnDevice();
            return columnVector;
        }
    }

    public static ColumnVector boolFromBytes(byte ... values) {
        return ColumnVector.build(DType.BOOL8, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static <T> ColumnVector fromLists(HostColumnVector.DataType dataType, List<T> ... lists) {
        try (HostColumnVector host = HostColumnVector.fromLists(dataType, lists);){
            ColumnVector columnVector = host.copyToDevice();
            return columnVector;
        }
    }

    public static ColumnVector fromStructs(HostColumnVector.DataType dataType, List<HostColumnVector.StructData> lists) {
        try (HostColumnVector host = HostColumnVector.fromStructs(dataType, lists);){
            ColumnVector columnVector = host.copyToDevice();
            return columnVector;
        }
    }

    public static ColumnVector fromStructs(HostColumnVector.DataType dataType, HostColumnVector.StructData ... lists) {
        try (HostColumnVector host = HostColumnVector.fromStructs(dataType, lists);){
            ColumnVector columnVector = host.copyToDevice();
            return columnVector;
        }
    }

    public static ColumnVector emptyStructs(HostColumnVector.DataType dataType, long numRows) {
        try (HostColumnVector host = HostColumnVector.emptyStructs(dataType, numRows);){
            ColumnVector columnVector = host.copyToDevice();
            return columnVector;
        }
    }

    public static ColumnVector fromBytes(byte ... values) {
        return ColumnVector.build(DType.INT8, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector fromUnsignedBytes(byte ... values) {
        return ColumnVector.build(DType.UINT8, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector fromShorts(short ... values) {
        return ColumnVector.build(DType.INT16, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector fromUnsignedShorts(short ... values) {
        return ColumnVector.build(DType.UINT16, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector fromInts(int ... values) {
        return ColumnVector.build(DType.INT32, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector fromUnsignedInts(int ... values) {
        return ColumnVector.build(DType.UINT32, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector fromLongs(long ... values) {
        return ColumnVector.build(DType.INT64, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector fromUnsignedLongs(long ... values) {
        return ColumnVector.build(DType.UINT64, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector fromFloats(float ... values) {
        return ColumnVector.build(DType.FLOAT32, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector fromDoubles(double ... values) {
        return ColumnVector.build(DType.FLOAT64, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector daysFromInts(int ... values) {
        return ColumnVector.build(DType.TIMESTAMP_DAYS, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector durationSecondsFromLongs(long ... values) {
        return ColumnVector.build(DType.DURATION_SECONDS, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector timestampSecondsFromLongs(long ... values) {
        return ColumnVector.build(DType.TIMESTAMP_SECONDS, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector durationDaysFromInts(int ... values) {
        return ColumnVector.build(DType.DURATION_DAYS, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector durationMilliSecondsFromLongs(long ... values) {
        return ColumnVector.build(DType.DURATION_MILLISECONDS, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector timestampMilliSecondsFromLongs(long ... values) {
        return ColumnVector.build(DType.TIMESTAMP_MILLISECONDS, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector durationMicroSecondsFromLongs(long ... values) {
        return ColumnVector.build(DType.DURATION_MICROSECONDS, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector timestampMicroSecondsFromLongs(long ... values) {
        return ColumnVector.build(DType.TIMESTAMP_MICROSECONDS, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector durationNanoSecondsFromLongs(long ... values) {
        return ColumnVector.build(DType.DURATION_NANOSECONDS, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector timestampNanoSecondsFromLongs(long ... values) {
        return ColumnVector.build(DType.TIMESTAMP_NANOSECONDS, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector decimalFromInts(int scale, int ... values) {
        try (HostColumnVector host = HostColumnVector.decimalFromInts(scale, values);){
            ColumnVector columnVector = host.copyToDevice();
            return columnVector;
        }
    }

    public static ColumnVector decimalFromBoxedInts(int scale, Integer ... values) {
        try (HostColumnVector host = HostColumnVector.decimalFromBoxedInts(scale, values);){
            ColumnVector columnVector = host.copyToDevice();
            return columnVector;
        }
    }

    public static ColumnVector decimalFromLongs(int scale, long ... values) {
        try (HostColumnVector host = HostColumnVector.decimalFromLongs(scale, values);){
            ColumnVector columnVector = host.copyToDevice();
            return columnVector;
        }
    }

    public static ColumnVector decimalFromBoxedLongs(int scale, Long ... values) {
        try (HostColumnVector host = HostColumnVector.decimalFromBoxedLongs(scale, values);){
            ColumnVector columnVector = host.copyToDevice();
            return columnVector;
        }
    }

    public static ColumnVector decimalFromDoubles(DType type, RoundingMode mode, double ... values) {
        try (HostColumnVector host = HostColumnVector.decimalFromDoubles(type, mode, values);){
            ColumnVector columnVector = host.copyToDevice();
            return columnVector;
        }
    }

    public static ColumnVector fromStrings(String ... values) {
        try (HostColumnVector host = HostColumnVector.fromStrings(values);){
            ColumnVector columnVector = host.copyToDevice();
            return columnVector;
        }
    }

    public static ColumnVector fromUTF8Strings(byte[] ... values) {
        try (HostColumnVector host = HostColumnVector.fromUTF8Strings(values);){
            ColumnVector columnVector = host.copyToDevice();
            return columnVector;
        }
    }

    public static ColumnVector fromDecimals(BigDecimal ... values) {
        try (HostColumnVector hcv = HostColumnVector.fromDecimals(values);){
            ColumnVector columnVector = hcv.copyToDevice();
            return columnVector;
        }
    }

    public static ColumnVector fromBoxedBooleans(Boolean ... values) {
        return ColumnVector.build(DType.BOOL8, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector fromBoxedBytes(Byte ... values) {
        return ColumnVector.build(DType.INT8, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector fromBoxedUnsignedBytes(Byte ... values) {
        return ColumnVector.build(DType.UINT8, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector fromBoxedShorts(Short ... values) {
        return ColumnVector.build(DType.INT16, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector fromBoxedUnsignedShorts(Short ... values) {
        return ColumnVector.build(DType.UINT16, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector fromBoxedInts(Integer ... values) {
        return ColumnVector.build(DType.INT32, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector fromBoxedUnsignedInts(Integer ... values) {
        return ColumnVector.build(DType.UINT32, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector fromBoxedLongs(Long ... values) {
        return ColumnVector.build(DType.INT64, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector fromBoxedUnsignedLongs(Long ... values) {
        return ColumnVector.build(DType.UINT64, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector fromBoxedFloats(Float ... values) {
        return ColumnVector.build(DType.FLOAT32, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector fromBoxedDoubles(Double ... values) {
        return ColumnVector.build(DType.FLOAT64, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector timestampDaysFromBoxedInts(Integer ... values) {
        return ColumnVector.build(DType.TIMESTAMP_DAYS, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector durationDaysFromBoxedInts(Integer ... values) {
        return ColumnVector.build(DType.DURATION_DAYS, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector durationSecondsFromBoxedLongs(Long ... values) {
        return ColumnVector.build(DType.DURATION_SECONDS, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector timestampSecondsFromBoxedLongs(Long ... values) {
        return ColumnVector.build(DType.TIMESTAMP_SECONDS, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector durationMilliSecondsFromBoxedLongs(Long ... values) {
        return ColumnVector.build(DType.DURATION_MILLISECONDS, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector timestampMilliSecondsFromBoxedLongs(Long ... values) {
        return ColumnVector.build(DType.TIMESTAMP_MILLISECONDS, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector durationMicroSecondsFromBoxedLongs(Long ... values) {
        return ColumnVector.build(DType.DURATION_MICROSECONDS, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector timestampMicroSecondsFromBoxedLongs(Long ... values) {
        return ColumnVector.build(DType.TIMESTAMP_MICROSECONDS, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector durationNanoSecondsFromBoxedLongs(Long ... values) {
        return ColumnVector.build(DType.DURATION_NANOSECONDS, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector timestampNanoSecondsFromBoxedLongs(Long ... values) {
        return ColumnVector.build(DType.TIMESTAMP_NANOSECONDS, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColumnVector empty(HostColumnVector.DataType colType) {
        if (colType == null || colType.getType() == null) {
            throw new IllegalArgumentException("The data type and its 'DType' should NOT be null.");
        }
        if (colType instanceof HostColumnVector.BasicType) {
            DType dt = colType.getType();
            return new ColumnVector(ColumnVector.makeEmptyCudfColumn(dt.typeId.getNativeId(), dt.getScale()));
        }
        if (colType instanceof HostColumnVector.ListType) {
            assert (colType.getNumChildren() == 1) : "List type requires one child type";
            try (ColumnVector child = ColumnVector.empty(colType.getChild(0));){
                ColumnVector columnVector = ColumnVector.makeList(child);
                return columnVector;
            }
        }
        if (colType instanceof HostColumnVector.StructType) {
            ColumnView[] children = new ColumnVector[colType.getNumChildren()];
            try {
                for (int i = 0; i < children.length; ++i) {
                    children[i] = ColumnVector.empty(colType.getChild(i));
                }
                ColumnVector columnVector = ColumnVector.makeStruct(children);
                return columnVector;
            }
            finally {
                for (ColumnView cv : children) {
                    if (cv == null) continue;
                    ((ColumnVector)cv).close();
                }
            }
        }
        throw new IllegalArgumentException("Unsupported data type: " + colType);
    }

    static {
        NativeDepsLoader.loadNativeDeps();
    }

    protected static final class OffHeapState
    extends MemoryCleaner.Cleaner {
        public static final long UNKNOWN_NULL_COUNT = -1L;
        private long columnHandle;
        private long viewHandle = 0L;
        private List<MemoryBuffer> toClose = new ArrayList<MemoryBuffer>();

        public OffHeapState(long columnHandle) {
            this.columnHandle = columnHandle;
            this.toClose.add(this.getData());
            this.toClose.add(this.getValid());
            this.toClose.add(this.getOffsets());
        }

        public OffHeapState(DType type, int rows, DeviceMemoryBuffer data, DeviceMemoryBuffer valid, DeviceMemoryBuffer offsets, List<DeviceMemoryBuffer> buffers, long viewHandle) {
            if (data != null) {
                this.toClose.add(data);
            }
            if (valid != null) {
                this.toClose.add(valid);
            }
            if (offsets != null) {
                this.toClose.add(offsets);
            }
            if (buffers != null) {
                this.toClose.addAll(buffers);
            }
            if (rows == 0 && !type.isNestedType()) {
                this.columnHandle = ColumnVector.makeEmptyCudfColumn(type.typeId.getNativeId(), type.getScale());
            } else {
                this.viewHandle = viewHandle;
            }
        }

        public OffHeapState(long viewHandle, DeviceMemoryBuffer contiguousBuffer) {
            assert (viewHandle != 0L);
            this.viewHandle = viewHandle;
            BaseDeviceMemoryBuffer valid = this.getValid();
            BaseDeviceMemoryBuffer data = this.getData();
            BaseDeviceMemoryBuffer offsets = this.getOffsets();
            this.toClose.add(data);
            this.toClose.add(valid);
            this.toClose.add(offsets);
            contiguousBuffer.incRefCount();
            this.toClose.add(contiguousBuffer);
        }

        public long getViewHandle() {
            if (this.viewHandle == 0L) {
                this.viewHandle = ColumnVector.getNativeColumnView(this.columnHandle);
            }
            return this.viewHandle;
        }

        public long getNativeNullCount() {
            if (this.viewHandle != 0L) {
                return ColumnView.getNativeNullCount(this.getViewHandle());
            }
            return ColumnVector.getNativeNullCountColumn(this.columnHandle);
        }

        private void setNativeNullCount(int nullCount) throws CudfException {
            assert (this.viewHandle == 0L) : "Cannot set the null count if a view has already been created";
            assert (this.columnHandle != 0L);
            ColumnVector.setNativeNullCountColumn(this.columnHandle, nullCount);
        }

        public BaseDeviceMemoryBuffer getData() {
            return ColumnView.getDataBuffer(this.getViewHandle());
        }

        public BaseDeviceMemoryBuffer getValid() {
            return ColumnView.getValidityBuffer(this.getViewHandle());
        }

        public BaseDeviceMemoryBuffer getOffsets() {
            return ColumnView.getOffsetsBuffer(this.getViewHandle());
        }

        @Override
        public void noWarnLeakExpected() {
            super.noWarnLeakExpected();
            BaseDeviceMemoryBuffer valid = this.getValid();
            BaseDeviceMemoryBuffer data = this.getData();
            BaseDeviceMemoryBuffer offsets = this.getOffsets();
            if (valid != null) {
                valid.noWarnLeakExpected();
            }
            if (data != null) {
                data.noWarnLeakExpected();
            }
            if (offsets != null) {
                offsets.noWarnLeakExpected();
            }
        }

        public String toString() {
            return "(ID: " + this.id + " " + Long.toHexString(this.columnHandle == 0L ? this.viewHandle : this.columnHandle) + ")";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected synchronized boolean cleanImpl(boolean logErrorIfNotClean) {
            boolean neededCleanup = false;
            long address = 0L;
            Throwable toThrow = null;
            if (this.viewHandle != 0L) {
                address = this.viewHandle;
                try {
                    ColumnView.deleteColumnView(this.viewHandle);
                }
                catch (Throwable t) {
                    toThrow = t;
                }
                finally {
                    this.viewHandle = 0L;
                }
                neededCleanup = true;
            }
            if (this.columnHandle != 0L) {
                if (address != 0L) {
                    address = this.columnHandle;
                }
                try {
                    ColumnVector.deleteCudfColumn(this.columnHandle);
                }
                catch (Throwable t) {
                    if (toThrow != null) {
                        toThrow.addSuppressed(t);
                    } else {
                        toThrow = t;
                    }
                }
                finally {
                    this.columnHandle = 0L;
                }
                neededCleanup = true;
            }
            if (!this.toClose.isEmpty()) {
                try {
                    for (MemoryBuffer toCloseBuff : this.toClose) {
                        ColumnVector.closeBuffers(toCloseBuff);
                    }
                }
                catch (Throwable t) {
                    if (toThrow != null) {
                        toThrow.addSuppressed(t);
                    } else {
                        toThrow = t;
                    }
                }
                finally {
                    this.toClose.clear();
                }
                neededCleanup = true;
            }
            if (toThrow != null) {
                throw new RuntimeException(toThrow);
            }
            if (neededCleanup && logErrorIfNotClean) {
                log.error("A DEVICE COLUMN VECTOR WAS LEAKED (ID: " + this.id + " " + Long.toHexString(address) + ")");
                this.logRefCountDebug("Leaked vector");
            }
            return neededCleanup;
        }

        @Override
        public boolean isClean() {
            return this.viewHandle == 0L && this.columnHandle == 0L && this.toClose.isEmpty();
        }
    }
}

