/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.Aggregation;
import ai.rapids.cudf.BaseDeviceMemoryBuffer;
import ai.rapids.cudf.BinaryOp;
import ai.rapids.cudf.BinaryOperable;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.CudfException;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.DeviceMemoryBuffer;
import ai.rapids.cudf.DeviceMemoryBufferView;
import ai.rapids.cudf.HostColumnVector;
import ai.rapids.cudf.HostColumnVectorCore;
import ai.rapids.cudf.HostMemoryBuffer;
import ai.rapids.cudf.MemoryBuffer;
import ai.rapids.cudf.NvtxColor;
import ai.rapids.cudf.NvtxRange;
import ai.rapids.cudf.PadSide;
import ai.rapids.cudf.QuantileMethod;
import ai.rapids.cudf.RollingAggregation;
import ai.rapids.cudf.RoundMode;
import ai.rapids.cudf.Scalar;
import ai.rapids.cudf.Table;
import ai.rapids.cudf.UnaryOp;
import ai.rapids.cudf.WindowOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;

public class ColumnView
implements AutoCloseable,
BinaryOperable {
    public static final long UNKNOWN_NULL_COUNT = -1L;
    protected long viewHandle;
    protected final DType type;
    protected final long rows;
    protected final long nullCount;

    ColumnView(long address) {
        this.viewHandle = address;
        this.type = DType.fromNative(ColumnView.getNativeTypeId(this.viewHandle), ColumnView.getNativeTypeScale(this.viewHandle));
        this.rows = ColumnView.getNativeRowCount(this.viewHandle);
        this.nullCount = ColumnView.getNativeNullCount(this.viewHandle);
    }

    public ColumnView(DType type, long rows, Optional<Long> nullCount, BaseDeviceMemoryBuffer validityBuffer, BaseDeviceMemoryBuffer offsetBuffer, ColumnView[] children) {
        this(type, (int)rows, nullCount.orElse(-1L).intValue(), null, validityBuffer, offsetBuffer, children);
        assert (type.isNestedType());
        assert (nullCount.isPresent() && nullCount.get() <= Integer.MAX_VALUE || !nullCount.isPresent());
    }

    public ColumnView(DType type, long rows, Optional<Long> nullCount, BaseDeviceMemoryBuffer dataBuffer, BaseDeviceMemoryBuffer validityBuffer) {
        this(type, (int)rows, nullCount.orElse(-1L).intValue(), dataBuffer, validityBuffer, null, null);
        assert (!type.isNestedType());
        assert (nullCount.isPresent() && nullCount.get() <= Integer.MAX_VALUE || !nullCount.isPresent());
    }

    private ColumnView(DType type, long rows, int nullCount, BaseDeviceMemoryBuffer dataBuffer, BaseDeviceMemoryBuffer validityBuffer, BaseDeviceMemoryBuffer offsetBuffer, ColumnView[] children) {
        this(ColumnVector.initViewHandle(type, (int)rows, nullCount, dataBuffer, validityBuffer, offsetBuffer, Arrays.stream(children).mapToLong(c -> c.getNativeView()).toArray()));
    }

    public ColumnVector copyToColumnVector() {
        return new ColumnVector(ColumnView.copyColumnViewToCV(this.getNativeView()));
    }

    public final long getNativeView() {
        return this.viewHandle;
    }

    static int getFixedPointOutputScale(BinaryOp op, DType lhsType, DType rhsType) {
        assert (lhsType.isDecimalType() && rhsType.isDecimalType());
        return ColumnView.fixedPointOutputScale(op.nativeId, lhsType.getScale(), rhsType.getScale());
    }

    private static native int fixedPointOutputScale(int var0, int var1, int var2);

    @Override
    public final DType getType() {
        return this.type;
    }

    public final ColumnView getChildColumnView(int childIndex) {
        int numChildren = this.getNumChildren();
        assert (childIndex < numChildren) : "children index should be less than " + numChildren;
        if (!this.getType().isNestedType()) {
            return null;
        }
        long childColumnView = ColumnView.getChildCvPointer(this.viewHandle, childIndex);
        return new ColumnView(childColumnView);
    }

    public final BaseDeviceMemoryBuffer getData() {
        return ColumnView.getDataBuffer(this.viewHandle);
    }

    public final BaseDeviceMemoryBuffer getOffsets() {
        return ColumnView.getOffsetsBuffer(this.viewHandle);
    }

    public final BaseDeviceMemoryBuffer getValid() {
        return ColumnView.getValidityBuffer(this.viewHandle);
    }

    public long getNullCount() {
        return this.nullCount;
    }

    public final long getRowCount() {
        return this.rows;
    }

    public final int getNumChildren() {
        if (!this.getType().isNestedType()) {
            return 0;
        }
        return ColumnView.getNativeNumChildren(this.viewHandle);
    }

    public long getDeviceMemorySize() {
        return ColumnView.getDeviceMemorySize(this.getNativeView());
    }

    @Override
    public void close() {
        ColumnView.deleteColumnView(this.viewHandle);
        this.viewHandle = 0L;
    }

    public String toString() {
        return "ColumnView{rows=" + this.rows + ", type=" + this.type + ", nullCount=" + this.nullCount + '}';
    }

    public final ColumnVector nansToNulls() {
        assert (this.type.equals(DType.FLOAT32) || this.type.equals(DType.FLOAT64));
        return new ColumnVector(ColumnView.nansToNulls(this.getNativeView()));
    }

    public final ColumnVector getCharLengths() {
        assert (DType.STRING.equals(this.type)) : "char length only available for String type";
        return new ColumnVector(ColumnView.charLengths(this.getNativeView()));
    }

    public final ColumnVector getByteCount() {
        assert (this.type.equals(DType.STRING)) : "type has to be a String";
        return new ColumnVector(ColumnView.byteCount(this.getNativeView()));
    }

    public final ColumnVector countElements() {
        assert (DType.LIST.equals(this.type)) : "Only lists are supported";
        return new ColumnVector(ColumnView.countElements(this.getNativeView()));
    }

    public final ColumnVector isNotNull() {
        return new ColumnVector(ColumnView.isNotNullNative(this.getNativeView()));
    }

    public final ColumnVector isNull() {
        return new ColumnVector(ColumnView.isNullNative(this.getNativeView()));
    }

    public final ColumnVector isInteger() {
        assert (this.type.equals(DType.STRING));
        return new ColumnVector(ColumnView.isInteger(this.getNativeView()));
    }

    public final ColumnVector isInteger(DType intType) {
        assert (this.type.equals(DType.STRING));
        return new ColumnVector(ColumnView.isIntegerWithType(this.getNativeView(), intType.getTypeId().getNativeId(), intType.getScale()));
    }

    public final ColumnVector isFloat() {
        assert (this.type.equals(DType.STRING));
        return new ColumnVector(ColumnView.isFloat(this.getNativeView()));
    }

    public final ColumnVector isNan() {
        return new ColumnVector(ColumnView.isNanNative(this.getNativeView()));
    }

    public final ColumnVector isNotNan() {
        return new ColumnVector(ColumnView.isNotNanNative(this.getNativeView()));
    }

    public final ColumnVector findAndReplaceAll(ColumnView oldValues, ColumnView newValues) {
        return new ColumnVector(ColumnView.findAndReplaceAll(oldValues.getNativeView(), newValues.getNativeView(), this.getNativeView()));
    }

    public final ColumnVector replaceNulls(Scalar scalar) {
        return new ColumnVector(ColumnView.replaceNullsScalar(this.getNativeView(), scalar.getScalarHandle()));
    }

    public final ColumnVector replaceNulls(ColumnView replacements) {
        return new ColumnVector(ColumnView.replaceNullsColumn(this.getNativeView(), replacements.getNativeView()));
    }

    public final ColumnVector ifElse(ColumnView trueValues, ColumnView falseValues) {
        if (!this.type.equals(DType.BOOL8)) {
            throw new IllegalArgumentException("Cannot select with a predicate vector of type " + this.type);
        }
        long result = ColumnView.ifElseVV(this.getNativeView(), trueValues.getNativeView(), falseValues.getNativeView());
        return new ColumnVector(result);
    }

    public final ColumnVector ifElse(ColumnView trueValues, Scalar falseValue) {
        if (!this.type.equals(DType.BOOL8)) {
            throw new IllegalArgumentException("Cannot select with a predicate vector of type " + this.type);
        }
        long result = ColumnView.ifElseVS(this.getNativeView(), trueValues.getNativeView(), falseValue.getScalarHandle());
        return new ColumnVector(result);
    }

    public final ColumnVector ifElse(Scalar trueValue, ColumnView falseValues) {
        if (!this.type.equals(DType.BOOL8)) {
            throw new IllegalArgumentException("Cannot select with a predicate vector of type " + this.type);
        }
        long result = ColumnView.ifElseSV(this.getNativeView(), trueValue.getScalarHandle(), falseValues.getNativeView());
        return new ColumnVector(result);
    }

    public final ColumnVector ifElse(Scalar trueValue, Scalar falseValue) {
        if (!this.type.equals(DType.BOOL8)) {
            throw new IllegalArgumentException("Cannot select with a predicate vector of type " + this.type);
        }
        long result = ColumnView.ifElseSS(this.getNativeView(), trueValue.getScalarHandle(), falseValue.getScalarHandle());
        return new ColumnVector(result);
    }

    public final ColumnVector[] slice(int ... indices) {
        long[] nativeHandles = ColumnView.slice(this.getNativeView(), indices);
        ColumnVector[] columnVectors = new ColumnVector[nativeHandles.length];
        for (int i = 0; i < nativeHandles.length; ++i) {
            columnVectors[i] = new ColumnVector(nativeHandles[i]);
        }
        return columnVectors;
    }

    public final ColumnVector subVector(int start) {
        return this.subVector(start, (int)this.rows);
    }

    public final ColumnVector subVector(int start, int end) {
        ColumnVector[] tmp = this.slice(start, end);
        assert (tmp.length == 1);
        return tmp[0];
    }

    public final ColumnVector[] split(int ... indices) {
        long[] nativeHandles = ColumnView.split(this.getNativeView(), indices);
        ColumnVector[] columnVectors = new ColumnVector[nativeHandles.length];
        for (int i = 0; i < nativeHandles.length; ++i) {
            columnVectors[i] = new ColumnVector(nativeHandles[i]);
        }
        return columnVectors;
    }

    public final ColumnVector normalizeNANsAndZeros() {
        return new ColumnVector(ColumnView.normalizeNANsAndZeros(this.getNativeView()));
    }

    public final ColumnVector mergeAndSetValidity(BinaryOp mergeOp, ColumnView ... columns) {
        assert (mergeOp == BinaryOp.BITWISE_AND || mergeOp == BinaryOp.BITWISE_OR) : "Only BITWISE_AND and BITWISE_OR supported right now";
        long[] columnViews = new long[columns.length];
        long size = this.getRowCount();
        for (int i = 0; i < columns.length; ++i) {
            assert (columns[i] != null) : "Column vectors passed may not be null";
            assert (columns[i].getRowCount() == size) : "Row count mismatch, all columns must be the same size";
            columnViews[i] = columns[i].getNativeView();
        }
        return new ColumnVector(ColumnView.bitwiseMergeAndSetValidity(this.getNativeView(), columnViews, mergeOp.nativeId));
    }

    public final ColumnVector year() {
        assert (this.type.isTimestampType());
        return new ColumnVector(ColumnView.year(this.getNativeView()));
    }

    public final ColumnVector month() {
        assert (this.type.isTimestampType());
        return new ColumnVector(ColumnView.month(this.getNativeView()));
    }

    public final ColumnVector day() {
        assert (this.type.isTimestampType());
        return new ColumnVector(ColumnView.day(this.getNativeView()));
    }

    public final ColumnVector hour() {
        assert (this.type.hasTimeResolution());
        return new ColumnVector(ColumnView.hour(this.getNativeView()));
    }

    public final ColumnVector minute() {
        assert (this.type.hasTimeResolution());
        return new ColumnVector(ColumnView.minute(this.getNativeView()));
    }

    public final ColumnVector second() {
        assert (this.type.hasTimeResolution());
        return new ColumnVector(ColumnView.second(this.getNativeView()));
    }

    public final ColumnVector weekDay() {
        assert (this.type.isTimestampType());
        return new ColumnVector(ColumnView.weekDay(this.getNativeView()));
    }

    public final ColumnVector lastDayOfMonth() {
        assert (this.type.isTimestampType());
        return new ColumnVector(ColumnView.lastDayOfMonth(this.getNativeView()));
    }

    public final ColumnVector dayOfYear() {
        assert (this.type.isTimestampType());
        return new ColumnVector(ColumnView.dayOfYear(this.getNativeView()));
    }

    public ColumnVector round(int decimalPlaces, RoundMode mode) {
        return new ColumnVector(ColumnView.round(this.getNativeView(), decimalPlaces, mode.nativeId));
    }

    public ColumnVector round(RoundMode round) {
        return this.round(0, round);
    }

    public ColumnVector round(int decimalPlaces) {
        return this.round(decimalPlaces, RoundMode.HALF_UP);
    }

    public ColumnVector round() {
        return this.round(0, RoundMode.HALF_UP);
    }

    public final ColumnVector transform(String udf, boolean isPtx) {
        return new ColumnVector(ColumnView.transform(this.getNativeView(), udf, isPtx));
    }

    public final ColumnVector unaryOp(UnaryOp op) {
        return new ColumnVector(ColumnView.unaryOperation(this.getNativeView(), op.nativeId));
    }

    public final ColumnVector sin() {
        return this.unaryOp(UnaryOp.SIN);
    }

    public final ColumnVector cos() {
        return this.unaryOp(UnaryOp.COS);
    }

    public final ColumnVector tan() {
        return this.unaryOp(UnaryOp.TAN);
    }

    public final ColumnVector arcsin() {
        return this.unaryOp(UnaryOp.ARCSIN);
    }

    public final ColumnVector arccos() {
        return this.unaryOp(UnaryOp.ARCCOS);
    }

    public final ColumnVector arctan() {
        return this.unaryOp(UnaryOp.ARCTAN);
    }

    public final ColumnVector sinh() {
        return this.unaryOp(UnaryOp.SINH);
    }

    public final ColumnVector cosh() {
        return this.unaryOp(UnaryOp.COSH);
    }

    public final ColumnVector tanh() {
        return this.unaryOp(UnaryOp.TANH);
    }

    public final ColumnVector arcsinh() {
        return this.unaryOp(UnaryOp.ARCSINH);
    }

    public final ColumnVector arccosh() {
        return this.unaryOp(UnaryOp.ARCCOSH);
    }

    public final ColumnVector arctanh() {
        return this.unaryOp(UnaryOp.ARCTANH);
    }

    public final ColumnVector exp() {
        return this.unaryOp(UnaryOp.EXP);
    }

    public final ColumnVector log() {
        return this.unaryOp(UnaryOp.LOG);
    }

    public final ColumnVector log2() {
        try (Scalar base = Scalar.fromInt(2);){
            ColumnVector columnVector = this.binaryOp(BinaryOp.LOG_BASE, base, this.getType());
            return columnVector;
        }
    }

    public final ColumnVector log10() {
        try (Scalar base = Scalar.fromInt(10);){
            ColumnVector columnVector = this.binaryOp(BinaryOp.LOG_BASE, base, this.getType());
            return columnVector;
        }
    }

    public final ColumnVector sqrt() {
        return this.unaryOp(UnaryOp.SQRT);
    }

    public final ColumnVector cbrt() {
        return this.unaryOp(UnaryOp.CBRT);
    }

    public final ColumnVector ceil() {
        return this.unaryOp(UnaryOp.CEIL);
    }

    public final ColumnVector floor() {
        return this.unaryOp(UnaryOp.FLOOR);
    }

    public final ColumnVector abs() {
        return this.unaryOp(UnaryOp.ABS);
    }

    public final ColumnVector rint() {
        return this.unaryOp(UnaryOp.RINT);
    }

    public final ColumnVector bitInvert() {
        return this.unaryOp(UnaryOp.BIT_INVERT);
    }

    @Override
    public final ColumnVector binaryOp(BinaryOp op, BinaryOperable rhs, DType outType) {
        if (rhs instanceof ColumnView) {
            assert (this.rows == ((ColumnView)rhs).getRowCount());
            return new ColumnVector(ColumnView.binaryOp(this, (ColumnView)rhs, op, outType));
        }
        return new ColumnVector(ColumnView.binaryOp(this, (Scalar)rhs, op, outType));
    }

    static long binaryOp(ColumnView lhs, ColumnView rhs, BinaryOp op, DType outputType) {
        return ColumnView.binaryOpVV(lhs.getNativeView(), rhs.getNativeView(), op.nativeId, outputType.typeId.getNativeId(), outputType.getScale());
    }

    static long binaryOp(ColumnView lhs, Scalar rhs, BinaryOp op, DType outputType) {
        return ColumnView.binaryOpVS(lhs.getNativeView(), rhs.getScalarHandle(), op.nativeId, outputType.typeId.getNativeId(), outputType.getScale());
    }

    public Scalar sum() {
        return this.sum(this.type);
    }

    public Scalar sum(DType outType) {
        return this.reduce(Aggregation.sum(), outType);
    }

    public Scalar min() {
        return this.reduce(Aggregation.min(), this.type);
    }

    @Deprecated
    public Scalar min(DType outType) {
        if (!outType.equals(this.type)) {
            try (ColumnVector tmp = this.castTo(outType);){
                Scalar scalar = tmp.min(outType);
                return scalar;
            }
        }
        return this.reduce(Aggregation.min(), outType);
    }

    public Scalar max() {
        return this.reduce(Aggregation.max(), this.type);
    }

    @Deprecated
    public Scalar max(DType outType) {
        if (!outType.equals(this.type)) {
            try (ColumnVector tmp = this.castTo(outType);){
                Scalar scalar = tmp.max(outType);
                return scalar;
            }
        }
        return this.reduce(Aggregation.max(), outType);
    }

    public Scalar product() {
        return this.product(this.type);
    }

    public Scalar product(DType outType) {
        return this.reduce(Aggregation.product(), outType);
    }

    public Scalar sumOfSquares() {
        return this.sumOfSquares(this.type);
    }

    public Scalar sumOfSquares(DType outType) {
        return this.reduce(Aggregation.sumOfSquares(), outType);
    }

    public Scalar mean() {
        DType outType = DType.FLOAT64;
        if (this.type.equals(DType.FLOAT32)) {
            outType = this.type;
        }
        return this.mean(outType);
    }

    public Scalar mean(DType outType) {
        return this.reduce(Aggregation.mean(), outType);
    }

    public Scalar variance() {
        DType outType = DType.FLOAT64;
        if (this.type.equals(DType.FLOAT32)) {
            outType = this.type;
        }
        return this.variance(outType);
    }

    public Scalar variance(DType outType) {
        return this.reduce(Aggregation.variance(), outType);
    }

    public Scalar standardDeviation() {
        DType outType = DType.FLOAT64;
        if (this.type.equals(DType.FLOAT32)) {
            outType = this.type;
        }
        return this.standardDeviation(outType);
    }

    public Scalar standardDeviation(DType outType) {
        return this.reduce(Aggregation.standardDeviation(), outType);
    }

    public Scalar any() {
        return this.any(DType.BOOL8);
    }

    public Scalar any(DType outType) {
        return this.reduce(Aggregation.any(), outType);
    }

    public Scalar all() {
        return this.all(DType.BOOL8);
    }

    @Deprecated
    public Scalar all(DType outType) {
        return this.reduce(Aggregation.all(), outType);
    }

    public Scalar reduce(Aggregation aggregation) {
        return this.reduce(aggregation, this.type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scalar reduce(Aggregation aggregation, DType outType) {
        long nativeId = aggregation.createNativeInstance();
        try {
            Scalar scalar = new Scalar(outType, ColumnView.reduce(this.getNativeView(), nativeId, outType.typeId.getNativeId(), outType.getScale()));
            return scalar;
        }
        finally {
            Aggregation.close(nativeId);
        }
    }

    public final ColumnVector quantile(QuantileMethod method, double[] quantiles) {
        return new ColumnVector(ColumnView.quantile(this.getNativeView(), method.nativeId, quantiles));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ColumnVector rollingWindow(RollingAggregation op, WindowOptions options) {
        Object agg = op.getBaseAggregation();
        if (!options.getFrameType().equals((Object)WindowOptions.FrameType.ROWS)) {
            throw new IllegalArgumentException("Expected ROWS-based window specification. Unexpected window type: " + (Object)((Object)options.getFrameType()));
        }
        long nativePtr = ((Aggregation)agg).createNativeInstance();
        try {
            Scalar p = options.getPrecedingScalar();
            Scalar f = options.getFollowingScalar();
            ColumnVector columnVector = new ColumnVector(ColumnView.rollingWindow(this.getNativeView(), ((Aggregation)agg).getDefaultOutput(), options.getMinPeriods(), nativePtr, p == null || !p.isValid() ? 0 : p.getInt(), f == null || !f.isValid() ? 0 : f.getInt(), options.getPrecedingCol() == null ? 0L : options.getPrecedingCol().getNativeView(), options.getFollowingCol() == null ? 0L : options.getFollowingCol().getNativeView()));
            return columnVector;
        }
        finally {
            Aggregation.close(nativePtr);
        }
    }

    public final ColumnVector prefixSum() {
        return new ColumnVector(ColumnView.prefixSum(this.getNativeView()));
    }

    public final ColumnVector not() {
        return this.unaryOp(UnaryOp.NOT);
    }

    public boolean contains(Scalar needle) {
        return ColumnView.containsScalar(this.getNativeView(), needle.getScalarHandle());
    }

    public final ColumnVector contains(ColumnView needles) {
        return new ColumnVector(ColumnView.containsVector(this.getNativeView(), needles.getNativeView()));
    }

    public final ColumnVector toTitle() {
        assert (this.type.equals(DType.STRING));
        return new ColumnVector(ColumnView.title(this.getNativeView()));
    }

    public ColumnVector castTo(DType type) {
        return new ColumnVector(ColumnView.castTo(this.getNativeView(), type.typeId.getNativeId(), type.getScale()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnView replaceChildrenWithViews(int[] indices, ColumnView[] views) {
        assert (this.type.isNestedType());
        assert (indices.length == views.length);
        if (this.type == DType.LIST) assert (indices.length == 1);
        if (indices.length != views.length) {
            throw new IllegalArgumentException("The indices size and children size should match");
        }
        HashMap map = new HashMap();
        IntStream.range(0, indices.length).forEach(index -> {
            if (map.containsKey(indices[index])) {
                throw new IllegalArgumentException("Duplicate mapping found for replacing child index");
            }
            map.put(indices[index], views[index]);
        });
        ArrayList newChildren = new ArrayList(this.getNumChildren());
        ArrayList toClose = new ArrayList(this.getNumChildren());
        try {
            IntStream.range(0, this.getNumChildren()).forEach(i -> {
                ColumnView view = (ColumnView)map.remove(i);
                ColumnView child = this.getChildColumnView(i);
                toClose.add(child);
                if (view == null) {
                    newChildren.add(child);
                } else {
                    if (child.getRowCount() != view.getRowCount()) {
                        throw new IllegalArgumentException("Child row count doesn't match the old child");
                    }
                    newChildren.add(view);
                }
            });
            if (!map.isEmpty()) {
                throw new IllegalArgumentException("One or more invalid child indices passed to be replaced");
            }
            ColumnView columnView = new ColumnView(this.type, this.getRowCount(), Optional.of(this.getNullCount()), this.getValid(), this.getOffsets(), (ColumnView[])newChildren.stream().toArray(ColumnView[]::new));
            return columnView;
        }
        finally {
            for (ColumnView columnView : toClose) {
                columnView.close();
            }
        }
    }

    public ColumnView replaceListChild(ColumnView child) {
        assert (this.type == DType.LIST);
        return this.replaceChildrenWithViews(new int[]{0}, new ColumnView[]{child});
    }

    @Deprecated
    public ColumnView logicalCastTo(DType type) {
        return this.bitCastTo(type);
    }

    public ColumnView bitCastTo(DType type) {
        return new ColumnView(ColumnView.bitCastTo(this.getNativeView(), type.typeId.getNativeId(), type.getScale()));
    }

    public final ColumnVector asBytes() {
        return this.castTo(DType.INT8);
    }

    public final ColumnVector asByteList() {
        return new ColumnVector(ColumnView.byteListCast(this.getNativeView(), true));
    }

    public final ColumnVector asByteList(boolean config) {
        return new ColumnVector(ColumnView.byteListCast(this.getNativeView(), config));
    }

    public final ColumnVector asUnsignedBytes() {
        return this.castTo(DType.UINT8);
    }

    public final ColumnVector asShorts() {
        return this.castTo(DType.INT16);
    }

    public final ColumnVector asUnsignedShorts() {
        return this.castTo(DType.UINT16);
    }

    public final ColumnVector asInts() {
        return this.castTo(DType.INT32);
    }

    public final ColumnVector asUnsignedInts() {
        return this.castTo(DType.UINT32);
    }

    public final ColumnVector asLongs() {
        return this.castTo(DType.INT64);
    }

    public final ColumnVector asUnsignedLongs() {
        return this.castTo(DType.UINT64);
    }

    public final ColumnVector asFloats() {
        return this.castTo(DType.FLOAT32);
    }

    public final ColumnVector asDoubles() {
        return this.castTo(DType.FLOAT64);
    }

    public final ColumnVector asTimestampDays() {
        if (this.type.equals(DType.STRING)) {
            return this.asTimestamp(DType.TIMESTAMP_DAYS, "%Y-%m-%dT%H:%M:%SZ%f");
        }
        return this.castTo(DType.TIMESTAMP_DAYS);
    }

    public final ColumnVector asTimestampDays(String format) {
        assert (this.type.equals(DType.STRING)) : "A column of type string is required when using a format string";
        return this.asTimestamp(DType.TIMESTAMP_DAYS, format);
    }

    public final ColumnVector asTimestampSeconds() {
        if (this.type.equals(DType.STRING)) {
            return this.asTimestamp(DType.TIMESTAMP_SECONDS, "%Y-%m-%dT%H:%M:%SZ%f");
        }
        return this.castTo(DType.TIMESTAMP_SECONDS);
    }

    public final ColumnVector asTimestampSeconds(String format) {
        assert (this.type.equals(DType.STRING)) : "A column of type string is required when using a format string";
        return this.asTimestamp(DType.TIMESTAMP_SECONDS, format);
    }

    public final ColumnVector asTimestampMicroseconds() {
        if (this.type.equals(DType.STRING)) {
            return this.asTimestamp(DType.TIMESTAMP_MICROSECONDS, "%Y-%m-%dT%H:%M:%SZ%f");
        }
        return this.castTo(DType.TIMESTAMP_MICROSECONDS);
    }

    public final ColumnVector asTimestampMicroseconds(String format) {
        assert (this.type.equals(DType.STRING)) : "A column of type string is required when using a format string";
        return this.asTimestamp(DType.TIMESTAMP_MICROSECONDS, format);
    }

    public final ColumnVector asTimestampMilliseconds() {
        if (this.type.equals(DType.STRING)) {
            return this.asTimestamp(DType.TIMESTAMP_MILLISECONDS, "%Y-%m-%dT%H:%M:%SZ%f");
        }
        return this.castTo(DType.TIMESTAMP_MILLISECONDS);
    }

    public final ColumnVector asTimestampMilliseconds(String format) {
        assert (this.type.equals(DType.STRING)) : "A column of type string is required when using a format string";
        return this.asTimestamp(DType.TIMESTAMP_MILLISECONDS, format);
    }

    public final ColumnVector asTimestampNanoseconds() {
        if (this.type.equals(DType.STRING)) {
            return this.asTimestamp(DType.TIMESTAMP_NANOSECONDS, "%Y-%m-%dT%H:%M:%SZ%9f");
        }
        return this.castTo(DType.TIMESTAMP_NANOSECONDS);
    }

    public final ColumnVector asTimestampNanoseconds(String format) {
        assert (this.type.equals(DType.STRING)) : "A column of type string is required when using a format string";
        return this.asTimestamp(DType.TIMESTAMP_NANOSECONDS, format);
    }

    public final ColumnVector asTimestamp(DType timestampType, String format) {
        assert (this.type.equals(DType.STRING)) : "A column of type string is required for .to_timestamp() operation";
        assert (format != null) : "Format string may not be NULL";
        assert (timestampType.isTimestampType()) : "unsupported conversion to non-timestamp DType";
        return new ColumnVector(ColumnView.stringTimestampToTimestamp(this.getNativeView(), timestampType.typeId.getNativeId(), format));
    }

    public final ColumnVector asStrings() {
        switch (this.type.typeId) {
            case TIMESTAMP_SECONDS: {
                return this.asStrings("%Y-%m-%d %H:%M:%S");
            }
            case TIMESTAMP_DAYS: {
                return this.asStrings("%Y-%m-%d");
            }
            case TIMESTAMP_MICROSECONDS: 
            case TIMESTAMP_MILLISECONDS: 
            case TIMESTAMP_NANOSECONDS: {
                return this.asStrings("%Y-%m-%d %H:%M:%S.%f");
            }
        }
        return this.castTo(DType.STRING);
    }

    public final ColumnVector asStrings(String format) {
        assert (this.type.isTimestampType()) : "unsupported conversion from non-timestamp DType";
        assert (format != null || format.isEmpty()) : "Format string may not be NULL or empty";
        return new ColumnVector(ColumnView.timestampToStringTimestamp(this.getNativeView(), format));
    }

    public final ColumnVector isTimestamp(String format) {
        return new ColumnVector(ColumnView.isTimestamp(this.getNativeView(), format));
    }

    public final ColumnVector extractListElement(int index) {
        assert (this.type.equals(DType.LIST)) : "A column of type LIST is required for .extractListElement()";
        return new ColumnVector(ColumnView.extractListElement(this.getNativeView(), index));
    }

    public final ColumnVector upper() {
        assert (this.type.equals(DType.STRING)) : "A column of type string is required for .upper() operation";
        return new ColumnVector(ColumnView.upperStrings(this.getNativeView()));
    }

    public final ColumnVector lower() {
        assert (this.type.equals(DType.STRING)) : "A column of type string is required for .lower() operation";
        return new ColumnVector(ColumnView.lowerStrings(this.getNativeView()));
    }

    public final ColumnVector stringLocate(Scalar substring) {
        return this.stringLocate(substring, 0);
    }

    public final ColumnVector stringLocate(Scalar substring, int start) {
        return this.stringLocate(substring, start, -1);
    }

    public final ColumnVector stringLocate(Scalar substring, int start, int end) {
        assert (this.type.equals(DType.STRING)) : "column type must be a String";
        assert (substring != null) : "target string may not be null";
        assert (substring.getType().equals(DType.STRING)) : "substring scalar must be a string scalar";
        assert (start >= 0) : "start index must be a positive value";
        assert (end >= start || end == -1) : "end index must be -1 or >= the start index";
        return new ColumnVector(ColumnView.substringLocate(this.getNativeView(), substring.getScalarHandle(), start, end));
    }

    public final Table stringSplit(Scalar delimiter) {
        assert (this.type.equals(DType.STRING)) : "column type must be a String";
        assert (delimiter != null) : "delimiter may not be null";
        assert (delimiter.getType().equals(DType.STRING)) : "delimiter must be a string scalar";
        return new Table(ColumnView.stringSplit(this.getNativeView(), delimiter.getScalarHandle()));
    }

    public final Table stringSplit() {
        try (Scalar emptyString = Scalar.fromString("");){
            Table table = this.stringSplit(emptyString);
            return table;
        }
    }

    public final ColumnVector stringSplitRecord() {
        return this.stringSplitRecord(-1);
    }

    public final ColumnVector stringSplitRecord(int maxSplit) {
        try (Scalar emptyString = Scalar.fromString("");){
            ColumnVector columnVector = this.stringSplitRecord(emptyString, maxSplit);
            return columnVector;
        }
    }

    public final ColumnVector stringSplitRecord(Scalar delimiter) {
        return this.stringSplitRecord(delimiter, -1);
    }

    public final ColumnVector stringSplitRecord(Scalar delimiter, int maxSplit) {
        assert (this.type.equals(DType.STRING)) : "column type must be a String";
        assert (delimiter != null) : "delimiter may not be null";
        assert (delimiter.getType().equals(DType.STRING)) : "delimiter must be a string scalar";
        return new ColumnVector(ColumnView.stringSplitRecord(this.getNativeView(), delimiter.getScalarHandle(), maxSplit));
    }

    public final ColumnVector substring(int start) {
        return this.substring(start, -1);
    }

    public final ColumnVector substring(int start, int end) {
        assert (this.type.equals(DType.STRING)) : "column type must be a String";
        return new ColumnVector(ColumnView.substring(this.getNativeView(), start, end));
    }

    public final ColumnVector substring(ColumnView start, ColumnView end) {
        assert (this.type.equals(DType.STRING)) : "column type must be a String";
        assert (this.rows == start.getRowCount() && this.rows == end.getRowCount()) : "Number of rows must be equal";
        assert (start.getType().equals(DType.INT32) && end.getType().equals(DType.INT32)) : "start and end vectors must be of integer type";
        return new ColumnVector(ColumnView.substringColumn(this.getNativeView(), start.getNativeView(), end.getNativeView()));
    }

    /*
     * Exception decompiling
     */
    public final ColumnVector stringConcatenateListElements(ColumnView sepCol) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final ColumnVector stringConcatenateListElements(ColumnView sepCol, Scalar separatorNarep, Scalar stringNarep, boolean separateNulls, boolean emptyStringOutputIfEmptyList) {
        assert (this.type.equals(DType.LIST)) : "column type must be a list";
        assert (separatorNarep != null) : "separator narep scalar provided may not be null";
        assert (stringNarep != null) : "string narep scalar provided may not be null";
        assert (separatorNarep.getType().equals(DType.STRING)) : "separator naprep scalar must be a string scalar";
        assert (stringNarep.getType().equals(DType.STRING)) : "string narep scalar must be a string scalar";
        return new ColumnVector(ColumnView.stringConcatenationListElementsSepCol(this.getNativeView(), sepCol.getNativeView(), separatorNarep.getScalarHandle(), stringNarep.getScalarHandle(), separateNulls, emptyStringOutputIfEmptyList));
    }

    public final ColumnVector stringConcatenateListElements(Scalar separator, Scalar narep, boolean separateNulls, boolean emptyStringOutputIfEmptyList) {
        assert (this.type.equals(DType.LIST)) : "column type must be a list";
        assert (separator != null) : "separator scalar provided may not be null";
        assert (narep != null) : "column narep scalar provided may not be null";
        assert (narep.getType().equals(DType.STRING)) : "narep scalar must be a string scalar";
        return new ColumnVector(ColumnView.stringConcatenationListElements(this.getNativeView(), separator.getScalarHandle(), narep.getScalarHandle(), separateNulls, emptyStringOutputIfEmptyList));
    }

    public final ColumnVector getJSONObject(Scalar path) {
        assert (this.type.equals(DType.STRING)) : "column type must be a String";
        return new ColumnVector(ColumnView.getJSONObject(this.getNativeView(), path.getScalarHandle()));
    }

    public final ColumnVector stringReplace(Scalar target, Scalar replace) {
        assert (this.type.equals(DType.STRING)) : "column type must be a String";
        assert (target != null) : "target string may not be null";
        assert (target.getType().equals(DType.STRING)) : "target string must be a string scalar";
        assert (!target.getJavaString().isEmpty()) : "target scalar may not be empty";
        return new ColumnVector(ColumnView.stringReplace(this.getNativeView(), target.getScalarHandle(), replace.getScalarHandle()));
    }

    public final ColumnVector stringReplaceWithBackrefs(String pattern, String replace) {
        return new ColumnVector(ColumnView.stringReplaceWithBackrefs(this.getNativeView(), pattern, replace));
    }

    public final ColumnVector zfill(int width) {
        return new ColumnVector(ColumnView.zfill(this.getNativeView(), width));
    }

    public final ColumnVector pad(int width) {
        return this.pad(width, PadSide.RIGHT, " ");
    }

    public final ColumnVector pad(int width, PadSide side) {
        return this.pad(width, side, " ");
    }

    public final ColumnVector pad(int width, PadSide side, String fillChar) {
        assert (fillChar != null);
        assert (fillChar.length() == 1);
        return new ColumnVector(ColumnView.pad(this.getNativeView(), width, side.getNativeId(), fillChar));
    }

    public final ColumnVector startsWith(Scalar pattern) {
        assert (this.type.equals(DType.STRING)) : "column type must be a String";
        assert (pattern != null) : "pattern scalar may not be null";
        assert (pattern.getType().equals(DType.STRING)) : "pattern scalar must be a string scalar";
        return new ColumnVector(ColumnView.stringStartWith(this.getNativeView(), pattern.getScalarHandle()));
    }

    public final ColumnVector endsWith(Scalar pattern) {
        assert (this.type.equals(DType.STRING)) : "column type must be a String";
        assert (pattern != null) : "pattern scalar may not be null";
        assert (pattern.getType().equals(DType.STRING)) : "pattern scalar must be a string scalar";
        return new ColumnVector(ColumnView.stringEndWith(this.getNativeView(), pattern.getScalarHandle()));
    }

    public final ColumnVector strip() {
        assert (this.type.equals(DType.STRING)) : "column type must be a String";
        try (Scalar emptyString = Scalar.fromString("");){
            ColumnVector columnVector = new ColumnVector(ColumnView.stringStrip(this.getNativeView(), StripType.BOTH.nativeId, emptyString.getScalarHandle()));
            return columnVector;
        }
    }

    public final ColumnVector strip(Scalar toStrip) {
        assert (this.type.equals(DType.STRING)) : "column type must be a String";
        assert (toStrip != null) : "toStrip scalar may not be null";
        assert (toStrip.getType().equals(DType.STRING)) : "toStrip must be a string scalar";
        return new ColumnVector(ColumnView.stringStrip(this.getNativeView(), StripType.BOTH.nativeId, toStrip.getScalarHandle()));
    }

    public final ColumnVector lstrip() {
        assert (this.type.equals(DType.STRING)) : "column type must be a String";
        try (Scalar emptyString = Scalar.fromString("");){
            ColumnVector columnVector = new ColumnVector(ColumnView.stringStrip(this.getNativeView(), StripType.LEFT.nativeId, emptyString.getScalarHandle()));
            return columnVector;
        }
    }

    public final ColumnVector lstrip(Scalar toStrip) {
        assert (this.type.equals(DType.STRING)) : "column type must be a String";
        assert (toStrip != null) : "toStrip  Scalar may not be null";
        assert (toStrip.getType().equals(DType.STRING)) : "toStrip must be a string scalar";
        return new ColumnVector(ColumnView.stringStrip(this.getNativeView(), StripType.LEFT.nativeId, toStrip.getScalarHandle()));
    }

    public final ColumnVector rstrip() {
        assert (this.type.equals(DType.STRING)) : "column type must be a String";
        try (Scalar emptyString = Scalar.fromString("");){
            ColumnVector columnVector = new ColumnVector(ColumnView.stringStrip(this.getNativeView(), StripType.RIGHT.nativeId, emptyString.getScalarHandle()));
            return columnVector;
        }
    }

    public final ColumnVector rstrip(Scalar toStrip) {
        assert (this.type.equals(DType.STRING)) : "column type must be a String";
        assert (toStrip != null) : "toStrip  Scalar may not be null";
        assert (toStrip.getType().equals(DType.STRING)) : "toStrip must be a string scalar";
        return new ColumnVector(ColumnView.stringStrip(this.getNativeView(), StripType.RIGHT.nativeId, toStrip.getScalarHandle()));
    }

    public final ColumnVector stringContains(Scalar compString) {
        assert (this.type.equals(DType.STRING)) : "column type must be a String";
        assert (compString != null) : "compString scalar may not be null";
        assert (compString.getType().equals(DType.STRING)) : "compString scalar must be a string scalar";
        return new ColumnVector(ColumnView.stringContains(this.getNativeView(), compString.getScalarHandle()));
    }

    public final ColumnVector clamp(Scalar lo, Scalar hi) {
        return new ColumnVector(ColumnView.clamper(this.getNativeView(), lo.getScalarHandle(), lo.getScalarHandle(), hi.getScalarHandle(), hi.getScalarHandle()));
    }

    public final ColumnVector clamp(Scalar lo, Scalar loReplace, Scalar hi, Scalar hiReplace) {
        return new ColumnVector(ColumnView.clamper(this.getNativeView(), lo.getScalarHandle(), loReplace.getScalarHandle(), hi.getScalarHandle(), hiReplace.getScalarHandle()));
    }

    public final ColumnVector matchesRe(String pattern) {
        assert (this.type.equals(DType.STRING)) : "column type must be a String";
        assert (pattern != null) : "pattern may not be null";
        assert (!pattern.isEmpty()) : "pattern string may not be empty";
        return new ColumnVector(ColumnView.matchesRe(this.getNativeView(), pattern));
    }

    public final ColumnVector containsRe(String pattern) {
        assert (this.type.equals(DType.STRING)) : "column type must be a String";
        assert (pattern != null) : "pattern may not be null";
        assert (!pattern.isEmpty()) : "pattern string may not be empty";
        return new ColumnVector(ColumnView.containsRe(this.getNativeView(), pattern));
    }

    public final Table extractRe(String pattern) throws CudfException {
        assert (this.type.equals(DType.STRING)) : "column type must be a String";
        assert (pattern != null) : "pattern may not be null";
        return new Table(ColumnView.extractRe(this.getNativeView(), pattern));
    }

    public final ColumnVector urlDecode() throws CudfException {
        assert (this.type.equals(DType.STRING)) : "column type must be a String";
        return new ColumnVector(ColumnView.urlDecode(this.getNativeView()));
    }

    public final ColumnVector urlEncode() throws CudfException {
        assert (this.type.equals(DType.STRING)) : "column type must be a String";
        return new ColumnVector(ColumnView.urlEncode(this.getNativeView()));
    }

    public final ColumnVector getMapValue(Scalar key) {
        assert (this.type.equals(DType.LIST)) : "column type must be a LIST";
        assert (key != null) : "target string may not be null";
        assert (key.getType().equals(DType.STRING)) : "target string must be a string scalar";
        return new ColumnVector(ColumnView.mapLookup(this.getNativeView(), key.getScalarHandle()));
    }

    public final ColumnVector getMapKeyExistence(Scalar key) {
        assert (this.type.equals(DType.LIST)) : "column type must be a LIST";
        assert (key != null) : "target string may not be null";
        assert (key.getType().equals(DType.STRING)) : "target must be a string scalar";
        return new ColumnVector(ColumnView.mapContains(this.getNativeView(), key.getScalarHandle()));
    }

    public static ColumnView makeStructView(long rows, ColumnView ... columns) {
        long[] handles = new long[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            ColumnView cv = columns[i];
            if (rows != cv.getRowCount()) {
                throw new IllegalArgumentException("All columns must have the same number of rows");
            }
            handles[i] = cv.getNativeView();
        }
        return new ColumnView(ColumnView.makeStructView(handles, rows));
    }

    public static ColumnView makeStructView(ColumnView ... columns) {
        if (columns.length <= 0) {
            throw new IllegalArgumentException("At least one column is needed to get the row count");
        }
        return ColumnView.makeStructView(columns[0].rows, columns);
    }

    public static ColumnView fromDeviceBuffer(BaseDeviceMemoryBuffer buffer, long startOffset, DType type, int rows) {
        if (buffer == null) {
            throw new NullPointerException("buffer is null");
        }
        int typeSize = type.getSizeInBytes();
        if (typeSize <= 0) {
            throw new IllegalArgumentException("Unsupported type: " + type);
        }
        if (startOffset < 0L) {
            throw new IllegalArgumentException("Invalid start offset: " + startOffset);
        }
        if (rows < 0) {
            throw new IllegalArgumentException("Invalid row count: " + rows);
        }
        long dataSize = typeSize * rows;
        if (startOffset + dataSize > buffer.length) {
            throw new IllegalArgumentException("View extends beyond buffer range");
        }
        long dataAddress = buffer.getAddress() + startOffset;
        if (dataAddress % (long)typeSize != 0L) {
            throw new IllegalArgumentException("Data address " + Long.toHexString(dataAddress) + " is misaligned relative to type size of " + typeSize + " bytes");
        }
        return new ColumnView(ColumnView.makeCudfColumnView(type.typeId.getNativeId(), type.getScale(), dataAddress, dataSize, 0L, 0L, 0, rows, null));
    }

    public final ColumnVector listContains(Scalar key) {
        assert (this.type.equals(DType.LIST)) : "column type must be a LIST";
        return new ColumnVector(ColumnView.listContains(this.getNativeView(), key.getScalarHandle()));
    }

    public final ColumnVector listContainsColumn(ColumnView key) {
        assert (this.type.equals(DType.LIST)) : "column type must be a LIST";
        return new ColumnVector(ColumnView.listContainsColumn(this.getNativeView(), key.getNativeView()));
    }

    static DeviceMemoryBufferView getDataBuffer(long viewHandle) {
        long address = ColumnView.getNativeDataAddress(viewHandle);
        if (address == 0L) {
            return null;
        }
        long length = ColumnView.getNativeDataLength(viewHandle);
        return new DeviceMemoryBufferView(address, length);
    }

    static DeviceMemoryBufferView getValidityBuffer(long viewHandle) {
        long address = ColumnView.getNativeValidityAddress(viewHandle);
        if (address == 0L) {
            return null;
        }
        long length = ColumnView.getNativeValidityLength(viewHandle);
        return new DeviceMemoryBufferView(address, length);
    }

    static DeviceMemoryBufferView getOffsetsBuffer(long viewHandle) {
        long address = ColumnView.getNativeOffsetsAddress(viewHandle);
        if (address == 0L) {
            return null;
        }
        long length = ColumnView.getNativeOffsetsLength(viewHandle);
        return new DeviceMemoryBufferView(address, length);
    }

    private static native long stringTimestampToTimestamp(long var0, int var2, String var3);

    private static native long stringConcatenationListElementsSepCol(long var0, long var2, long var4, long var6, boolean var8, boolean var9);

    private static native long stringConcatenationListElements(long var0, long var2, long var4, boolean var6, boolean var7);

    private static native long getJSONObject(long var0, long var2) throws CudfException;

    private static native long timestampToStringTimestamp(long var0, String var2);

    private static native long substringLocate(long var0, long var2, int var4, int var5);

    private static native long[] stringSplit(long var0, long var2);

    private static native long stringSplitRecord(long var0, long var2, int var4);

    private static native long substring(long var0, int var2, int var3) throws CudfException;

    private static native long substringColumn(long var0, long var2, long var4) throws CudfException;

    private static native long stringReplace(long var0, long var2, long var4) throws CudfException;

    private static native long stringReplaceWithBackrefs(long var0, String var2, String var3) throws CudfException;

    private static native long stringStartWith(long var0, long var2) throws CudfException;

    private static native long stringEndWith(long var0, long var2) throws CudfException;

    private static native long stringStrip(long var0, int var2, long var3) throws CudfException;

    private static native long matchesRe(long var0, String var2) throws CudfException;

    private static native long containsRe(long var0, String var2) throws CudfException;

    private static native long stringContains(long var0, long var2) throws CudfException;

    private static native long[] extractRe(long var0, String var2) throws CudfException;

    private static native long urlDecode(long var0);

    private static native long urlEncode(long var0);

    private static native long mapLookup(long var0, long var2) throws CudfException;

    private static native long mapContains(long var0, long var2) throws CudfException;

    private static native long zfill(long var0, int var2);

    private static native long pad(long var0, int var2, int var3, String var4);

    private static native long binaryOpVS(long var0, long var2, int var4, int var5, int var6);

    private static native long binaryOpVV(long var0, long var2, int var4, int var5, int var6);

    private static native long countElements(long var0);

    private static native long byteCount(long var0) throws CudfException;

    private static native long extractListElement(long var0, int var2);

    private static native long listContains(long var0, long var2);

    private static native long listContainsColumn(long var0, long var2);

    private static native long castTo(long var0, int var2, int var3);

    private static native long bitCastTo(long var0, int var2, int var3);

    private static native long byteListCast(long var0, boolean var2);

    private static native long[] slice(long var0, int[] var2) throws CudfException;

    private static native long[] split(long var0, int[] var2) throws CudfException;

    private static native long findAndReplaceAll(long var0, long var2, long var4) throws CudfException;

    private static native long round(long var0, int var2, int var3) throws CudfException;

    private static native long lowerStrings(long var0);

    private static native long upperStrings(long var0);

    private static native long quantile(long var0, int var2, double[] var3) throws CudfException;

    private static native long rollingWindow(long var0, long var2, int var4, long var5, int var7, int var8, long var9, long var11);

    private static native long prefixSum(long var0) throws CudfException;

    private static native long nansToNulls(long var0) throws CudfException;

    private static native long charLengths(long var0) throws CudfException;

    private static native long replaceNullsScalar(long var0, long var2) throws CudfException;

    private static native long replaceNullsColumn(long var0, long var2) throws CudfException;

    private static native long ifElseVV(long var0, long var2, long var4) throws CudfException;

    private static native long ifElseVS(long var0, long var2, long var4) throws CudfException;

    private static native long ifElseSV(long var0, long var2, long var4) throws CudfException;

    private static native long ifElseSS(long var0, long var2, long var4) throws CudfException;

    private static native long reduce(long var0, long var2, int var4, int var5) throws CudfException;

    private static native long isNullNative(long var0);

    private static native long isNanNative(long var0);

    private static native long isFloat(long var0);

    private static native long isInteger(long var0);

    private static native long isIntegerWithType(long var0, int var2, int var3);

    private static native long isNotNanNative(long var0);

    private static native long isNotNullNative(long var0);

    private static native long unaryOperation(long var0, int var2);

    private static native long year(long var0) throws CudfException;

    private static native long month(long var0) throws CudfException;

    private static native long day(long var0) throws CudfException;

    private static native long hour(long var0) throws CudfException;

    private static native long minute(long var0) throws CudfException;

    private static native long second(long var0) throws CudfException;

    private static native long weekDay(long var0) throws CudfException;

    private static native long lastDayOfMonth(long var0) throws CudfException;

    private static native long dayOfYear(long var0) throws CudfException;

    private static native boolean containsScalar(long var0, long var2) throws CudfException;

    private static native long containsVector(long var0, long var2) throws CudfException;

    private static native long transform(long var0, String var2, boolean var3);

    private static native long clamper(long var0, long var2, long var4, long var6, long var8);

    protected static native long title(long var0);

    private static native long makeStructView(long[] var0, long var1);

    private static native long isTimestamp(long var0, String var2);

    private static native long normalizeNANsAndZeros(long var0) throws CudfException;

    private static native long bitwiseMergeAndSetValidity(long var0, long[] var2, int var3) throws CudfException;

    static native long getNativeValidPointerSize(int var0);

    static native int getNativeTypeId(long var0) throws CudfException;

    static native int getNativeTypeScale(long var0) throws CudfException;

    static native int getNativeRowCount(long var0) throws CudfException;

    static native int getNativeNullCount(long var0) throws CudfException;

    static native void deleteColumnView(long var0) throws CudfException;

    private static native long getNativeDataAddress(long var0) throws CudfException;

    private static native long getNativeDataLength(long var0) throws CudfException;

    private static native long getNativeOffsetsAddress(long var0) throws CudfException;

    private static native long getNativeOffsetsLength(long var0) throws CudfException;

    private static native long getNativeValidityAddress(long var0) throws CudfException;

    private static native long getNativeValidityLength(long var0) throws CudfException;

    static native long makeCudfColumnView(int var0, int var1, long var2, long var4, long var6, long var8, int var10, int var11, long[] var12);

    static native long getChildCvPointer(long var0, int var2) throws CudfException;

    static native int getNativeNumChildren(long var0) throws CudfException;

    static native long getDeviceMemorySize(long var0) throws CudfException;

    static native long copyColumnViewToCV(long var0) throws CudfException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HostColumnVectorCore copyToHostNestedHelper(ColumnView deviceCvPointer) {
        if (deviceCvPointer == null) {
            return null;
        }
        MemoryBuffer hostOffsets = null;
        MemoryBuffer hostValid = null;
        MemoryBuffer hostData = null;
        ArrayList<HostColumnVectorCore> children = new ArrayList<HostColumnVectorCore>();
        MemoryBuffer currData = null;
        MemoryBuffer currOffsets = null;
        MemoryBuffer currValidity = null;
        long currNullCount = 0L;
        boolean needsCleanup = true;
        try {
            Object object;
            long currRows = deviceCvPointer.getRowCount();
            DType currType = deviceCvPointer.getType();
            currData = deviceCvPointer.getData();
            currOffsets = deviceCvPointer.getOffsets();
            currValidity = deviceCvPointer.getValid();
            if (currData != null) {
                hostData = HostMemoryBuffer.allocate(((BaseDeviceMemoryBuffer)currData).length);
                ((HostMemoryBuffer)hostData).copyFromDeviceBuffer((BaseDeviceMemoryBuffer)currData);
            }
            if (currValidity != null) {
                hostValid = HostMemoryBuffer.allocate(((BaseDeviceMemoryBuffer)currValidity).length);
                ((HostMemoryBuffer)hostValid).copyFromDeviceBuffer((BaseDeviceMemoryBuffer)currValidity);
            }
            if (currOffsets != null) {
                hostOffsets = HostMemoryBuffer.allocate(((BaseDeviceMemoryBuffer)currOffsets).length);
                ((HostMemoryBuffer)hostOffsets).copyFromDeviceBuffer((BaseDeviceMemoryBuffer)currOffsets);
            }
            int numChildren = deviceCvPointer.getNumChildren();
            for (int i = 0; i < numChildren; ++i) {
                ColumnView childDevPtr = deviceCvPointer.getChildColumnView(i);
                object = null;
                try {
                    children.add(ColumnView.copyToHostNestedHelper(childDevPtr));
                    continue;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (childDevPtr != null) {
                        if (object != null) {
                            try {
                                childDevPtr.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            childDevPtr.close();
                        }
                    }
                }
            }
            currNullCount = deviceCvPointer.getNullCount();
            Optional<Long> nullCount = Optional.of(currNullCount);
            HostColumnVectorCore ret = new HostColumnVectorCore(currType, currRows, nullCount, (HostMemoryBuffer)hostData, (HostMemoryBuffer)hostValid, (HostMemoryBuffer)hostOffsets, children);
            needsCleanup = false;
            object = ret;
            return object;
        }
        finally {
            if (currData != null) {
                currData.close();
            }
            if (currOffsets != null) {
                currOffsets.close();
            }
            if (currValidity != null) {
                currValidity.close();
            }
            if (needsCleanup) {
                if (hostData != null) {
                    hostData.close();
                }
                if (hostOffsets != null) {
                    hostOffsets.close();
                }
                if (hostValid != null) {
                    hostValid.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostColumnVector copyToHost() {
        Throwable throwable = null;
        try (NvtxRange toHost = new NvtxRange("ensureOnHost", NvtxColor.BLUE);){
            HostColumnVector hostColumnVector;
            boolean needsCleanup;
            BaseDeviceMemoryBuffer offsets;
            BaseDeviceMemoryBuffer valid;
            HostMemoryBuffer hostOffsetsBuffer;
            HostMemoryBuffer hostValidityBuffer;
            HostMemoryBuffer hostDataBuffer;
            block60: {
                long rows;
                DType type;
                BaseDeviceMemoryBuffer data;
                block58: {
                    HostColumnVector hostColumnVector2;
                    block59: {
                        hostDataBuffer = null;
                        hostValidityBuffer = null;
                        hostOffsetsBuffer = null;
                        valid = this.getValid();
                        offsets = this.getOffsets();
                        data = null;
                        type = this.type;
                        rows = this.rows;
                        if (!type.isNestedType()) {
                            data = this.getData();
                        }
                        needsCleanup = true;
                        this.getNullCount();
                        if (type.isNestedType()) break block58;
                        if (valid != null) {
                            hostValidityBuffer = HostMemoryBuffer.allocate(valid.getLength());
                            hostValidityBuffer.copyFromDeviceBuffer(valid);
                        }
                        if (offsets != null) {
                            hostOffsetsBuffer = HostMemoryBuffer.allocate(offsets.length);
                            hostOffsetsBuffer.copyFromDeviceBuffer(offsets);
                        }
                        if (data != null) {
                            hostDataBuffer = HostMemoryBuffer.allocate(data.length);
                            hostDataBuffer.copyFromDeviceBuffer(data);
                        }
                        HostColumnVector ret = new HostColumnVector(type, rows, Optional.of(this.nullCount), hostDataBuffer, hostValidityBuffer, hostOffsetsBuffer);
                        needsCleanup = false;
                        hostColumnVector2 = ret;
                        if (data == null) break block59;
                        data.close();
                    }
                    if (offsets != null) {
                        offsets.close();
                    }
                    if (valid != null) {
                        valid.close();
                    }
                    if (needsCleanup) {
                        if (hostOffsetsBuffer != null) {
                            hostOffsetsBuffer.close();
                        }
                        if (hostDataBuffer != null) {
                            hostDataBuffer.close();
                        }
                        if (hostValidityBuffer != null) {
                            hostValidityBuffer.close();
                        }
                    }
                    return hostColumnVector2;
                }
                try {
                    if (data != null) {
                        hostDataBuffer = HostMemoryBuffer.allocate(data.length);
                        hostDataBuffer.copyFromDeviceBuffer(data);
                    }
                    if (valid != null) {
                        hostValidityBuffer = HostMemoryBuffer.allocate(valid.getLength());
                        hostValidityBuffer.copyFromDeviceBuffer(valid);
                    }
                    if (offsets != null) {
                        hostOffsetsBuffer = HostMemoryBuffer.allocate(offsets.getLength());
                        hostOffsetsBuffer.copyFromDeviceBuffer(offsets);
                    }
                    ArrayList<HostColumnVectorCore> children = new ArrayList<HostColumnVectorCore>();
                    for (int i = 0; i < this.getNumChildren(); ++i) {
                        try (ColumnView childDevPtr = this.getChildColumnView(i);){
                            children.add(ColumnView.copyToHostNestedHelper(childDevPtr));
                            continue;
                        }
                    }
                    HostColumnVector ret = new HostColumnVector(type, rows, Optional.of(this.nullCount), hostDataBuffer, hostValidityBuffer, hostOffsetsBuffer, children);
                    needsCleanup = false;
                    hostColumnVector = ret;
                    if (data == null) break block60;
                }
                catch (Throwable throwable2) {
                    try {
                        if (data != null) {
                            data.close();
                        }
                        if (offsets != null) {
                            offsets.close();
                        }
                        if (valid != null) {
                            valid.close();
                        }
                        if (needsCleanup) {
                            if (hostOffsetsBuffer != null) {
                                hostOffsetsBuffer.close();
                            }
                            if (hostDataBuffer != null) {
                                hostDataBuffer.close();
                            }
                            if (hostValidityBuffer != null) {
                                hostValidityBuffer.close();
                            }
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                data.close();
            }
            if (offsets != null) {
                offsets.close();
            }
            if (valid != null) {
                valid.close();
            }
            if (needsCleanup) {
                if (hostOffsetsBuffer != null) {
                    hostOffsetsBuffer.close();
                }
                if (hostDataBuffer != null) {
                    hostDataBuffer.close();
                }
                if (hostValidityBuffer != null) {
                    hostValidityBuffer.close();
                }
            }
            return hostColumnVector;
        }
    }

    static class NestedColumnVector {
        private final DeviceMemoryBuffer data;
        private final DeviceMemoryBuffer valid;
        private final DeviceMemoryBuffer offsets;
        private final DType dataType;
        private final long rows;
        private final Optional<Long> nullCount;
        List<NestedColumnVector> children;

        private NestedColumnVector(DType type, long rows, Optional<Long> nullCount, DeviceMemoryBuffer data, DeviceMemoryBuffer valid, DeviceMemoryBuffer offsets, List<NestedColumnVector> children) {
            this.dataType = type;
            this.rows = rows;
            this.nullCount = nullCount;
            this.data = data;
            this.valid = valid;
            this.offsets = offsets;
            this.children = children;
        }

        static ColumnVector createColumnVector(DType type, int rows, HostMemoryBuffer data, HostMemoryBuffer valid, HostMemoryBuffer offsets, Optional<Long> nullCount, List<HostColumnVectorCore> child) {
            ArrayList<NestedColumnVector> devChildren = new ArrayList<NestedColumnVector>();
            for (HostColumnVectorCore c : child) {
                devChildren.add(NestedColumnVector.createNewNestedColumnVector(c));
            }
            int mainColRows = rows;
            DType mainColType = type;
            HostMemoryBuffer mainColValid = valid;
            HostMemoryBuffer mainColOffsets = offsets;
            DeviceMemoryBuffer mainDataDevBuff = null;
            DeviceMemoryBuffer mainValidDevBuff = null;
            DeviceMemoryBuffer mainOffsetsDevBuff = null;
            if (mainColValid != null) {
                long validLen = ColumnView.getNativeValidPointerSize(mainColRows);
                mainValidDevBuff = DeviceMemoryBuffer.allocate(validLen);
                mainValidDevBuff.copyFromHostBuffer(mainColValid, 0L, validLen);
            }
            if (data != null) {
                long dataLen = data.length;
                mainDataDevBuff = DeviceMemoryBuffer.allocate(dataLen);
                mainDataDevBuff.copyFromHostBuffer(data, 0L, dataLen);
            }
            if (mainColOffsets != null) {
                long offsetsLen = HostColumnVector.OFFSET_SIZE * (mainColRows + 1);
                mainOffsetsDevBuff = DeviceMemoryBuffer.allocate(offsetsLen);
                mainOffsetsDevBuff.copyFromHostBuffer(mainColOffsets, 0L, offsetsLen);
            }
            ArrayList<DeviceMemoryBuffer> toClose = new ArrayList<DeviceMemoryBuffer>();
            long[] childHandles = new long[devChildren.size()];
            for (NestedColumnVector ncv : devChildren) {
                toClose.addAll(ncv.getBuffersToClose());
            }
            for (int i = 0; i < devChildren.size(); ++i) {
                childHandles[i] = ((NestedColumnVector)devChildren.get(i)).getViewHandle();
            }
            return new ColumnVector(mainColType, mainColRows, nullCount, mainDataDevBuff, mainValidDevBuff, mainOffsetsDevBuff, toClose, childHandles);
        }

        private static NestedColumnVector createNewNestedColumnVector(HostColumnVectorCore nestedChildren) {
            if (nestedChildren == null) {
                return null;
            }
            DType colType = nestedChildren.getType();
            Optional<Long> nullCount = Optional.of(nestedChildren.getNullCount());
            long colRows = nestedChildren.getRowCount();
            HostMemoryBuffer colData = nestedChildren.getNestedChildren().isEmpty() ? nestedChildren.getData() : null;
            HostMemoryBuffer colValid = nestedChildren.getValidity();
            HostMemoryBuffer colOffsets = nestedChildren.getOffsets();
            ArrayList<NestedColumnVector> children = new ArrayList<NestedColumnVector>();
            for (HostColumnVectorCore nhcv : nestedChildren.getNestedChildren()) {
                children.add(NestedColumnVector.createNewNestedColumnVector(nhcv));
            }
            return NestedColumnVector.createNestedColumnVector(colType, colRows, nullCount, colData, colValid, colOffsets, children);
        }

        long getViewHandle() {
            long[] childrenColViews = null;
            if (this.children != null) {
                childrenColViews = new long[this.children.size()];
                for (int i = 0; i < this.children.size(); ++i) {
                    childrenColViews[i] = this.children.get(i).getViewHandle();
                }
            }
            long dataAddr = this.data == null ? 0L : this.data.address;
            long dataLen = this.data == null ? 0L : this.data.length;
            long offsetAddr = this.offsets == null ? 0L : this.offsets.address;
            long validAddr = this.valid == null ? 0L : this.valid.address;
            int nc = this.nullCount.orElse(-1L).intValue();
            return ColumnView.makeCudfColumnView(this.dataType.typeId.getNativeId(), this.dataType.getScale(), dataAddr, dataLen, offsetAddr, validAddr, nc, (int)this.rows, childrenColViews);
        }

        List<DeviceMemoryBuffer> getBuffersToClose() {
            ArrayList<DeviceMemoryBuffer> buffers = new ArrayList<DeviceMemoryBuffer>();
            if (this.children != null) {
                for (NestedColumnVector ncv : this.children) {
                    buffers.addAll(ncv.getBuffersToClose());
                }
            }
            if (this.data != null) {
                buffers.add(this.data);
            }
            if (this.valid != null) {
                buffers.add(this.valid);
            }
            if (this.offsets != null) {
                buffers.add(this.offsets);
            }
            return buffers;
        }

        private static long getEndStringOffset(long totalRows, long index, HostMemoryBuffer offsets) {
            assert (index < totalRows);
            return offsets.getInt((index + 1L) * 4L);
        }

        private static NestedColumnVector createNestedColumnVector(DType type, long rows, Optional<Long> nullCount, HostMemoryBuffer dataBuffer, HostMemoryBuffer validityBuffer, HostMemoryBuffer offsetBuffer, List<NestedColumnVector> child) {
            DeviceMemoryBuffer data = null;
            DeviceMemoryBuffer valid = null;
            DeviceMemoryBuffer offsets = null;
            if (dataBuffer != null) {
                long dataLen = rows * (long)type.getSizeInBytes();
                if (type.equals(DType.STRING) && (dataLen = NestedColumnVector.getEndStringOffset(rows, rows - 1L, offsetBuffer)) == 0L && nullCount.get() == 0L) {
                    dataLen = 1L;
                }
                data = DeviceMemoryBuffer.allocate(dataLen);
                data.copyFromHostBuffer(dataBuffer, 0L, dataLen);
            }
            if (validityBuffer != null) {
                long validLen = ColumnView.getNativeValidPointerSize((int)rows);
                valid = DeviceMemoryBuffer.allocate(validLen);
                valid.copyFromHostBuffer(validityBuffer, 0L, validLen);
            }
            if (offsetBuffer != null) {
                long offsetsLen = (long)HostColumnVector.OFFSET_SIZE * (rows + 1L);
                offsets = DeviceMemoryBuffer.allocate(offsetsLen);
                offsets.copyFromHostBuffer(offsetBuffer, 0L, offsetsLen);
            }
            NestedColumnVector ret = new NestedColumnVector(type, rows, nullCount, data, valid, offsets, child);
            return ret;
        }
    }

    private static enum StripType {
        LEFT(0),
        RIGHT(1),
        BOTH(2);

        final int nativeId;

        private StripType(int nativeId) {
            this.nativeId = nativeId;
        }
    }
}

