/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.CompressionType;
import ai.rapids.cudf.WriterOptions;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

class CompressedMetadataWriterOptions
extends WriterOptions {
    private final CompressionType compressionType;
    private final Map<String, String> metadata;

    <T extends CMWriterBuilder> CompressedMetadataWriterOptions(T builder) {
        super(builder);
        this.compressionType = builder.compressionType;
        this.metadata = Collections.unmodifiableMap(builder.metadata);
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    String[] getMetadataKeys() {
        return this.metadata.keySet().toArray(new String[this.metadata.size()]);
    }

    String[] getMetadataValues() {
        return this.metadata.values().toArray(new String[this.metadata.size()]);
    }

    protected static class CMWriterBuilder<T extends CMWriterBuilder>
    extends WriterOptions.WriterBuilder<T> {
        final Map<String, String> metadata = new LinkedHashMap<String, String>();
        CompressionType compressionType = CompressionType.AUTO;

        protected CMWriterBuilder() {
        }

        public T withMetadata(String key, String value) {
            this.metadata.put(key, value);
            return (T)this;
        }

        public T withMetadata(Map<String, String> metadata) {
            this.metadata.putAll(metadata);
            return (T)this;
        }

        public T withCompressionType(CompressionType compression) {
            this.compressionType = compression;
            return (T)this;
        }
    }
}

