/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.DeviceMemoryBuffer;
import ai.rapids.cudf.Table;
import java.nio.ByteBuffer;

public final class ContiguousTable
implements AutoCloseable {
    private long metadataHandle = 0L;
    private Table table = null;
    private DeviceMemoryBuffer buffer;
    private ByteBuffer metadataBuffer = null;
    private final long rowCount;

    static ContiguousTable fromPackedTable(long metadataHandle, long dataAddress, long dataLength, long rmmBufferAddress, long rowCount) {
        DeviceMemoryBuffer buffer = DeviceMemoryBuffer.fromRmm(dataAddress, dataLength, rmmBufferAddress);
        return new ContiguousTable(metadataHandle, buffer, rowCount);
    }

    ContiguousTable(Table table, DeviceMemoryBuffer buffer) {
        this.metadataHandle = ContiguousTable.createPackedMetadata(table.getNativeView(), buffer.getAddress(), buffer.getLength());
        this.table = table;
        this.buffer = buffer;
        this.rowCount = table.getRowCount();
    }

    ContiguousTable(long metadataHandle, DeviceMemoryBuffer buffer, long rowCount) {
        this.metadataHandle = metadataHandle;
        this.buffer = buffer;
        this.rowCount = rowCount;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public synchronized Table getTable() {
        if (this.table == null) {
            this.table = Table.fromPackedTable(this.getMetadataDirectBuffer(), this.buffer);
        }
        return this.table;
    }

    public DeviceMemoryBuffer getBuffer() {
        return this.buffer;
    }

    public ByteBuffer getMetadataDirectBuffer() {
        if (this.metadataBuffer == null) {
            this.metadataBuffer = ContiguousTable.createMetadataDirectBuffer(this.metadataHandle);
        }
        return this.metadataBuffer.asReadOnlyBuffer();
    }

    @Override
    public void close() {
        if (this.metadataHandle != 0L) {
            ContiguousTable.closeMetadata(this.metadataHandle);
            this.metadataHandle = 0L;
        }
        if (this.table != null) {
            this.table.close();
            this.table = null;
        }
        if (this.buffer != null) {
            this.buffer.close();
            this.buffer = null;
        }
    }

    private static native long createPackedMetadata(long var0, long var2, long var4);

    private static native ByteBuffer createMetadataDirectBuffer(long var0);

    private static native void closeMetadata(long var0);
}

