/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.BaseDeviceMemoryBuffer;
import ai.rapids.cudf.CuFileDriver;
import ai.rapids.cudf.NativeDepsLoader;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuFile {
    private static final Logger log = LoggerFactory.getLogger(CuFile.class);
    private static boolean initialized = false;
    private static CuFileDriver driver;

    static synchronized void initialize() {
        if (!initialized) {
            try {
                NativeDepsLoader.loadNativeDeps(new String[]{"cufilejni"});
                driver = new CuFileDriver();
                Runtime.getRuntime().addShutdownHook(new Thread(() -> driver.close()));
                initialized = true;
            }
            catch (Throwable t) {
                log.error("Could not load cuFile jni library...", t);
            }
        }
    }

    public static boolean libraryLoaded() {
        return initialized;
    }

    public static void writeDeviceBufferToFile(File path, long file_offset, BaseDeviceMemoryBuffer buffer) {
        CuFile.writeDeviceMemoryToFile(path, file_offset, buffer.getAddress(), buffer.getLength());
    }

    public static void writeDeviceMemoryToFile(File path, long file_offset, long address, long length) {
        CuFile.writeToFile(path.getAbsolutePath(), file_offset, address, length);
    }

    public static long appendDeviceBufferToFile(File path, BaseDeviceMemoryBuffer buffer) {
        return CuFile.appendDeviceMemoryToFile(path, buffer.getAddress(), buffer.getLength());
    }

    public static long appendDeviceMemoryToFile(File path, long address, long length) {
        return CuFile.appendToFile(path.getAbsolutePath(), address, length);
    }

    public static void readFileToDeviceBuffer(BaseDeviceMemoryBuffer buffer, File path, long fileOffset) {
        CuFile.readFileToDeviceMemory(buffer.getAddress(), buffer.getLength(), path, fileOffset);
    }

    public static void readFileToDeviceMemory(long address, long length, File path, long fileOffset) {
        CuFile.readFromFile(address, length, path.getAbsolutePath(), fileOffset);
    }

    private static native void writeToFile(String var0, long var1, long var3, long var5);

    private static native long appendToFile(String var0, long var1, long var3);

    private static native void readFromFile(long var0, long var2, String var4, long var5);

    static {
        CuFile.initialize();
    }
}

