/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.BaseDeviceMemoryBuffer;
import ai.rapids.cudf.CuFile;
import ai.rapids.cudf.CuFileResourceCleaner;
import ai.rapids.cudf.DeviceMemoryBuffer;
import ai.rapids.cudf.MemoryBuffer;
import ai.rapids.cudf.MemoryCleaner;

public final class CuFileBuffer
extends BaseDeviceMemoryBuffer {
    private static final int ALIGNMENT = 4096;
    private final DeviceMemoryBuffer deviceMemoryBuffer;
    private final CuFileResourceCleaner cleaner;

    private CuFileBuffer(DeviceMemoryBuffer buffer, boolean registerBuffer) {
        super(buffer.address, buffer.length, (MemoryBuffer.MemoryBufferCleaner)null);
        if (registerBuffer && !this.isAligned(buffer)) {
            buffer.close();
            throw new IllegalArgumentException("To register a cuFile buffer, its length must be a multiple of 4096");
        }
        this.deviceMemoryBuffer = buffer;
        this.cleaner = new CuFileResourceCleaner(CuFileBuffer.create(buffer.address, buffer.length, registerBuffer), CuFileBuffer::destroy);
        MemoryCleaner.register(this, (MemoryCleaner.Cleaner)this.cleaner);
    }

    public static CuFileBuffer allocate(long bytes, boolean registerBuffer) {
        DeviceMemoryBuffer buffer = DeviceMemoryBuffer.allocate(bytes);
        return new CuFileBuffer(buffer, registerBuffer);
    }

    @Override
    public MemoryBuffer slice(long offset, long len) {
        throw new UnsupportedOperationException("Slice on cuFile buffer is not supported");
    }

    @Override
    public void close() {
        this.cleaner.close(this);
        this.deviceMemoryBuffer.close();
    }

    long getPointer() {
        return this.cleaner.getPointer();
    }

    private boolean isAligned(BaseDeviceMemoryBuffer buffer) {
        return buffer.length % 4096L == 0L;
    }

    private static native long create(long var0, long var2, boolean var4);

    private static native void destroy(long var0);

    static {
        CuFile.initialize();
    }
}

