/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.CuFileResourceDestroyer;
import ai.rapids.cudf.MemoryCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CuFileResourceCleaner
extends MemoryCleaner.Cleaner {
    private static final Logger log = LoggerFactory.getLogger(CuFileResourceCleaner.class);
    private long pointer;
    private final CuFileResourceDestroyer destroyer;
    private boolean closed = false;

    CuFileResourceCleaner(long pointer, CuFileResourceDestroyer destroyer) {
        this.pointer = pointer;
        this.destroyer = destroyer;
        this.addRef();
    }

    long getPointer() {
        return this.pointer;
    }

    synchronized void close(Object resource) {
        this.delRef();
        if (this.closed) {
            this.logRefCountDebug("double free " + resource);
            throw new IllegalStateException("Close called too many times " + resource);
        }
        this.clean(false);
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized boolean cleanImpl(boolean logErrorIfNotClean) {
        boolean neededCleanup = false;
        long origAddress = this.pointer;
        if (this.pointer != 0L) {
            try {
                this.destroyer.destroy(this.pointer);
            }
            finally {
                this.pointer = 0L;
            }
            neededCleanup = true;
        }
        if (neededCleanup && logErrorIfNotClean) {
            log.error("A CUFile RESOURCE WAS LEAKED (ID: " + this.id + " " + Long.toHexString(origAddress) + ")");
            this.logRefCountDebug("Leaked cuFile resource");
        }
        return neededCleanup;
    }

    @Override
    public boolean isClean() {
        return this.pointer == 0L;
    }
}

