/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.CudaException;
import ai.rapids.cudf.CudaMemInfo;
import ai.rapids.cudf.CudaMemcpyKind;
import ai.rapids.cudf.CudfException;
import ai.rapids.cudf.MemoryCleaner;
import ai.rapids.cudf.NativeDepsLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cuda {
    static final int CPU_DEVICE_ID = -1;
    static final long CUDA_STREAM_DEFAULT = 0L;
    static final long CUDA_STREAM_LEGACY = 1L;
    static final long CUDA_STREAM_PER_THREAD = 2L;
    private static final long DEFAULT_STREAM_ID;
    private static final Logger log;
    private static Boolean isCompat;
    public static final Stream DEFAULT_STREAM;

    public static native CudaMemInfo memGetInfo() throws CudaException;

    static native long hostAllocPinned(long var0) throws CudaException;

    static native void freePinned(long var0) throws CudaException;

    static void memcpy(long dst, long src, long count, CudaMemcpyKind kind) {
        Cuda.memcpy(dst, src, count, kind, DEFAULT_STREAM);
    }

    static void asyncMemcpy(long dst, long src, long count, CudaMemcpyKind kind) {
        Cuda.asyncMemcpy(dst, src, count, kind, DEFAULT_STREAM);
    }

    public static native void memset(long var0, byte var2, long var3) throws CudaException;

    public static native void asyncMemset(long var0, byte var2, long var3) throws CudaException;

    public static native int getDevice() throws CudaException;

    public static native int getDeviceCount() throws CudaException;

    public static native void setDevice(int var0) throws CudaException, CudfException;

    public static native void autoSetDevice() throws CudaException;

    public static native void freeZero() throws CudaException;

    static native long createStream(boolean var0) throws CudaException;

    static native void destroyStream(long var0) throws CudaException;

    static native void streamWaitEvent(long var0, long var2) throws CudaException;

    static native void streamSynchronize(long var0) throws CudaException;

    static native long createEvent(boolean var0, boolean var1) throws CudaException;

    static native void destroyEvent(long var0) throws CudaException;

    static native boolean eventQuery(long var0) throws CudaException;

    static native void eventRecord(long var0, long var2) throws CudaException;

    static native void eventSynchronize(long var0) throws CudaException;

    static void memcpy(long dst, long src, long count, CudaMemcpyKind kind, Stream stream) {
        Cuda.memcpyOnStream(dst, src, count, kind.getValue(), stream.getStream());
    }

    private static native void memcpyOnStream(long var0, long var2, long var4, int var6, long var7) throws CudaException;

    static void asyncMemcpy(long dst, long src, long count, CudaMemcpyKind kind, Stream stream) {
        Cuda.asyncMemcpyOnStream(dst, src, count, kind.getValue(), stream.getStream());
    }

    private static native void asyncMemcpyOnStream(long var0, long var2, long var4, int var6, long var7) throws CudaException;

    public static synchronized boolean isEnvCompatibleForTesting() {
        if (isCompat == null) {
            if (NativeDepsLoader.libraryLoaded()) {
                try {
                    int device = Cuda.getDevice();
                    if (device >= 0) {
                        isCompat = true;
                        return isCompat;
                    }
                }
                catch (Throwable e) {
                    log.error("Error trying to detect device", e);
                }
            }
            isCompat = false;
        }
        return isCompat;
    }

    public static native boolean isPtdsEnabled();

    static {
        NativeDepsLoader.loadNativeDeps();
        DEFAULT_STREAM_ID = Cuda.isPtdsEnabled() ? 2L : 1L;
        log = LoggerFactory.getLogger(Cuda.class);
        isCompat = null;
        DEFAULT_STREAM = new Stream();
    }

    public static final class Event
    implements AutoCloseable {
        private final EventCleaner cleaner;
        boolean closed = false;

        public Event() {
            this(false, false);
        }

        public Event(boolean enableTiming, boolean blockingSync) {
            this.cleaner = new EventCleaner(Cuda.createEvent(enableTiming, blockingSync));
            MemoryCleaner.register(this, (MemoryCleaner.Cleaner)this.cleaner);
            this.cleaner.addRef();
        }

        long getEvent() {
            return this.cleaner.event;
        }

        public boolean hasCompleted() {
            return Cuda.eventQuery(this.getEvent());
        }

        public void record(Stream stream) {
            Cuda.eventRecord(this.getEvent(), stream.getStream());
        }

        public void record() {
            this.record(DEFAULT_STREAM);
        }

        public void sync() {
            Cuda.eventSynchronize(this.getEvent());
        }

        public String toString() {
            return "CUDA EVENT (ID: " + this.cleaner.id + " " + Long.toHexString(this.getEvent()) + ")";
        }

        @Override
        public synchronized void close() {
            this.cleaner.delRef();
            if (this.closed) {
                this.cleaner.logRefCountDebug("double free " + this);
                throw new IllegalStateException("Close called too many times " + this);
            }
            this.cleaner.clean(false);
            this.closed = true;
        }
    }

    private static class EventCleaner
    extends MemoryCleaner.Cleaner {
        private long event;

        EventCleaner(long event) {
            this.event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected synchronized boolean cleanImpl(boolean logErrorIfNotClean) {
            boolean neededCleanup = false;
            long origAddress = this.event;
            if (this.event != 0L) {
                try {
                    Cuda.destroyEvent(this.event);
                }
                finally {
                    this.event = 0L;
                }
                neededCleanup = true;
            }
            if (neededCleanup && logErrorIfNotClean) {
                log.error("A CUDA EVENT WAS LEAKED (ID: " + this.id + " " + Long.toHexString(origAddress) + ")");
                this.logRefCountDebug("Leaked event");
            }
            return neededCleanup;
        }

        @Override
        public boolean isClean() {
            return this.event == 0L;
        }
    }

    public static final class Stream
    implements AutoCloseable {
        private final StreamCleaner cleaner;
        boolean closed = false;
        private final long id;

        public Stream(boolean isNonBlocking) {
            this.cleaner = new StreamCleaner(Cuda.createStream(isNonBlocking));
            this.id = this.cleaner.id;
            MemoryCleaner.register(this, (MemoryCleaner.Cleaner)this.cleaner);
            this.cleaner.addRef();
        }

        private Stream() {
            this.cleaner = null;
            this.id = -1L;
        }

        public void waitOn(Event event) {
            Cuda.streamWaitEvent(this.getStream(), event.getEvent());
        }

        public long getStream() {
            return this.cleaner == null ? DEFAULT_STREAM_ID : this.cleaner.stream;
        }

        public void sync() {
            Cuda.streamSynchronize(this.getStream());
        }

        public String toString() {
            return "CUDA STREAM (ID: " + this.id + " " + Long.toHexString(this.getStream()) + ")";
        }

        @Override
        public synchronized void close() {
            if (this.cleaner != null) {
                this.cleaner.delRef();
            }
            if (this.closed) {
                this.cleaner.logRefCountDebug("double free " + this);
                throw new IllegalStateException("Close called too many times " + this);
            }
            if (this.cleaner != null) {
                this.cleaner.clean(false);
                this.closed = true;
            }
        }
    }

    private static class StreamCleaner
    extends MemoryCleaner.Cleaner {
        private long stream;

        StreamCleaner(long stream) {
            this.stream = stream;
        }

        @Override
        protected synchronized boolean cleanImpl(boolean logErrorIfNotClean) {
            boolean neededCleanup = false;
            long origAddress = this.stream;
            if (this.stream != 0L && this.stream != 1L && this.stream != 2L) {
                Cuda.destroyStream(this.stream);
                this.stream = 0L;
                neededCleanup = true;
            }
            if (neededCleanup && logErrorIfNotClean) {
                log.error("A CUDA STREAM WAS LEAKED (ID: " + this.id + " " + Long.toHexString(origAddress) + ")");
                this.logRefCountDebug("Leaked stream");
            }
            return neededCleanup;
        }

        @Override
        public boolean isClean() {
            return this.stream == 0L;
        }
    }
}

