/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import java.math.BigDecimal;
import java.util.EnumSet;
import java.util.Objects;

public final class DType {
    public static final int DECIMAL32_MAX_PRECISION = 9;
    public static final int DECIMAL64_MAX_PRECISION = 18;
    final DTypeEnum typeId;
    private final int scale;
    public static final DType EMPTY = new DType(DTypeEnum.EMPTY);
    public static final DType INT8 = new DType(DTypeEnum.INT8);
    public static final DType INT16 = new DType(DTypeEnum.INT16);
    public static final DType INT32 = new DType(DTypeEnum.INT32);
    public static final DType INT64 = new DType(DTypeEnum.INT64);
    public static final DType UINT8 = new DType(DTypeEnum.UINT8);
    public static final DType UINT16 = new DType(DTypeEnum.UINT16);
    public static final DType UINT32 = new DType(DTypeEnum.UINT32);
    public static final DType UINT64 = new DType(DTypeEnum.UINT64);
    public static final DType FLOAT32 = new DType(DTypeEnum.FLOAT32);
    public static final DType FLOAT64 = new DType(DTypeEnum.FLOAT64);
    public static final DType BOOL8 = new DType(DTypeEnum.BOOL8);
    public static final DType TIMESTAMP_DAYS = new DType(DTypeEnum.TIMESTAMP_DAYS);
    public static final DType TIMESTAMP_SECONDS = new DType(DTypeEnum.TIMESTAMP_SECONDS);
    public static final DType TIMESTAMP_MILLISECONDS = new DType(DTypeEnum.TIMESTAMP_MILLISECONDS);
    public static final DType TIMESTAMP_MICROSECONDS = new DType(DTypeEnum.TIMESTAMP_MICROSECONDS);
    public static final DType TIMESTAMP_NANOSECONDS = new DType(DTypeEnum.TIMESTAMP_NANOSECONDS);
    public static final DType DURATION_DAYS = new DType(DTypeEnum.DURATION_DAYS);
    public static final DType DURATION_SECONDS = new DType(DTypeEnum.DURATION_SECONDS);
    public static final DType DURATION_MILLISECONDS = new DType(DTypeEnum.DURATION_MILLISECONDS);
    public static final DType DURATION_MICROSECONDS = new DType(DTypeEnum.DURATION_MICROSECONDS);
    public static final DType DURATION_NANOSECONDS = new DType(DTypeEnum.DURATION_NANOSECONDS);
    public static final DType STRING = new DType(DTypeEnum.STRING);
    public static final DType LIST = new DType(DTypeEnum.LIST);
    public static final DType STRUCT = new DType(DTypeEnum.STRUCT);
    private static final DType[] SINGLETON_DTYPE_LOOKUP = new DType[]{EMPTY, INT8, INT16, INT32, INT64, UINT8, UINT16, UINT32, UINT64, FLOAT32, FLOAT64, BOOL8, TIMESTAMP_DAYS, TIMESTAMP_SECONDS, TIMESTAMP_MILLISECONDS, TIMESTAMP_MICROSECONDS, TIMESTAMP_NANOSECONDS, DURATION_DAYS, DURATION_SECONDS, DURATION_MILLISECONDS, DURATION_MICROSECONDS, DURATION_NANOSECONDS, null, STRING, LIST, null, null, STRUCT};
    private static final EnumSet<DTypeEnum> TIMESTAMPS = EnumSet.of(DTypeEnum.TIMESTAMP_DAYS, DTypeEnum.TIMESTAMP_SECONDS, DTypeEnum.TIMESTAMP_MILLISECONDS, DTypeEnum.TIMESTAMP_MICROSECONDS, DTypeEnum.TIMESTAMP_NANOSECONDS);
    private static final EnumSet<DTypeEnum> TIME_RESOLUTION = EnumSet.of(DTypeEnum.TIMESTAMP_SECONDS, DTypeEnum.TIMESTAMP_MILLISECONDS, DTypeEnum.TIMESTAMP_MICROSECONDS, DTypeEnum.TIMESTAMP_NANOSECONDS);
    private static final EnumSet<DTypeEnum> DURATION_TYPE = EnumSet.of(DTypeEnum.DURATION_DAYS, DTypeEnum.DURATION_MICROSECONDS, DTypeEnum.DURATION_MILLISECONDS, DTypeEnum.DURATION_NANOSECONDS, DTypeEnum.DURATION_SECONDS);
    private static final EnumSet<DTypeEnum> LONGS = EnumSet.of(DTypeEnum.INT64, new DTypeEnum[]{DTypeEnum.UINT64, DTypeEnum.DURATION_SECONDS, DTypeEnum.DURATION_MILLISECONDS, DTypeEnum.DURATION_MICROSECONDS, DTypeEnum.DURATION_NANOSECONDS, DTypeEnum.TIMESTAMP_SECONDS, DTypeEnum.TIMESTAMP_MILLISECONDS, DTypeEnum.TIMESTAMP_MICROSECONDS, DTypeEnum.TIMESTAMP_NANOSECONDS, DTypeEnum.DECIMAL64});
    private static final EnumSet<DTypeEnum> INTS = EnumSet.of(DTypeEnum.INT32, DTypeEnum.UINT32, DTypeEnum.DURATION_DAYS, DTypeEnum.TIMESTAMP_DAYS, DTypeEnum.DECIMAL32);
    private static final EnumSet<DTypeEnum> SHORTS = EnumSet.of(DTypeEnum.INT16, DTypeEnum.UINT16);
    private static final EnumSet<DTypeEnum> BYTES = EnumSet.of(DTypeEnum.INT8, DTypeEnum.UINT8, DTypeEnum.BOOL8);
    private static final EnumSet<DTypeEnum> DECIMALS = EnumSet.of(DTypeEnum.DECIMAL32, DTypeEnum.DECIMAL64);
    private static final EnumSet<DTypeEnum> NESTED_TYPE = EnumSet.of(DTypeEnum.LIST, DTypeEnum.STRUCT);
    private static final EnumSet<DTypeEnum> OFFSETS_TYPE = EnumSet.of(DTypeEnum.STRING, DTypeEnum.LIST);

    private DType(DTypeEnum id) {
        this.typeId = id;
        this.scale = 0;
    }

    private DType(DTypeEnum id, int decimalScale) {
        this.typeId = id;
        this.scale = decimalScale;
    }

    public int getSizeInBytes() {
        return this.typeId.sizeInBytes;
    }

    public int getScale() {
        return this.scale;
    }

    public String getSimpleName() {
        return this.typeId.simpleName;
    }

    public DTypeEnum getTypeId() {
        return this.typeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DType type = (DType)o;
        return this.scale == type.scale && this.typeId == type.typeId;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.typeId, this.scale});
    }

    public String toString() {
        if (this.isDecimalType()) {
            return (Object)((Object)this.typeId) + " scale:" + this.scale;
        }
        return String.valueOf((Object)this.typeId);
    }

    public static DType create(DTypeEnum dt) {
        if (DECIMALS.contains((Object)dt)) {
            throw new IllegalArgumentException("Could not create a Decimal DType without scale");
        }
        return DType.fromNative(dt.nativeId, 0);
    }

    public static DType create(DTypeEnum dt, int scale) {
        if (!DECIMALS.contains((Object)dt)) {
            throw new IllegalArgumentException("Could not create a non-Decimal DType with scale");
        }
        return DType.fromNative(dt.nativeId, scale);
    }

    public static DType fromNative(int nativeId, int scale) {
        if (nativeId >= 0 && nativeId < SINGLETON_DTYPE_LOOKUP.length) {
            DType ret = SINGLETON_DTYPE_LOOKUP[nativeId];
            if (ret != null) {
                assert (ret.typeId.nativeId == nativeId) : "Something went wrong and it looks like SINGLETON_DTYPE_LOOKUP is out of sync";
                return ret;
            }
            if (nativeId == DTypeEnum.DECIMAL32.nativeId) {
                if (-scale > 9) {
                    throw new IllegalArgumentException("Scale " + -scale + " exceeds DECIMAL32_MAX_PRECISION " + 9);
                }
                return new DType(DTypeEnum.DECIMAL32, scale);
            }
            if (nativeId == DTypeEnum.DECIMAL64.nativeId) {
                if (-scale > 18) {
                    throw new IllegalArgumentException("Scale " + -scale + " exceeds DECIMAL64_MAX_PRECISION " + 18);
                }
                return new DType(DTypeEnum.DECIMAL64, scale);
            }
        }
        throw new IllegalArgumentException("Could not translate " + nativeId + " into a DType");
    }

    public static DType fromJavaBigDecimal(BigDecimal dec) {
        if (dec.precision() <= 9) {
            return new DType(DTypeEnum.DECIMAL32, -dec.scale());
        }
        if (dec.precision() <= 18) {
            return new DType(DTypeEnum.DECIMAL64, -dec.scale());
        }
        throw new IllegalArgumentException("Precision " + dec.precision() + " exceeds max precision cuDF can support " + 18);
    }

    public boolean hasTimeResolution() {
        return TIME_RESOLUTION.contains((Object)this.typeId);
    }

    public boolean isBackedByInt() {
        return INTS.contains((Object)this.typeId);
    }

    public boolean isBackedByLong() {
        return LONGS.contains((Object)this.typeId);
    }

    public boolean isBackedByShort() {
        return SHORTS.contains((Object)this.typeId);
    }

    public boolean isBackedByByte() {
        return BYTES.contains((Object)this.typeId);
    }

    public boolean isDecimalType() {
        return this.typeId.isDecimalType();
    }

    public boolean isDurationType() {
        return DURATION_TYPE.contains((Object)this.typeId);
    }

    public boolean isNestedType() {
        return NESTED_TYPE.contains((Object)this.typeId);
    }

    @Deprecated
    public boolean isTimestamp() {
        return TIMESTAMPS.contains((Object)this.typeId);
    }

    public boolean isTimestampType() {
        return TIMESTAMPS.contains((Object)this.typeId);
    }

    public boolean hasOffsets() {
        return OFFSETS_TYPE.contains((Object)this.typeId);
    }

    public static enum DTypeEnum {
        EMPTY(0, 0, "NOT SUPPORTED"),
        INT8(1, 1, "byte"),
        INT16(2, 2, "short"),
        INT32(4, 3, "int"),
        INT64(8, 4, "long"),
        UINT8(1, 5, "uint8"),
        UINT16(2, 6, "uint16"),
        UINT32(4, 7, "uint32"),
        UINT64(8, 8, "uint64"),
        FLOAT32(4, 9, "float"),
        FLOAT64(8, 10, "double"),
        BOOL8(1, 11, "bool"),
        TIMESTAMP_DAYS(4, 12, "date32"),
        TIMESTAMP_SECONDS(8, 13, "timestamp[s]"),
        TIMESTAMP_MILLISECONDS(8, 14, "timestamp[ms]"),
        TIMESTAMP_MICROSECONDS(8, 15, "timestamp[us]"),
        TIMESTAMP_NANOSECONDS(8, 16, "timestamp[ns]"),
        DURATION_DAYS(4, 17, "int32"),
        DURATION_SECONDS(8, 18, "int64"),
        DURATION_MILLISECONDS(8, 19, "int64"),
        DURATION_MICROSECONDS(8, 20, "int64"),
        DURATION_NANOSECONDS(8, 21, "int64"),
        STRING(0, 23, "str"),
        LIST(0, 24, "list"),
        DECIMAL32(4, 25, "decimal32"),
        DECIMAL64(8, 26, "decimal64"),
        STRUCT(0, 27, "struct");

        final int sizeInBytes;
        final int nativeId;
        final String simpleName;

        private DTypeEnum(int sizeInBytes, int nativeId, String simpleName) {
            this.sizeInBytes = sizeInBytes;
            this.nativeId = nativeId;
            this.simpleName = simpleName;
        }

        public int getNativeId() {
            return this.nativeId;
        }

        public boolean isDecimalType() {
            return DECIMALS.contains((Object)this);
        }
    }
}

