/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.ColumnView;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.DeviceMemoryBuffer;

public class GatherMap
implements AutoCloseable {
    private DeviceMemoryBuffer buffer;

    public GatherMap(DeviceMemoryBuffer buffer) {
        if (buffer.getLength() % (long)DType.INT32.getSizeInBytes() != 0L) {
            throw new IllegalArgumentException("buffer length not a multiple of 4");
        }
        this.buffer = buffer;
    }

    public long getRowCount() {
        this.ensureOpen();
        return this.buffer.getLength() / 4L;
    }

    public ColumnView toColumnView(long startRow, int numRows) {
        this.ensureOpen();
        return ColumnView.fromDeviceBuffer(this.buffer, startRow * 4L, DType.INT32, numRows);
    }

    public DeviceMemoryBuffer releaseBuffer() {
        DeviceMemoryBuffer result = this.buffer;
        this.buffer = null;
        return result;
    }

    @Override
    public void close() {
        if (this.buffer != null) {
            this.buffer.close();
            this.buffer = null;
        }
    }

    private void ensureOpen() {
        if (this.buffer == null) {
            throw new IllegalStateException("instance is closed");
        }
        if (this.buffer.closed) {
            throw new IllegalStateException("buffer is closed");
        }
    }
}

