/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

public class GroupByOptions {
    public static GroupByOptions DEFAULT = new GroupByOptions(new Builder());
    private final boolean ignoreNullKeys;
    private final boolean keysSorted;
    private final boolean[] keysDescending;
    private final boolean[] keysNullSmallest;

    private GroupByOptions(Builder builder) {
        this.ignoreNullKeys = builder.ignoreNullKeys;
        this.keysSorted = builder.keysSorted;
        this.keysDescending = builder.keysDescending;
        this.keysNullSmallest = builder.keysNullSmallest;
    }

    boolean getIgnoreNullKeys() {
        return this.ignoreNullKeys;
    }

    boolean getKeySorted() {
        return this.keysSorted;
    }

    boolean[] getKeysDescending() {
        return this.keysDescending;
    }

    boolean[] getKeysNullSmallest() {
        return this.keysNullSmallest;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean ignoreNullKeys = false;
        private boolean keysSorted = false;
        private boolean[] keysDescending = new boolean[0];
        private boolean[] keysNullSmallest = new boolean[0];

        public Builder withIgnoreNullKeys(boolean ignoreNullKeys) {
            this.ignoreNullKeys = ignoreNullKeys;
            return this;
        }

        public Builder withKeysSorted(boolean keysSorted) {
            this.keysSorted = keysSorted;
            return this;
        }

        public Builder withKeysDescending(boolean ... keysDescending) {
            this.keysDescending = keysDescending == null ? new boolean[0] : keysDescending;
            return this;
        }

        public Builder withKeysNullSmallest(boolean ... keysNullSmallest) {
            this.keysNullSmallest = keysNullSmallest == null ? new boolean[0] : keysNullSmallest;
            return this;
        }

        public GroupByOptions build() {
            return new GroupByOptions(this);
        }
    }
}

