/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

public enum HashType {
    IDENTITY(0),
    MURMUR3(1),
    HASH_MD5(2),
    HASH_SERIAL_MURMUR3(3),
    HASH_SPARK_MURMUR3(4);

    private static final HashType[] HASH_TYPES;
    final int nativeId;

    private HashType(int nativeId) {
        this.nativeId = nativeId;
    }

    public int getNativeId() {
        return this.nativeId;
    }

    public static HashType fromNative(int nativeId) {
        for (HashType type : HASH_TYPES) {
            if (type.nativeId != nativeId) continue;
            return type;
        }
        throw new IllegalArgumentException("Could not translate " + nativeId + " into a HashType");
    }

    static {
        HASH_TYPES = HashType.values();
    }
}

