/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.BaseDeviceMemoryBuffer;
import ai.rapids.cudf.BitVectorHelper;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.ColumnView;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.DeviceMemoryBuffer;
import ai.rapids.cudf.HostColumnVectorCore;
import ai.rapids.cudf.HostMemoryBuffer;
import ai.rapids.cudf.MemoryBuffer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public final class HostColumnVector
extends HostColumnVectorCore {
    static final int OFFSET_SIZE = DType.INT32.getSizeInBytes();
    private int refCount;

    HostColumnVector(DType type, long rows, Optional<Long> nullCount, HostMemoryBuffer hostDataBuffer, HostMemoryBuffer hostValidityBuffer) {
        this(type, rows, nullCount, hostDataBuffer, hostValidityBuffer, null);
    }

    public HostColumnVector(DType type, long rows, Optional<Long> nullCount, HostMemoryBuffer hostDataBuffer, HostMemoryBuffer hostValidityBuffer, HostMemoryBuffer offsetBuffer, List<HostColumnVectorCore> nestedHcv) {
        super(type, rows, nullCount, hostDataBuffer, hostValidityBuffer, offsetBuffer, nestedHcv);
        this.refCount = 0;
        this.incRefCountInternal(true);
    }

    HostColumnVector(DType type, long rows, Optional<Long> nullCount, HostMemoryBuffer hostDataBuffer, HostMemoryBuffer hostValidityBuffer, HostMemoryBuffer offsetBuffer) {
        super(type, rows, nullCount, hostDataBuffer, hostValidityBuffer, offsetBuffer, new ArrayList<HostColumnVectorCore>());
        assert (!type.equals(DType.LIST)) : "This constructor should not be used for list type";
        if (nullCount.isPresent() && nullCount.get() > 0L && hostValidityBuffer == null) {
            throw new IllegalStateException("Buffer cannot have a nullCount without a validity buffer");
        }
        if (!type.equals(DType.STRING) && !type.equals(DType.LIST)) assert (offsetBuffer == null) : "offsets are only supported for STRING and LIST";
        this.refCount = 0;
        this.incRefCountInternal(true);
    }

    public void noWarnLeakExpected() {
        this.offHeap.noWarnLeakExpected();
    }

    @Override
    public synchronized void close() {
        --this.refCount;
        this.offHeap.delRef();
        if (this.refCount == 0) {
            this.offHeap.clean(false);
            for (HostColumnVectorCore child : this.children) {
                child.close();
            }
        } else if (this.refCount < 0) {
            this.offHeap.logRefCountDebug("double free " + this);
            throw new IllegalStateException("Close called too many times " + this);
        }
    }

    @Override
    public String toString() {
        return "HostColumnVector{rows=" + this.rows + ", type=" + this.type + ", nullCount=" + this.nullCount + ", offHeap=" + this.offHeap + '}';
    }

    public HostColumnVector incRefCount() {
        return this.incRefCountInternal(false);
    }

    private synchronized HostColumnVector incRefCountInternal(boolean isFirstTime) {
        this.offHeap.addRef();
        if (this.refCount <= 0 && !isFirstTime) {
            this.offHeap.logRefCountDebug("INC AFTER CLOSE " + this);
            throw new IllegalStateException("Column is already closed");
        }
        ++this.refCount;
        return this;
    }

    synchronized int getRefCount() {
        return this.refCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnVector copyToDevice() {
        if (this.rows == 0L) {
            if (this.type.isNestedType()) {
                return ColumnView.NestedColumnVector.createColumnVector(this.type, 0, null, null, null, Optional.of(0L), this.children);
            }
            return new ColumnVector(this.type, 0L, Optional.of(0L), null, null, null);
        }
        MemoryBuffer data = null;
        MemoryBuffer valid = null;
        MemoryBuffer offsets = null;
        try {
            if (!this.type.isNestedType()) {
                HostMemoryBuffer hoff;
                HostMemoryBuffer hvalid;
                HostMemoryBuffer hdata = this.offHeap.data;
                if (hdata != null) {
                    long dataLen = this.rows * (long)this.type.getSizeInBytes();
                    if (this.type.equals(DType.STRING) && (dataLen = this.getEndStringOffset(this.rows - 1L)) == 0L && this.getNullCount() == 0L) {
                        dataLen = 1L;
                    }
                    data = DeviceMemoryBuffer.allocate(dataLen);
                    ((BaseDeviceMemoryBuffer)data).copyFromHostBuffer(hdata, 0L, dataLen);
                }
                if ((hvalid = this.offHeap.valid) != null) {
                    long validLen = ColumnView.getNativeValidPointerSize((int)this.rows);
                    valid = DeviceMemoryBuffer.allocate(validLen);
                    ((BaseDeviceMemoryBuffer)valid).copyFromHostBuffer(hvalid, 0L, validLen);
                }
                if ((hoff = this.offHeap.offsets) != null) {
                    long offsetsLen = (long)OFFSET_SIZE * (this.rows + 1L);
                    offsets = DeviceMemoryBuffer.allocate(offsetsLen);
                    ((BaseDeviceMemoryBuffer)offsets).copyFromHostBuffer(hoff, 0L, offsetsLen);
                }
                ColumnVector ret = new ColumnVector(this.type, this.rows, (Optional<Long>)this.nullCount, (DeviceMemoryBuffer)data, (DeviceMemoryBuffer)valid, (DeviceMemoryBuffer)offsets);
                data = null;
                valid = null;
                offsets = null;
                ColumnVector columnVector = ret;
                return columnVector;
            }
            ColumnVector columnVector = ColumnView.NestedColumnVector.createColumnVector(this.type, (int)this.rows, this.offHeap.data, this.offHeap.valid, this.offHeap.offsets, this.nullCount, this.children);
            return columnVector;
        }
        finally {
            if (data != null) {
                data.close();
            }
            if (valid != null) {
                valid.close();
            }
            if (offsets != null) {
                offsets.close();
            }
        }
    }

    public static Builder builder(DType type, int rows) {
        return new Builder(type, rows, 0L);
    }

    public static Builder builder(int rows, long stringBufferSize) {
        return new Builder(DType.STRING, rows, stringBufferSize);
    }

    public static HostColumnVector build(DType type, int rows, Consumer<Builder> init) {
        try (Builder builder = HostColumnVector.builder(type, rows);){
            init.accept(builder);
            HostColumnVector hostColumnVector = builder.build();
            return hostColumnVector;
        }
    }

    public static HostColumnVector build(int rows, long stringBufferSize, Consumer<Builder> init) {
        try (Builder builder = HostColumnVector.builder(rows, stringBufferSize);){
            init.accept(builder);
            HostColumnVector hostColumnVector = builder.build();
            return hostColumnVector;
        }
    }

    public static <T> HostColumnVector fromLists(DataType dataType, List<T> ... values) {
        try (ColumnBuilder cb = new ColumnBuilder(dataType, values.length);){
            cb.appendLists(values);
            HostColumnVector hostColumnVector = cb.build();
            return hostColumnVector;
        }
    }

    public static HostColumnVector fromStructs(DataType dataType, List<StructData> values) {
        try (ColumnBuilder cb = new ColumnBuilder(dataType, values.size());){
            cb.appendStructValues(values);
            HostColumnVector hostColumnVector = cb.build();
            return hostColumnVector;
        }
    }

    public static HostColumnVector fromStructs(DataType dataType, StructData ... values) {
        try (ColumnBuilder cb = new ColumnBuilder(dataType, values.length);){
            cb.appendStructValues(values);
            HostColumnVector hostColumnVector = cb.build();
            return hostColumnVector;
        }
    }

    public static HostColumnVector emptyStructs(DataType dataType, long rows) {
        StructData sd = new StructData(new Object[0]);
        try (ColumnBuilder cb = new ColumnBuilder(dataType, rows);){
            for (long i = 0L; i < rows; ++i) {
                cb.append(sd);
            }
            HostColumnVector hostColumnVector = cb.build();
            return hostColumnVector;
        }
    }

    public static HostColumnVector boolFromBytes(byte ... values) {
        return HostColumnVector.build(DType.BOOL8, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector fromBytes(byte ... values) {
        return HostColumnVector.build(DType.INT8, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector fromUnsignedBytes(byte ... values) {
        return HostColumnVector.build(DType.UINT8, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector fromShorts(short ... values) {
        return HostColumnVector.build(DType.INT16, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector fromUnsignedShorts(short ... values) {
        return HostColumnVector.build(DType.UINT16, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector durationNanosecondsFromLongs(long ... values) {
        return HostColumnVector.build(DType.DURATION_NANOSECONDS, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector durationMicrosecondsFromLongs(long ... values) {
        return HostColumnVector.build(DType.DURATION_MICROSECONDS, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector durationMillisecondsFromLongs(long ... values) {
        return HostColumnVector.build(DType.DURATION_MILLISECONDS, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector durationSecondsFromLongs(long ... values) {
        return HostColumnVector.build(DType.DURATION_SECONDS, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector durationDaysFromInts(int ... values) {
        return HostColumnVector.build(DType.DURATION_DAYS, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector fromInts(int ... values) {
        return HostColumnVector.build(DType.INT32, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector fromUnsignedInts(int ... values) {
        return HostColumnVector.build(DType.UINT32, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector fromLongs(long ... values) {
        return HostColumnVector.build(DType.INT64, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector fromUnsignedLongs(long ... values) {
        return HostColumnVector.build(DType.UINT64, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector fromFloats(float ... values) {
        return HostColumnVector.build(DType.FLOAT32, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector fromDoubles(double ... values) {
        return HostColumnVector.build(DType.FLOAT64, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector daysFromInts(int ... values) {
        return HostColumnVector.build(DType.TIMESTAMP_DAYS, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector timestampSecondsFromLongs(long ... values) {
        return HostColumnVector.build(DType.TIMESTAMP_SECONDS, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector timestampMilliSecondsFromLongs(long ... values) {
        return HostColumnVector.build(DType.TIMESTAMP_MILLISECONDS, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector timestampMicroSecondsFromLongs(long ... values) {
        return HostColumnVector.build(DType.TIMESTAMP_MICROSECONDS, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector timestampNanoSecondsFromLongs(long ... values) {
        return HostColumnVector.build(DType.TIMESTAMP_NANOSECONDS, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector decimalFromInts(int scale, int ... values) {
        return HostColumnVector.build(DType.create(DType.DTypeEnum.DECIMAL32, scale), values.length, (Builder b) -> b.appendUnscaledDecimalArray(values));
    }

    public static HostColumnVector decimalFromBoxedInts(int scale, Integer ... values) {
        return HostColumnVector.build(DType.create(DType.DTypeEnum.DECIMAL32, scale), values.length, (Builder b) -> {
            for (Integer v : values) {
                if (v == null) {
                    b.appendNull();
                    continue;
                }
                b.appendUnscaledDecimal(v);
            }
        });
    }

    public static HostColumnVector decimalFromLongs(int scale, long ... values) {
        return HostColumnVector.build(DType.create(DType.DTypeEnum.DECIMAL64, scale), values.length, (Builder b) -> b.appendUnscaledDecimalArray(values));
    }

    public static HostColumnVector decimalFromBoxedLongs(int scale, Long ... values) {
        return HostColumnVector.build(DType.create(DType.DTypeEnum.DECIMAL64, scale), values.length, (Builder b) -> {
            for (Long v : values) {
                if (v == null) {
                    b.appendNull();
                    continue;
                }
                b.appendUnscaledDecimal(v);
            }
        });
    }

    public static HostColumnVector decimalFromDoubles(DType type, RoundingMode mode, double ... values) {
        assert (type.isDecimalType());
        if (type.typeId == DType.DTypeEnum.DECIMAL64) {
            long[] data = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                BigDecimal dec = BigDecimal.valueOf(values[i]).setScale(-type.getScale(), mode);
                data[i] = dec.unscaledValue().longValueExact();
            }
            return HostColumnVector.build(type, values.length, (Builder b) -> b.appendUnscaledDecimalArray(data));
        }
        int[] data = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            BigDecimal dec = BigDecimal.valueOf(values[i]).setScale(-type.getScale(), mode);
            data[i] = dec.unscaledValue().intValueExact();
        }
        return HostColumnVector.build(type, values.length, (Builder b) -> b.appendUnscaledDecimalArray(data));
    }

    public static HostColumnVector fromStrings(String ... values) {
        int rows = values.length;
        long nullCount = 0L;
        long bufferSize = 0L;
        for (String s : values) {
            if (s == null) {
                ++nullCount;
                continue;
            }
            bufferSize += (long)s.getBytes(StandardCharsets.UTF_8).length;
        }
        if (nullCount > 0L) {
            return HostColumnVector.build(rows, bufferSize, (Builder b) -> b.appendBoxed(values));
        }
        return HostColumnVector.build(rows, bufferSize, (Builder b) -> {
            for (String s : values) {
                b.append(s);
            }
        });
    }

    public static HostColumnVector fromUTF8Strings(byte[] ... values) {
        int rows = values.length;
        long nullCount = 0L;
        long bufferSize = 0L;
        for (byte[] s2 : values) {
            if (s2 == null) {
                ++nullCount;
                continue;
            }
            bufferSize += (long)s2.length;
        }
        BiConsumer<Builder, byte[]> appendUTF8 = nullCount == 0L ? (b, s) -> b.appendUTF8String((byte[])s) : (b, s) -> {
            if (s == null) {
                b.appendNull();
            } else {
                b.appendUTF8String((byte[])s);
            }
        };
        return HostColumnVector.build(rows, bufferSize, (Builder b) -> {
            for (byte[] s : values) {
                appendUTF8.accept((Builder)b, s);
            }
        });
    }

    public static HostColumnVector fromDecimals(BigDecimal ... values) {
        BigDecimal maxDec = Arrays.stream(values).filter(Objects::nonNull).max(Comparator.comparingInt(BigDecimal::precision)).orElse(BigDecimal.ZERO);
        int maxScale = Arrays.stream(values).filter(Objects::nonNull).map(decimal -> decimal.scale()).max(Comparator.naturalOrder()).orElse(0);
        maxDec = maxDec.setScale(maxScale, RoundingMode.UNNECESSARY);
        return HostColumnVector.build(DType.fromJavaBigDecimal(maxDec), values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector fromBoxedBooleans(Boolean ... values) {
        return HostColumnVector.build(DType.BOOL8, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector fromBoxedBytes(Byte ... values) {
        return HostColumnVector.build(DType.INT8, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector fromBoxedUnsignedBytes(Byte ... values) {
        return HostColumnVector.build(DType.UINT8, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector fromBoxedShorts(Short ... values) {
        return HostColumnVector.build(DType.INT16, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector fromBoxedUnsignedShorts(Short ... values) {
        return HostColumnVector.build(DType.UINT16, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector durationNanosecondsFromBoxedLongs(Long ... values) {
        return HostColumnVector.build(DType.DURATION_NANOSECONDS, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector durationMicrosecondsFromBoxedLongs(Long ... values) {
        return HostColumnVector.build(DType.DURATION_MICROSECONDS, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector durationMillisecondsFromBoxedLongs(Long ... values) {
        return HostColumnVector.build(DType.DURATION_MILLISECONDS, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector durationSecondsFromBoxedLongs(Long ... values) {
        return HostColumnVector.build(DType.DURATION_SECONDS, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector durationDaysFromBoxedInts(Integer ... values) {
        return HostColumnVector.build(DType.DURATION_DAYS, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector fromBoxedInts(Integer ... values) {
        return HostColumnVector.build(DType.INT32, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector fromBoxedUnsignedInts(Integer ... values) {
        return HostColumnVector.build(DType.UINT32, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector fromBoxedLongs(Long ... values) {
        return HostColumnVector.build(DType.INT64, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector fromBoxedUnsignedLongs(Long ... values) {
        return HostColumnVector.build(DType.UINT64, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector fromBoxedFloats(Float ... values) {
        return HostColumnVector.build(DType.FLOAT32, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector fromBoxedDoubles(Double ... values) {
        return HostColumnVector.build(DType.FLOAT64, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector timestampDaysFromBoxedInts(Integer ... values) {
        return HostColumnVector.build(DType.TIMESTAMP_DAYS, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector timestampSecondsFromBoxedLongs(Long ... values) {
        return HostColumnVector.build(DType.TIMESTAMP_SECONDS, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector timestampMilliSecondsFromBoxedLongs(Long ... values) {
        return HostColumnVector.build(DType.TIMESTAMP_MILLISECONDS, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector timestampMicroSecondsFromBoxedLongs(Long ... values) {
        return HostColumnVector.build(DType.TIMESTAMP_MICROSECONDS, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector timestampNanoSecondsFromBoxedLongs(Long ... values) {
        return HostColumnVector.build(DType.TIMESTAMP_NANOSECONDS, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static class BasicType
    extends DataType {
        private DType type;
        private boolean isNullable;

        public BasicType(boolean isNullable, DType type) {
            this.isNullable = isNullable;
            this.type = type;
        }

        @Override
        DType getType() {
            return this.type;
        }

        @Override
        boolean isNullable() {
            return this.isNullable;
        }

        @Override
        DataType getChild(int index) {
            return null;
        }

        @Override
        int getNumChildren() {
            return 0;
        }
    }

    public static class StructType
    extends DataType {
        private boolean isNullable;
        private List<DataType> children;

        public StructType(boolean isNullable, List<DataType> children) {
            this.isNullable = isNullable;
            this.children = children;
        }

        public StructType(boolean isNullable, DataType ... children) {
            this(isNullable, Arrays.asList(children));
        }

        @Override
        DType getType() {
            return DType.STRUCT;
        }

        @Override
        boolean isNullable() {
            return this.isNullable;
        }

        @Override
        DataType getChild(int index) {
            return this.children.get(index);
        }

        @Override
        int getNumChildren() {
            return this.children.size();
        }
    }

    public static class StructData {
        List<Object> dataRecord;

        public StructData(List<Object> dataRecord) {
            this.dataRecord = dataRecord;
        }

        public StructData(Object ... data) {
            this(Arrays.asList(data));
        }

        public int getNumFields() {
            if (this.dataRecord != null) {
                return this.dataRecord.size();
            }
            return 0;
        }
    }

    public static class ListType
    extends DataType {
        private boolean isNullable;
        private DataType child;

        public ListType(boolean isNullable, DataType child) {
            this.isNullable = isNullable;
            this.child = child;
        }

        @Override
        DType getType() {
            return DType.LIST;
        }

        @Override
        boolean isNullable() {
            return this.isNullable;
        }

        @Override
        DataType getChild(int index) {
            if (index > 0) {
                return null;
            }
            return this.child;
        }

        @Override
        int getNumChildren() {
            return 1;
        }
    }

    public static abstract class DataType {
        abstract DType getType();

        abstract boolean isNullable();

        abstract DataType getChild(int var1);

        abstract int getNumChildren();
    }

    public static final class Builder
    implements AutoCloseable {
        private final long rows;
        private final DType type;
        private HostMemoryBuffer data;
        private HostMemoryBuffer valid;
        private HostMemoryBuffer offsets;
        private long currentIndex = 0L;
        private long nullCount;
        private int currentStringByteIndex = 0;
        private boolean built;

        Builder(DType type, long rows, long stringBufferSize) {
            this.type = type;
            this.rows = rows;
            if (type.equals(DType.STRING)) {
                if (stringBufferSize <= 0L) {
                    stringBufferSize = 1L;
                }
                this.data = HostMemoryBuffer.allocate(stringBufferSize);
                this.offsets = HostMemoryBuffer.allocate((rows + 1L) * (long)OFFSET_SIZE);
                this.offsets.setInt(0L, 0);
            } else {
                this.data = HostMemoryBuffer.allocate(rows * (long)type.getSizeInBytes());
            }
        }

        Builder(DType type, long rows, HostMemoryBuffer testData, HostMemoryBuffer testValid, HostMemoryBuffer testOffsets) {
            this.type = type;
            this.rows = rows;
            this.data = testData;
            this.valid = testValid;
        }

        public final Builder append(boolean value) {
            assert (this.type.equals(DType.BOOL8));
            assert (this.currentIndex < this.rows);
            this.data.setByte(this.currentIndex * (long)this.type.getSizeInBytes(), value ? (byte)1 : 0);
            ++this.currentIndex;
            return this;
        }

        public final Builder append(byte value) {
            assert (this.type.isBackedByByte());
            assert (this.currentIndex < this.rows);
            this.data.setByte(this.currentIndex * (long)this.type.getSizeInBytes(), value);
            ++this.currentIndex;
            return this;
        }

        public final Builder append(byte value, long count) {
            assert (count + this.currentIndex <= this.rows);
            assert (this.type.isBackedByByte());
            this.data.setMemory(this.currentIndex * (long)this.type.getSizeInBytes(), count, value);
            this.currentIndex += count;
            return this;
        }

        public final Builder append(short value) {
            assert (this.type.isBackedByShort());
            assert (this.currentIndex < this.rows);
            this.data.setShort(this.currentIndex * (long)this.type.getSizeInBytes(), value);
            ++this.currentIndex;
            return this;
        }

        public final Builder append(int value) {
            assert (this.type.isBackedByInt());
            assert (this.currentIndex < this.rows);
            this.data.setInt(this.currentIndex * (long)this.type.getSizeInBytes(), value);
            ++this.currentIndex;
            return this;
        }

        public final Builder append(long value) {
            assert (this.type.isBackedByLong());
            assert (this.currentIndex < this.rows);
            this.data.setLong(this.currentIndex * (long)this.type.getSizeInBytes(), value);
            ++this.currentIndex;
            return this;
        }

        public final Builder append(float value) {
            assert (this.type.equals(DType.FLOAT32));
            assert (this.currentIndex < this.rows);
            this.data.setFloat(this.currentIndex * (long)this.type.getSizeInBytes(), value);
            ++this.currentIndex;
            return this;
        }

        public final Builder append(double value) {
            assert (this.type.equals(DType.FLOAT64));
            assert (this.currentIndex < this.rows);
            this.data.setDouble(this.currentIndex * (long)this.type.getSizeInBytes(), value);
            ++this.currentIndex;
            return this;
        }

        public final Builder append(BigDecimal value) {
            return this.append(value, RoundingMode.UNNECESSARY);
        }

        public final Builder append(BigDecimal value, RoundingMode roundingMode) {
            assert (this.type.isDecimalType());
            assert (this.currentIndex < this.rows);
            BigInteger unscaledValue = value.setScale(-this.type.getScale(), roundingMode).unscaledValue();
            if (this.type.typeId == DType.DTypeEnum.DECIMAL32) {
                assert (value.precision() <= 9) : "value exceeds maximum precision for DECIMAL32";
                this.data.setInt(this.currentIndex * (long)this.type.getSizeInBytes(), unscaledValue.intValueExact());
            } else if (this.type.typeId == DType.DTypeEnum.DECIMAL64) {
                assert (value.precision() <= 18) : "value exceeds maximum precision for DECIMAL64 ";
                this.data.setLong(this.currentIndex * (long)this.type.getSizeInBytes(), unscaledValue.longValueExact());
            } else {
                throw new IllegalStateException(this.type + " is not a supported decimal type.");
            }
            ++this.currentIndex;
            return this;
        }

        public final Builder appendUnscaledDecimal(int value) {
            assert (this.type.typeId == DType.DTypeEnum.DECIMAL32);
            assert (this.currentIndex < this.rows);
            this.data.setInt(this.currentIndex * (long)this.type.getSizeInBytes(), value);
            ++this.currentIndex;
            return this;
        }

        public final Builder appendUnscaledDecimal(long value) {
            assert (this.type.typeId == DType.DTypeEnum.DECIMAL64);
            assert (this.currentIndex < this.rows);
            this.data.setLong(this.currentIndex * (long)this.type.getSizeInBytes(), value);
            ++this.currentIndex;
            return this;
        }

        public Builder append(String value) {
            assert (value != null) : "appendNull must be used to append null strings";
            return this.appendUTF8String(value.getBytes(StandardCharsets.UTF_8));
        }

        public Builder appendUTF8String(byte[] value) {
            return this.appendUTF8String(value, 0, value.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Builder appendUTF8String(byte[] value, int offset, int length) {
            long oldLen;
            long newLen;
            assert (value != null) : "appendNull must be used to append null strings";
            assert (offset >= 0);
            assert (length >= 0);
            assert (value.length + offset <= length);
            assert (this.type.equals(DType.STRING));
            assert (this.currentIndex < this.rows);
            for (newLen = oldLen = this.data.getLength(); (long)(this.currentStringByteIndex + length) > newLen; newLen *= 2L) {
            }
            if (newLen > Integer.MAX_VALUE) {
                throw new IllegalStateException("A string buffer is not supported over 2GB in size");
            }
            if (newLen != oldLen) {
                try (HostMemoryBuffer newData = HostMemoryBuffer.allocate(newLen);){
                    newData.copyFromHostBuffer(0L, this.data, 0L, this.currentStringByteIndex);
                    this.data.close();
                    this.data = newData;
                    newData = null;
                }
            }
            if (length > 0) {
                this.data.setBytes(this.currentStringByteIndex, value, offset, length);
            }
            this.currentStringByteIndex += length;
            ++this.currentIndex;
            this.offsets.setInt(this.currentIndex * (long)OFFSET_SIZE, this.currentStringByteIndex);
            return this;
        }

        public Builder appendArray(byte ... values) {
            assert ((long)values.length + this.currentIndex <= this.rows);
            assert (this.type.isBackedByByte());
            this.data.setBytes(this.currentIndex * (long)this.type.getSizeInBytes(), values, 0L, values.length);
            this.currentIndex += (long)values.length;
            return this;
        }

        public Builder appendArray(short ... values) {
            assert (this.type.isBackedByShort());
            assert ((long)values.length + this.currentIndex <= this.rows);
            this.data.setShorts(this.currentIndex * (long)this.type.getSizeInBytes(), values, 0L, values.length);
            this.currentIndex += (long)values.length;
            return this;
        }

        public Builder appendArray(int ... values) {
            assert (this.type.isBackedByInt());
            assert ((long)values.length + this.currentIndex <= this.rows);
            this.data.setInts(this.currentIndex * (long)this.type.getSizeInBytes(), values, 0L, values.length);
            this.currentIndex += (long)values.length;
            return this;
        }

        public Builder appendArray(long ... values) {
            assert (this.type.isBackedByLong());
            assert ((long)values.length + this.currentIndex <= this.rows);
            this.data.setLongs(this.currentIndex * (long)this.type.getSizeInBytes(), values, 0L, values.length);
            this.currentIndex += (long)values.length;
            return this;
        }

        public Builder appendArray(float ... values) {
            assert (this.type.equals(DType.FLOAT32));
            assert ((long)values.length + this.currentIndex <= this.rows);
            this.data.setFloats(this.currentIndex * (long)this.type.getSizeInBytes(), values, 0L, values.length);
            this.currentIndex += (long)values.length;
            return this;
        }

        public Builder appendArray(double ... values) {
            assert (this.type.equals(DType.FLOAT64));
            assert ((long)values.length + this.currentIndex <= this.rows);
            this.data.setDoubles(this.currentIndex * (long)this.type.getSizeInBytes(), values, 0L, values.length);
            this.currentIndex += (long)values.length;
            return this;
        }

        public Builder appendUnscaledDecimalArray(int ... values) {
            assert (this.type.typeId == DType.DTypeEnum.DECIMAL32);
            assert ((long)values.length + this.currentIndex <= this.rows);
            this.data.setInts(this.currentIndex * (long)this.type.getSizeInBytes(), values, 0L, values.length);
            this.currentIndex += (long)values.length;
            return this;
        }

        public Builder appendUnscaledDecimalArray(long ... values) {
            assert (this.type.typeId == DType.DTypeEnum.DECIMAL64);
            assert ((long)values.length + this.currentIndex <= this.rows);
            this.data.setLongs(this.currentIndex * (long)this.type.getSizeInBytes(), values, 0L, values.length);
            this.currentIndex += (long)values.length;
            return this;
        }

        public Builder appendBoxed(BigDecimal ... values) throws IndexOutOfBoundsException {
            assert (this.type.isDecimalType());
            for (BigDecimal v : values) {
                if (v == null) {
                    this.appendNull();
                    continue;
                }
                this.append(v);
            }
            return this;
        }

        public final Builder appendBoxed(Byte ... values) throws IndexOutOfBoundsException {
            for (Byte b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b);
            }
            return this;
        }

        public final Builder appendBoxed(Boolean ... values) throws IndexOutOfBoundsException {
            for (Boolean b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b != false ? (byte)1 : 0);
            }
            return this;
        }

        public final Builder appendBoxed(Short ... values) throws IndexOutOfBoundsException {
            for (Short b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b);
            }
            return this;
        }

        public final Builder appendBoxed(Integer ... values) throws IndexOutOfBoundsException {
            for (Integer b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b);
            }
            return this;
        }

        public final Builder appendBoxed(Long ... values) throws IndexOutOfBoundsException {
            for (Long b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b);
            }
            return this;
        }

        public final Builder appendBoxed(Float ... values) throws IndexOutOfBoundsException {
            for (Float b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b.floatValue());
            }
            return this;
        }

        public final Builder appendBoxed(Double ... values) throws IndexOutOfBoundsException {
            for (Double b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b);
            }
            return this;
        }

        public final Builder appendBoxed(String ... values) throws IndexOutOfBoundsException {
            for (String b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b);
            }
            return this;
        }

        public final Builder append(HostColumnVector columnVector) {
            assert (columnVector.rows <= this.rows - this.currentIndex);
            assert (columnVector.type.equals(this.type));
            if (this.type.equals(DType.STRING)) {
                throw new UnsupportedOperationException("Appending a string column vector client side is not currently supported");
            }
            this.data.copyFromHostBuffer(this.currentIndex * (long)this.type.getSizeInBytes(), columnVector.offHeap.data, 0L, columnVector.getRowCount() * (long)this.type.getSizeInBytes());
            long otherNc = columnVector.getNullCount();
            if (otherNc != 0L) {
                if (this.valid == null) {
                    this.allocateBitmaskAndSetDefaultValues();
                }
                BitVectorHelper.append(columnVector.offHeap.valid, this.valid, this.currentIndex, columnVector.rows);
                this.nullCount += otherNc;
            }
            this.currentIndex += columnVector.rows;
            return this;
        }

        private void allocateBitmaskAndSetDefaultValues() {
            long bitmaskSize = ColumnView.getNativeValidPointerSize((int)this.rows);
            this.valid = HostMemoryBuffer.allocate(bitmaskSize);
            this.valid.setMemory(0L, bitmaskSize, (byte)-1);
        }

        public final Builder appendNull() {
            this.setNullAt(this.currentIndex);
            ++this.currentIndex;
            if (this.type.equals(DType.STRING)) {
                this.offsets.setInt(this.currentIndex * (long)OFFSET_SIZE, this.currentStringByteIndex);
            }
            return this;
        }

        public final Builder setNullAt(long index) {
            assert (index < this.rows);
            if (this.valid == null) {
                this.allocateBitmaskAndSetDefaultValues();
            }
            this.nullCount += (long)BitVectorHelper.setNullAt(this.valid, index);
            return this;
        }

        public final HostColumnVector build() {
            HostColumnVector cv = new HostColumnVector(this.type, this.currentIndex, Optional.of(this.nullCount), this.data, this.valid, this.offsets);
            this.built = true;
            return cv;
        }

        public final ColumnVector buildAndPutOnDevice() {
            try (HostColumnVector tmp = this.build();){
                ColumnVector columnVector = tmp.copyToDevice();
                return columnVector;
            }
        }

        @Override
        public final void close() {
            if (!this.built) {
                this.data.close();
                this.data = null;
                if (this.valid != null) {
                    this.valid.close();
                    this.valid = null;
                }
                if (this.offsets != null) {
                    this.offsets.close();
                    this.offsets = null;
                }
                this.built = true;
            }
        }

        public String toString() {
            return "Builder{data=" + this.data + "type=" + this.type + ", valid=" + this.valid + ", currentIndex=" + this.currentIndex + ", nullCount=" + this.nullCount + ", rows=" + this.rows + ", built=" + this.built + '}';
        }
    }

    public static final class ColumnBuilder
    implements AutoCloseable {
        private DType type;
        private HostMemoryBuffer data;
        private HostMemoryBuffer valid;
        private HostMemoryBuffer offsets;
        private long nullCount = 0L;
        private boolean nullable;
        private long rows;
        private long estimatedRows;
        private boolean built = false;
        private List<ColumnBuilder> childBuilders = new ArrayList<ColumnBuilder>();
        private int currentIndex = 0;
        private int currentByteIndex = 0;

        public ColumnBuilder(DataType type, long estimatedRows) {
            this.type = type.getType();
            this.nullable = type.isNullable();
            this.rows = 0L;
            this.estimatedRows = estimatedRows;
            for (int i = 0; i < type.getNumChildren(); ++i) {
                this.childBuilders.add(new ColumnBuilder(type.getChild(i), estimatedRows));
            }
        }

        public HostColumnVector build() {
            ArrayList<HostColumnVectorCore> hostColumnVectorCoreList = new ArrayList<HostColumnVectorCore>();
            for (ColumnBuilder childBuilder : this.childBuilders) {
                hostColumnVectorCoreList.add(childBuilder.buildNestedInternal());
            }
            HostColumnVector hostColumnVector = new HostColumnVector(this.type, this.rows, Optional.of(this.nullCount), this.data, this.valid, this.offsets, hostColumnVectorCoreList);
            this.built = true;
            return hostColumnVector;
        }

        private HostColumnVectorCore buildNestedInternal() {
            ArrayList<HostColumnVectorCore> hostColumnVectorCoreList = new ArrayList<HostColumnVectorCore>();
            for (ColumnBuilder childBuilder : this.childBuilders) {
                hostColumnVectorCoreList.add(childBuilder.buildNestedInternal());
            }
            return new HostColumnVectorCore(this.type, this.rows, Optional.of(this.nullCount), this.data, this.valid, this.offsets, hostColumnVectorCoreList);
        }

        public ColumnBuilder appendLists(List ... inputLists) {
            for (List inputList : inputLists) {
                this.append(inputList);
            }
            return this;
        }

        public ColumnBuilder appendStructValues(List<StructData> inputList) {
            for (StructData structInput : inputList) {
                this.append(structInput);
            }
            return this;
        }

        public ColumnBuilder appendStructValues(StructData ... inputList) {
            for (StructData structInput : inputList) {
                this.append(structInput);
            }
            return this;
        }

        private void growBuffersAndRows(boolean hasNull, int length) {
            assert (this.rows + 1L <= Integer.MAX_VALUE) : "Row count cannot go over Integer.MAX_VALUE";
            ++this.rows;
            long targetDataSize = 0L;
            if (!this.type.isNestedType()) {
                if (this.type.equals(DType.STRING)) {
                    targetDataSize = this.data == null ? (long)length : (long)(this.currentByteIndex + length);
                } else {
                    long l = targetDataSize = this.data == null ? this.estimatedRows * (long)this.type.getSizeInBytes() : this.rows * (long)this.type.getSizeInBytes();
                }
            }
            if (targetDataSize > 0L) {
                if (this.data == null) {
                    this.data = HostMemoryBuffer.allocate(targetDataSize);
                } else {
                    long newDataLen;
                    long maxLen = this.type.equals(DType.STRING) ? Integer.MAX_VALUE : Integer.MAX_VALUE * (long)this.type.getSizeInBytes();
                    long oldLen = this.data.getLength();
                    for (newDataLen = Math.max(1L, oldLen); targetDataSize > newDataLen; newDataLen *= 2L) {
                    }
                    if (newDataLen != oldLen) {
                        if ((newDataLen = Math.min(newDataLen, maxLen)) < targetDataSize) {
                            throw new IllegalStateException("A data buffer for strings is not supported over 2GB in size");
                        }
                        HostMemoryBuffer newData = HostMemoryBuffer.allocate(newDataLen);
                        this.data = this.copyBuffer(newData, this.data);
                    }
                }
            }
            if (this.type.equals(DType.LIST) || this.type.equals(DType.STRING)) {
                if (this.offsets == null) {
                    this.offsets = HostMemoryBuffer.allocate((this.estimatedRows + 1L) * (long)OFFSET_SIZE);
                    this.offsets.setInt(0L, 0);
                } else if ((this.rows + 1L) * (long)OFFSET_SIZE > this.offsets.length) {
                    long newOffsetLen = this.offsets.length * 2L;
                    HostMemoryBuffer newOffsets = HostMemoryBuffer.allocate(newOffsetLen);
                    this.offsets = this.copyBuffer(newOffsets, this.offsets);
                }
            }
            if (hasNull || this.nullCount > 0L) {
                if (this.valid == null) {
                    long targetValidSize = ColumnView.getNativeValidPointerSize((int)this.estimatedRows);
                    this.valid = HostMemoryBuffer.allocate(targetValidSize);
                    this.valid.setMemory(0L, targetValidSize, (byte)-1);
                } else if (this.valid.length < ColumnView.getNativeValidPointerSize((int)this.rows)) {
                    long newValidLen = this.valid.length * 2L;
                    HostMemoryBuffer newValid = HostMemoryBuffer.allocate(newValidLen);
                    newValid.setMemory(0L, newValidLen, (byte)-1);
                    this.valid = this.copyBuffer(newValid, this.valid);
                }
            }
        }

        private HostMemoryBuffer copyBuffer(HostMemoryBuffer targetBuffer, HostMemoryBuffer buffer) {
            try {
                targetBuffer.copyFromHostBuffer(0L, buffer, 0L, buffer.length);
                buffer.close();
                buffer = targetBuffer;
                targetBuffer = null;
            }
            finally {
                if (targetBuffer != null) {
                    targetBuffer.close();
                }
            }
            return buffer;
        }

        private void setNullAt(int index) {
            assert ((long)index < this.rows) : "Index for null value should fit the column with " + this.rows + " rows";
            this.nullCount += (long)BitVectorHelper.setNullAt(this.valid, index);
        }

        public final ColumnBuilder appendNull() {
            this.growBuffersAndRows(true, 0);
            this.setNullAt(this.currentIndex);
            ++this.currentIndex;
            this.currentByteIndex += this.type.getSizeInBytes();
            if (this.type.hasOffsets()) {
                if (this.type.equals(DType.LIST)) {
                    this.offsets.setInt(this.currentIndex * OFFSET_SIZE, this.childBuilders.get(0).getCurrentIndex());
                } else {
                    this.offsets.setInt(this.currentIndex * OFFSET_SIZE, this.currentByteIndex);
                }
            } else if (this.type.equals(DType.STRUCT)) {
                for (ColumnBuilder childBuilder : this.childBuilders) {
                    childBuilder.appendNull();
                }
            }
            return this;
        }

        private ColumnBuilder append(StructData structData) {
            assert (this.type.isNestedType());
            if (this.type.equals(DType.STRUCT)) {
                if (structData == null || structData.dataRecord == null) {
                    return this.appendNull();
                }
                for (int i = 0; i < structData.getNumFields(); ++i) {
                    ColumnBuilder childBuilder = this.childBuilders.get(i);
                    this.appendChildOrNull(childBuilder, structData.dataRecord.get(i));
                }
                this.endStruct();
            }
            return this;
        }

        private boolean allChildrenHaveSameIndex() {
            if (this.childBuilders.size() > 0) {
                int expected = this.childBuilders.get(0).getCurrentIndex();
                for (ColumnBuilder child : this.childBuilders) {
                    if (child.getCurrentIndex() == expected) continue;
                    return false;
                }
            }
            return true;
        }

        public ColumnBuilder endStruct() {
            assert (this.type.equals(DType.STRUCT)) : "This only works for structs";
            assert (this.allChildrenHaveSameIndex()) : "Appending structs data appears to be off " + this.childBuilders + " should all have the same currentIndex " + this.type;
            this.growBuffersAndRows(false, this.currentIndex * this.type.getSizeInBytes() + this.type.getSizeInBytes());
            ++this.currentIndex;
            return this;
        }

        public ColumnBuilder endList() {
            assert (this.type.equals(DType.LIST));
            this.growBuffersAndRows(false, this.currentIndex * this.type.getSizeInBytes() + this.type.getSizeInBytes());
            ++this.currentIndex;
            this.offsets.setInt(this.currentIndex * OFFSET_SIZE, this.childBuilders.get(0).getCurrentIndex());
            return this;
        }

        private <T> ColumnBuilder append(List<T> inputList) {
            if (inputList == null) {
                this.appendNull();
            } else {
                ColumnBuilder childBuilder = this.childBuilders.get(0);
                for (T listElement : inputList) {
                    this.appendChildOrNull(childBuilder, listElement);
                }
                this.endList();
            }
            return this;
        }

        private void appendChildOrNull(ColumnBuilder childBuilder, Object listElement) {
            if (listElement == null) {
                childBuilder.appendNull();
            } else if (listElement instanceof Integer) {
                childBuilder.append((Integer)listElement);
            } else if (listElement instanceof String) {
                childBuilder.append((String)listElement);
            } else if (listElement instanceof Double) {
                childBuilder.append((Double)listElement);
            } else if (listElement instanceof Float) {
                childBuilder.append(((Float)listElement).floatValue());
            } else if (listElement instanceof Boolean) {
                childBuilder.append((Boolean)listElement);
            } else if (listElement instanceof Long) {
                childBuilder.append((Long)listElement);
            } else if (listElement instanceof Byte) {
                childBuilder.append((Byte)listElement);
            } else if (listElement instanceof Short) {
                childBuilder.append((Short)listElement);
            } else if (listElement instanceof BigDecimal) {
                childBuilder.append((BigDecimal)listElement);
            } else if (listElement instanceof List) {
                childBuilder.append((List)listElement);
            } else if (listElement instanceof StructData) {
                childBuilder.append((StructData)listElement);
            } else if (listElement instanceof byte[]) {
                childBuilder.appendUTF8String((byte[])listElement);
            } else {
                throw new IllegalStateException("Unexpected element type: " + listElement.getClass());
            }
        }

        @Deprecated
        public void incrCurrentIndex() {
            ++this.currentIndex;
        }

        public int getCurrentIndex() {
            return this.currentIndex;
        }

        public int getCurrentByteIndex() {
            return this.currentByteIndex;
        }

        public final ColumnBuilder append(byte value) {
            this.growBuffersAndRows(false, this.currentIndex * this.type.getSizeInBytes() + this.type.getSizeInBytes());
            assert (this.type.isBackedByByte());
            assert ((long)this.currentIndex < this.rows);
            this.data.setByte(this.currentIndex * this.type.getSizeInBytes(), value);
            ++this.currentIndex;
            this.currentByteIndex += this.type.getSizeInBytes();
            return this;
        }

        public final ColumnBuilder append(short value) {
            this.growBuffersAndRows(false, this.currentIndex * this.type.getSizeInBytes() + this.type.getSizeInBytes());
            assert (this.type.isBackedByShort());
            assert ((long)this.currentIndex < this.rows);
            this.data.setShort(this.currentIndex * this.type.getSizeInBytes(), value);
            ++this.currentIndex;
            this.currentByteIndex += this.type.getSizeInBytes();
            return this;
        }

        public final ColumnBuilder append(int value) {
            this.growBuffersAndRows(false, this.currentIndex * this.type.getSizeInBytes() + this.type.getSizeInBytes());
            assert (this.type.isBackedByInt());
            assert ((long)this.currentIndex < this.rows);
            this.data.setInt(this.currentIndex * this.type.getSizeInBytes(), value);
            ++this.currentIndex;
            this.currentByteIndex += this.type.getSizeInBytes();
            return this;
        }

        public final ColumnBuilder append(long value) {
            this.growBuffersAndRows(false, this.currentIndex * this.type.getSizeInBytes() + this.type.getSizeInBytes());
            assert (this.type.isBackedByLong());
            assert ((long)this.currentIndex < this.rows);
            this.data.setLong(this.currentIndex * this.type.getSizeInBytes(), value);
            ++this.currentIndex;
            this.currentByteIndex += this.type.getSizeInBytes();
            return this;
        }

        public final ColumnBuilder append(float value) {
            this.growBuffersAndRows(false, this.currentIndex * this.type.getSizeInBytes() + this.type.getSizeInBytes());
            assert (this.type.equals(DType.FLOAT32));
            assert ((long)this.currentIndex < this.rows);
            this.data.setFloat(this.currentIndex * this.type.getSizeInBytes(), value);
            ++this.currentIndex;
            this.currentByteIndex += this.type.getSizeInBytes();
            return this;
        }

        public final ColumnBuilder append(double value) {
            this.growBuffersAndRows(false, this.currentIndex * this.type.getSizeInBytes() + this.type.getSizeInBytes());
            assert (this.type.equals(DType.FLOAT64));
            assert ((long)this.currentIndex < this.rows);
            this.data.setDouble(this.currentIndex * this.type.getSizeInBytes(), value);
            ++this.currentIndex;
            this.currentByteIndex += this.type.getSizeInBytes();
            return this;
        }

        public final ColumnBuilder append(boolean value) {
            this.growBuffersAndRows(false, this.currentIndex * this.type.getSizeInBytes() + this.type.getSizeInBytes());
            assert (this.type.equals(DType.BOOL8));
            assert ((long)this.currentIndex < this.rows);
            this.data.setBoolean(this.currentIndex * this.type.getSizeInBytes(), value);
            ++this.currentIndex;
            this.currentByteIndex += this.type.getSizeInBytes();
            return this;
        }

        public final ColumnBuilder append(BigDecimal value) {
            this.growBuffersAndRows(false, this.currentIndex * this.type.getSizeInBytes() + this.type.getSizeInBytes());
            assert ((long)this.currentIndex < this.rows);
            BigInteger unscaledVal = value.setScale(-this.type.getScale(), RoundingMode.UNNECESSARY).unscaledValue();
            if (this.type.typeId == DType.DTypeEnum.DECIMAL32) {
                this.data.setInt(this.currentIndex * this.type.getSizeInBytes(), unscaledVal.intValueExact());
            } else if (this.type.typeId == DType.DTypeEnum.DECIMAL64) {
                this.data.setLong(this.currentIndex * this.type.getSizeInBytes(), unscaledVal.longValueExact());
            } else {
                throw new IllegalStateException(this.type + " is not a supported decimal type.");
            }
            ++this.currentIndex;
            this.currentByteIndex += this.type.getSizeInBytes();
            return this;
        }

        public ColumnBuilder append(String value) {
            assert (value != null) : "appendNull must be used to append null strings";
            return this.appendUTF8String(value.getBytes(StandardCharsets.UTF_8));
        }

        public ColumnBuilder appendUTF8String(byte[] value) {
            return this.appendUTF8String(value, 0, value.length);
        }

        public ColumnBuilder appendUTF8String(byte[] value, int srcOffset, int length) {
            assert (value != null) : "appendNull must be used to append null strings";
            assert (srcOffset >= 0);
            assert (length >= 0);
            assert (value.length + srcOffset <= length);
            assert (this.type.equals(DType.STRING)) : " type " + this.type + " is not String";
            ++this.currentIndex;
            this.growBuffersAndRows(false, length);
            assert ((long)this.currentIndex < this.rows + 1L);
            if (length > 0) {
                this.data.setBytes(this.currentByteIndex, value, srcOffset, length);
            }
            this.currentByteIndex += length;
            this.offsets.setInt(this.currentIndex * OFFSET_SIZE, this.currentByteIndex);
            return this;
        }

        public ColumnBuilder getChild(int index) {
            return this.childBuilders.get(index);
        }

        public final ColumnVector buildAndPutOnDevice() {
            try (HostColumnVector tmp = this.build();){
                ColumnVector columnVector = tmp.copyToDevice();
                return columnVector;
            }
        }

        @Override
        public void close() {
            if (!this.built) {
                if (this.data != null) {
                    this.data.close();
                    this.data = null;
                }
                if (this.valid != null) {
                    this.valid.close();
                    this.valid = null;
                }
                if (this.offsets != null) {
                    this.offsets.close();
                    this.offsets = null;
                }
                for (ColumnBuilder childBuilder : this.childBuilders) {
                    childBuilder.close();
                }
                this.built = true;
            }
        }

        public String toString() {
            StringJoiner sj = new StringJoiner(",");
            for (ColumnBuilder cb : this.childBuilders) {
                sj.add(cb.toString());
            }
            return "ColumnBuilder{type=" + this.type + ", children=" + sj.toString() + ", data=" + this.data + ", valid=" + this.valid + ", currentIndex=" + this.currentIndex + ", nullCount=" + this.nullCount + ", estimatedRows=" + this.estimatedRows + ", populatedRows=" + this.rows + ", built=" + this.built + '}';
        }
    }
}

