/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.BitVectorHelper;
import ai.rapids.cudf.BufferType;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.HostColumnVector;
import ai.rapids.cudf.HostMemoryBuffer;
import ai.rapids.cudf.MemoryCleaner;
import ai.rapids.cudf.UnsafeMemoryAccessor;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostColumnVectorCore
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(HostColumnVector.class);
    protected final OffHeapState offHeap;
    protected final DType type;
    protected long rows;
    protected Optional<Long> nullCount;
    protected List<HostColumnVectorCore> children;

    public HostColumnVectorCore(DType type, long rows, Optional<Long> nullCount, HostMemoryBuffer data, HostMemoryBuffer validity, HostMemoryBuffer offsets, List<HostColumnVectorCore> nestedChildren) {
        this.offHeap = new OffHeapState(data, validity, offsets);
        MemoryCleaner.register(this, (MemoryCleaner.Cleaner)this.offHeap);
        this.type = type;
        this.rows = rows;
        this.nullCount = nullCount;
        this.children = nestedChildren;
    }

    public DType getType() {
        return this.type;
    }

    public HostMemoryBuffer getData() {
        return this.offHeap.data;
    }

    public HostMemoryBuffer getValidity() {
        return this.offHeap.valid;
    }

    public HostMemoryBuffer getOffsets() {
        return this.offHeap.offsets;
    }

    public HostColumnVectorCore getChildColumnView(int childIndex) {
        return this.getNestedChildren().get(childIndex);
    }

    public long getNullCount() {
        if (!this.nullCount.isPresent()) {
            throw new IllegalStateException("Calculating an unknown null count on the host is not currently supported");
        }
        return this.nullCount.get();
    }

    List<HostColumnVectorCore> getNestedChildren() {
        return this.children;
    }

    public long getRowCount() {
        return this.rows;
    }

    public int getNumChildren() {
        return this.children.size();
    }

    Object getElement(int rowIndex) {
        if (this.type.equals(DType.LIST)) {
            return this.getList(rowIndex);
        }
        if (this.type.equals(DType.STRUCT)) {
            return this.getStruct(rowIndex);
        }
        if (this.isNull(rowIndex)) {
            return null;
        }
        return this.readValue(rowIndex);
    }

    private Object getString(int rowIndex) {
        if (this.isNull(rowIndex)) {
            return null;
        }
        int start = (int)this.getStartListOffset(rowIndex);
        int end = (int)this.getEndListOffset(rowIndex);
        int size = end - start;
        byte[] rawData = new byte[size];
        if (size > 0) {
            this.offHeap.data.getBytes(rawData, 0L, start, size);
            return new String(rawData);
        }
        return new String();
    }

    boolean isNullExtendedRange(long index) {
        long maxNullRow = BitVectorHelper.getValidityAllocationSizeInBytes(this.rows) * 8L;
        assert (index >= 0L && index < maxNullRow) : "TEST: index is out of range 0 <= " + index + " < " + maxNullRow;
        if (this.hasValidityVector()) {
            if (this.nullCount.isPresent() && !this.hasNulls()) {
                return false;
            }
            return BitVectorHelper.isNull(this.offHeap.valid, index);
        }
        return false;
    }

    public HostMemoryBuffer getHostBufferFor(BufferType type) {
        HostMemoryBuffer srcBuffer = null;
        switch (type) {
            case VALIDITY: {
                srcBuffer = this.offHeap.valid;
                break;
            }
            case OFFSET: {
                srcBuffer = this.offHeap.offsets;
                break;
            }
            case DATA: {
                srcBuffer = this.offHeap.data;
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)type) + " is not a supported buffer type.");
            }
        }
        return srcBuffer;
    }

    void copyHostBufferBytes(byte[] dst, int dstOffset, BufferType src, long srcOffset, int length) {
        assert (dstOffset >= 0);
        assert (srcOffset >= 0L);
        assert (length >= 0);
        assert (dstOffset + length <= dst.length);
        HostMemoryBuffer srcBuffer = this.getHostBufferFor(src);
        assert (srcOffset + (long)length <= srcBuffer.length) : "would copy off end of buffer " + srcOffset + " + " + length + " > " + srcBuffer.length;
        UnsafeMemoryAccessor.getBytes(dst, dstOffset, srcBuffer.getAddress() + srcOffset, length);
    }

    private void assertsForGet(long index) {
        assert (index >= 0L && index < this.rows) : "index is out of range 0 <= " + index + " < " + this.rows;
        assert (!this.isNull(index)) : " value at " + index + " is null";
    }

    public byte getByte(long index) {
        assert (this.type.isBackedByByte()) : this.type + " is not stored as a byte.";
        this.assertsForGet(index);
        return this.offHeap.data.getByte(index * (long)this.type.getSizeInBytes());
    }

    public final short getShort(long index) {
        assert (this.type.isBackedByShort()) : this.type + " is not stored as a short.";
        this.assertsForGet(index);
        return this.offHeap.data.getShort(index * (long)this.type.getSizeInBytes());
    }

    public final int getInt(long index) {
        assert (this.type.isBackedByInt()) : this.type + " is not stored as a int.";
        this.assertsForGet(index);
        return this.offHeap.data.getInt(index * (long)this.type.getSizeInBytes());
    }

    long getStartStringOffset(long index) {
        return this.getStartListOffset(index);
    }

    public long getStartListOffset(long index) {
        assert (this.type.equals(DType.STRING) || this.type.equals(DType.LIST)) : this.type + " is not a supported string or list type.";
        assert (index >= 0L && index < this.rows) : "index is out of range 0 <= " + index + " < " + this.rows;
        return this.offHeap.offsets.getInt(index * 4L);
    }

    long getEndStringOffset(long index) {
        return this.getEndListOffset(index);
    }

    public long getEndListOffset(long index) {
        assert (this.type.equals(DType.STRING) || this.type.equals(DType.LIST)) : this.type + " is not a supported string or list type.";
        assert (index >= 0L && index < this.rows) : "index is out of range 0 <= " + index + " < " + this.rows;
        return this.offHeap.offsets.getInt((index + 1L) * 4L);
    }

    public final long getLong(long index) {
        assert (this.type.isBackedByLong()) : this.type + " is not stored as a long.";
        this.assertsForGet(index);
        return this.offHeap.data.getLong(index * (long)this.type.getSizeInBytes());
    }

    public final float getFloat(long index) {
        assert (this.type.equals(DType.FLOAT32)) : this.type + " is not a supported float type.";
        this.assertsForGet(index);
        return this.offHeap.data.getFloat(index * (long)this.type.getSizeInBytes());
    }

    public final double getDouble(long index) {
        assert (this.type.equals(DType.FLOAT64)) : this.type + " is not a supported double type.";
        this.assertsForGet(index);
        return this.offHeap.data.getDouble(index * (long)this.type.getSizeInBytes());
    }

    public final boolean getBoolean(long index) {
        assert (this.type.equals(DType.BOOL8)) : this.type + " is not a supported boolean type.";
        this.assertsForGet(index);
        return this.offHeap.data.getBoolean(index * (long)this.type.getSizeInBytes());
    }

    public final BigDecimal getBigDecimal(long index) {
        assert (this.type.isDecimalType()) : this.type + " is not a supported decimal type.";
        this.assertsForGet(index);
        if (this.type.typeId == DType.DTypeEnum.DECIMAL32) {
            int unscaledValue = this.offHeap.data.getInt(index * (long)this.type.getSizeInBytes());
            return BigDecimal.valueOf(unscaledValue, -this.type.getScale());
        }
        if (this.type.typeId == DType.DTypeEnum.DECIMAL64) {
            long unscaledValue = this.offHeap.data.getLong(index * (long)this.type.getSizeInBytes());
            return BigDecimal.valueOf(unscaledValue, -this.type.getScale());
        }
        throw new IllegalStateException(this.type + " is not a supported decimal type.");
    }

    public byte[] getUTF8(long index) {
        assert (this.type.equals(DType.STRING)) : this.type + " is not a supported string type.";
        this.assertsForGet(index);
        int start = (int)this.getStartListOffset(index);
        int size = (int)this.getEndListOffset(index) - start;
        byte[] rawData = new byte[size];
        if (size > 0) {
            this.offHeap.data.getBytes(rawData, 0L, start, size);
        }
        return rawData;
    }

    public String getJavaString(long index) {
        byte[] rawData = this.getUTF8(index);
        return new String(rawData, StandardCharsets.UTF_8);
    }

    public byte[] getBytesFromList(long rowIndex) {
        assert (this.type.equals(DType.LIST)) : this.type + " is not a supported list of bytes type.";
        HostColumnVectorCore listData = this.children.get(0);
        assert (listData.type.equals(DType.INT8) || listData.type.equals(DType.UINT8)) : this.type + " is not a supported list of bytes type.";
        assert (!listData.hasNulls()) : "byte list column with nulls are not supported";
        this.assertsForGet(rowIndex);
        int start = (int)this.getStartListOffset(rowIndex);
        int end = (int)this.getEndListOffset(rowIndex);
        int size = end - start;
        byte[] result = new byte[size];
        listData.offHeap.data.getBytes(result, 0L, start, size);
        return result;
    }

    public List getList(long rowIndex) {
        assert (rowIndex < this.rows);
        assert (this.type.equals(DType.LIST));
        ArrayList<Object> retList = new ArrayList<Object>();
        int start = (int)this.getStartListOffset(rowIndex);
        int end = (int)this.getEndListOffset(rowIndex);
        if (this.isNull(rowIndex)) {
            return null;
        }
        for (int j = start; j < end; ++j) {
            for (HostColumnVectorCore childHcv : this.children) {
                retList.add(childHcv.getElement(j));
            }
        }
        return retList;
    }

    public HostColumnVector.StructData getStruct(int rowIndex) {
        assert ((long)rowIndex < this.rows);
        assert (this.type.equals(DType.STRUCT));
        ArrayList<Object> retList = new ArrayList<Object>();
        if (this.isNull(rowIndex)) {
            return null;
        }
        for (int k = 0; k < this.getNumChildren(); ++k) {
            retList.add(this.children.get(k).getElement(rowIndex));
        }
        return new HostColumnVector.StructData(retList);
    }

    public boolean isNull(long rowIndex) {
        assert (rowIndex >= 0L && rowIndex < this.rows) : "index is out of range 0 <= " + rowIndex + " < " + this.rows;
        if (this.hasValidityVector()) {
            return BitVectorHelper.isNull(this.offHeap.valid, rowIndex);
        }
        return false;
    }

    public boolean hasValidityVector() {
        return this.offHeap.valid != null;
    }

    public boolean hasNulls() {
        return this.getNullCount() > 0L;
    }

    private Object readValue(int rowIndex) {
        assert ((long)rowIndex < this.rows);
        int rowOffset = rowIndex * this.type.getSizeInBytes();
        switch (this.type.typeId) {
            case INT32: 
            case UINT32: 
            case TIMESTAMP_DAYS: 
            case DURATION_DAYS: {
                return this.offHeap.data.getInt(rowOffset);
            }
            case INT64: 
            case UINT64: 
            case DURATION_MICROSECONDS: 
            case DURATION_MILLISECONDS: 
            case DURATION_NANOSECONDS: 
            case DURATION_SECONDS: 
            case TIMESTAMP_MICROSECONDS: 
            case TIMESTAMP_MILLISECONDS: 
            case TIMESTAMP_NANOSECONDS: 
            case TIMESTAMP_SECONDS: {
                return this.offHeap.data.getLong(rowOffset);
            }
            case FLOAT32: {
                return Float.valueOf(this.offHeap.data.getFloat(rowOffset));
            }
            case FLOAT64: {
                return this.offHeap.data.getDouble(rowOffset);
            }
            case UINT8: 
            case INT8: {
                return this.offHeap.data.getByte(rowOffset);
            }
            case UINT16: 
            case INT16: {
                return this.offHeap.data.getShort(rowOffset);
            }
            case BOOL8: {
                return this.offHeap.data.getBoolean(rowOffset);
            }
            case STRING: {
                return this.getString(rowIndex);
            }
            case DECIMAL32: {
                return BigDecimal.valueOf(this.offHeap.data.getInt(rowOffset), -this.type.getScale());
            }
            case DECIMAL64: {
                return BigDecimal.valueOf(this.offHeap.data.getLong(rowOffset), -this.type.getScale());
            }
        }
        throw new UnsupportedOperationException("Do not support " + this.type);
    }

    public long getHostMemorySize() {
        long totalSize = this.offHeap.getHostMemorySize();
        for (HostColumnVectorCore nhcv : this.children) {
            totalSize += nhcv.getHostMemorySize();
        }
        return totalSize;
    }

    @Override
    public synchronized void close() {
        for (HostColumnVectorCore child : this.children) {
            if (child == null) continue;
            child.close();
        }
        this.offHeap.delRef();
        this.offHeap.cleanImpl(false);
    }

    public String toString() {
        return "HostColumnVectorCore{rows=" + this.rows + ", type=" + this.type + ", nullCount=" + this.nullCount + ", offHeap=" + this.offHeap + '}';
    }

    protected static final class OffHeapState
    extends MemoryCleaner.Cleaner {
        public HostMemoryBuffer data;
        public HostMemoryBuffer valid = null;
        public HostMemoryBuffer offsets = null;

        OffHeapState(HostMemoryBuffer data, HostMemoryBuffer valid, HostMemoryBuffer offsets) {
            this.data = data;
            this.valid = valid;
            this.offsets = offsets;
        }

        @Override
        protected synchronized boolean cleanImpl(boolean logErrorIfNotClean) {
            boolean neededCleanup = false;
            if (this.data != null || this.valid != null || this.offsets != null) {
                try {
                    ColumnVector.closeBuffers(this.data);
                    ColumnVector.closeBuffers(this.offsets);
                    ColumnVector.closeBuffers(this.valid);
                }
                finally {
                    this.data = null;
                    this.valid = null;
                    this.offsets = null;
                }
                neededCleanup = true;
            }
            if (neededCleanup && logErrorIfNotClean) {
                log.error("A HOST COLUMN VECTOR WAS LEAKED (ID: " + this.id + ")");
                this.logRefCountDebug("Leaked vector");
            }
            return neededCleanup;
        }

        @Override
        public void noWarnLeakExpected() {
            super.noWarnLeakExpected();
            if (this.data != null) {
                this.data.noWarnLeakExpected();
            }
            if (this.valid != null) {
                this.valid.noWarnLeakExpected();
            }
            if (this.offsets != null) {
                this.offsets.noWarnLeakExpected();
            }
        }

        @Override
        public boolean isClean() {
            return this.data == null && this.valid == null && this.offsets == null;
        }

        public long getHostMemorySize() {
            long total = 0L;
            if (this.valid != null) {
                total += this.valid.length;
            }
            if (this.data != null) {
                total += this.data.length;
            }
            if (this.offsets != null) {
                total += this.offsets.length;
            }
            return total;
        }

        public String toString() {
            return "(ID: " + this.id + ")";
        }
    }
}

