/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.BaseDeviceMemoryBuffer;
import ai.rapids.cudf.Cuda;
import ai.rapids.cudf.CudaMemcpyKind;
import ai.rapids.cudf.HostMemoryBufferNativeUtils;
import ai.rapids.cudf.MemoryBuffer;
import ai.rapids.cudf.PinnedMemoryPool;
import ai.rapids.cudf.UnsafeMemoryAccessor;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostMemoryBuffer
extends MemoryBuffer {
    private static final boolean defaultPreferPinned;
    private static final Logger log;

    public static HostMemoryBuffer allocate(long bytes, boolean preferPinned) {
        HostMemoryBuffer pinnedBuffer;
        if (preferPinned && (pinnedBuffer = PinnedMemoryPool.tryAllocate(bytes)) != null) {
            return pinnedBuffer;
        }
        return new HostMemoryBuffer(UnsafeMemoryAccessor.allocate(bytes), bytes);
    }

    public static HostMemoryBuffer allocate(long bytes) {
        return HostMemoryBuffer.allocate(bytes, defaultPreferPinned);
    }

    public static HostMemoryBuffer mapFile(File path, FileChannel.MapMode mode, long offset, long length) throws IOException {
        long address;
        long offsetDelta = offset & (long)(UnsafeMemoryAccessor.pageSize() - 1);
        try {
            address = HostMemoryBufferNativeUtils.mmap(path.getPath(), HostMemoryBuffer.modeAsInt(mode), offset - offsetDelta, length + offsetDelta);
        }
        catch (IOException e) {
            throw new IOException("Error creating memory map for " + path, e);
        }
        return new HostMemoryBuffer(address + offsetDelta, length, new MmapCleaner(address, length + offsetDelta));
    }

    private static int modeAsInt(FileChannel.MapMode mode) {
        if (FileChannel.MapMode.READ_ONLY.equals(mode)) {
            return 0;
        }
        if (FileChannel.MapMode.READ_WRITE.equals(mode)) {
            return 1;
        }
        throw new UnsupportedOperationException("Unsupported mapping mode: " + mode);
    }

    HostMemoryBuffer(long address, long length) {
        this(address, length, new HostBufferCleaner(address, length));
    }

    HostMemoryBuffer(long address, long length, MemoryBuffer.MemoryBufferCleaner cleaner) {
        super(address, length, cleaner);
    }

    private HostMemoryBuffer(long address, long lengthInBytes, HostMemoryBuffer parent) {
        super(address, lengthInBytes, parent);
    }

    public final ByteBuffer asByteBuffer() {
        assert (this.length <= Integer.MAX_VALUE) : "2GB limit on ByteBuffers";
        return this.asByteBuffer(0L, (int)this.length);
    }

    public final ByteBuffer asByteBuffer(long offset, int length) {
        this.addressOutOfBoundsCheck(this.address + offset, length, "asByteBuffer");
        return HostMemoryBufferNativeUtils.wrapRangeInBuffer(this.address + offset, length).order(ByteOrder.nativeOrder());
    }

    public final void copyFromHostBuffer(long destOffset, HostMemoryBuffer srcData, long srcOffset, long length) {
        this.addressOutOfBoundsCheck(this.address + destOffset, length, "copy from dest");
        srcData.addressOutOfBoundsCheck(srcData.address + srcOffset, length, "copy from source");
        UnsafeMemoryAccessor.copyMemory(null, srcData.address + srcOffset, null, this.address + destOffset, length);
    }

    final void copyFromStream(long destOffset, InputStream in, long byteLength) throws IOException {
        int amountRead;
        this.addressOutOfBoundsCheck(this.address + destOffset, byteLength, "copy from stream");
        byte[] arrayBuffer = new byte[(int)Math.min(131072L, byteLength)];
        for (long left = byteLength; left > 0L; left -= (long)amountRead) {
            int amountToCopy = (int)Math.min((long)arrayBuffer.length, left);
            amountRead = in.read(arrayBuffer, 0, amountToCopy);
            if (amountRead < 0) {
                throw new EOFException();
            }
            this.setBytes(destOffset, arrayBuffer, 0L, amountRead);
            destOffset += (long)amountRead;
        }
    }

    public final byte getByte(long offset) {
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, 1L, "getByte");
        return UnsafeMemoryAccessor.getByte(requestedAddress);
    }

    public final void setByte(long offset, byte value) {
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, 1L, "setByte");
        UnsafeMemoryAccessor.setByte(requestedAddress, value);
    }

    public final void getBytes(byte[] dst, long dstOffset, long srcOffset, long len) {
        assert (len >= 0L);
        assert (len <= (long)dst.length - dstOffset);
        assert (srcOffset >= 0L);
        long requestedAddress = this.address + srcOffset;
        this.addressOutOfBoundsCheck(requestedAddress, len, "getBytes");
        UnsafeMemoryAccessor.getBytes(dst, dstOffset, requestedAddress, len);
    }

    public final void setBytes(long offset, byte[] data, long srcOffset, long len) {
        assert (len >= 0L) : "length is not allowed " + len;
        assert (len <= (long)data.length - srcOffset);
        assert (srcOffset >= 0L);
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, len, "setBytes");
        UnsafeMemoryAccessor.setBytes(requestedAddress, data, srcOffset, len);
    }

    public final short getShort(long offset) {
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, 2L, "getShort");
        return UnsafeMemoryAccessor.getShort(requestedAddress);
    }

    public final void setShort(long offset, short value) {
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, 2L, "setShort");
        UnsafeMemoryAccessor.setShort(requestedAddress, value);
    }

    public final void setShorts(long offset, short[] data, long srcOffset, long len) {
        assert (len >= 0L) : "length is not allowed " + len;
        assert (len <= (long)data.length - srcOffset);
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, len * 2L, "setShorts");
        UnsafeMemoryAccessor.setShorts(requestedAddress, data, srcOffset, len);
    }

    public final int getInt(long offset) {
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, 4L, "getInt");
        return UnsafeMemoryAccessor.getInt(requestedAddress);
    }

    public final void setInt(long offset, int value) {
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, 4L, "setInt");
        UnsafeMemoryAccessor.setInt(requestedAddress, value);
    }

    public final void setInts(long offset, int[] data, long srcOffset, long len) {
        assert (len >= 0L) : "length is not allowed " + len;
        assert (len <= (long)data.length - srcOffset);
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, len * 4L, "setInts");
        UnsafeMemoryAccessor.setInts(requestedAddress, data, srcOffset, len);
    }

    public final long getLong(long offset) {
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, 8L, "setLong");
        return UnsafeMemoryAccessor.getLong(requestedAddress);
    }

    public final void setLong(long offset, long value) {
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, 8L, "getLong");
        UnsafeMemoryAccessor.setLong(requestedAddress, value);
    }

    public final void getLongs(long[] dst, long dstIndex, long srcOffset, int count) {
        assert (count >= 0);
        assert ((long)count <= (long)dst.length - dstIndex);
        assert (srcOffset >= 0L);
        long requestedAddress = this.address + srcOffset;
        this.addressOutOfBoundsCheck(requestedAddress, (long)count * 8L, "getLongs");
        UnsafeMemoryAccessor.getLongs(dst, dstIndex, requestedAddress, count);
    }

    public final void setLongs(long offset, long[] data, long srcOffset, long len) {
        assert (len >= 0L) : "length is not allowed " + len;
        assert (len <= (long)data.length - srcOffset);
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, len * 8L, "setLongs");
        UnsafeMemoryAccessor.setLongs(requestedAddress, data, srcOffset, len);
    }

    public final float getFloat(long offset) {
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, 4L, "getFloat");
        return UnsafeMemoryAccessor.getFloat(requestedAddress);
    }

    public final void setFloat(long offset, float value) {
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, 4L, "setFloat");
        UnsafeMemoryAccessor.setFloat(requestedAddress, value);
    }

    public final void setFloats(long offset, float[] data, long srcOffset, long len) {
        assert (len >= 0L) : "length is not allowed " + len;
        assert (len <= (long)data.length - srcOffset);
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, len * 4L, "setFloats");
        UnsafeMemoryAccessor.setFloats(requestedAddress, data, srcOffset, len);
    }

    public final double getDouble(long offset) {
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, 8L, "getDouble");
        return UnsafeMemoryAccessor.getDouble(requestedAddress);
    }

    public final void setDouble(long offset, double value) {
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, 8L, "setDouble");
        UnsafeMemoryAccessor.setDouble(requestedAddress, value);
    }

    public final void setDoubles(long offset, double[] data, long srcOffset, long len) {
        assert (len >= 0L) : "length is not allowed " + len;
        assert (len <= (long)data.length - srcOffset);
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, len * 8L, "setDoubles");
        UnsafeMemoryAccessor.setDoubles(requestedAddress, data, srcOffset, len);
    }

    public final boolean getBoolean(long offset) {
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, 1L, "getBoolean");
        return UnsafeMemoryAccessor.getBoolean(requestedAddress);
    }

    public final void setBoolean(long offset, boolean value) {
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, 1L, "setBoolean");
        UnsafeMemoryAccessor.setBoolean(requestedAddress, value);
    }

    public final void setMemory(long offset, long length, byte value) {
        this.addressOutOfBoundsCheck(this.address + offset, length, "set memory");
        UnsafeMemoryAccessor.setMemory(this.address + offset, length, value);
    }

    final void copyFromMemory(long fromAddress, long len) {
        this.addressOutOfBoundsCheck(this.address, len, "copy from memory");
        UnsafeMemoryAccessor.copyMemory(null, fromAddress, null, this.address, len);
    }

    final void copyToMemory(long toAddress, long len) {
        this.addressOutOfBoundsCheck(this.address, len, "copy to memory");
        UnsafeMemoryAccessor.copyMemory(null, this.address, null, toAddress, len);
    }

    public final void copyFromDeviceBuffer(BaseDeviceMemoryBuffer deviceMemoryBuffer) {
        this.addressOutOfBoundsCheck(this.address, deviceMemoryBuffer.length, "copy range dest");
        assert (!deviceMemoryBuffer.closed);
        Cuda.memcpy(this.address, deviceMemoryBuffer.address, deviceMemoryBuffer.length, CudaMemcpyKind.DEVICE_TO_HOST);
    }

    public final void copyFromDeviceBuffer(BaseDeviceMemoryBuffer deviceMemoryBuffer, Cuda.Stream stream) {
        this.addressOutOfBoundsCheck(this.address, deviceMemoryBuffer.length, "copy range dest");
        assert (!deviceMemoryBuffer.closed);
        Cuda.memcpy(this.address, deviceMemoryBuffer.address, deviceMemoryBuffer.length, CudaMemcpyKind.DEVICE_TO_HOST, stream);
    }

    public final void copyFromDeviceBufferAsync(BaseDeviceMemoryBuffer deviceMemoryBuffer, Cuda.Stream stream) {
        this.addressOutOfBoundsCheck(this.address, deviceMemoryBuffer.length, "copy range dest");
        assert (!deviceMemoryBuffer.closed);
        Cuda.asyncMemcpy(this.address, deviceMemoryBuffer.address, deviceMemoryBuffer.length, CudaMemcpyKind.DEVICE_TO_HOST, stream);
    }

    @Override
    public final synchronized HostMemoryBuffer slice(long offset, long len) {
        this.addressOutOfBoundsCheck(this.address + offset, len, "slice");
        ++this.refCount;
        this.cleaner.addRef();
        return new HostMemoryBuffer(this.address + offset, len, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final HostMemoryBuffer sliceWithCopy(long offset, long len) {
        this.addressOutOfBoundsCheck(this.address + offset, len, "slice");
        HostMemoryBuffer ret = null;
        boolean success = false;
        try {
            ret = HostMemoryBuffer.allocate(len);
            UnsafeMemoryAccessor.copyMemory(null, this.address + offset, null, ret.getAddress(), len);
            success = true;
            HostMemoryBuffer hostMemoryBuffer = ret;
            return hostMemoryBuffer;
        }
        finally {
            if (!success && ret != null) {
                ret.close();
            }
        }
    }

    public void printBuffer() {
        this.printBuffer(5);
    }

    public void printBuffer(int wordsPerRow) {
        int bytesPerWord = 4;
        int bytesPerRow = 4 * wordsPerRow;
        assert (this.length == (long)((int)this.length)) : "The buffer is too large to be printed";
        byte[] data = new byte[(int)this.length];
        System.out.println("BUFFER length = " + data.length);
        this.getBytes(data, 0L, 0L, this.length);
        for (int i = 0; i < data.length; ++i) {
            if (i % 4 == 0) {
                if (i % bytesPerRow == 0) {
                    System.out.println();
                } else {
                    System.out.print(" ");
                }
            }
            System.out.print(String.format("%02x", (long)data[i] & 0xFFL));
        }
        System.out.println();
    }

    static {
        log = LoggerFactory.getLogger(HostMemoryBuffer.class);
        boolean preferPinned = true;
        String propString = System.getProperty("ai.rapids.cudf.prefer-pinned");
        if (propString != null) {
            preferPinned = Boolean.parseBoolean(propString);
        }
        defaultPreferPinned = preferPinned;
    }

    private static final class MmapCleaner
    extends MemoryBuffer.MemoryBufferCleaner {
        private long address;
        private final long length;

        MmapCleaner(long address, long length) {
            this.address = address;
            this.length = length;
        }

        @Override
        protected boolean cleanImpl(boolean logErrorIfNotClean) {
            boolean neededCleanup = false;
            if (this.address != 0L) {
                try {
                    HostMemoryBufferNativeUtils.munmap(this.address, this.length);
                }
                finally {
                    this.address = 0L;
                }
                neededCleanup = true;
            }
            if (neededCleanup && logErrorIfNotClean) {
                log.error("A MEMORY MAPPED BUFFER WAS LEAKED!!!!");
                this.logRefCountDebug("Leaked mmap buffer");
            }
            return neededCleanup;
        }

        @Override
        public boolean isClean() {
            return this.address == 0L;
        }
    }

    private static final class HostBufferCleaner
    extends MemoryBuffer.MemoryBufferCleaner {
        private long address;
        private final long length;

        HostBufferCleaner(long address, long length) {
            this.address = address;
            this.length = length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected synchronized boolean cleanImpl(boolean logErrorIfNotClean) {
            boolean neededCleanup = false;
            long origAddress = this.address;
            if (this.address != 0L) {
                try {
                    UnsafeMemoryAccessor.free(this.address);
                }
                finally {
                    this.address = 0L;
                }
                neededCleanup = true;
            }
            if (neededCleanup && logErrorIfNotClean) {
                log.error("A HOST BUFFER WAS LEAKED (ID: " + this.id + " " + Long.toHexString(origAddress) + ")");
                this.logRefCountDebug("Leaked host buffer");
            }
            return neededCleanup;
        }

        @Override
        public boolean isClean() {
            return this.address == 0L;
        }
    }
}

