/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.BitVectorHelper;
import ai.rapids.cudf.BufferType;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.ColumnView;
import ai.rapids.cudf.ContiguousTable;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.DeviceMemoryBuffer;
import ai.rapids.cudf.HostColumnVector;
import ai.rapids.cudf.HostColumnVectorCore;
import ai.rapids.cudf.HostMemoryBuffer;
import ai.rapids.cudf.NvtxColor;
import ai.rapids.cudf.NvtxRange;
import ai.rapids.cudf.Table;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;

public class JCudfSerialization {
    private static final int SER_FORMAT_MAGIC_NUMBER = 1129661510;
    private static final short VERSION_NUMBER = 0;

    private static long padFor64byteAlignment(long orig) {
        return (orig + 63L) / 64L * 64L;
    }

    private static long padFor64byteAlignment(DataWriter out, long bytes) throws IOException {
        long paddedBytes = JCudfSerialization.padFor64byteAlignment(bytes);
        while (paddedBytes > bytes) {
            out.writeByte((byte)0);
            ++bytes;
        }
        return paddedBytes;
    }

    private static long getRawStringDataLength(ColumnBufferProvider column, long rowOffset, long numRows) {
        if (numRows <= 0L) {
            return 0L;
        }
        long start = column.getOffset(rowOffset);
        long end = column.getOffset(rowOffset + numRows);
        return end - start;
    }

    private static long getSlicedSerializedDataSizeInBytes(ColumnBufferProvider[] columns, long rowOffset, long numRows) {
        long totalDataSize = 0L;
        for (ColumnBufferProvider column : columns) {
            totalDataSize += JCudfSerialization.getSlicedSerializedDataSizeInBytes(column, rowOffset, numRows);
        }
        return totalDataSize;
    }

    private static long getSlicedSerializedDataSizeInBytes(ColumnBufferProvider column, long rowOffset, long numRows) {
        long totalDataSize = 0L;
        DType type = column.getType();
        if (column.getNullCount() > 0L) {
            totalDataSize += JCudfSerialization.padFor64byteAlignment(BitVectorHelper.getValidityLengthInBytes(numRows));
        }
        if (type.hasOffsets()) {
            if (numRows > 0L) {
                totalDataSize += JCudfSerialization.padFor64byteAlignment((numRows + 1L) * 4L);
                if (type.equals(DType.STRING)) {
                    totalDataSize += JCudfSerialization.padFor64byteAlignment(JCudfSerialization.getRawStringDataLength(column, rowOffset, numRows));
                }
            }
        } else if (type.getSizeInBytes() > 0) {
            totalDataSize += JCudfSerialization.padFor64byteAlignment((long)column.getType().getSizeInBytes() * numRows);
        }
        if (numRows > 0L && type.isNestedType()) {
            if (type.equals(DType.LIST)) {
                ColumnBufferProvider child = column.getChildProviders()[0];
                long childStartRow = column.getOffset(rowOffset);
                long childNumRows = column.getOffset(rowOffset + numRows) - childStartRow;
                totalDataSize += JCudfSerialization.getSlicedSerializedDataSizeInBytes(child, childStartRow, childNumRows);
            } else if (type.equals(DType.STRUCT)) {
                for (ColumnBufferProvider childProvider : column.getChildProviders()) {
                    totalDataSize += JCudfSerialization.getSlicedSerializedDataSizeInBytes(childProvider, rowOffset, numRows);
                }
            } else {
                throw new IllegalStateException("Unexpected nested type: " + type);
            }
        }
        return totalDataSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getSerializedSizeInBytes(HostColumnVector[] columns, long rowOffset, long numRows) {
        ColumnBufferProvider[] providers = JCudfSerialization.providersFrom(columns, false);
        try {
            SerializedColumnHeader[] columnHeaders = new SerializedColumnHeader[providers.length];
            for (int i = 0; i < columnHeaders.length; ++i) {
                columnHeaders[i] = new SerializedColumnHeader(providers[i], rowOffset, numRows);
            }
            long dataLen = JCudfSerialization.getSlicedSerializedDataSizeInBytes(providers, rowOffset, numRows);
            SerializedTableHeader tableHeader = new SerializedTableHeader(columnHeaders, (int)numRows, dataLen);
            long l = tableHeader.getTotalSerializedSizeInBytes();
            return l;
        }
        finally {
            JCudfSerialization.closeAll(providers);
        }
    }

    static ArrayDeque<ColumnOffsets> buildIndex(SerializedTableHeader header, HostMemoryBuffer buffer) {
        int numTopColumns = header.getNumColumns();
        ArrayDeque<ColumnOffsets> offsetsList = new ArrayDeque<ColumnOffsets>();
        long bufferOffset = 0L;
        for (int i = 0; i < numTopColumns; ++i) {
            SerializedColumnHeader column = header.getColumnHeader(i);
            bufferOffset = JCudfSerialization.buildIndex(column, buffer, offsetsList, bufferOffset);
        }
        return offsetsList;
    }

    private static long buildIndex(SerializedColumnHeader column, HostMemoryBuffer buffer, ArrayDeque<ColumnOffsets> offsetsList, long bufferOffset) {
        DType dtype;
        long validity = 0L;
        long offsets = 0L;
        long data = 0L;
        long dataLen = 0L;
        long rowCount = column.getRowCount();
        if (column.getNullCount() > 0L) {
            long validityLen = JCudfSerialization.padFor64byteAlignment(BitVectorHelper.getValidityLengthInBytes(rowCount));
            validity = bufferOffset;
            bufferOffset += validityLen;
        }
        if ((dtype = column.getType()).hasOffsets()) {
            if (rowCount > 0L) {
                long offsetsLen = (rowCount + 1L) * 4L;
                offsets = bufferOffset;
                int startOffset = buffer.getInt(bufferOffset);
                int endOffset = buffer.getInt(bufferOffset + rowCount * 4L);
                bufferOffset += JCudfSerialization.padFor64byteAlignment(offsetsLen);
                if (dtype.equals(DType.STRING)) {
                    dataLen = endOffset - startOffset;
                    data = bufferOffset;
                    bufferOffset += JCudfSerialization.padFor64byteAlignment(dataLen);
                }
            }
        } else if (dtype.getSizeInBytes() > 0) {
            dataLen = (long)dtype.getSizeInBytes() * rowCount;
            data = bufferOffset;
            bufferOffset += JCudfSerialization.padFor64byteAlignment(dataLen);
        }
        offsetsList.add(new ColumnOffsets(validity, offsets, data, dataLen));
        SerializedColumnHeader[] children = column.getChildren();
        if (children != null) {
            for (SerializedColumnHeader child : children) {
                bufferOffset = JCudfSerialization.buildIndex(child, buffer, offsetsList, bufferOffset);
            }
        }
        return bufferOffset;
    }

    private static void closeAll(ColumnBufferProvider[] providers) {
        for (int i = 0; i < providers.length; ++i) {
            providers[i].close();
        }
    }

    private static void closeAll(ColumnBufferProvider[][] providers) {
        for (int i = 0; i < providers.length; ++i) {
            if (providers[i] == null) continue;
            JCudfSerialization.closeAll(providers[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ColumnBufferProvider[] providersFrom(ColumnVector[] columns) {
        ColumnBufferProvider[] columnBufferProviderArray;
        block6: {
            HostColumnVector[] onHost = new HostColumnVector[columns.length];
            boolean success = false;
            try {
                for (int i = 0; i < columns.length; ++i) {
                    onHost[i] = columns[i].copyToHost();
                }
                ColumnBufferProvider[] ret = JCudfSerialization.providersFrom(onHost, true);
                success = true;
                columnBufferProviderArray = ret;
                if (success) break block6;
            }
            catch (Throwable throwable) {
                if (!success) {
                    for (int i = 0; i < onHost.length; ++i) {
                        if (onHost[i] == null) continue;
                        onHost[i].close();
                        onHost[i] = null;
                    }
                }
                throw throwable;
            }
            for (int i = 0; i < onHost.length; ++i) {
                if (onHost[i] == null) continue;
                onHost[i].close();
                onHost[i] = null;
            }
        }
        return columnBufferProviderArray;
    }

    private static ColumnBufferProvider[] providersFrom(HostColumnVector[] columns, boolean closeAtEnd) {
        ColumnBufferProvider[] providers = new ColumnBufferProvider[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            providers[i] = new ColumnProvider(columns[i], closeAtEnd);
        }
        return providers;
    }

    private static ColumnBufferProvider[][] providersFrom(SerializedTableHeader[] headers, HostMemoryBuffer[] dataBuffers) {
        int numColumns = 0;
        int numTables = headers.length;
        int numNonEmptyTables = 0;
        ArrayList providersPerColumn = null;
        for (int tableIdx = 0; tableIdx < numTables; ++tableIdx) {
            SerializedTableHeader header = headers[tableIdx];
            if (tableIdx == 0) {
                numColumns = header.getNumColumns();
                providersPerColumn = new ArrayList(numColumns);
                for (int i = 0; i < numColumns; ++i) {
                    providersPerColumn.add(new ArrayList(numTables));
                }
            } else {
                JCudfSerialization.checkCompatibleTypes(headers[0], header, tableIdx);
            }
            if (headers[tableIdx].getNumRows() > 0 || numNonEmptyTables == 0 && tableIdx == numTables - 1) {
                ++numNonEmptyTables;
                HostMemoryBuffer dataBuffer = dataBuffers[tableIdx];
                ArrayDeque<ColumnOffsets> offsets = JCudfSerialization.buildIndex(header, dataBuffer);
                for (int columnIdx = 0; columnIdx < numColumns; ++columnIdx) {
                    BufferOffsetProvider provider = JCudfSerialization.buildBufferOffsetProvider(header.getColumnHeader(columnIdx), offsets, dataBuffer);
                    ((ArrayList)providersPerColumn.get(columnIdx)).add(provider);
                }
                assert (offsets.isEmpty());
                continue;
            }
            assert (headers[tableIdx].dataLen == 0L);
        }
        ColumnBufferProvider[][] result = new ColumnBufferProvider[numColumns][];
        for (int i = 0; i < numColumns; ++i) {
            result[i] = ((ArrayList)providersPerColumn.get(i)).toArray(new ColumnBufferProvider[0]);
        }
        return result;
    }

    private static void checkCompatibleTypes(SerializedTableHeader expected, SerializedTableHeader other, int tableIdx) {
        int numColumns = expected.getNumColumns();
        if (other.getNumColumns() != numColumns) {
            throw new IllegalArgumentException("The number of columns did not match " + tableIdx + " " + other.getNumColumns() + " != " + numColumns);
        }
        for (int i = 0; i < numColumns; ++i) {
            JCudfSerialization.checkCompatibleTypes(expected.getColumnHeader(i), other.getColumnHeader(i), tableIdx, i);
        }
    }

    private static void checkCompatibleTypes(SerializedColumnHeader expected, SerializedColumnHeader other, int tableIdx, int columnIdx) {
        DType dtype = expected.getType();
        if (!dtype.equals(other.getType())) {
            throw new IllegalArgumentException("Type mismatch at table " + tableIdx + "column " + columnIdx + " expected " + dtype + " but found " + other.getType());
        }
        if (dtype.isNestedType()) {
            SerializedColumnHeader[] otherChildren;
            SerializedColumnHeader[] expectedChildren = expected.getChildren();
            if (expectedChildren.length != (otherChildren = other.getChildren()).length) {
                throw new IllegalArgumentException("Child count mismatch at table " + tableIdx + "column " + columnIdx + " expected " + expectedChildren.length + " but found " + otherChildren.length);
            }
            for (int i = 0; i < expectedChildren.length; ++i) {
                JCudfSerialization.checkCompatibleTypes(expectedChildren[i], otherChildren[i], tableIdx, columnIdx);
            }
        }
    }

    private static BufferOffsetProvider buildBufferOffsetProvider(SerializedColumnHeader header, ArrayDeque<ColumnOffsets> offsets, HostMemoryBuffer dataBuffer) {
        ColumnOffsets columnOffsets = offsets.remove();
        ColumnBufferProvider[] childProviders = null;
        SerializedColumnHeader[] children = header.getChildren();
        if (children != null) {
            childProviders = new ColumnBufferProvider[children.length];
            for (int i = 0; i < children.length; ++i) {
                childProviders[i] = JCudfSerialization.buildBufferOffsetProvider(children[i], offsets, dataBuffer);
            }
        }
        return new BufferOffsetProvider(header, columnOffsets, dataBuffer, childProviders);
    }

    private static SerializedTableHeader calcHeader(ColumnBufferProvider[] columns, long rowOffset, int numRows) {
        SerializedColumnHeader[] headers = new SerializedColumnHeader[columns.length];
        for (int i = 0; i < headers.length; ++i) {
            headers[i] = new SerializedColumnHeader(columns[i], rowOffset, numRows);
        }
        long dataLength = JCudfSerialization.getSlicedSerializedDataSizeInBytes(columns, rowOffset, (long)numRows);
        return new SerializedTableHeader(headers, numRows, dataLength);
    }

    private static SerializedTableHeader calcConcatHeader(ColumnBufferProvider[][] providersPerColumn) {
        int numColumns = providersPerColumn.length;
        long rowCount = 0L;
        long totalDataSize = 0L;
        ArrayList<SerializedColumnHeader> headers = new ArrayList<SerializedColumnHeader>(numColumns);
        for (int columnIdx = 0; columnIdx < numColumns; ++columnIdx) {
            totalDataSize += JCudfSerialization.calcConcatColumnHeaderAndSize(headers, providersPerColumn[columnIdx]);
            if (columnIdx == 0) {
                rowCount = headers.get(0).getRowCount();
                continue;
            }
            assert (rowCount == headers.get(columnIdx).getRowCount());
        }
        SerializedColumnHeader[] columnHeaders = headers.toArray(new SerializedColumnHeader[0]);
        return new SerializedTableHeader(columnHeaders, (int)rowCount, totalDataSize);
    }

    private static long calcConcatColumnHeaderAndSize(ArrayList<SerializedColumnHeader> outHeaders, ColumnBufferProvider[] providers) {
        ColumnBufferProvider firstProvider;
        DType dtype;
        long totalSize = 0L;
        int numTables = providers.length;
        long rowCount = 0L;
        long nullCount = 0L;
        for (ColumnBufferProvider provider : providers) {
            rowCount += provider.getRowCount();
            nullCount += provider.getNullCount();
        }
        if (rowCount > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot build a batch larger than 2147483647 rows");
        }
        if (nullCount > 0L) {
            totalSize += JCudfSerialization.padFor64byteAlignment(BitVectorHelper.getValidityLengthInBytes(rowCount));
        }
        if ((dtype = (firstProvider = providers[0]).getType()).hasOffsets()) {
            if (rowCount > 0L) {
                totalSize += JCudfSerialization.padFor64byteAlignment((rowCount + 1L) * 4L);
                if (dtype.equals(DType.STRING)) {
                    long stringDataLen = 0L;
                    for (ColumnBufferProvider provider : providers) {
                        stringDataLen += JCudfSerialization.getRawStringDataLength(provider, 0L, provider.getRowCount());
                    }
                    totalSize += JCudfSerialization.padFor64byteAlignment(stringDataLen);
                }
            }
        } else if (dtype.getSizeInBytes() > 0) {
            totalSize += JCudfSerialization.padFor64byteAlignment((long)dtype.getSizeInBytes() * rowCount);
        }
        SerializedColumnHeader[] children = null;
        if (dtype.isNestedType()) {
            int numChildren = firstProvider.getChildProviders().length;
            ArrayList<SerializedColumnHeader> childHeaders = new ArrayList<SerializedColumnHeader>(numChildren);
            ColumnBufferProvider[] childColumnProviders = new ColumnBufferProvider[numTables];
            for (int childIdx = 0; childIdx < numChildren; ++childIdx) {
                for (int tableIdx = 0; tableIdx < numTables; ++tableIdx) {
                    childColumnProviders[tableIdx] = providers[tableIdx].getChildProviders()[childIdx];
                }
                totalSize += JCudfSerialization.calcConcatColumnHeaderAndSize(childHeaders, childColumnProviders);
            }
            children = childHeaders.toArray(new SerializedColumnHeader[0]);
        }
        outHeaders.add(new SerializedColumnHeader(dtype, rowCount, nullCount, children));
        return totalSize;
    }

    private static DataWriter writerFrom(OutputStream out) {
        if (!(out instanceof DataOutputStream)) {
            out = new DataOutputStream(new BufferedOutputStream(out));
        }
        return new DataOutputStreamWriter((DataOutputStream)out);
    }

    private static DataWriter writerFrom(HostMemoryBuffer buffer) {
        return new HostDataWriter(buffer);
    }

    private static long copySlicedAndPad(DataWriter out, ColumnBufferProvider column, BufferType buffer, long offset, long length) throws IOException {
        out.copyDataFrom(column, buffer, offset, length);
        return JCudfSerialization.padFor64byteAlignment(out, length);
    }

    private static int copyPartialValidity(byte[] dest, int destBitOffset, ColumnBufferProvider provider, int srcBitOffset, int lengthBits) {
        HostMemoryBuffer src = provider.getHostBufferFor(BufferType.VALIDITY);
        long baseSrcByteOffset = provider.getBufferStartOffset(BufferType.VALIDITY);
        int destStartBytes = destBitOffset / 8;
        int destStartBitOffset = destBitOffset % 8;
        long srcStartBytes = baseSrcByteOffset + (long)(srcBitOffset / 8);
        int srcStartBitOffset = srcBitOffset % 8;
        int availableDestBits = dest.length * 8 - destBitOffset;
        int bitsToCopy = Math.min(lengthBits, availableDestBits);
        int lastIndex = (bitsToCopy + destStartBitOffset + 7) / 8;
        int allBitsSet = -1;
        byte firstSrcMask = (byte)(allBitsSet << destStartBitOffset);
        int srcShift = destStartBitOffset - srcStartBitOffset;
        if (srcShift > 0) {
            byte current = src.getByte(srcStartBytes);
            byte result = (byte)(current << srcShift);
            dest[destStartBytes] = result = (byte)(result | dest[destStartBytes] & ~firstSrcMask);
            byte previous = current;
            for (int index = 1; index < lastIndex; ++index) {
                current = src.getByte((long)index + srcStartBytes);
                result = (byte)(current << srcShift);
                dest[index + destStartBytes] = result = (byte)(result | (previous & 0xFF) >>> 8 - srcShift);
                previous = current;
            }
            return bitsToCopy;
        }
        if (srcShift < 0) {
            srcShift = -srcShift;
            byte result = src.getByte(srcStartBytes);
            result = (byte)((result & 0xFF) >>> srcShift);
            byte next = 0;
            if (srcStartBytes + 1L < src.length) {
                next = src.getByte(srcStartBytes + 1L);
            }
            result = (byte)(result | (byte)(next << 8 - srcShift));
            result = (byte)(result & firstSrcMask);
            dest[destStartBytes] = result = (byte)(result | dest[destStartBytes] & ~firstSrcMask);
            for (int index = 1; index < lastIndex - 1; ++index) {
                result = next;
                result = (byte)((result & 0xFF) >>> srcShift);
                next = src.getByte(srcStartBytes + (long)index + 1L);
                dest[index + destStartBytes] = result = (byte)(result | (byte)(next << 8 - srcShift));
            }
            int idx = lastIndex - 1;
            if (idx > 0) {
                result = next;
                result = (byte)((result & 0xFF) >>> srcShift);
                next = 0;
                if (srcStartBytes + (long)idx + 1L < src.length) {
                    next = src.getByte(srcStartBytes + (long)idx + 1L);
                }
                dest[idx + destStartBytes] = result = (byte)(result | (byte)(next << 8 - srcShift));
            }
            return bitsToCopy;
        }
        src.getBytes(dest, destStartBytes, srcStartBytes, (bitsToCopy + 7) / 8);
        return bitsToCopy;
    }

    static long copySlicedValidity(DataWriter out, ColumnBufferProvider column, long rowOffset, long numRows) throws IOException {
        long validityLen = BitVectorHelper.getValidityLengthInBytes(numRows);
        long byteOffset = rowOffset / 8L;
        long bytesLeft = validityLen;
        int lshift = (int)rowOffset % 8;
        if (lshift == 0) {
            out.copyDataFrom(column, BufferType.VALIDITY, byteOffset, bytesLeft);
        } else {
            byte[] arrayBuffer = new byte[131072];
            int rowsStoredInArray = 0;
            int rowsLeftInBatch = (int)numRows;
            int validityBitOffset = (int)rowOffset;
            while (rowsLeftInBatch > 0) {
                int rowsStoredJustNow = JCudfSerialization.copyPartialValidity(arrayBuffer, rowsStoredInArray, column, validityBitOffset, rowsLeftInBatch);
                assert (rowsStoredJustNow > 0);
                rowsLeftInBatch -= rowsStoredJustNow;
                validityBitOffset += rowsStoredJustNow;
                if ((rowsStoredInArray += rowsStoredJustNow) != arrayBuffer.length * 8) continue;
                out.write(arrayBuffer, 0, arrayBuffer.length);
                rowsStoredInArray = 0;
            }
            if (rowsStoredInArray > 0) {
                out.write(arrayBuffer, 0, (rowsStoredInArray + 7) / 8);
            }
        }
        return JCudfSerialization.padFor64byteAlignment(out, validityLen);
    }

    static int fillValidity(byte[] dest, int destBitOffset, int lengthBits) {
        int destStartBytes = destBitOffset / 8;
        int destStartBits = destBitOffset % 8;
        long lengthBytes = BitVectorHelper.getValidityLengthInBytes(lengthBits);
        int rshift = destStartBits;
        int totalCopied = 0;
        if (rshift != 0) {
            int n = destStartBytes++;
            dest[n] = (byte)(dest[n] | 255 << destStartBits);
            totalCopied = 8 - destStartBits;
            destStartBits = 0;
        }
        int amountToCopyBytes = (int)Math.min(lengthBytes, (long)(dest.length - destStartBytes));
        for (int i = 0; i < amountToCopyBytes; ++i) {
            dest[i + destStartBytes] = -1;
        }
        return Math.min(totalCopied += amountToCopyBytes * 8, lengthBits);
    }

    private static long concatValidity(DataWriter out, long numRows, ColumnBufferProvider[] providers) throws IOException {
        long validityLen = BitVectorHelper.getValidityLengthInBytes(numRows);
        byte[] arrayBuffer = new byte[131072];
        int rowsStoredInArray = 0;
        for (ColumnBufferProvider provider : providers) {
            int rowsLeftInBatch = (int)provider.getRowCount();
            int validityBitOffset = 0;
            while (rowsLeftInBatch > 0) {
                int rowsStoredJustNow = provider.getNullCount() > 0L ? JCudfSerialization.copyPartialValidity(arrayBuffer, rowsStoredInArray, provider, validityBitOffset, rowsLeftInBatch) : JCudfSerialization.fillValidity(arrayBuffer, rowsStoredInArray, rowsLeftInBatch);
                assert (rowsStoredJustNow > 0);
                assert (rowsStoredJustNow <= rowsLeftInBatch);
                rowsLeftInBatch -= rowsStoredJustNow;
                validityBitOffset += rowsStoredJustNow;
                if ((rowsStoredInArray += rowsStoredJustNow) != arrayBuffer.length * 8) continue;
                out.write(arrayBuffer, 0, arrayBuffer.length);
                rowsStoredInArray = 0;
            }
        }
        if (rowsStoredInArray > 0) {
            int len = (rowsStoredInArray + 7) / 8;
            out.write(arrayBuffer, 0, len);
        }
        return JCudfSerialization.padFor64byteAlignment(out, validityLen);
    }

    private static long copySlicedStringData(DataWriter out, ColumnBufferProvider column, long rowOffset, long numRows) throws IOException {
        if (numRows > 0L) {
            long startByteOffset = column.getOffset(rowOffset);
            long endByteOffset = column.getOffset(rowOffset + numRows);
            long bytesToCopy = endByteOffset - startByteOffset;
            long srcOffset = startByteOffset;
            return JCudfSerialization.copySlicedAndPad(out, column, BufferType.DATA, srcOffset, bytesToCopy);
        }
        return 0L;
    }

    private static void copyConcatStringData(DataWriter out, ColumnBufferProvider[] providers) throws IOException {
        long totalCopied = 0L;
        for (ColumnBufferProvider provider : providers) {
            long rowCount = provider.getRowCount();
            if (rowCount <= 0L) continue;
            HostMemoryBuffer dataBuffer = provider.getHostBufferFor(BufferType.DATA);
            long currentOffset = provider.getBufferStartOffset(BufferType.DATA);
            long dataLeft = provider.getOffset(rowCount);
            out.copyDataFrom(dataBuffer, currentOffset, dataLeft);
            totalCopied += dataLeft;
        }
        JCudfSerialization.padFor64byteAlignment(out, totalCopied);
    }

    private static long copySlicedOffsets(DataWriter out, ColumnBufferProvider column, long rowOffset, long numRows) throws IOException {
        if (numRows <= 0L) {
            return 0L;
        }
        long bytesToCopy = (numRows + 1L) * 4L;
        long srcOffset = rowOffset * 4L;
        if (rowOffset == 0L) {
            return JCudfSerialization.copySlicedAndPad(out, column, BufferType.OFFSET, srcOffset, bytesToCopy);
        }
        HostMemoryBuffer buff = column.getHostBufferFor(BufferType.OFFSET);
        long startOffset = column.getBufferStartOffset(BufferType.OFFSET) + srcOffset;
        if (bytesToCopy >= Integer.MAX_VALUE) {
            throw new IllegalStateException("Copy is too large, need to do chunked copy");
        }
        ByteBuffer bb = buff.asByteBuffer(startOffset, (int)bytesToCopy);
        int start = bb.getInt();
        out.writeIntNativeOrder(0);
        long total = 4L;
        int i = 1;
        while ((long)i < numRows + 1L) {
            int offset = bb.getInt();
            out.writeIntNativeOrder(offset - start);
            total += 4L;
            ++i;
        }
        assert (total == bytesToCopy);
        long ret = JCudfSerialization.padFor64byteAlignment(out, total);
        return ret;
    }

    private static void copyConcatOffsets(DataWriter out, ColumnBufferProvider[] providers) throws IOException {
        long totalCopied = 0L;
        int offsetToAdd = 0;
        for (ColumnBufferProvider provider : providers) {
            long rowCount = provider.getRowCount();
            if (rowCount <= 0L) continue;
            HostMemoryBuffer offsetsBuffer = provider.getHostBufferFor(BufferType.OFFSET);
            long currentOffset = provider.getBufferStartOffset(BufferType.OFFSET);
            if (totalCopied == 0L) {
                totalCopied = (rowCount + 1L) * 4L;
                out.copyDataFrom(offsetsBuffer, currentOffset, totalCopied);
                offsetToAdd = offsetsBuffer.getInt(currentOffset + rowCount * 4L);
                continue;
            }
            int localOffset = 0;
            int row = 1;
            while ((long)row < rowCount + 1L) {
                localOffset = offsetsBuffer.getInt(currentOffset + (long)(row * 4));
                out.writeIntNativeOrder(localOffset + offsetToAdd);
                ++row;
            }
            offsetToAdd += localOffset;
            totalCopied += rowCount * 4L;
        }
        JCudfSerialization.padFor64byteAlignment(out, totalCopied);
    }

    private static long sliceBasicData(DataWriter out, ColumnBufferProvider column, long rowOffset, long numRows) throws IOException {
        DType type = column.getType();
        long bytesToCopy = numRows * (long)type.getSizeInBytes();
        long srcOffset = rowOffset * (long)type.getSizeInBytes();
        return JCudfSerialization.copySlicedAndPad(out, column, BufferType.DATA, srcOffset, bytesToCopy);
    }

    private static void concatBasicData(DataWriter out, DType type, ColumnBufferProvider[] providers) throws IOException {
        long totalCopied = 0L;
        for (ColumnBufferProvider provider : providers) {
            long rowCount = provider.getRowCount();
            if (rowCount <= 0L) continue;
            HostMemoryBuffer dataBuffer = provider.getHostBufferFor(BufferType.DATA);
            long currentOffset = provider.getBufferStartOffset(BufferType.DATA);
            long dataLeft = rowCount * (long)type.getSizeInBytes();
            out.copyDataFrom(dataBuffer, currentOffset, dataLeft);
            totalCopied += dataLeft;
        }
        JCudfSerialization.padFor64byteAlignment(out, totalCopied);
    }

    private static void writeConcat(DataWriter out, SerializedColumnHeader header, ColumnBufferProvider[] providers) throws IOException {
        DType dtype;
        if (header.getNullCount() > 0L) {
            JCudfSerialization.concatValidity(out, header.getRowCount(), providers);
        }
        if ((dtype = header.getType()).hasOffsets()) {
            if (header.getRowCount() > 0L) {
                JCudfSerialization.copyConcatOffsets(out, providers);
                if (dtype.equals(DType.STRING)) {
                    JCudfSerialization.copyConcatStringData(out, providers);
                }
            }
        } else if (dtype.getSizeInBytes() > 0) {
            JCudfSerialization.concatBasicData(out, dtype, providers);
        }
        if (dtype.isNestedType()) {
            int numTables = providers.length;
            SerializedColumnHeader[] childHeaders = header.getChildren();
            ColumnBufferProvider[] childColumnProviders = new ColumnBufferProvider[numTables];
            for (int childIdx = 0; childIdx < childHeaders.length; ++childIdx) {
                for (int tableIdx = 0; tableIdx < numTables; ++tableIdx) {
                    childColumnProviders[tableIdx] = providers[tableIdx].getChildProviders()[childIdx];
                }
                JCudfSerialization.writeConcat(out, childHeaders[childIdx], childColumnProviders);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeSliced(DataWriter out, ColumnBufferProvider column, long rowOffset, long numRows) throws IOException {
        NvtxRange range;
        Throwable throwable;
        DType type;
        block80: {
            if (column.getNullCount() > 0L) {
                try (NvtxRange range2 = new NvtxRange("Write Validity", NvtxColor.DARK_GREEN);){
                    JCudfSerialization.copySlicedValidity(out, column, rowOffset, numRows);
                }
            }
            if ((type = column.getType()).hasOffsets()) {
                if (numRows > 0L) {
                    throwable = null;
                    try (NvtxRange offsetRange = new NvtxRange("Write Offset Data", NvtxColor.ORANGE);){
                        JCudfSerialization.copySlicedOffsets(out, column, rowOffset, numRows);
                        if (!type.equals(DType.STRING)) break block80;
                        try (NvtxRange dataRange = new NvtxRange("Write String Data", NvtxColor.RED);){
                            JCudfSerialization.copySlicedStringData(out, column, rowOffset, numRows);
                        }
                    }
                    catch (Throwable dataRange) {
                        throwable = dataRange;
                        throw dataRange;
                    }
                }
            } else if (type.getSizeInBytes() > 0) {
                range = new NvtxRange("Write Data", NvtxColor.BLUE);
                throwable = null;
                try {
                    JCudfSerialization.sliceBasicData(out, column, rowOffset, numRows);
                }
                catch (Throwable dataRange) {
                    throwable = dataRange;
                    throw dataRange;
                }
                finally {
                    if (range != null) {
                        if (throwable != null) {
                            try {
                                range.close();
                            }
                            catch (Throwable dataRange) {
                                throwable.addSuppressed(dataRange);
                            }
                        } else {
                            range.close();
                        }
                    }
                }
            }
        }
        if (numRows <= 0L) return;
        if (!type.isNestedType()) return;
        if (type.equals(DType.LIST)) {
            range = new NvtxRange("Write List Child", NvtxColor.PURPLE);
            throwable = null;
            try {
                ColumnBufferProvider child = column.getChildProviders()[0];
                long childStartRow = column.getOffset(rowOffset);
                long childNumRows = column.getOffset(rowOffset + numRows) - childStartRow;
                JCudfSerialization.writeSliced(out, child, childStartRow, childNumRows);
                return;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (range != null) {
                    if (throwable != null) {
                        try {
                            range.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        range.close();
                    }
                }
            }
        }
        if (!type.equals(DType.STRUCT)) throw new IllegalStateException("Unexpected nested type: " + type);
        range = new NvtxRange("Write Struct Children", NvtxColor.PURPLE);
        throwable = null;
        try {
            ColumnBufferProvider[] columnBufferProviderArray = column.getChildProviders();
            int n = columnBufferProviderArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnBufferProvider child = columnBufferProviderArray[n2];
                JCudfSerialization.writeSliced(out, child, rowOffset, numRows);
                ++n2;
            }
            return;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (range != null) {
                if (throwable != null) {
                    try {
                        range.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    range.close();
                }
            }
        }
    }

    private static void writeSliced(ColumnBufferProvider[] columns, DataWriter out, long rowOffset, long numRows) throws IOException {
        assert (rowOffset >= 0L);
        assert (numRows >= 0L);
        for (int i = 0; i < columns.length; ++i) {
            long rows = columns[i].getRowCount();
            assert (rowOffset + numRows <= rows);
            long nullCount = columns[i].getNullCount();
            assert (nullCount == (long)((int)nullCount)) : "can only support an int for indexes";
            assert (rows == (long)((int)rows)) : "can only support an int for indexes";
        }
        SerializedTableHeader header = JCudfSerialization.calcHeader(columns, rowOffset, (int)numRows);
        header.writeTo(out);
        try (NvtxRange range = new NvtxRange("Write Sliced", NvtxColor.GREEN);){
            for (int i = 0; i < columns.length; ++i) {
                JCudfSerialization.writeSliced(out, columns[i], rowOffset, numRows);
            }
        }
        out.flush();
    }

    public static void writeToStream(Table t, OutputStream out, long rowOffset, long numRows) throws IOException {
        JCudfSerialization.writeToStream(t.getColumns(), out, rowOffset, numRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToStream(ColumnVector[] columns, OutputStream out, long rowOffset, long numRows) throws IOException {
        ColumnBufferProvider[] providers = JCudfSerialization.providersFrom(columns);
        try {
            DataWriter writer = JCudfSerialization.writerFrom(out);
            JCudfSerialization.writeSliced(providers, writer, rowOffset, numRows);
        }
        finally {
            JCudfSerialization.closeAll(providers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToStream(HostColumnVector[] columns, OutputStream out, long rowOffset, long numRows) throws IOException {
        ColumnBufferProvider[] providers = JCudfSerialization.providersFrom(columns, false);
        try {
            DataWriter writer = JCudfSerialization.writerFrom(out);
            JCudfSerialization.writeSliced(providers, writer, rowOffset, numRows);
        }
        finally {
            JCudfSerialization.closeAll(providers);
        }
    }

    public static void writeRowsToStream(OutputStream out, long numRows) throws IOException {
        DataWriter writer = JCudfSerialization.writerFrom(out);
        SerializedTableHeader header = new SerializedTableHeader((int)numRows);
        header.writeTo(writer);
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeConcatedStream(SerializedTableHeader[] headers, HostMemoryBuffer[] dataBuffers, OutputStream out) throws IOException {
        ColumnBufferProvider[][] providersPerColumn = JCudfSerialization.providersFrom(headers, dataBuffers);
        try {
            SerializedTableHeader combined = JCudfSerialization.calcConcatHeader(providersPerColumn);
            DataWriter writer = JCudfSerialization.writerFrom(out);
            combined.writeTo(writer);
            try (NvtxRange range = new NvtxRange("Concat Host Side", NvtxColor.GREEN);){
                int numColumns = combined.getNumColumns();
                for (int columnIdx = 0; columnIdx < numColumns; ++columnIdx) {
                    ColumnBufferProvider[] providers = providersPerColumn[columnIdx];
                    JCudfSerialization.writeConcat(writer, combined.getColumnHeader(columnIdx), providersPerColumn[columnIdx]);
                }
            }
            writer.flush();
        }
        finally {
            JCudfSerialization.closeAll(providersPerColumn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long buildColumnView(SerializedColumnHeader column, ArrayDeque<ColumnOffsets> columnOffsets, DeviceMemoryBuffer combinedBuffer) {
        ColumnOffsets offsetsInfo = columnOffsets.remove();
        long[] childViews = null;
        try {
            SerializedColumnHeader[] children = column.getChildren();
            if (children != null) {
                childViews = new long[children.length];
                for (int i = 0; i < childViews.length; ++i) {
                    childViews[i] = JCudfSerialization.buildColumnView(children[i], columnOffsets, combinedBuffer);
                }
            }
            DType dtype = column.getType();
            long bufferAddress = combinedBuffer.getAddress();
            long dataAddress = dtype.isNestedType() ? 0L : bufferAddress + offsetsInfo.data;
            long validityAddress = column.getNullCount() > 0L ? bufferAddress + offsetsInfo.validity : 0L;
            long offsetsAddress = dtype.hasOffsets() ? bufferAddress + offsetsInfo.offsets : 0L;
            long l = ColumnView.makeCudfColumnView(dtype.typeId.getNativeId(), dtype.getScale(), dataAddress, offsetsInfo.dataLen, offsetsAddress, validityAddress, (int)column.getNullCount(), (int)column.getRowCount(), childViews);
            return l;
        }
        finally {
            if (childViews != null) {
                for (long childView : childViews) {
                    ColumnView.deleteColumnView(childView);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Table sliceUpColumnVectors(SerializedTableHeader header, DeviceMemoryBuffer combinedBuffer, HostMemoryBuffer combinedBufferOnHost) {
        Throwable throwable = null;
        try (NvtxRange range = new NvtxRange("bufferToTable", NvtxColor.PURPLE);){
            Table table;
            ArrayDeque<ColumnOffsets> columnOffsets = JCudfSerialization.buildIndex(header, combinedBufferOnHost);
            int numColumns = header.getNumColumns();
            ColumnVector[] vectors = new ColumnVector[numColumns];
            try {
                for (int i = 0; i < numColumns; ++i) {
                    SerializedColumnHeader column = header.getColumnHeader(i);
                    long columnView = JCudfSerialization.buildColumnView(column, columnOffsets, combinedBuffer);
                    vectors[i] = ColumnVector.fromViewWithContiguousAllocation(columnView, combinedBuffer);
                }
                assert (columnOffsets.isEmpty());
                table = new Table(vectors);
            }
            catch (Throwable throwable2) {
                try {
                    for (ColumnVector cv : vectors) {
                        if (cv == null) continue;
                        cv.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            for (ColumnVector cv : vectors) {
                if (cv == null) continue;
                cv.close();
            }
            return table;
        }
    }

    public static Table readAndConcat(SerializedTableHeader[] headers, HostMemoryBuffer[] dataBuffers) throws IOException {
        ContiguousTable ct = JCudfSerialization.concatToContiguousTable(headers, dataBuffers);
        ct.getBuffer().close();
        return ct.getTable();
    }

    public static ContiguousTable concatToContiguousTable(SerializedTableHeader[] headers, HostMemoryBuffer[] dataBuffers) throws IOException {
        try (HostConcatResult concatResult = JCudfSerialization.concatToHostBuffer(headers, dataBuffers);){
            ContiguousTable contiguousTable = concatResult.toContiguousTable();
            return contiguousTable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HostConcatResult concatToHostBuffer(SerializedTableHeader[] headers, HostMemoryBuffer[] dataBuffers) throws IOException {
        ColumnBufferProvider[][] providersPerColumn = JCudfSerialization.providersFrom(headers, dataBuffers);
        try {
            SerializedTableHeader combined = JCudfSerialization.calcConcatHeader(providersPerColumn);
            HostMemoryBuffer hostBuffer = HostMemoryBuffer.allocate(combined.dataLen);
            try (NvtxRange range = new NvtxRange("Concat Host Side", NvtxColor.GREEN);){
                DataWriter writer = JCudfSerialization.writerFrom(hostBuffer);
                int numColumns = combined.getNumColumns();
                for (int columnIdx = 0; columnIdx < numColumns; ++columnIdx) {
                    JCudfSerialization.writeConcat(writer, combined.getColumnHeader(columnIdx), providersPerColumn[columnIdx]);
                }
            }
            catch (Exception e) {
                hostBuffer.close();
                throw e;
            }
            HostConcatResult hostConcatResult = new HostConcatResult(combined, hostBuffer);
            return hostConcatResult;
        }
        finally {
            JCudfSerialization.closeAll(providersPerColumn);
        }
    }

    public static void readTableIntoBuffer(InputStream in, SerializedTableHeader header, HostMemoryBuffer buffer) throws IOException {
        if (header.initialized && buffer.length >= header.dataLen) {
            try (NvtxRange range = new NvtxRange("Read Data", NvtxColor.RED);){
                buffer.copyFromStream(0L, in, header.dataLen);
            }
            header.dataRead = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableAndRowCountPair readTableFrom(SerializedTableHeader header, HostMemoryBuffer hostBuffer) {
        ContiguousTable contigTable = null;
        DeviceMemoryBuffer devBuffer = DeviceMemoryBuffer.allocate(hostBuffer.length);
        try {
            if (hostBuffer.length > 0L) {
                try (NvtxRange range = new NvtxRange("Copy Data To Device", NvtxColor.WHITE);){
                    devBuffer.copyFromHostBuffer(hostBuffer);
                }
            }
            if (header.getNumColumns() > 0) {
                Table table = JCudfSerialization.sliceUpColumnVectors(header, devBuffer, hostBuffer);
                contigTable = new ContiguousTable(table, devBuffer);
            }
        }
        finally {
            if (contigTable == null) {
                devBuffer.close();
            }
        }
        return new TableAndRowCountPair(header.numRows, contigTable);
    }

    public static TableAndRowCountPair readTableFrom(InputStream in) throws IOException {
        DataInputStream din = in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in);
        SerializedTableHeader header = new SerializedTableHeader(din);
        if (!header.initialized) {
            return new TableAndRowCountPair(0, null);
        }
        try (HostMemoryBuffer hostBuffer = HostMemoryBuffer.allocate(header.dataLen);){
            if (header.dataLen > 0L) {
                JCudfSerialization.readTableIntoBuffer(din, header, hostBuffer);
            }
            TableAndRowCountPair tableAndRowCountPair = JCudfSerialization.readTableFrom(header, hostBuffer);
            return tableAndRowCountPair;
        }
    }

    public static final class TableAndRowCountPair
    implements Closeable {
        private final int numRows;
        private final ContiguousTable contigTable;

        public TableAndRowCountPair(int numRows, ContiguousTable table) {
            this.numRows = numRows;
            this.contigTable = table;
        }

        @Override
        public void close() {
            if (this.contigTable != null) {
                this.contigTable.close();
            }
        }

        public int getNumRows() {
            return this.numRows;
        }

        public Table getTable() {
            if (this.contigTable != null) {
                return this.contigTable.getTable();
            }
            return null;
        }

        public ContiguousTable getContiguousTable() {
            return this.contigTable;
        }
    }

    private static final class HostDataWriter
    extends DataWriter {
        private final HostMemoryBuffer buffer;
        private long offset = 0L;

        public HostDataWriter(HostMemoryBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public void writeByte(byte b) {
            this.buffer.setByte(this.offset, b);
            ++this.offset;
        }

        @Override
        public void writeShort(short s) {
            this.buffer.setShort(this.offset, s);
            this.offset += 2L;
        }

        @Override
        public void writeInt(int i) {
            this.buffer.setInt(this.offset, i);
            this.offset += 4L;
        }

        @Override
        public void writeIntNativeOrder(int i) {
            this.writeInt(i);
        }

        @Override
        public void writeLong(long val) {
            this.buffer.setLong(this.offset, val);
            this.offset += 8L;
        }

        @Override
        public void copyDataFrom(HostMemoryBuffer src, long srcOffset, long len) {
            this.buffer.copyFromHostBuffer(this.offset, src, srcOffset, len);
            this.offset += len;
        }

        @Override
        public void write(byte[] arr, int srcOffset, int length) {
            this.buffer.setBytes(this.offset, arr, srcOffset, length);
            this.offset += (long)length;
        }
    }

    static final class DataOutputStreamWriter
    extends DataWriter {
        private final byte[] arrayBuffer = new byte[131072];
        private final DataOutputStream dout;

        public DataOutputStreamWriter(DataOutputStream dout) {
            this.dout = dout;
        }

        @Override
        public void writeByte(byte b) throws IOException {
            this.dout.writeByte(b);
        }

        @Override
        public void writeShort(short s) throws IOException {
            this.dout.writeShort(s);
        }

        @Override
        public void writeInt(int i) throws IOException {
            this.dout.writeInt(i);
        }

        @Override
        public void writeIntNativeOrder(int i) throws IOException {
            this.writeInt(Integer.reverseBytes(i));
        }

        @Override
        public void writeLong(long val) throws IOException {
            this.dout.writeLong(val);
        }

        @Override
        public void copyDataFrom(HostMemoryBuffer src, long srcOffset, long len) throws IOException {
            int amountToCopy;
            for (long dataLeft = len; dataLeft > 0L; dataLeft -= (long)amountToCopy) {
                amountToCopy = (int)Math.min((long)this.arrayBuffer.length, dataLeft);
                src.getBytes(this.arrayBuffer, 0L, srcOffset, amountToCopy);
                this.dout.write(this.arrayBuffer, 0, amountToCopy);
                srcOffset += (long)amountToCopy;
            }
        }

        @Override
        public void flush() throws IOException {
            this.dout.flush();
        }

        @Override
        public void write(byte[] arr, int offset, int length) throws IOException {
            this.dout.write(arr, offset, length);
        }
    }

    static abstract class DataWriter {
        DataWriter() {
        }

        public abstract void writeByte(byte var1) throws IOException;

        public abstract void writeShort(short var1) throws IOException;

        public abstract void writeInt(int var1) throws IOException;

        public abstract void writeIntNativeOrder(int var1) throws IOException;

        public abstract void writeLong(long var1) throws IOException;

        public abstract void copyDataFrom(HostMemoryBuffer var1, long var2, long var4) throws IOException;

        public void copyDataFrom(ColumnBufferProvider column, BufferType buffType, long offset, long length) throws IOException {
            HostMemoryBuffer buff = column.getHostBufferFor(buffType);
            long startOffset = column.getBufferStartOffset(buffType);
            this.copyDataFrom(buff, startOffset + offset, length);
        }

        public void flush() throws IOException {
        }

        public abstract void write(byte[] var1, int var2, int var3) throws IOException;
    }

    private static class BufferOffsetProvider
    extends ColumnBufferProvider {
        private final SerializedColumnHeader header;
        private final ColumnOffsets offsets;
        private final HostMemoryBuffer buffer;
        private final ColumnBufferProvider[] childProviders;

        private BufferOffsetProvider(SerializedColumnHeader header, ColumnOffsets offsets, HostMemoryBuffer buffer, ColumnBufferProvider[] childProviders) {
            this.header = header;
            this.offsets = offsets;
            this.buffer = buffer;
            this.childProviders = childProviders;
        }

        @Override
        public DType getType() {
            return this.header.getType();
        }

        @Override
        public long getNullCount() {
            return this.header.getNullCount();
        }

        @Override
        public long getRowCount() {
            return this.header.getRowCount();
        }

        @Override
        public HostMemoryBuffer getHostBufferFor(BufferType buffType) {
            return this.buffer;
        }

        @Override
        public long getBufferStartOffset(BufferType buffType) {
            switch (buffType) {
                case DATA: {
                    return this.offsets.data;
                }
                case OFFSET: {
                    return this.offsets.offsets;
                }
                case VALIDITY: {
                    return this.offsets.validity;
                }
            }
            throw new IllegalArgumentException("Buffer type " + (Object)((Object)buffType) + " is not supported");
        }

        @Override
        public long getOffset(long index) {
            assert (this.getType().hasOffsets());
            assert (index >= 0L && index <= this.getRowCount()) : "index is out of range 0 <= " + index + " <= " + this.getRowCount();
            return this.buffer.getInt(this.offsets.offsets + index * 4L);
        }

        @Override
        public ColumnBufferProvider[] getChildProviders() {
            return this.childProviders;
        }

        @Override
        public void close() {
        }
    }

    static class ColumnProvider
    extends ColumnBufferProvider {
        private final HostColumnVectorCore column;
        private final boolean closeAtEnd;
        private final ColumnBufferProvider[] childProviders;

        ColumnProvider(HostColumnVectorCore column, boolean closeAtEnd) {
            this.column = column;
            this.closeAtEnd = closeAtEnd;
            if (this.getType().isNestedType()) {
                int numChildren = column.getNumChildren();
                this.childProviders = new ColumnBufferProvider[numChildren];
                for (int i = 0; i < numChildren; ++i) {
                    this.childProviders[i] = new ColumnProvider(column.getChildColumnView(i), false);
                }
            } else {
                this.childProviders = null;
            }
        }

        @Override
        public DType getType() {
            return this.column.getType();
        }

        @Override
        public long getNullCount() {
            return this.column.getNullCount();
        }

        @Override
        public long getOffset(long index) {
            return this.column.getOffsets().getInt(index * 4L);
        }

        @Override
        public long getRowCount() {
            return this.column.getRowCount();
        }

        @Override
        public HostMemoryBuffer getHostBufferFor(BufferType buffType) {
            switch (buffType) {
                case VALIDITY: {
                    return this.column.getValidity();
                }
                case OFFSET: {
                    return this.column.getOffsets();
                }
                case DATA: {
                    return this.column.getData();
                }
            }
            throw new IllegalStateException("Unexpected buffer type: " + (Object)((Object)buffType));
        }

        @Override
        public long getBufferStartOffset(BufferType buffType) {
            return 0L;
        }

        @Override
        public ColumnBufferProvider[] getChildProviders() {
            return this.childProviders;
        }

        @Override
        public void close() {
            if (this.closeAtEnd) {
                this.column.close();
            }
        }
    }

    static abstract class ColumnBufferProvider
    implements AutoCloseable {
        ColumnBufferProvider() {
        }

        public abstract DType getType();

        public abstract long getNullCount();

        public abstract long getOffset(long var1);

        public abstract long getRowCount();

        public abstract HostMemoryBuffer getHostBufferFor(BufferType var1);

        public abstract long getBufferStartOffset(BufferType var1);

        public abstract ColumnBufferProvider[] getChildProviders();

        @Override
        public abstract void close();
    }

    public static final class HostConcatResult
    implements AutoCloseable {
        private final SerializedTableHeader tableHeader;
        private final HostMemoryBuffer hostBuffer;

        public HostConcatResult(SerializedTableHeader tableHeader, HostMemoryBuffer tableBuffer) {
            this.tableHeader = tableHeader;
            this.hostBuffer = tableBuffer;
        }

        public SerializedTableHeader getTableHeader() {
            return this.tableHeader;
        }

        public HostMemoryBuffer getHostBuffer() {
            return this.hostBuffer;
        }

        public ContiguousTable toContiguousTable() {
            DeviceMemoryBuffer devBuffer = DeviceMemoryBuffer.allocate(this.hostBuffer.length);
            try {
                if (this.hostBuffer.length > 0L) {
                    devBuffer.copyFromHostBuffer(this.hostBuffer);
                }
                Table table = JCudfSerialization.sliceUpColumnVectors(this.tableHeader, devBuffer, this.hostBuffer);
                try {
                    return new ContiguousTable(table, devBuffer);
                }
                catch (Exception e) {
                    table.close();
                    throw e;
                }
            }
            catch (Exception e) {
                devBuffer.close();
                throw e;
            }
        }

        @Override
        public void close() {
            this.hostBuffer.close();
        }
    }

    public static final class SerializedColumnHeader {
        public final DType dtype;
        public final long nullCount;
        public final long rowCount;
        public final SerializedColumnHeader[] children;

        SerializedColumnHeader(DType dtype, long rowCount, long nullCount, SerializedColumnHeader[] children) {
            this.dtype = dtype;
            this.rowCount = rowCount;
            this.nullCount = nullCount;
            this.children = children;
        }

        SerializedColumnHeader(ColumnBufferProvider column, long rowOffset, long numRows) {
            this.dtype = column.getType();
            this.rowCount = numRows;
            this.nullCount = Math.min(column.getNullCount(), numRows);
            ColumnBufferProvider[] childProviders = column.getChildProviders();
            if (childProviders != null) {
                this.children = new SerializedColumnHeader[childProviders.length];
                long childRowOffset = rowOffset;
                long childNumRows = numRows;
                if (this.dtype.equals(DType.LIST) && numRows > 0L) {
                    childRowOffset = column.getOffset(rowOffset);
                    childNumRows = column.getOffset(rowOffset + numRows) - childRowOffset;
                }
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i] = new SerializedColumnHeader(childProviders[i], childRowOffset, childNumRows);
                }
            } else {
                this.children = null;
            }
        }

        public DType getType() {
            return this.dtype;
        }

        public long getRowCount() {
            return this.rowCount;
        }

        public long getNullCount() {
            return this.nullCount;
        }

        public SerializedColumnHeader[] getChildren() {
            return this.children;
        }

        public int getNumChildren() {
            return this.children != null ? this.children.length : 0;
        }

        public long getSerializedHeaderSizeInBytes() {
            long total = 12L;
            if (this.dtype.isNestedType()) {
                assert (this.children != null);
                if (this.dtype.equals(DType.LIST)) {
                    total += 4L;
                } else if (this.dtype.equals(DType.STRUCT)) {
                    total += 4L;
                } else {
                    throw new IllegalStateException("Unexpected nested type: " + this.dtype);
                }
                for (SerializedColumnHeader child : this.children) {
                    total += child.getSerializedHeaderSizeInBytes();
                }
            }
            return total;
        }

        public void writeTo(DataWriter dout) throws IOException {
            dout.writeInt(this.dtype.typeId.getNativeId());
            dout.writeInt(this.dtype.getScale());
            dout.writeInt((int)this.nullCount);
            if (this.dtype.isNestedType()) {
                assert (this.children != null);
                if (this.dtype.equals(DType.LIST)) {
                    dout.writeInt((int)this.children[0].getRowCount());
                } else if (this.dtype.equals(DType.STRUCT)) {
                    dout.writeInt(this.getNumChildren());
                } else {
                    throw new IllegalStateException("Unexpected nested type: " + this.dtype);
                }
                for (SerializedColumnHeader child : this.children) {
                    child.writeTo(dout);
                }
            }
        }

        static SerializedColumnHeader readFrom(DataInputStream din, long rowCount) throws IOException {
            DType dtype = DType.fromNative(din.readInt(), din.readInt());
            long nullCount = din.readInt();
            SerializedColumnHeader[] children = null;
            if (dtype.isNestedType()) {
                long childRowCount;
                int numChildren;
                if (dtype.equals(DType.LIST)) {
                    numChildren = 1;
                    childRowCount = din.readInt();
                } else if (dtype.equals(DType.STRUCT)) {
                    numChildren = din.readInt();
                    childRowCount = rowCount;
                } else {
                    throw new IllegalStateException("Unexpected nested type: " + dtype);
                }
                children = new SerializedColumnHeader[numChildren];
                for (int i = 0; i < numChildren; ++i) {
                    children[i] = SerializedColumnHeader.readFrom(din, childRowCount);
                }
            }
            return new SerializedColumnHeader(dtype, rowCount, nullCount, children);
        }
    }

    public static final class SerializedTableHeader {
        private SerializedColumnHeader[] columns;
        private int numRows;
        private long dataLen;
        private boolean initialized = false;
        private boolean dataRead = false;

        public SerializedTableHeader(DataInputStream din) throws IOException {
            this.readFrom(din);
        }

        SerializedTableHeader(SerializedColumnHeader[] columns, int numRows, long dataLen) {
            this.columns = columns;
            this.numRows = numRows;
            this.dataLen = dataLen;
            this.initialized = true;
            this.dataRead = true;
        }

        SerializedTableHeader(int numRows) {
            this(new SerializedColumnHeader[0], numRows, 0L);
        }

        public SerializedColumnHeader getColumnHeader(int columnIndex) {
            return this.columns[columnIndex];
        }

        public boolean wasDataRead() {
            return this.dataRead;
        }

        public long getDataLen() {
            return this.dataLen;
        }

        public int getNumRows() {
            return this.numRows;
        }

        public int getNumColumns() {
            return this.columns != null ? this.columns.length : 0;
        }

        public boolean wasInitialized() {
            return this.initialized;
        }

        public long getSerializedHeaderSizeInBytes() {
            long total = 22L;
            for (SerializedColumnHeader column : this.columns) {
                total += column.getSerializedHeaderSizeInBytes();
            }
            return total;
        }

        public long getTotalSerializedSizeInBytes() {
            return this.getSerializedHeaderSizeInBytes() + this.dataLen;
        }

        private void readFrom(DataInputStream din) throws IOException {
            try {
                int num = din.readInt();
                if (num != 1129661510) {
                    throw new IllegalStateException("THIS DOES NOT LOOK LIKE CUDF SERIALIZED DATA. Expected magic number 1129661510 Found " + num);
                }
            }
            catch (EOFException e) {
                return;
            }
            short version = din.readShort();
            if (version != 0) {
                throw new IllegalStateException("READING THE WRONG SERIALIZATION FORMAT VERSION FOUND " + version + " EXPECTED " + 0);
            }
            int numColumns = din.readInt();
            this.numRows = din.readInt();
            this.columns = new SerializedColumnHeader[numColumns];
            for (int i = 0; i < numColumns; ++i) {
                this.columns[i] = SerializedColumnHeader.readFrom(din, this.numRows);
            }
            this.dataLen = din.readLong();
            this.initialized = true;
        }

        public void writeTo(DataWriter dout) throws IOException {
            dout.writeInt(1129661510);
            dout.writeShort((short)0);
            dout.writeInt(this.columns.length);
            dout.writeInt(this.numRows);
            for (SerializedColumnHeader column : this.columns) {
                column.writeTo(dout);
            }
            dout.writeLong(this.dataLen);
        }
    }

    private static final class ColumnOffsets {
        private final long validity;
        private final long offsets;
        private final long data;
        private final long dataLen;

        public ColumnOffsets(long validity, long offsets, long data, long dataLen) {
            this.validity = validity;
            this.offsets = offsets;
            this.data = data;
            this.dataLen = dataLen;
        }
    }
}

