/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.Cuda;
import ai.rapids.cudf.CudaMemcpyKind;
import ai.rapids.cudf.MemoryCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MemoryBuffer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(MemoryBuffer.class);
    protected final long address;
    protected final long length;
    protected boolean closed = false;
    protected int refCount = 0;
    protected final MemoryBufferCleaner cleaner;
    protected final long id;

    public void noWarnLeakExpected() {
        if (this.cleaner != null) {
            this.cleaner.noWarnLeakExpected();
        }
    }

    protected MemoryBuffer(long address, long length, MemoryBufferCleaner cleaner) {
        this.address = address;
        this.length = length;
        this.cleaner = cleaner;
        if (cleaner != null) {
            this.id = cleaner.id;
            this.incRefCount();
            MemoryCleaner.register(this, (MemoryCleaner.Cleaner)cleaner);
        } else {
            this.id = -1L;
        }
    }

    protected MemoryBuffer(long address, long length) {
        this(address, length, (MemoryBufferCleaner)null);
    }

    protected MemoryBuffer(long address, long length, MemoryBuffer parent) {
        this(address, length, new SlicedBufferCleaner(parent));
    }

    public final long getLength() {
        return this.length;
    }

    protected final void addressOutOfBoundsCheck(long address, long size, String type) {
        assert (!this.closed) : "Buffer is already closed " + Long.toHexString(this.address);
        assert (size >= 0L) : "A positive size is required";
        assert (address >= this.address) : "Start address is too low for " + type + " 0x" + Long.toHexString(address) + " < 0x" + Long.toHexString(this.address);
        assert (address + size <= this.address + this.length) : "End address is too high for " + type + " 0x" + Long.toHexString(address + size) + " < 0x" + Long.toHexString(this.address + this.length);
    }

    public final long getAddress() {
        return this.address;
    }

    public final void copyFromMemoryBuffer(long destOffset, MemoryBuffer src, long srcOffset, long length, Cuda.Stream stream) {
        this.addressOutOfBoundsCheck(this.address + destOffset, length, "copy range dest");
        src.addressOutOfBoundsCheck(src.address + srcOffset, length, "copy range src");
        Cuda.memcpy(this.address + destOffset, src.address + srcOffset, length, CudaMemcpyKind.DEFAULT, stream);
    }

    public final void copyFromMemoryBufferAsync(long destOffset, MemoryBuffer src, long srcOffset, long length, Cuda.Stream stream) {
        this.addressOutOfBoundsCheck(this.address + destOffset, length, "copy range dest");
        src.addressOutOfBoundsCheck(src.address + srcOffset, length, "copy range src");
        Cuda.asyncMemcpy(this.address + destOffset, src.address + srcOffset, length, CudaMemcpyKind.DEFAULT, stream);
    }

    public abstract MemoryBuffer slice(long var1, long var3);

    @Override
    public synchronized void close() {
        if (this.cleaner != null) {
            --this.refCount;
            this.cleaner.delRef();
            if (this.refCount == 0) {
                this.cleaner.clean(false);
                this.closed = true;
            } else if (this.refCount < 0) {
                this.cleaner.logRefCountDebug("double free " + this);
                throw new IllegalStateException("Close called too many times " + this);
            }
        }
    }

    public String toString() {
        long id = -1L;
        if (this.cleaner != null) {
            id = this.cleaner.id;
        }
        String name = this.getClass().getSimpleName();
        return name + "{address=0x" + Long.toHexString(this.address) + ", length=" + this.length + ", id=" + id + "}";
    }

    public synchronized void incRefCount() {
        ++this.refCount;
        this.cleaner.addRef();
    }

    synchronized int getRefCount() {
        return this.refCount;
    }

    private static final class SlicedBufferCleaner
    extends MemoryBufferCleaner {
        private MemoryBuffer parent;

        SlicedBufferCleaner(MemoryBuffer parent) {
            this.parent = parent;
        }

        @Override
        protected synchronized boolean cleanImpl(boolean logErrorIfNotClean) {
            if (this.parent != null) {
                if (logErrorIfNotClean) {
                    log.error("A SLICED BUFFER WAS LEAKED(ID: " + this.id + " parent: " + this.parent + ")");
                    this.logRefCountDebug("Leaked sliced buffer");
                }
                try {
                    this.parent.close();
                }
                finally {
                    this.parent = null;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean isClean() {
            return this.parent == null;
        }
    }

    public static abstract class MemoryBufferCleaner
    extends MemoryCleaner.Cleaner {
    }
}

