/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeDepsLoader {
    private static final Logger log = LoggerFactory.getLogger(NativeDepsLoader.class);
    private static final Boolean preserveDepsAfterLoad = Boolean.getBoolean("ai.rapids.cudf.preserve-dependencies");
    private static final String[][] loadOrder = new String[][]{{"nvcomp", "cudf"}, {"cudfjni"}};
    private static final ClassLoader loader = NativeDepsLoader.class.getClassLoader();
    private static boolean loaded = false;

    public static synchronized void loadNativeDeps() {
        if (!loaded) {
            try {
                NativeDepsLoader.loadNativeDeps(loadOrder);
                loaded = true;
            }
            catch (Throwable t) {
                log.error("Could not load cudf jni library...", t);
            }
        }
    }

    public static void loadNativeDeps(String[] loadOrder) throws IOException {
        String os = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        for (String toLoad : loadOrder) {
            NativeDepsLoader.loadDep(os, arch, toLoad);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void loadNativeDeps(String[][] loadOrder) throws IOException {
        void var7_9;
        String os = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        ExecutorService executor = Executors.newCachedThreadPool();
        ArrayList allFileFutures = new ArrayList();
        String[][] stringArray = loadOrder;
        int n = stringArray.length;
        boolean bl = false;
        while (var7_9 < n) {
            String[] stageDependencies = stringArray[var7_9];
            ArrayList<Future<File>> arrayList = new ArrayList<Future<File>>();
            allFileFutures.add(arrayList);
            for (String name : stageDependencies) {
                arrayList.add(executor.submit(() -> NativeDepsLoader.createFile(os, arch, name)));
            }
            ++var7_9;
        }
        ArrayList loadCompletionFutures = new ArrayList();
        for (List list : allFileFutures) {
            loadCompletionFutures.clear();
            for (Future future : list) {
                loadCompletionFutures.add(executor.submit(() -> NativeDepsLoader.loadDep(fileFuture)));
            }
            for (Future future : loadCompletionFutures) {
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new IOException("Error loading dependencies", e);
                }
            }
        }
        executor.shutdownNow();
    }

    private static void loadDep(String os, String arch, String baseName) throws IOException {
        File path = NativeDepsLoader.createFile(os, arch, baseName);
        NativeDepsLoader.loadDep(path);
    }

    private static void loadDep(File path) {
        System.load(path.getAbsolutePath());
        if (!preserveDepsAfterLoad.booleanValue()) {
            path.delete();
        }
    }

    private static void loadDep(Future<File> fileFuture) {
        File path;
        try {
            path = fileFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Error loading dependencies", e);
        }
        NativeDepsLoader.loadDep(path);
    }

    private static File createFile(String os, String arch, String baseName) throws IOException {
        File loc;
        String path = arch + "/" + os + "/" + System.mapLibraryName(baseName);
        URL resource = loader.getResource(path);
        if (resource == null) {
            File f = new File("./target/native-deps/" + path);
            if (!f.exists()) {
                throw new FileNotFoundException("Could not locate native dependency " + path);
            }
            resource = f.toURI().toURL();
        }
        try (InputStream in = resource.openStream();){
            loc = File.createTempFile(baseName, ".so");
            loc.deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(loc);){
                byte[] buffer = new byte[16384];
                int read = 0;
                while ((read = in.read(buffer)) >= 0) {
                    ((OutputStream)out).write(buffer, 0, read);
                }
            }
        }
        return loc;
    }

    public static boolean libraryLoaded() {
        if (!loaded) {
            NativeDepsLoader.loadNativeDeps();
        }
        return loaded;
    }
}

