/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.ColumnFilterOptions;
import ai.rapids.cudf.DType;

public class ORCOptions
extends ColumnFilterOptions {
    public static ORCOptions DEFAULT = new ORCOptions(new Builder());
    private final boolean useNumPyTypes;
    private final DType unit;

    private ORCOptions(Builder builder) {
        super(builder);
        this.useNumPyTypes = builder.useNumPyTypes;
        this.unit = builder.unit;
    }

    boolean usingNumPyTypes() {
        return this.useNumPyTypes;
    }

    DType timeUnit() {
        return this.unit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ColumnFilterOptions.Builder<Builder> {
        private boolean useNumPyTypes = true;
        private DType unit = DType.EMPTY;

        public Builder withNumPyTypes(boolean useNumPyTypes) {
            this.useNumPyTypes = useNumPyTypes;
            return this;
        }

        public Builder withTimeUnit(DType unit) {
            assert (unit.isTimestampType());
            this.unit = unit;
            return this;
        }

        public ORCOptions build() {
            return new ORCOptions(this);
        }
    }
}

