/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

public enum PadSide {
    LEFT(0),
    RIGHT(1),
    BOTH(2);

    private static final PadSide[] PAD_SIDES;
    final int nativeId;

    private PadSide(int nativeId) {
        this.nativeId = nativeId;
    }

    public int getNativeId() {
        return this.nativeId;
    }

    public static PadSide fromNative(int nativeId) {
        for (PadSide type : PAD_SIDES) {
            if (type.nativeId != nativeId) continue;
            return type;
        }
        throw new IllegalArgumentException("Could not translate " + nativeId + " into a PadSide");
    }

    static {
        PAD_SIDES = PadSide.values();
    }
}

