/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import java.util.ArrayList;
import java.util.List;

public class ParquetColumnWriterOptions {
    private boolean isTimestampTypeInt96;
    private int precision;
    private boolean isNullable;
    private String columName;
    protected ParquetColumnWriterOptions[] childColumnOptions = new ParquetColumnWriterOptions[0];
    static ParquetColumnWriterOptions DUMMY_CHILD = new ParquetColumnWriterOptions("DUMMY");

    private ParquetColumnWriterOptions(AbstractStructBuilder builder) {
        this.columName = builder.name;
        this.isNullable = builder.isNullable;
        this.childColumnOptions = builder.children.toArray(new ParquetColumnWriterOptions[0]);
    }

    private ParquetColumnWriterOptions(ListBuilder builder) {
        assert (builder.children.size() == 1) : "Lists can only have one child";
        this.columName = builder.name;
        this.isNullable = builder.isNullable;
        this.childColumnOptions = new ParquetColumnWriterOptions[]{DUMMY_CHILD, (ParquetColumnWriterOptions)builder.children.get(0)};
    }

    ParquetColumnWriterOptions(String columnName, boolean isTimestampTypeInt96, int precision, boolean isNullable) {
        this.isTimestampTypeInt96 = isTimestampTypeInt96;
        this.precision = precision;
        this.isNullable = isNullable;
        this.columName = columnName;
    }

    ParquetColumnWriterOptions(String columnName, boolean isNullable) {
        this.isTimestampTypeInt96 = false;
        this.precision = 0;
        this.isNullable = isNullable;
        this.columName = columnName;
    }

    ParquetColumnWriterOptions(String columnName) {
        this(columnName, true);
    }

    boolean[] getFlatIsTimeTypeInt96() {
        boolean[] ret = new boolean[]{this.isTimestampTypeInt96};
        if (this.childColumnOptions.length > 0) {
            return this.getFlatBooleans(ret, opt -> opt.getFlatIsTimeTypeInt96());
        }
        return ret;
    }

    protected boolean[] getFlatBooleans(boolean[] ret, ByteArrayProducer producer) {
        boolean[][] childResults = new boolean[this.childColumnOptions.length][];
        int totalChildrenFlatLength = ret.length;
        for (int i = 0; i < this.childColumnOptions.length; ++i) {
            ParquetColumnWriterOptions opt = this.childColumnOptions[i];
            childResults[i] = producer.apply(opt);
            totalChildrenFlatLength += childResults[i].length;
        }
        boolean[] result = new boolean[totalChildrenFlatLength];
        System.arraycopy(ret, 0, result, 0, ret.length);
        int copiedSoFar = ret.length;
        for (int i = 0; i < this.childColumnOptions.length; ++i) {
            System.arraycopy(childResults[i], 0, result, copiedSoFar, childResults[i].length);
            copiedSoFar += childResults[i].length;
        }
        return result;
    }

    int[] getFlatPrecision() {
        int[] ret = new int[]{this.precision};
        if (this.childColumnOptions.length > 0) {
            return this.getFlatInts(ret, opt -> opt.getFlatPrecision());
        }
        return ret;
    }

    boolean[] getFlatIsNullable() {
        boolean[] ret = new boolean[]{this.isNullable};
        if (this.childColumnOptions.length > 0) {
            return this.getFlatBooleans(ret, opt -> opt.getFlatIsNullable());
        }
        return ret;
    }

    int[] getFlatNumChildren() {
        int[] ret = new int[]{this.childColumnOptions.length};
        if (this.childColumnOptions.length > 0) {
            return this.getFlatInts(ret, opt -> opt.getFlatNumChildren());
        }
        return ret;
    }

    protected int[] getFlatInts(int[] ret, IntArrayProducer producer) {
        int[][] childResults = new int[this.childColumnOptions.length][];
        int totalChildrenFlatLength = ret.length;
        for (int i = 0; i < this.childColumnOptions.length; ++i) {
            ParquetColumnWriterOptions opt = this.childColumnOptions[i];
            childResults[i] = producer.apply(opt);
            totalChildrenFlatLength += childResults[i].length;
        }
        int[] result = new int[totalChildrenFlatLength];
        System.arraycopy(ret, 0, result, 0, ret.length);
        int copiedSoFar = ret.length;
        for (int i = 0; i < this.childColumnOptions.length; ++i) {
            System.arraycopy(childResults[i], 0, result, copiedSoFar, childResults[i].length);
            copiedSoFar += childResults[i].length;
        }
        return result;
    }

    String[] getFlatColumnNames() {
        String[] ret = new String[]{this.columName};
        if (this.childColumnOptions.length > 0) {
            return this.getFlatColumnNames(ret);
        }
        return ret;
    }

    protected String[] getFlatColumnNames(String[] ret) {
        String[][] childResults = new String[this.childColumnOptions.length][];
        int totalChildrenFlatLength = ret.length;
        for (int i = 0; i < this.childColumnOptions.length; ++i) {
            ParquetColumnWriterOptions opt = this.childColumnOptions[i];
            childResults[i] = opt.getFlatColumnNames();
            totalChildrenFlatLength += childResults[i].length;
        }
        String[] result = new String[totalChildrenFlatLength];
        System.arraycopy(ret, 0, result, 0, ret.length);
        int copiedSoFar = ret.length;
        for (int i = 0; i < this.childColumnOptions.length; ++i) {
            System.arraycopy(childResults[i], 0, result, copiedSoFar, childResults[i].length);
            copiedSoFar += childResults[i].length;
        }
        return result;
    }

    public static ListBuilder listBuilder(String name) {
        return new ListBuilder(name, true);
    }

    public static ListBuilder listBuilder(String name, boolean isNullable) {
        return new ListBuilder(name, isNullable);
    }

    public static StructBuilder structBuilder(String name, boolean isNullable) {
        return new StructBuilder(name, isNullable);
    }

    public static StructBuilder structBuilder(String name) {
        return new StructBuilder(name, true);
    }

    public String getColumName() {
        return this.columName;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public int getPrecision() {
        return this.precision;
    }

    public boolean isTimestampTypeInt96() {
        return this.isTimestampTypeInt96;
    }

    public ParquetColumnWriterOptions[] getChildColumnOptions() {
        return this.childColumnOptions;
    }

    public static class ListBuilder
    extends NestedBuilder<ListBuilder, ParquetListColumnWriterOptions> {
        public ListBuilder(String name, boolean isNullable) {
            super(name, isNullable);
        }

        @Override
        public ParquetListColumnWriterOptions build() {
            return new ParquetListColumnWriterOptions(this);
        }
    }

    public static class StructBuilder
    extends AbstractStructBuilder<StructBuilder, ParquetStructColumnWriterOptions> {
        public StructBuilder(String name, boolean isNullable) {
            super(name, isNullable);
        }

        @Override
        public ParquetStructColumnWriterOptions build() {
            return new ParquetStructColumnWriterOptions(this);
        }
    }

    public static class ParquetListColumnWriterOptions
    extends ParquetColumnWriterOptions {
        protected ParquetListColumnWriterOptions(ListBuilder builder) {
            super(builder);
        }
    }

    public static class ParquetStructColumnWriterOptions
    extends ParquetColumnWriterOptions {
        protected ParquetStructColumnWriterOptions(AbstractStructBuilder builder) {
            super(builder);
        }
    }

    @FunctionalInterface
    protected static interface IntArrayProducer {
        public int[] apply(ParquetColumnWriterOptions var1);
    }

    @FunctionalInterface
    protected static interface ByteArrayProducer {
        public boolean[] apply(ParquetColumnWriterOptions var1);
    }

    public static abstract class NestedBuilder<T extends NestedBuilder, V extends ParquetColumnWriterOptions> {
        protected List<ParquetColumnWriterOptions> children = new ArrayList<ParquetColumnWriterOptions>();
        protected boolean isNullable = true;
        protected String name = "";

        protected NestedBuilder(String name, boolean isNullable) {
            this.name = name;
            this.isNullable = isNullable;
        }

        protected NestedBuilder() {
        }

        protected ParquetColumnWriterOptions withColumns(String name, boolean isNullable) {
            return new ParquetColumnWriterOptions(name, isNullable);
        }

        protected ParquetColumnWriterOptions withDecimal(String name, int precision, boolean isNullable) {
            return new ParquetColumnWriterOptions(name, false, precision, isNullable);
        }

        protected ParquetColumnWriterOptions withTimestamp(String name, boolean isInt96, boolean isNullable) {
            return new ParquetColumnWriterOptions(name, isInt96, 0, isNullable);
        }

        public T withListColumn(ParquetListColumnWriterOptions child) {
            assert (child.getChildColumnOptions().length == 2) : "Lists can only have two children";
            if (child.getChildColumnOptions()[0] != DUMMY_CHILD) {
                throw new IllegalArgumentException("First child in the list has to be DUMMY_CHILD");
            }
            if (child.getChildColumnOptions()[1].getColumName().isEmpty()) {
                throw new IllegalArgumentException("Column name can't be empty");
            }
            this.children.add(child);
            return (T)this;
        }

        public T withStructColumn(ParquetStructColumnWriterOptions child) {
            for (ParquetColumnWriterOptions opt : child.getChildColumnOptions()) {
                if (!opt.getColumName().isEmpty()) continue;
                throw new IllegalArgumentException("Column name can't be empty");
            }
            this.children.add(child);
            return (T)this;
        }

        public T withNonNullableColumns(String ... name) {
            this.withColumns(false, name);
            return (T)this;
        }

        public T withNullableColumns(String ... name) {
            this.withColumns(true, name);
            return (T)this;
        }

        public T withColumns(boolean nullable, String ... name) {
            for (String n : name) {
                this.children.add(this.withColumns(n, nullable));
            }
            return (T)this;
        }

        public T withDecimalColumn(String name, int precision, boolean nullable) {
            this.children.add(this.withDecimal(name, precision, nullable));
            return (T)this;
        }

        public T withNullableDecimalColumn(String name, int precision) {
            this.withDecimalColumn(name, precision, true);
            return (T)this;
        }

        public T withDecimalColumn(String name, int precision) {
            this.withDecimalColumn(name, precision, false);
            return (T)this;
        }

        public T withTimestampColumn(String name, boolean isInt96, boolean nullable) {
            this.children.add(this.withTimestamp(name, isInt96, nullable));
            return (T)this;
        }

        public T withTimestampColumn(String name, boolean isInt96) {
            this.withTimestampColumn(name, isInt96, false);
            return (T)this;
        }

        public T withNullableTimestampColumn(String name, boolean isInt96) {
            this.withTimestampColumn(name, isInt96, true);
            return (T)this;
        }

        public abstract V build();
    }

    protected static abstract class AbstractStructBuilder<T extends AbstractStructBuilder, V extends ParquetColumnWriterOptions>
    extends NestedBuilder<T, V> {
        public AbstractStructBuilder(String name, boolean isNullable) {
            super(name, isNullable);
        }

        protected AbstractStructBuilder() {
        }
    }
}

