/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.ColumnFilterOptions;
import ai.rapids.cudf.DType;

public class ParquetOptions
extends ColumnFilterOptions {
    public static ParquetOptions DEFAULT = new ParquetOptions(new Builder());
    private final DType unit;
    private final boolean strictDecimalType;

    private ParquetOptions(Builder builder) {
        super(builder);
        this.unit = builder.unit;
        this.strictDecimalType = builder.strictDecimalType;
    }

    DType timeUnit() {
        return this.unit;
    }

    boolean isStrictDecimalType() {
        return this.strictDecimalType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ColumnFilterOptions.Builder<Builder> {
        private DType unit = DType.EMPTY;
        private boolean strictDecimalType = false;

        public Builder withTimeUnit(DType unit) {
            assert (unit.isTimestampType());
            this.unit = unit;
            return this;
        }

        public Builder enableStrictDecimalType(boolean strictDecimalType) {
            this.strictDecimalType = strictDecimalType;
            return this;
        }

        public ParquetOptions build() {
            return new ParquetOptions(this);
        }
    }
}

