/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.CompressionType;
import ai.rapids.cudf.ParquetColumnWriterOptions;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ParquetWriterOptions
extends ParquetColumnWriterOptions.ParquetStructColumnWriterOptions {
    private final CompressionType compressionType;
    private final Map<String, String> metadata;
    private final StatisticsFrequency statsGranularity;

    private ParquetWriterOptions(Builder builder) {
        super(builder);
        this.statsGranularity = builder.statsGranularity;
        this.compressionType = builder.compressionType;
        this.metadata = builder.metadata;
    }

    @Override
    boolean[] getFlatIsTimeTypeInt96() {
        return super.getFlatBooleans(new boolean[0], opt -> opt.getFlatIsTimeTypeInt96());
    }

    @Override
    int[] getFlatPrecision() {
        return super.getFlatInts(new int[0], opt -> opt.getFlatPrecision());
    }

    @Override
    int[] getFlatNumChildren() {
        return super.getFlatInts(new int[0], opt -> opt.getFlatNumChildren());
    }

    @Override
    boolean[] getFlatIsNullable() {
        return super.getFlatBooleans(new boolean[0], opt -> opt.getFlatIsNullable());
    }

    @Override
    String[] getFlatColumnNames() {
        return super.getFlatColumnNames(new String[0]);
    }

    String[] getMetadataKeys() {
        return this.metadata.keySet().toArray(new String[this.metadata.size()]);
    }

    String[] getMetadataValues() {
        return this.metadata.values().toArray(new String[this.metadata.size()]);
    }

    public static Builder builder() {
        return new Builder();
    }

    public StatisticsFrequency getStatisticsFrequency() {
        return this.statsGranularity;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public int getTopLevelChildren() {
        return this.childColumnOptions.length;
    }

    public static class Builder
    extends ParquetColumnWriterOptions.AbstractStructBuilder<Builder, ParquetWriterOptions> {
        private StatisticsFrequency statsGranularity = StatisticsFrequency.ROWGROUP;
        final Map<String, String> metadata = new LinkedHashMap<String, String>();
        CompressionType compressionType = CompressionType.AUTO;

        public Builder withMetadata(String key, String value) {
            this.metadata.put(key, value);
            return this;
        }

        public Builder withMetadata(Map<String, String> metadata) {
            this.metadata.putAll(metadata);
            return this;
        }

        public Builder withCompressionType(CompressionType compression) {
            this.compressionType = compression;
            return this;
        }

        public Builder withStatisticsFrequency(StatisticsFrequency statsGranularity) {
            this.statsGranularity = statsGranularity;
            return this;
        }

        @Override
        public ParquetWriterOptions build() {
            return new ParquetWriterOptions(this);
        }
    }

    public static enum StatisticsFrequency {
        NONE(0),
        ROWGROUP(1),
        PAGE(2);

        final int nativeId;

        private StatisticsFrequency(int nativeId) {
            this.nativeId = nativeId;
        }
    }
}

