/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.Cuda;
import ai.rapids.cudf.DeviceMemoryBuffer;
import ai.rapids.cudf.MemoryCleaner;
import ai.rapids.cudf.NativeDepsLoader;
import ai.rapids.cudf.RmmEventHandler;
import ai.rapids.cudf.RmmException;
import java.io.File;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class Rmm {
    private static volatile boolean initialized = false;

    public static LogConf logTo(File location) {
        return new LogConf(location, LogLoc.FILE);
    }

    public static LogConf logToStdout() {
        return new LogConf(null, LogLoc.STDOUT);
    }

    public static LogConf logToStderr() {
        return new LogConf(null, LogLoc.STDERR);
    }

    public static void initialize(int allocationMode, boolean enableLogging, long poolSize) throws RmmException {
        Rmm.initialize(allocationMode, enableLogging, poolSize, 0L);
    }

    public static void initialize(int allocationMode, boolean enableLogging, long poolSize, long maxPoolSize) throws RmmException {
        LogConf lc = null;
        if (enableLogging) {
            String f = System.getenv("RMM_LOG_FILE");
            lc = f != null ? Rmm.logTo(new File(f)) : Rmm.logToStderr();
        }
        Rmm.initialize(allocationMode, lc, poolSize, maxPoolSize);
    }

    public static synchronized void initialize(int allocationMode, LogConf logConf, long poolSize) throws RmmException {
        Rmm.initialize(allocationMode, logConf, poolSize, 0L);
    }

    public static synchronized void initialize(int allocationMode, LogConf logConf, long poolSize, long maxPoolSize) throws RmmException {
        Rmm.initialize(allocationMode, logConf, poolSize, maxPoolSize, 0L, 0L);
    }

    public static synchronized void initialize(int allocationMode, LogConf logConf, long poolSize, long maxPoolSize, long allocationAlignment, long alignmentThreshold) throws RmmException {
        if (initialized) {
            throw new IllegalStateException("RMM is already initialized");
        }
        if (maxPoolSize > 0L) {
            if (allocationMode != 1 && allocationMode != 4) {
                throw new IllegalArgumentException("Pool limit only supported in POOL or ARENA allocation mode");
            }
            if (maxPoolSize < poolSize) {
                throw new IllegalArgumentException("Pool limit of " + maxPoolSize + " is less than initial pool size of " + poolSize);
            }
        }
        LogLoc loc = LogLoc.NONE;
        String path = null;
        if (logConf != null) {
            if (logConf.file != null) {
                path = logConf.file.getAbsolutePath();
            }
            loc = logConf.loc;
        }
        Rmm.initializeInternal(allocationMode, loc.internalId, path, poolSize, maxPoolSize, allocationAlignment, alignmentThreshold);
        MemoryCleaner.setDefaultGpu(Cuda.getDevice());
        initialized = true;
    }

    public static boolean isInitialized() throws RmmException {
        return initialized;
    }

    public static native long getTotalBytesAllocated();

    public static void setEventHandler(RmmEventHandler handler) throws RmmException {
        long[] allocThresholds = handler != null ? Rmm.sortThresholds(handler.getAllocThresholds()) : null;
        long[] deallocThresholds = handler != null ? Rmm.sortThresholds(handler.getDeallocThresholds()) : null;
        Rmm.setEventHandlerInternal(handler, allocThresholds, deallocThresholds);
    }

    public static void clearEventHandler() throws RmmException {
        Rmm.setEventHandlerInternal(null, null, null);
    }

    private static long[] sortThresholds(long[] thresholds) {
        if (thresholds == null) {
            return null;
        }
        long[] result = Arrays.copyOf(thresholds, thresholds.length);
        Arrays.sort(result);
        return result;
    }

    private static native void initializeInternal(int var0, int var1, String var2, long var3, long var5, long var7, long var9) throws RmmException;

    public static void shutdown() throws RmmException {
        Rmm.shutdown(2L, 4L, TimeUnit.SECONDS);
    }

    public static synchronized void shutdown(long forceGCInterval, long maxWaitTime, TimeUnit units) throws RmmException {
        long now = System.currentTimeMillis();
        long endTime = now + units.toMillis(maxWaitTime);
        long nextGcTime = now;
        try {
            if (MemoryCleaner.bestEffortHasRmmBlockers()) {
                do {
                    if (nextGcTime <= now) {
                        System.gc();
                        nextGcTime += units.toMillis(forceGCInterval);
                    }
                    Thread.sleep(10L);
                } while (endTime > (now = System.currentTimeMillis()) && MemoryCleaner.bestEffortHasRmmBlockers());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (MemoryCleaner.bestEffortHasRmmBlockers()) {
            throw new RmmException("Could not shut down RMM there appear to be outstanding allocations");
        }
        if (initialized) {
            Rmm.shutdownInternal();
            initialized = false;
        }
    }

    private static native void shutdownInternal() throws RmmException;

    public static DeviceMemoryBuffer alloc(long size) {
        return Rmm.alloc(size, null);
    }

    public static DeviceMemoryBuffer alloc(long size, Cuda.Stream stream) {
        long s = stream == null ? 0L : stream.getStream();
        return new DeviceMemoryBuffer(Rmm.allocInternal(size, s), size, stream);
    }

    private static native long allocInternal(long var0, long var2) throws RmmException;

    static native void free(long var0, long var2, long var4) throws RmmException;

    static native void freeDeviceBuffer(long var0) throws RmmException;

    static native void setEventHandlerInternal(RmmEventHandler var0, long[] var1, long[] var2) throws RmmException;

    static {
        NativeDepsLoader.loadNativeDeps();
    }

    public static class LogConf {
        private final File file;
        private final LogLoc loc;

        private LogConf(File file, LogLoc loc) {
            this.file = file;
            this.loc = loc;
        }
    }

    private static enum LogLoc {
        NONE(0),
        FILE(1),
        STDOUT(2),
        STDERR(3);

        final int internalId;

        private LogLoc(int internalId) {
            this.internalId = internalId;
        }
    }
}

