/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.BinaryOp;
import ai.rapids.cudf.BinaryOperable;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.ColumnView;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.HostColumnVector;
import ai.rapids.cudf.MemoryCleaner;
import ai.rapids.cudf.NativeDepsLoader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Scalar
implements AutoCloseable,
BinaryOperable {
    private static final Logger LOG;
    private final DType type;
    private int refCount;
    private final OffHeapState offHeap;

    public static Scalar fromNull(DType type) {
        switch (type.typeId) {
            case EMPTY: 
            case BOOL8: {
                return new Scalar(type, Scalar.makeBool8Scalar(false, false));
            }
            case INT8: {
                return new Scalar(type, Scalar.makeInt8Scalar((byte)0, false));
            }
            case UINT8: {
                return new Scalar(type, Scalar.makeUint8Scalar((byte)0, false));
            }
            case INT16: {
                return new Scalar(type, Scalar.makeInt16Scalar((short)0, false));
            }
            case UINT16: {
                return new Scalar(type, Scalar.makeUint16Scalar((short)0, false));
            }
            case INT32: {
                return new Scalar(type, Scalar.makeInt32Scalar(0, false));
            }
            case UINT32: {
                return new Scalar(type, Scalar.makeUint32Scalar(0, false));
            }
            case TIMESTAMP_DAYS: {
                return new Scalar(type, Scalar.makeTimestampDaysScalar(0, false));
            }
            case FLOAT32: {
                return new Scalar(type, Scalar.makeFloat32Scalar(0.0f, false));
            }
            case FLOAT64: {
                return new Scalar(type, Scalar.makeFloat64Scalar(0.0, false));
            }
            case INT64: {
                return new Scalar(type, Scalar.makeInt64Scalar(0L, false));
            }
            case UINT64: {
                return new Scalar(type, Scalar.makeUint64Scalar(0L, false));
            }
            case TIMESTAMP_SECONDS: 
            case TIMESTAMP_MILLISECONDS: 
            case TIMESTAMP_MICROSECONDS: 
            case TIMESTAMP_NANOSECONDS: {
                return new Scalar(type, Scalar.makeTimestampTimeScalar(type.typeId.getNativeId(), 0L, false));
            }
            case STRING: {
                return new Scalar(type, Scalar.makeStringScalar(null, false));
            }
            case DURATION_DAYS: {
                return new Scalar(type, Scalar.makeDurationDaysScalar(0, false));
            }
            case DURATION_MICROSECONDS: 
            case DURATION_MILLISECONDS: 
            case DURATION_NANOSECONDS: 
            case DURATION_SECONDS: {
                return new Scalar(type, Scalar.makeDurationTimeScalar(type.typeId.getNativeId(), 0L, false));
            }
            case DECIMAL32: {
                return new Scalar(type, Scalar.makeDecimal32Scalar(0, type.getScale(), false));
            }
            case DECIMAL64: {
                return new Scalar(type, Scalar.makeDecimal64Scalar(0L, type.getScale(), false));
            }
            case LIST: {
                throw new IllegalArgumentException("Please call 'listFromNull' to create a null list scalar.");
            }
        }
        throw new IllegalArgumentException("Unexpected type: " + type);
    }

    public static Scalar fromBool(boolean value) {
        return new Scalar(DType.BOOL8, Scalar.makeBool8Scalar(value, true));
    }

    public static Scalar fromBool(Boolean value) {
        if (value == null) {
            return Scalar.fromNull(DType.BOOL8);
        }
        return Scalar.fromBool((boolean)value);
    }

    public static Scalar fromByte(byte value) {
        return new Scalar(DType.INT8, Scalar.makeInt8Scalar(value, true));
    }

    public static Scalar fromByte(Byte value) {
        if (value == null) {
            return Scalar.fromNull(DType.INT8);
        }
        return Scalar.fromByte((byte)value);
    }

    public static Scalar fromUnsignedByte(byte value) {
        return new Scalar(DType.UINT8, Scalar.makeUint8Scalar(value, true));
    }

    public static Scalar fromUnsignedByte(Byte value) {
        if (value == null) {
            return Scalar.fromNull(DType.UINT8);
        }
        return Scalar.fromUnsignedByte((byte)value);
    }

    public static Scalar fromShort(short value) {
        return new Scalar(DType.INT16, Scalar.makeInt16Scalar(value, true));
    }

    public static Scalar fromShort(Short value) {
        if (value == null) {
            return Scalar.fromNull(DType.INT16);
        }
        return Scalar.fromShort((short)value);
    }

    public static Scalar fromUnsignedShort(short value) {
        return new Scalar(DType.UINT16, Scalar.makeUint16Scalar(value, true));
    }

    public static Scalar fromUnsignedShort(Short value) {
        if (value == null) {
            return Scalar.fromNull(DType.UINT16);
        }
        return Scalar.fromUnsignedShort((short)value);
    }

    public static Scalar durationDaysFromInt(int value) {
        return new Scalar(DType.DURATION_DAYS, Scalar.makeDurationDaysScalar(value, true));
    }

    public static Scalar durationDaysFromInt(Integer value) {
        if (value == null) {
            return Scalar.fromNull(DType.DURATION_DAYS);
        }
        return Scalar.durationDaysFromInt((int)value);
    }

    public static Scalar fromInt(int value) {
        return new Scalar(DType.INT32, Scalar.makeInt32Scalar(value, true));
    }

    public static Scalar fromInt(Integer value) {
        if (value == null) {
            return Scalar.fromNull(DType.INT32);
        }
        return Scalar.fromInt((int)value);
    }

    public static Scalar fromUnsignedInt(int value) {
        return new Scalar(DType.UINT32, Scalar.makeUint32Scalar(value, true));
    }

    public static Scalar fromUnsignedInt(Integer value) {
        if (value == null) {
            return Scalar.fromNull(DType.UINT32);
        }
        return Scalar.fromUnsignedInt((int)value);
    }

    public static Scalar fromLong(long value) {
        return new Scalar(DType.INT64, Scalar.makeInt64Scalar(value, true));
    }

    public static Scalar fromLong(Long value) {
        if (value == null) {
            return Scalar.fromNull(DType.INT64);
        }
        return Scalar.fromLong((long)value);
    }

    public static Scalar fromUnsignedLong(long value) {
        return new Scalar(DType.UINT64, Scalar.makeUint64Scalar(value, true));
    }

    public static Scalar fromUnsignedLong(Long value) {
        if (value == null) {
            return Scalar.fromNull(DType.UINT64);
        }
        return Scalar.fromUnsignedLong((long)value);
    }

    public static Scalar fromFloat(float value) {
        return new Scalar(DType.FLOAT32, Scalar.makeFloat32Scalar(value, true));
    }

    public static Scalar fromDecimal(int scale, int unscaledValue) {
        long handle = Scalar.makeDecimal32Scalar(unscaledValue, scale, true);
        return new Scalar(DType.create(DType.DTypeEnum.DECIMAL32, scale), handle);
    }

    public static Scalar fromDecimal(int scale, long unscaledValue) {
        long handle = Scalar.makeDecimal64Scalar(unscaledValue, scale, true);
        return new Scalar(DType.create(DType.DTypeEnum.DECIMAL64, scale), handle);
    }

    public static Scalar fromFloat(Float value) {
        if (value == null) {
            return Scalar.fromNull(DType.FLOAT32);
        }
        return Scalar.fromFloat(value.floatValue());
    }

    public static Scalar fromDouble(double value) {
        return new Scalar(DType.FLOAT64, Scalar.makeFloat64Scalar(value, true));
    }

    public static Scalar fromDouble(Double value) {
        if (value == null) {
            return Scalar.fromNull(DType.FLOAT64);
        }
        return Scalar.fromDouble((double)value);
    }

    public static Scalar fromDecimal(BigDecimal value) {
        if (value == null) {
            return Scalar.fromNull(DType.create(DType.DTypeEnum.DECIMAL64, 0));
        }
        DType dt = DType.fromJavaBigDecimal(value);
        long handle = dt.typeId == DType.DTypeEnum.DECIMAL32 ? Scalar.makeDecimal32Scalar(value.unscaledValue().intValueExact(), -value.scale(), true) : Scalar.makeDecimal64Scalar(value.unscaledValue().longValueExact(), -value.scale(), true);
        return new Scalar(dt, handle);
    }

    public static Scalar timestampDaysFromInt(int value) {
        return new Scalar(DType.TIMESTAMP_DAYS, Scalar.makeTimestampDaysScalar(value, true));
    }

    public static Scalar timestampDaysFromInt(Integer value) {
        if (value == null) {
            return Scalar.fromNull(DType.TIMESTAMP_DAYS);
        }
        return Scalar.timestampDaysFromInt((int)value);
    }

    public static Scalar durationFromLong(DType type, long value) {
        if (type.isDurationType()) {
            if (type.equals(DType.DURATION_DAYS)) {
                int intValue = (int)value;
                if (value != (long)intValue) {
                    throw new IllegalArgumentException("value too large for type " + type + ": " + value);
                }
                return Scalar.durationDaysFromInt(intValue);
            }
            return new Scalar(type, Scalar.makeDurationTimeScalar(type.typeId.getNativeId(), value, true));
        }
        throw new IllegalArgumentException("type is not a timestamp: " + type);
    }

    public static Scalar durationFromLong(DType type, Long value) {
        if (value == null) {
            return Scalar.fromNull(type);
        }
        return Scalar.durationFromLong(type, (long)value);
    }

    public static Scalar timestampFromLong(DType type, long value) {
        if (type.isTimestampType()) {
            if (type.equals(DType.TIMESTAMP_DAYS)) {
                int intValue = (int)value;
                if (value != (long)intValue) {
                    throw new IllegalArgumentException("value too large for type " + type + ": " + value);
                }
                return Scalar.timestampDaysFromInt(intValue);
            }
            return new Scalar(type, Scalar.makeTimestampTimeScalar(type.typeId.getNativeId(), value, true));
        }
        throw new IllegalArgumentException("type is not a timestamp: " + type);
    }

    public static Scalar timestampFromLong(DType type, Long value) {
        if (value == null) {
            return Scalar.fromNull(type);
        }
        return Scalar.timestampFromLong(type, (long)value);
    }

    public static Scalar fromString(String value) {
        return Scalar.fromUTF8String(value == null ? null : value.getBytes(StandardCharsets.UTF_8));
    }

    public static Scalar fromUTF8String(byte[] value) {
        if (value == null) {
            return Scalar.fromNull(DType.STRING);
        }
        return new Scalar(DType.STRING, Scalar.makeStringScalar(value, true));
    }

    public static Scalar listFromNull(HostColumnVector.DataType elementType) {
        try (ColumnVector col = ColumnVector.empty(elementType);){
            Scalar scalar = new Scalar(DType.LIST, Scalar.makeListScalar(col.getNativeView(), false));
            return scalar;
        }
    }

    public static Scalar listFromColumnView(ColumnView list) {
        if (list == null) {
            throw new IllegalArgumentException("'list' should NOT be null. Please call 'listFromNull' to create a null list scalar.");
        }
        return new Scalar(DType.LIST, Scalar.makeListScalar(list.getNativeView(), true));
    }

    public static Scalar structFromNull(HostColumnVector.DataType ... elementTypes) {
        ColumnVector[] children = new ColumnVector[elementTypes.length];
        long[] childHandles = new long[elementTypes.length];
        RuntimeException error = null;
        try {
            for (int i = 0; i < elementTypes.length; ++i) {
                children[i] = Scalar.buildNullColumnVector(elementTypes[i]);
                childHandles[i] = children[i].getNativeView();
            }
            Scalar i = new Scalar(DType.STRUCT, Scalar.makeStructScalar(childHandles, false));
            return i;
        }
        catch (RuntimeException ex) {
            error = ex;
            throw ex;
        }
        catch (Exception ex) {
            error = new RuntimeException(ex);
            throw ex;
        }
        finally {
            for (ColumnVector child : children) {
                if (child == null) break;
                try {
                    child.close();
                }
                catch (Exception ex) {
                    if (error == null) {
                        error = new RuntimeException(ex);
                        continue;
                    }
                    error.addSuppressed(ex);
                }
            }
            if (error != null) {
                throw error;
            }
        }
    }

    public static Scalar structFromColumnViews(ColumnView ... columns) {
        if (columns == null) {
            throw new IllegalArgumentException("input columns should NOT be null");
        }
        long[] columnHandles = new long[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            columnHandles[i] = columns[i].getNativeView();
        }
        return new Scalar(DType.STRUCT, Scalar.makeStructScalar(columnHandles, true));
    }

    /*
     * Exception decompiling
     */
    private static ColumnVector buildNullColumnVector(HostColumnVector.DataType hostType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static native void closeScalar(long var0);

    private static native boolean isScalarValid(long var0);

    private static native byte getByte(long var0);

    private static native short getShort(long var0);

    private static native int getInt(long var0);

    private static native long getLong(long var0);

    private static native float getFloat(long var0);

    private static native double getDouble(long var0);

    private static native byte[] getUTF8(long var0);

    private static native long getListAsColumnView(long var0);

    private static native long[] getChildrenFromStructScalar(long var0);

    private static native long makeBool8Scalar(boolean var0, boolean var1);

    private static native long makeInt8Scalar(byte var0, boolean var1);

    private static native long makeUint8Scalar(byte var0, boolean var1);

    private static native long makeInt16Scalar(short var0, boolean var1);

    private static native long makeUint16Scalar(short var0, boolean var1);

    private static native long makeInt32Scalar(int var0, boolean var1);

    private static native long makeUint32Scalar(int var0, boolean var1);

    private static native long makeInt64Scalar(long var0, boolean var2);

    private static native long makeUint64Scalar(long var0, boolean var2);

    private static native long makeFloat32Scalar(float var0, boolean var1);

    private static native long makeFloat64Scalar(double var0, boolean var2);

    private static native long makeStringScalar(byte[] var0, boolean var1);

    private static native long makeDurationDaysScalar(int var0, boolean var1);

    private static native long makeDurationTimeScalar(int var0, long var1, boolean var3);

    private static native long makeTimestampDaysScalar(int var0, boolean var1);

    private static native long makeTimestampTimeScalar(int var0, long var1, boolean var3);

    private static native long makeDecimal32Scalar(int var0, int var1, boolean var2);

    private static native long makeDecimal64Scalar(long var0, int var2, boolean var3);

    private static native long makeListScalar(long var0, boolean var2);

    private static native long makeStructScalar(long[] var0, boolean var1);

    Scalar(DType type, long scalarHandle) {
        this.type = type;
        this.offHeap = new OffHeapState(scalarHandle);
        this.incRefCount();
    }

    public synchronized Scalar incRefCount() {
        if (this.offHeap.scalarHandle == 0L) {
            this.offHeap.logRefCountDebug("INC AFTER CLOSE " + this);
            throw new IllegalStateException("Scalar is already closed");
        }
        ++this.refCount;
        return this;
    }

    long getScalarHandle() {
        return this.offHeap.scalarHandle;
    }

    @Override
    public synchronized void close() {
        --this.refCount;
        this.offHeap.delRef();
        if (this.refCount == 0) {
            this.offHeap.clean(false);
        } else if (this.refCount < 0) {
            this.offHeap.logRefCountDebug("double free " + this);
            throw new IllegalStateException("Close called too many times " + this);
        }
    }

    @Override
    public DType getType() {
        return this.type;
    }

    public boolean isValid() {
        return Scalar.isScalarValid(this.getScalarHandle());
    }

    public boolean getBoolean() {
        return Scalar.getByte(this.getScalarHandle()) != 0;
    }

    public byte getByte() {
        return Scalar.getByte(this.getScalarHandle());
    }

    public short getShort() {
        return Scalar.getShort(this.getScalarHandle());
    }

    public int getInt() {
        return Scalar.getInt(this.getScalarHandle());
    }

    public long getLong() {
        return Scalar.getLong(this.getScalarHandle());
    }

    public float getFloat() {
        return Scalar.getFloat(this.getScalarHandle());
    }

    public double getDouble() {
        return Scalar.getDouble(this.getScalarHandle());
    }

    public BigDecimal getBigDecimal() {
        if (this.type.typeId == DType.DTypeEnum.DECIMAL32) {
            return BigDecimal.valueOf(this.getInt(), -this.type.getScale());
        }
        if (this.type.typeId == DType.DTypeEnum.DECIMAL64) {
            return BigDecimal.valueOf(this.getLong(), -this.type.getScale());
        }
        throw new IllegalArgumentException("Couldn't getBigDecimal from nonDecimal scalar");
    }

    public String getJavaString() {
        return new String(Scalar.getUTF8(this.getScalarHandle()), StandardCharsets.UTF_8);
    }

    public byte[] getUTF8() {
        return Scalar.getUTF8(this.getScalarHandle());
    }

    public ColumnView getListAsColumnView() {
        assert (DType.LIST.equals(this.type)) : "Cannot get list for the vector of type " + this.type;
        return new ColumnView(Scalar.getListAsColumnView(this.getScalarHandle()));
    }

    public ColumnView[] getChildrenFromStructScalar() {
        assert (DType.STRUCT.equals(this.type)) : "Cannot get table for the vector of type " + this.type;
        long[] childHandles = Scalar.getChildrenFromStructScalar(this.getScalarHandle());
        ColumnView[] children = new ColumnView[childHandles.length];
        try {
            for (int i = 0; i < children.length; ++i) {
                children[i] = new ColumnView(childHandles[i]);
            }
        }
        catch (Exception ex) {
            for (ColumnView child : children) {
                if (child == null) break;
                try {
                    child.close();
                }
                catch (Exception suppressed) {
                    ex.addSuppressed(suppressed);
                }
            }
            throw ex;
        }
        return children;
    }

    @Override
    public ColumnVector binaryOp(BinaryOp op, BinaryOperable rhs, DType outType) {
        if (rhs instanceof ColumnView) {
            ColumnView cvRhs = (ColumnView)rhs;
            return new ColumnVector(Scalar.binaryOp(this, cvRhs, op, outType));
        }
        throw new IllegalArgumentException(rhs.getClass() + " is not supported as a binary op with Scalar");
    }

    static long binaryOp(Scalar lhs, ColumnView rhs, BinaryOp op, DType outputType) {
        return Scalar.binaryOpSV(lhs.getScalarHandle(), rhs.getNativeView(), op.nativeId, outputType.typeId.getNativeId(), outputType.getScale());
    }

    private static native long binaryOpSV(long var0, long var2, int var4, int var5, int var6);

    /*
     * Exception decompiling
     */
    public boolean equals(Object o) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    public int hashCode() {
        block23: {
            valueHash = 0;
            if (!this.isValid()) break block23;
            switch (1.$SwitchMap$ai$rapids$cudf$DType$DTypeEnum[this.type.typeId.ordinal()]) {
                case 1: {
                    valueHash = 0;
                    break;
                }
                case 2: {
                    valueHash = this.getBoolean() != false ? 1 : 0;
                    break;
                }
                case 3: 
                case 4: {
                    valueHash = this.getByte();
                    break;
                }
                case 5: 
                case 6: {
                    valueHash = this.getShort();
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 19: 
                case 24: {
                    valueHash = this.getInt();
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 25: {
                    valueHash = Long.hashCode(this.getLong());
                    break;
                }
                case 10: {
                    valueHash = Float.hashCode(this.getFloat());
                    break;
                }
                case 11: {
                    valueHash = Double.hashCode(this.getDouble());
                    break;
                }
                case 18: {
                    valueHash = Arrays.hashCode(this.getUTF8());
                    break;
                }
                case 26: {
                    v = this.getListAsColumnView();
                    var3_3 = null;
                    valueHash = v.hashCode();
                    if (v == null) break;
                    if (var3_3 == null) ** GOTO lbl44
                    try {
                        v.close();
                    }
                    catch (Throwable var4_4) {
                        var3_3.addSuppressed(var4_4);
                    }
                    break;
lbl44:
                    // 1 sources

                    v.close();
                    break;
                    catch (Throwable var4_5) {
                        try {
                            var3_3 = var4_5;
                            throw var4_5;
                        }
                        catch (Throwable var5_6) {
                            if (v != null) {
                                if (var3_3 != null) {
                                    try {
                                        v.close();
                                    }
                                    catch (Throwable var6_7) {
                                        var3_3.addSuppressed(var6_7);
                                    }
                                } else {
                                    v.close();
                                }
                            }
                            throw var5_6;
                        }
                    }
                }
                default: {
                    throw new IllegalStateException("Unknown scalar type: " + this.type);
                }
            }
        }
        return Objects.hash(new Object[]{this.type, valueHash});
    }

    /*
     * Unable to fully structure code
     */
    public String toString() {
        block27: {
            sb = new StringBuilder("Scalar{type=");
            sb.append(this.type);
            if (this.getScalarHandle() == 0L) break block27;
            sb.append(" value=");
            switch (1.$SwitchMap$ai$rapids$cudf$DType$DTypeEnum[this.type.typeId.ordinal()]) {
                case 2: {
                    sb.append(this.getBoolean());
                    break;
                }
                case 3: {
                    sb.append(this.getByte());
                    break;
                }
                case 4: {
                    sb.append(Byte.toUnsignedInt(this.getByte()));
                    break;
                }
                case 5: {
                    sb.append(this.getShort());
                    break;
                }
                case 6: {
                    sb.append(Short.toUnsignedInt(this.getShort()));
                    break;
                }
                case 7: 
                case 9: {
                    sb.append(this.getInt());
                    break;
                }
                case 8: {
                    sb.append(Integer.toUnsignedLong(this.getInt()));
                    break;
                }
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    sb.append(this.getLong());
                    break;
                }
                case 13: {
                    sb.append(Long.toUnsignedString(this.getLong()));
                    break;
                }
                case 10: {
                    sb.append(this.getFloat());
                    break;
                }
                case 11: {
                    sb.append(this.getDouble());
                    break;
                }
                case 18: {
                    sb.append('\"');
                    sb.append(this.getJavaString());
                    sb.append('\"');
                    break;
                }
                case 24: 
                case 25: {
                    sb.append(this.getBigDecimal());
                    break;
                }
                case 26: {
                    v = this.getListAsColumnView();
                    var3_3 = null;
                    sb.append(v.toString());
                    if (v == null) break;
                    if (var3_3 == null) ** GOTO lbl78
                    try {
                        v.close();
                    }
                    catch (Throwable var4_4) {
                        var3_3.addSuppressed(var4_4);
                    }
                    break;
lbl78:
                    // 1 sources

                    v.close();
                    break;
                    catch (Throwable var4_5) {
                        try {
                            var3_3 = var4_5;
                            throw var4_5;
                        }
                        catch (Throwable var5_6) {
                            if (v != null) {
                                if (var3_3 != null) {
                                    try {
                                        v.close();
                                    }
                                    catch (Throwable var6_7) {
                                        var3_3.addSuppressed(var6_7);
                                    }
                                } else {
                                    v.close();
                                }
                            }
                            throw var5_6;
                        }
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unknown scalar type: " + this.type);
                }
            }
        }
        sb.append("} (ID: ");
        sb.append(this.offHeap.id);
        sb.append(" ");
        sb.append(Long.toHexString(OffHeapState.access$000(this.offHeap)));
        sb.append(")");
        return sb.toString();
    }

    static {
        NativeDepsLoader.loadNativeDeps();
        LOG = LoggerFactory.getLogger(Scalar.class);
    }

    private static class OffHeapState
    extends MemoryCleaner.Cleaner {
        private long scalarHandle;

        OffHeapState(long scalarHandle) {
            this.scalarHandle = scalarHandle;
        }

        @Override
        protected synchronized boolean cleanImpl(boolean logErrorIfNotClean) {
            if (this.scalarHandle != 0L) {
                if (logErrorIfNotClean) {
                    LOG.error("A SCALAR WAS LEAKED(ID: " + this.id + " " + Long.toHexString(this.scalarHandle) + ")");
                    this.logRefCountDebug("Leaked scalar");
                }
                try {
                    Scalar.closeScalar(this.scalarHandle);
                }
                finally {
                    this.scalarHandle = 0L;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean isClean() {
            return this.scalarHandle == 0L;
        }
    }
}

