/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.DType;
import java.util.ArrayList;
import java.util.List;

public class Schema {
    public static final Schema INFERRED = new Schema();
    private final List<String> names;
    private final List<String> typeNames;

    private Schema(List<String> names, List<String> typeNames) {
        this.names = new ArrayList<String>(names);
        this.typeNames = new ArrayList<String>(typeNames);
    }

    private Schema() {
        this.names = null;
        this.typeNames = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String[] getColumnNames() {
        if (this.names == null) {
            return null;
        }
        return this.names.toArray(new String[this.names.size()]);
    }

    String[] getTypesAsStrings() {
        if (this.typeNames == null) {
            return null;
        }
        return this.typeNames.toArray(new String[this.typeNames.size()]);
    }

    public static class Builder {
        private final List<String> names = new ArrayList<String>();
        private final List<String> typeNames = new ArrayList<String>();

        public Builder column(DType type, String name) {
            this.typeNames.add(type.getSimpleName());
            this.names.add(name);
            return this;
        }

        public Schema build() {
            return new Schema(this.names, this.typeNames);
        }
    }
}

