/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.Aggregation;
import ai.rapids.cudf.AggregationOnColumn;
import ai.rapids.cudf.AggregationOverWindow;
import ai.rapids.cudf.ArrowIPCOptions;
import ai.rapids.cudf.ArrowIPCWriterOptions;
import ai.rapids.cudf.CSVOptions;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.ColumnView;
import ai.rapids.cudf.ContiguousTable;
import ai.rapids.cudf.CudfException;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.DeviceMemoryBuffer;
import ai.rapids.cudf.GatherMap;
import ai.rapids.cudf.GroupByOptions;
import ai.rapids.cudf.HashType;
import ai.rapids.cudf.HostBufferConsumer;
import ai.rapids.cudf.HostBufferProvider;
import ai.rapids.cudf.HostColumnVector;
import ai.rapids.cudf.HostMemoryBuffer;
import ai.rapids.cudf.NativeDepsLoader;
import ai.rapids.cudf.ORCOptions;
import ai.rapids.cudf.ORCWriterOptions;
import ai.rapids.cudf.OrderByArg;
import ai.rapids.cudf.ParquetOptions;
import ai.rapids.cudf.ParquetWriterOptions;
import ai.rapids.cudf.PartitionedTable;
import ai.rapids.cudf.Scalar;
import ai.rapids.cudf.Schema;
import ai.rapids.cudf.StreamedTableReader;
import ai.rapids.cudf.TableWriter;
import ai.rapids.cudf.WindowOptions;
import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class Table
implements AutoCloseable {
    private final long rows;
    private long nativeHandle;
    private ColumnVector[] columns;

    public Table(ColumnVector ... columns) {
        assert (columns != null && columns.length > 0) : "ColumnVectors can't be null or empty";
        this.rows = columns[0].getRowCount();
        for (ColumnVector columnVector : columns) {
            assert (null != columnVector) : "ColumnVectors can't be null";
            assert (this.rows == columnVector.getRowCount()) : "All columns should have the same number of rows " + columnVector.getType();
        }
        this.columns = new ColumnVector[columns.length];
        long[] viewPointers = new long[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            this.columns[i] = columns[i];
            columns[i].incRefCount();
            viewPointers[i] = columns[i].getNativeView();
        }
        this.nativeHandle = Table.createCudfTableView(viewPointers);
    }

    public Table(long[] cudfColumns) {
        assert (cudfColumns != null && cudfColumns.length > 0) : "CudfColumns can't be null or empty";
        this.columns = new ColumnVector[cudfColumns.length];
        try {
            for (int i = 0; i < cudfColumns.length; ++i) {
                this.columns[i] = new ColumnVector(cudfColumns[i]);
            }
            long[] views = new long[this.columns.length];
            for (int i = 0; i < this.columns.length; ++i) {
                views[i] = this.columns[i].getNativeView();
            }
            this.nativeHandle = Table.createCudfTableView(views);
            this.rows = this.columns[0].getRowCount();
        }
        catch (Throwable t) {
            for (int i = 0; i < cudfColumns.length; ++i) {
                if (this.columns[i] != null) {
                    this.columns[i].close();
                    continue;
                }
                ColumnVector.deleteCudfColumn(cudfColumns[i]);
            }
            throw t;
        }
    }

    ColumnVector[] getColumns() {
        return this.columns;
    }

    long getNativeView() {
        return this.nativeHandle;
    }

    public ColumnVector getColumn(int index) {
        assert (index < this.columns.length);
        return this.columns[index];
    }

    public final long getRowCount() {
        return this.rows;
    }

    public final int getNumberOfColumns() {
        return this.columns.length;
    }

    @Override
    public void close() {
        if (this.nativeHandle != 0L) {
            Table.deleteCudfTable(this.nativeHandle);
            this.nativeHandle = 0L;
        }
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                this.columns[i].close();
                this.columns[i] = null;
            }
            this.columns = null;
        }
    }

    public String toString() {
        return "Table{columns=" + Arrays.toString(this.columns) + ", cudfTable=" + this.nativeHandle + ", rows=" + this.rows + '}';
    }

    public long getDeviceMemorySize() {
        long total = 0L;
        for (ColumnVector cv : this.columns) {
            total += cv.getDeviceMemorySize();
        }
        return total;
    }

    private static native ContiguousTable[] contiguousSplit(long var0, int[] var2);

    private static native long[] partition(long var0, long var2, int var4, int[] var5);

    private static native long[] hashPartition(long var0, int[] var2, int var3, int var4, int[] var5) throws CudfException;

    private static native long[] roundRobinPartition(long var0, int var2, int var3, int[] var4) throws CudfException;

    private static native void deleteCudfTable(long var0) throws CudfException;

    private static native long bound(long var0, long var2, boolean[] var4, boolean[] var5, boolean var6) throws CudfException;

    private static native long[] readCSV(String[] var0, String[] var1, String[] var2, String var3, long var4, long var6, int var8, byte var9, byte var10, byte var11, String[] var12, String[] var13, String[] var14) throws CudfException;

    private static native long[] readParquet(String[] var0, String var1, long var2, long var4, int var6, boolean var7) throws CudfException;

    private static native long writeParquetFileBegin(String[] var0, int var1, int[] var2, boolean[] var3, String[] var4, String[] var5, int var6, int var7, boolean[] var8, int[] var9, String var10) throws CudfException;

    private static native long writeParquetBufferBegin(String[] var0, int var1, int[] var2, boolean[] var3, String[] var4, String[] var5, int var6, int var7, boolean[] var8, int[] var9, HostBufferConsumer var10) throws CudfException;

    private static native void writeParquetChunk(long var0, long var2, long var4);

    private static native void writeParquetEnd(long var0);

    private static native long[] readORC(String[] var0, String var1, long var2, long var4, boolean var6, int var7) throws CudfException;

    private static native long writeORCFileBegin(String[] var0, boolean[] var1, String[] var2, String[] var3, int var4, String var5) throws CudfException;

    private static native long writeORCBufferBegin(String[] var0, boolean[] var1, String[] var2, String[] var3, int var4, HostBufferConsumer var5) throws CudfException;

    private static native void writeORCChunk(long var0, long var2, long var4);

    private static native void writeORCEnd(long var0);

    private static native long writeArrowIPCFileBegin(String[] var0, String var1);

    private static native long writeArrowIPCBufferBegin(String[] var0, HostBufferConsumer var1);

    private static native long convertCudfToArrowTable(long var0, long var2);

    private static native void writeArrowIPCArrowChunk(long var0, long var2, long var4);

    private static native void writeArrowIPCEnd(long var0);

    private static native long readArrowIPCFileBegin(String var0);

    private static native long readArrowIPCBufferBegin(ArrowReaderWrapper var0);

    private static native long readArrowIPCChunkToArrowTable(long var0, int var2);

    private static native void closeArrowTable(long var0);

    private static native long[] convertArrowTableToCudf(long var0);

    private static native void readArrowIPCEnd(long var0);

    private static native long[] groupByAggregate(long var0, int[] var2, int[] var3, long[] var4, boolean var5, boolean var6, boolean[] var7, boolean[] var8) throws CudfException;

    private static native long[] rollingWindowAggregate(long var0, int[] var2, long[] var3, int[] var4, long[] var5, int[] var6, int[] var7, int[] var8, boolean var9) throws CudfException;

    private static native long[] rangeRollingWindowAggregate(long var0, int[] var2, int[] var3, boolean[] var4, int[] var5, long[] var6, int[] var7, long[] var8, long[] var9, boolean[] var10, boolean[] var11, boolean var12) throws CudfException;

    private static native long sortOrder(long var0, long[] var2, boolean[] var3, boolean[] var4) throws CudfException;

    private static native long[] orderBy(long var0, long[] var2, boolean[] var3, boolean[] var4) throws CudfException;

    private static native long[] merge(long[] var0, int[] var1, boolean[] var2, boolean[] var3) throws CudfException;

    private static native long[] leftJoin(long var0, int[] var2, long var3, int[] var5, boolean var6) throws CudfException;

    private static native long[] leftJoinGatherMaps(long var0, long var2, boolean var4) throws CudfException;

    private static native long[] innerJoin(long var0, int[] var2, long var3, int[] var5, boolean var6) throws CudfException;

    private static native long[] innerJoinGatherMaps(long var0, long var2, boolean var4) throws CudfException;

    private static native long[] fullJoin(long var0, int[] var2, long var3, int[] var5, boolean var6) throws CudfException;

    private static native long[] fullJoinGatherMaps(long var0, long var2, boolean var4) throws CudfException;

    private static native long[] leftSemiJoin(long var0, int[] var2, long var3, int[] var5, boolean var6) throws CudfException;

    private static native long[] leftSemiJoinGatherMap(long var0, long var2, boolean var4) throws CudfException;

    private static native long[] leftAntiJoin(long var0, int[] var2, long var3, int[] var5, boolean var6) throws CudfException;

    private static native long[] leftAntiJoinGatherMap(long var0, long var2, boolean var4) throws CudfException;

    private static native long[] crossJoin(long var0, long var2) throws CudfException;

    private static native long[] concatenate(long[] var0) throws CudfException;

    private static native long interleaveColumns(long var0);

    private static native long[] filter(long var0, long var2);

    private static native long[] gather(long var0, long var2, boolean var4);

    private static native long[] convertToRows(long var0);

    private static native long[] convertFromRows(long var0, int[] var2, int[] var3);

    private static native long[] repeatStaticCount(long var0, int var2);

    private static native long[] repeatColumnCount(long var0, long var2, boolean var4);

    private static native long rowBitCount(long var0) throws CudfException;

    private static native long[] explode(long var0, int var2);

    private static native long[] explodePosition(long var0, int var2);

    private static native long[] explodeOuter(long var0, int var2);

    private static native long[] explodeOuterPosition(long var0, int var2);

    private static native long createCudfTableView(long[] var0);

    private static native long[] columnViewsFromPacked(ByteBuffer var0, long var1);

    private static native ContiguousTable[] contiguousSplitGroups(long var0, int[] var2, boolean var3, boolean var4, boolean[] var5, boolean[] var6);

    public static Table readCSV(Schema schema, File path) {
        return Table.readCSV(schema, CSVOptions.DEFAULT, path);
    }

    public static Table readCSV(Schema schema, CSVOptions opts, File path) {
        return new Table(Table.readCSV(schema.getColumnNames(), schema.getTypesAsStrings(), opts.getIncludeColumnNames(), path.getAbsolutePath(), 0L, 0L, opts.getHeaderRow(), opts.getDelim(), opts.getQuote(), opts.getComment(), opts.getNullValues(), opts.getTrueValues(), opts.getFalseValues()));
    }

    public static Table readCSV(Schema schema, byte[] buffer) {
        return Table.readCSV(schema, CSVOptions.DEFAULT, buffer, 0L, (long)buffer.length);
    }

    public static Table readCSV(Schema schema, CSVOptions opts, byte[] buffer) {
        return Table.readCSV(schema, opts, buffer, 0L, (long)buffer.length);
    }

    public static Table readCSV(Schema schema, CSVOptions opts, byte[] buffer, long offset, long len) {
        if (len <= 0L) {
            len = (long)buffer.length - offset;
        }
        assert (len > 0L);
        assert (len <= (long)buffer.length - offset);
        assert (offset >= 0L && offset < (long)buffer.length);
        try (HostMemoryBuffer newBuf = HostMemoryBuffer.allocate(len);){
            newBuf.setBytes(0L, buffer, offset, len);
            Table table = Table.readCSV(schema, opts, newBuf, 0L, len);
            return table;
        }
    }

    public static Table readCSV(Schema schema, CSVOptions opts, HostMemoryBuffer buffer, long offset, long len) {
        if (len <= 0L) {
            len = buffer.length - offset;
        }
        assert (len > 0L);
        assert (len <= buffer.getLength() - offset);
        assert (offset >= 0L && offset < buffer.length);
        return new Table(Table.readCSV(schema.getColumnNames(), schema.getTypesAsStrings(), opts.getIncludeColumnNames(), null, buffer.getAddress() + offset, len, opts.getHeaderRow(), opts.getDelim(), opts.getQuote(), opts.getComment(), opts.getNullValues(), opts.getTrueValues(), opts.getFalseValues()));
    }

    public static Table readParquet(File path) {
        return Table.readParquet(ParquetOptions.DEFAULT, path);
    }

    public static Table readParquet(ParquetOptions opts, File path) {
        return new Table(Table.readParquet(opts.getIncludeColumnNames(), path.getAbsolutePath(), 0L, 0L, opts.timeUnit().typeId.getNativeId(), opts.isStrictDecimalType()));
    }

    public static Table readParquet(byte[] buffer) {
        return Table.readParquet(ParquetOptions.DEFAULT, buffer, 0L, (long)buffer.length);
    }

    public static Table readParquet(ParquetOptions opts, byte[] buffer) {
        return Table.readParquet(opts, buffer, 0L, (long)buffer.length);
    }

    public static Table readParquet(ParquetOptions opts, byte[] buffer, long offset, long len) {
        if (len <= 0L) {
            len = (long)buffer.length - offset;
        }
        assert (len > 0L);
        assert (len <= (long)buffer.length - offset);
        assert (offset >= 0L && offset < (long)buffer.length);
        try (HostMemoryBuffer newBuf = HostMemoryBuffer.allocate(len);){
            newBuf.setBytes(0L, buffer, offset, len);
            Table table = Table.readParquet(opts, newBuf, 0L, len);
            return table;
        }
    }

    public static Table readParquet(ParquetOptions opts, HostMemoryBuffer buffer, long offset, long len) {
        if (len <= 0L) {
            len = buffer.length - offset;
        }
        assert (len > 0L);
        assert (len <= buffer.getLength() - offset);
        assert (offset >= 0L && offset < buffer.length);
        return new Table(Table.readParquet(opts.getIncludeColumnNames(), null, buffer.getAddress() + offset, len, opts.timeUnit().typeId.getNativeId(), opts.isStrictDecimalType()));
    }

    public static Table readORC(File path) {
        return Table.readORC(ORCOptions.DEFAULT, path);
    }

    public static Table readORC(ORCOptions opts, File path) {
        return new Table(Table.readORC(opts.getIncludeColumnNames(), path.getAbsolutePath(), 0L, 0L, opts.usingNumPyTypes(), opts.timeUnit().typeId.getNativeId()));
    }

    public static Table readORC(byte[] buffer) {
        return Table.readORC(ORCOptions.DEFAULT, buffer, 0L, (long)buffer.length);
    }

    public static Table readORC(ORCOptions opts, byte[] buffer) {
        return Table.readORC(opts, buffer, 0L, (long)buffer.length);
    }

    public static Table readORC(ORCOptions opts, byte[] buffer, long offset, long len) {
        if (len <= 0L) {
            len = (long)buffer.length - offset;
        }
        assert (len > 0L);
        assert (len <= (long)buffer.length - offset);
        assert (offset >= 0L && offset < (long)buffer.length);
        try (HostMemoryBuffer newBuf = HostMemoryBuffer.allocate(len);){
            newBuf.setBytes(0L, buffer, offset, len);
            Table table = Table.readORC(opts, newBuf, 0L, len);
            return table;
        }
    }

    public static Table readORC(ORCOptions opts, HostMemoryBuffer buffer, long offset, long len) {
        if (len <= 0L) {
            len = buffer.length - offset;
        }
        assert (len > 0L);
        assert (len <= buffer.getLength() - offset);
        assert (offset >= 0L && offset < buffer.length);
        return new Table(Table.readORC(opts.getIncludeColumnNames(), null, buffer.getAddress() + offset, len, opts.usingNumPyTypes(), opts.timeUnit().typeId.getNativeId()));
    }

    public static TableWriter writeParquetChunked(ParquetWriterOptions options, File outputFile) {
        return new ParquetTableWriter(options, outputFile);
    }

    public static TableWriter writeParquetChunked(ParquetWriterOptions options, HostBufferConsumer consumer) {
        return new ParquetTableWriter(options, consumer);
    }

    @Deprecated
    public void writeParquet(ParquetWriterOptions options, File outputFile) {
        try (TableWriter writer = Table.writeParquetChunked(options, outputFile);){
            writer.write(this);
        }
    }

    public static TableWriter writeORCChunked(ORCWriterOptions options, File outputFile) {
        return new ORCTableWriter(options, outputFile);
    }

    public static TableWriter writeORCChunked(ORCWriterOptions options, HostBufferConsumer consumer) {
        return new ORCTableWriter(options, consumer);
    }

    @Deprecated
    public void writeORC(File outputFile) {
        this.writeORC(ORCWriterOptions.DEFAULT, outputFile);
    }

    @Deprecated
    public void writeORC(ORCWriterOptions options, File outputFile) {
        try (TableWriter writer = Table.writeORCChunked(options, outputFile);){
            writer.write(this);
        }
    }

    public static TableWriter writeArrowIPCChunked(ArrowIPCWriterOptions options, File outputFile) {
        return new ArrowIPCTableWriter(options, outputFile);
    }

    public static TableWriter writeArrowIPCChunked(ArrowIPCWriterOptions options, HostBufferConsumer consumer) {
        return new ArrowIPCTableWriter(options, consumer);
    }

    public static StreamedTableReader readArrowIPCChunked(ArrowIPCOptions options, File inputFile) {
        return new ArrowIPCStreamedTableReader(options, inputFile);
    }

    public static StreamedTableReader readArrowIPCChunked(File inputFile) {
        return Table.readArrowIPCChunked(ArrowIPCOptions.DEFAULT, inputFile);
    }

    public static StreamedTableReader readArrowIPCChunked(ArrowIPCOptions options, HostBufferProvider provider) {
        return new ArrowIPCStreamedTableReader(options, provider);
    }

    public static StreamedTableReader readArrowIPCChunked(HostBufferProvider provider) {
        return Table.readArrowIPCChunked(ArrowIPCOptions.DEFAULT, provider);
    }

    public static Table concatenate(Table ... tables) {
        if (tables.length < 2) {
            throw new IllegalArgumentException("concatenate requires 2 or more tables");
        }
        int numColumns = tables[0].getNumberOfColumns();
        long[] tableHandles = new long[tables.length];
        for (int i = 0; i < tables.length; ++i) {
            tableHandles[i] = tables[i].nativeHandle;
            assert (tables[i].getNumberOfColumns() == numColumns) : "all tables must have the same schema";
        }
        return new Table(Table.concatenate(tableHandles));
    }

    public ColumnVector interleaveColumns() {
        assert (this.getNumberOfColumns() >= 2) : ".interleaveColumns() operation requires at least 2 columns";
        return new ColumnVector(Table.interleaveColumns(this.nativeHandle));
    }

    public Table repeat(int count) {
        return new Table(Table.repeatStaticCount(this.nativeHandle, count));
    }

    public Table repeat(ColumnView counts) {
        return this.repeat(counts, true);
    }

    public Table repeat(ColumnView counts, boolean checkCount) {
        return new Table(Table.repeatColumnCount(this.nativeHandle, counts.getNativeView(), checkCount));
    }

    public PartitionedTable partition(ColumnView partitionMap, int numberOfPartitions) {
        int[] partitionOffsets = new int[numberOfPartitions];
        return new PartitionedTable(new Table(Table.partition(this.getNativeView(), partitionMap.getNativeView(), partitionOffsets.length, partitionOffsets)), partitionOffsets);
    }

    public ColumnVector lowerBound(boolean[] areNullsSmallest, Table valueTable, boolean[] descFlags) {
        this.assertForBounds(valueTable);
        return new ColumnVector(Table.bound(this.nativeHandle, valueTable.nativeHandle, descFlags, areNullsSmallest, false));
    }

    /*
     * Exception decompiling
     */
    public ColumnVector lowerBound(Table valueTable, OrderByArg ... args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ColumnVector upperBound(boolean[] areNullsSmallest, Table valueTable, boolean[] descFlags) {
        this.assertForBounds(valueTable);
        return new ColumnVector(Table.bound(this.nativeHandle, valueTable.nativeHandle, descFlags, areNullsSmallest, true));
    }

    /*
     * Exception decompiling
     */
    public ColumnVector upperBound(Table valueTable, OrderByArg ... args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void assertForBounds(Table valueTable) {
        assert (this.getRowCount() != 0L) : "Input table cannot be empty";
        assert (valueTable.getRowCount() != 0L) : "Value table cannot be empty";
        for (int i = 0; i < Math.min(this.columns.length, valueTable.columns.length); ++i) {
            assert (valueTable.columns[i].getType().equals(this.getColumn(i).getType())) : "Input and values tables' data types do not match";
        }
    }

    public Table crossJoin(Table right) {
        return new Table(Table.crossJoin(this.nativeHandle, right.nativeHandle));
    }

    public ColumnVector sortOrder(OrderByArg ... args) {
        long[] sortKeys = new long[args.length];
        boolean[] isDescending = new boolean[args.length];
        boolean[] areNullsSmallest = new boolean[args.length];
        for (int i = 0; i < args.length; ++i) {
            int index = args[i].index;
            assert (index >= 0 && index < this.columns.length) : "index is out of range 0 <= " + index + " < " + this.columns.length;
            isDescending[i] = args[i].isDescending;
            areNullsSmallest[i] = args[i].isNullSmallest;
            sortKeys[i] = this.columns[index].getNativeView();
        }
        return new ColumnVector(Table.sortOrder(this.nativeHandle, sortKeys, isDescending, areNullsSmallest));
    }

    public Table orderBy(OrderByArg ... args) {
        long[] sortKeys = new long[args.length];
        boolean[] isDescending = new boolean[args.length];
        boolean[] areNullsSmallest = new boolean[args.length];
        for (int i = 0; i < args.length; ++i) {
            int index = args[i].index;
            assert (index >= 0 && index < this.columns.length) : "index is out of range 0 <= " + index + " < " + this.columns.length;
            isDescending[i] = args[i].isDescending;
            areNullsSmallest[i] = args[i].isNullSmallest;
            sortKeys[i] = this.columns[index].getNativeView();
        }
        return new Table(Table.orderBy(this.nativeHandle, sortKeys, isDescending, areNullsSmallest));
    }

    public static Table merge(Table[] tables, OrderByArg ... args) {
        assert (tables.length > 0);
        long[] tableHandles = new long[tables.length];
        Table first = tables[0];
        assert (args.length <= first.columns.length);
        for (int i = 0; i < tables.length; ++i) {
            Table t = tables[i];
            assert (t != null);
            assert (t.columns.length == first.columns.length);
            tableHandles[i] = t.nativeHandle;
        }
        int[] sortKeyIndexes = new int[args.length];
        boolean[] isDescending = new boolean[args.length];
        boolean[] areNullsSmallest = new boolean[args.length];
        for (int i = 0; i < args.length; ++i) {
            int index = args[i].index;
            assert (index >= 0 && index < first.columns.length) : "index is out of range 0 <= " + index + " < " + first.columns.length;
            isDescending[i] = args[i].isDescending;
            areNullsSmallest[i] = args[i].isNullSmallest;
            sortKeyIndexes[i] = index;
        }
        return new Table(Table.merge(tableHandles, sortKeyIndexes, isDescending, areNullsSmallest));
    }

    public static Table merge(List<Table> tables, OrderByArg ... args) {
        return Table.merge(tables.toArray(new Table[tables.size()]), args);
    }

    public GroupByOperation groupBy(GroupByOptions groupByOptions, int ... indices) {
        return this.groupByInternal(groupByOptions, indices);
    }

    public GroupByOperation groupBy(int ... indices) {
        return this.groupByInternal(GroupByOptions.builder().withIgnoreNullKeys(false).build(), indices);
    }

    private GroupByOperation groupByInternal(GroupByOptions groupByOptions, int[] indices) {
        int[] operationIndicesArray = this.copyAndValidate(indices);
        return new GroupByOperation(this, groupByOptions, operationIndicesArray);
    }

    public PartitionedTable roundRobinPartition(int numberOfPartitions, int startPartition) {
        int[] partitionOffsets = new int[numberOfPartitions];
        return new PartitionedTable(new Table(Table.roundRobinPartition(this.nativeHandle, numberOfPartitions, startPartition, partitionOffsets)), partitionOffsets);
    }

    public TableOperation onColumns(int ... indices) {
        int[] operationIndicesArray = this.copyAndValidate(indices);
        return new TableOperation(this, operationIndicesArray);
    }

    private int[] copyAndValidate(int[] indices) {
        int[] operationIndicesArray = new int[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            operationIndicesArray[i] = indices[i];
            assert (operationIndicesArray[i] >= 0 && operationIndicesArray[i] < this.columns.length) : "operation index is out of range 0 <= " + operationIndicesArray[i] + " < " + this.columns.length;
        }
        return operationIndicesArray;
    }

    public Table filter(ColumnView mask) {
        assert (mask.getType().equals(DType.BOOL8)) : "Mask column must be of type BOOL8";
        assert (this.getRowCount() == 0L || this.getRowCount() == mask.getRowCount()) : "Mask column has incorrect size";
        return new Table(Table.filter(this.nativeHandle, mask.getNativeView()));
    }

    public ContiguousTable[] contiguousSplit(int ... indices) {
        return Table.contiguousSplit(this.nativeHandle, indices);
    }

    public Table explode(int index) {
        assert (0 <= index && index < this.columns.length) : "Column index is out of range";
        assert (this.columns[index].getType().equals(DType.LIST)) : "Column to explode must be of type LIST";
        return new Table(Table.explode(this.nativeHandle, index));
    }

    public Table explodePosition(int index) {
        assert (0 <= index && index < this.columns.length) : "Column index is out of range";
        assert (this.columns[index].getType().equals(DType.LIST)) : "Column to explode must be of type LIST";
        return new Table(Table.explodePosition(this.nativeHandle, index));
    }

    public Table explodeOuter(int index) {
        assert (0 <= index && index < this.columns.length) : "Column index is out of range";
        assert (this.columns[index].getType().equals(DType.LIST)) : "Column to explode must be of type LIST";
        return new Table(Table.explodeOuter(this.nativeHandle, index));
    }

    public Table explodeOuterPosition(int index) {
        assert (0 <= index && index < this.columns.length) : "Column index is out of range";
        assert (this.columns[index].getType().equals(DType.LIST)) : "Column to explode must be of type LIST";
        return new Table(Table.explodeOuterPosition(this.nativeHandle, index));
    }

    public ColumnVector rowBitCount() {
        return new ColumnVector(Table.rowBitCount(this.getNativeView()));
    }

    public Table gather(ColumnView gatherMap) {
        return this.gather(gatherMap, true);
    }

    public Table gather(ColumnView gatherMap, boolean checkBounds) {
        return new Table(Table.gather(this.nativeHandle, gatherMap.getNativeView(), checkBounds));
    }

    private GatherMap[] buildJoinGatherMaps(long[] gatherMapData) {
        long bufferSize = gatherMapData[0];
        long leftAddr = gatherMapData[1];
        long leftHandle = gatherMapData[2];
        long rightAddr = gatherMapData[3];
        long rightHandle = gatherMapData[4];
        GatherMap[] maps = new GatherMap[]{new GatherMap(DeviceMemoryBuffer.fromRmm(leftAddr, bufferSize, leftHandle)), new GatherMap(DeviceMemoryBuffer.fromRmm(rightAddr, bufferSize, rightHandle))};
        return maps;
    }

    public GatherMap[] leftJoinGatherMaps(Table rightKeys, boolean compareNullsEqual) {
        if (this.getNumberOfColumns() != rightKeys.getNumberOfColumns()) {
            throw new IllegalArgumentException("column count mismatch, this: " + this.getNumberOfColumns() + "rightKeys: " + rightKeys.getNumberOfColumns());
        }
        long[] gatherMapData = Table.leftJoinGatherMaps(this.getNativeView(), rightKeys.getNativeView(), compareNullsEqual);
        return this.buildJoinGatherMaps(gatherMapData);
    }

    public GatherMap[] innerJoinGatherMaps(Table rightKeys, boolean compareNullsEqual) {
        if (this.getNumberOfColumns() != rightKeys.getNumberOfColumns()) {
            throw new IllegalArgumentException("column count mismatch, this: " + this.getNumberOfColumns() + "rightKeys: " + rightKeys.getNumberOfColumns());
        }
        long[] gatherMapData = Table.innerJoinGatherMaps(this.getNativeView(), rightKeys.getNativeView(), compareNullsEqual);
        return this.buildJoinGatherMaps(gatherMapData);
    }

    public GatherMap[] fullJoinGatherMaps(Table rightKeys, boolean compareNullsEqual) {
        if (this.getNumberOfColumns() != rightKeys.getNumberOfColumns()) {
            throw new IllegalArgumentException("column count mismatch, this: " + this.getNumberOfColumns() + "rightKeys: " + rightKeys.getNumberOfColumns());
        }
        long[] gatherMapData = Table.fullJoinGatherMaps(this.getNativeView(), rightKeys.getNativeView(), compareNullsEqual);
        return this.buildJoinGatherMaps(gatherMapData);
    }

    private GatherMap buildSemiJoinGatherMap(long[] gatherMapData) {
        long bufferSize = gatherMapData[0];
        long leftAddr = gatherMapData[1];
        long leftHandle = gatherMapData[2];
        return new GatherMap(DeviceMemoryBuffer.fromRmm(leftAddr, bufferSize, leftHandle));
    }

    public GatherMap leftSemiJoinGatherMap(Table rightKeys, boolean compareNullsEqual) {
        if (this.getNumberOfColumns() != rightKeys.getNumberOfColumns()) {
            throw new IllegalArgumentException("column count mismatch, this: " + this.getNumberOfColumns() + "rightKeys: " + rightKeys.getNumberOfColumns());
        }
        long[] gatherMapData = Table.leftSemiJoinGatherMap(this.getNativeView(), rightKeys.getNativeView(), compareNullsEqual);
        return this.buildSemiJoinGatherMap(gatherMapData);
    }

    public GatherMap leftAntiJoinGatherMap(Table rightKeys, boolean compareNullsEqual) {
        if (this.getNumberOfColumns() != rightKeys.getNumberOfColumns()) {
            throw new IllegalArgumentException("column count mismatch, this: " + this.getNumberOfColumns() + "rightKeys: " + rightKeys.getNumberOfColumns());
        }
        long[] gatherMapData = Table.leftAntiJoinGatherMap(this.getNativeView(), rightKeys.getNativeView(), compareNullsEqual);
        return this.buildSemiJoinGatherMap(gatherMapData);
    }

    public ColumnVector[] convertToRows() {
        long[] ptrs = Table.convertToRows(this.nativeHandle);
        ColumnVector[] ret = new ColumnVector[ptrs.length];
        for (int i = 0; i < ptrs.length; ++i) {
            ret[i] = new ColumnVector(ptrs[i]);
        }
        return ret;
    }

    public static Table convertFromRows(ColumnView vec, DType ... schema) {
        int[] types = new int[schema.length];
        int[] scale = new int[schema.length];
        for (int i = 0; i < schema.length; ++i) {
            types[i] = schema[i].typeId.nativeId;
            scale[i] = schema[i].getScale();
        }
        return new Table(Table.convertFromRows(vec.getNativeView(), types, scale));
    }

    public static Table fromPackedTable(ByteBuffer metadata, DeviceMemoryBuffer data) {
        ByteBuffer directBuffer = metadata;
        if (!directBuffer.isDirect()) {
            directBuffer = ByteBuffer.allocateDirect(metadata.remaining());
            directBuffer.put(metadata);
            directBuffer.flip();
        }
        long[] columnViewAddresses = Table.columnViewsFromPacked(directBuffer, data.getAddress());
        ColumnVector[] columns = new ColumnVector[columnViewAddresses.length];
        Table result = null;
        try {
            for (int i = 0; i < columns.length; ++i) {
                columns[i] = ColumnVector.fromViewWithContiguousAllocation(columnViewAddresses[i], data);
                columnViewAddresses[i] = 0L;
            }
            result = new Table(columns);
        }
        catch (Throwable t) {
            for (int i = 0; i < columns.length; ++i) {
                if (columns[i] != null) {
                    columns[i].close();
                }
                if (columnViewAddresses[i] == 0L) continue;
                ColumnView.deleteColumnView(columnViewAddresses[i]);
            }
            throw t;
        }
        for (ColumnVector column : columns) {
            column.close();
        }
        return result;
    }

    static {
        NativeDepsLoader.loadNativeDeps();
    }

    public static final class TestBuilder {
        private final List<HostColumnVector.DataType> types = new ArrayList<HostColumnVector.DataType>();
        private final List<Object> typeErasedData = new ArrayList<Object>();

        public TestBuilder column(String ... values) {
            this.types.add(new HostColumnVector.BasicType(true, DType.STRING));
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(Boolean ... values) {
            this.types.add(new HostColumnVector.BasicType(true, DType.BOOL8));
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(Byte ... values) {
            this.types.add(new HostColumnVector.BasicType(true, DType.INT8));
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(Short ... values) {
            this.types.add(new HostColumnVector.BasicType(true, DType.INT16));
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(Integer ... values) {
            this.types.add(new HostColumnVector.BasicType(true, DType.INT32));
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(Long ... values) {
            this.types.add(new HostColumnVector.BasicType(true, DType.INT64));
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(Float ... values) {
            this.types.add(new HostColumnVector.BasicType(true, DType.FLOAT32));
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(Double ... values) {
            this.types.add(new HostColumnVector.BasicType(true, DType.FLOAT64));
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(HostColumnVector.ListType dataType, List<?> ... values) {
            this.types.add(dataType);
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(String[] ... values) {
            this.types.add(new HostColumnVector.ListType(true, new HostColumnVector.BasicType(true, DType.STRING)));
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(Boolean[] ... values) {
            this.types.add(new HostColumnVector.ListType(true, new HostColumnVector.BasicType(true, DType.BOOL8)));
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(Byte[] ... values) {
            this.types.add(new HostColumnVector.ListType(true, new HostColumnVector.BasicType(true, DType.INT8)));
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(Short[] ... values) {
            this.types.add(new HostColumnVector.ListType(true, new HostColumnVector.BasicType(true, DType.INT16)));
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(Integer[] ... values) {
            this.types.add(new HostColumnVector.ListType(true, new HostColumnVector.BasicType(true, DType.INT32)));
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(Long[] ... values) {
            this.types.add(new HostColumnVector.ListType(true, new HostColumnVector.BasicType(true, DType.INT64)));
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(Float[] ... values) {
            this.types.add(new HostColumnVector.ListType(true, new HostColumnVector.BasicType(true, DType.FLOAT32)));
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(Double[] ... values) {
            this.types.add(new HostColumnVector.ListType(true, new HostColumnVector.BasicType(true, DType.FLOAT64)));
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(HostColumnVector.StructType dataType, HostColumnVector.StructData ... values) {
            this.types.add(dataType);
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(HostColumnVector.StructType dataType, HostColumnVector.StructData[] ... values) {
            this.types.add(new HostColumnVector.ListType(true, dataType));
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder timestampDayColumn(Integer ... values) {
            this.types.add(new HostColumnVector.BasicType(true, DType.TIMESTAMP_DAYS));
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder timestampNanosecondsColumn(Long ... values) {
            this.types.add(new HostColumnVector.BasicType(true, DType.TIMESTAMP_NANOSECONDS));
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder timestampMillisecondsColumn(Long ... values) {
            this.types.add(new HostColumnVector.BasicType(true, DType.TIMESTAMP_MILLISECONDS));
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder timestampMicrosecondsColumn(Long ... values) {
            this.types.add(new HostColumnVector.BasicType(true, DType.TIMESTAMP_MICROSECONDS));
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder timestampSecondsColumn(Long ... values) {
            this.types.add(new HostColumnVector.BasicType(true, DType.TIMESTAMP_SECONDS));
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder decimal32Column(int scale, Integer ... unscaledValues) {
            this.types.add(new HostColumnVector.BasicType(true, DType.create(DType.DTypeEnum.DECIMAL32, scale)));
            this.typeErasedData.add(unscaledValues);
            return this;
        }

        public TestBuilder decimal32Column(int scale, RoundingMode mode, Double ... values) {
            this.types.add(new HostColumnVector.BasicType(true, DType.create(DType.DTypeEnum.DECIMAL32, scale)));
            BigDecimal[] data = (BigDecimal[])Arrays.stream(values).map(x -> {
                if (x == null) {
                    return null;
                }
                return BigDecimal.valueOf(x).setScale(-scale, mode);
            }).toArray(BigDecimal[]::new);
            this.typeErasedData.add(data);
            return this;
        }

        public TestBuilder decimal32Column(int scale, RoundingMode mode, String ... values) {
            this.types.add(new HostColumnVector.BasicType(true, DType.create(DType.DTypeEnum.DECIMAL32, scale)));
            BigDecimal[] data = (BigDecimal[])Arrays.stream(values).map(x -> {
                if (x == null) {
                    return null;
                }
                return new BigDecimal((String)x).setScale(-scale, mode);
            }).toArray(BigDecimal[]::new);
            this.typeErasedData.add(data);
            return this;
        }

        public TestBuilder decimal64Column(int scale, Long ... unscaledValues) {
            this.types.add(new HostColumnVector.BasicType(true, DType.create(DType.DTypeEnum.DECIMAL64, scale)));
            this.typeErasedData.add(unscaledValues);
            return this;
        }

        public TestBuilder decimal64Column(int scale, RoundingMode mode, Double ... values) {
            this.types.add(new HostColumnVector.BasicType(true, DType.create(DType.DTypeEnum.DECIMAL64, scale)));
            BigDecimal[] data = (BigDecimal[])Arrays.stream(values).map(x -> {
                if (x == null) {
                    return null;
                }
                return BigDecimal.valueOf(x).setScale(-scale, mode);
            }).toArray(BigDecimal[]::new);
            this.typeErasedData.add(data);
            return this;
        }

        public TestBuilder decimal64Column(int scale, RoundingMode mode, String ... values) {
            this.types.add(new HostColumnVector.BasicType(true, DType.create(DType.DTypeEnum.DECIMAL64, scale)));
            BigDecimal[] data = (BigDecimal[])Arrays.stream(values).map(x -> {
                if (x == null) {
                    return null;
                }
                return new BigDecimal((String)x).setScale(-scale, mode);
            }).toArray(BigDecimal[]::new);
            this.typeErasedData.add(data);
            return this;
        }

        private static ColumnVector from(DType type, Object dataArray) {
            ColumnVector ret = null;
            switch (type.typeId) {
                case STRING: {
                    ret = ColumnVector.fromStrings((String[])dataArray);
                    break;
                }
                case BOOL8: {
                    ret = ColumnVector.fromBoxedBooleans((Boolean[])dataArray);
                    break;
                }
                case INT8: {
                    ret = ColumnVector.fromBoxedBytes((Byte[])dataArray);
                    break;
                }
                case INT16: {
                    ret = ColumnVector.fromBoxedShorts((Short[])dataArray);
                    break;
                }
                case INT32: {
                    ret = ColumnVector.fromBoxedInts((Integer[])dataArray);
                    break;
                }
                case INT64: {
                    ret = ColumnVector.fromBoxedLongs((Long[])dataArray);
                    break;
                }
                case TIMESTAMP_DAYS: {
                    ret = ColumnVector.timestampDaysFromBoxedInts((Integer[])dataArray);
                    break;
                }
                case TIMESTAMP_SECONDS: {
                    ret = ColumnVector.timestampSecondsFromBoxedLongs((Long[])dataArray);
                    break;
                }
                case TIMESTAMP_MILLISECONDS: {
                    ret = ColumnVector.timestampMilliSecondsFromBoxedLongs((Long[])dataArray);
                    break;
                }
                case TIMESTAMP_MICROSECONDS: {
                    ret = ColumnVector.timestampMicroSecondsFromBoxedLongs((Long[])dataArray);
                    break;
                }
                case TIMESTAMP_NANOSECONDS: {
                    ret = ColumnVector.timestampNanoSecondsFromBoxedLongs((Long[])dataArray);
                    break;
                }
                case FLOAT32: {
                    ret = ColumnVector.fromBoxedFloats((Float[])dataArray);
                    break;
                }
                case FLOAT64: {
                    ret = ColumnVector.fromBoxedDoubles((Double[])dataArray);
                    break;
                }
                case DECIMAL32: 
                case DECIMAL64: {
                    int scale = type.getScale();
                    if (dataArray instanceof Integer[]) {
                        BigDecimal[] data = (BigDecimal[])Arrays.stream((Integer[])dataArray).map(i -> i == null ? null : BigDecimal.valueOf(i.intValue(), -scale)).toArray(BigDecimal[]::new);
                        ret = ColumnVector.build(type, data.length, b -> b.appendBoxed(data));
                        break;
                    }
                    if (dataArray instanceof Long[]) {
                        BigDecimal[] data = (BigDecimal[])Arrays.stream((Long[])dataArray).map(i -> i == null ? null : BigDecimal.valueOf(i, -scale)).toArray(BigDecimal[]::new);
                        ret = ColumnVector.build(type, data.length, b -> b.appendBoxed(data));
                        break;
                    }
                    if (dataArray instanceof BigDecimal[]) {
                        BigDecimal[] data = (BigDecimal[])dataArray;
                        ret = ColumnVector.build(type, data.length, b -> b.appendBoxed(data));
                        break;
                    }
                    throw new IllegalArgumentException("Data array of invalid type(" + dataArray.getClass() + ") to build decimal column");
                }
                default: {
                    throw new IllegalArgumentException(type + " is not supported yet");
                }
            }
            return ret;
        }

        private static <T> ColumnVector fromLists(HostColumnVector.DataType dataType, Object[] dataArray) {
            List[] dataLists = new List[dataArray.length];
            for (int i = 0; i < dataLists.length; ++i) {
                Object dataList = dataArray[i];
                dataLists[i] = dataList == null ? null : (dataList instanceof List ? (List<Object>)dataList : Arrays.asList((Object[])dataList));
            }
            return ColumnVector.fromLists(dataType, dataLists);
        }

        private static ColumnVector fromStructs(HostColumnVector.DataType dataType, HostColumnVector.StructData[] dataArray) {
            return ColumnVector.fromStructs(dataType, dataArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Table build() {
            ArrayList<ColumnVector> columns = new ArrayList<ColumnVector>(this.types.size());
            try {
                for (int i = 0; i < this.types.size(); ++i) {
                    HostColumnVector.DataType dataType = this.types.get(i);
                    DType dtype = dataType.getType();
                    Object dataArray = this.typeErasedData.get(i);
                    if (dtype.isNestedType()) {
                        if (dtype.equals(DType.LIST)) {
                            columns.add(TestBuilder.fromLists(dataType, (Object[])dataArray));
                            continue;
                        }
                        if (dtype.equals(DType.STRUCT)) {
                            columns.add(TestBuilder.fromStructs(dataType, (HostColumnVector.StructData[])dataArray));
                            continue;
                        }
                        throw new IllegalStateException("Unexpected nested type: " + dtype);
                    }
                    columns.add(TestBuilder.from(dtype, dataArray));
                }
                Table table = new Table(columns.toArray(new ColumnVector[columns.size()]));
                return table;
            }
            finally {
                for (ColumnVector cv : columns) {
                    cv.close();
                }
            }
        }
    }

    public static final class TableOperation {
        private final Operation operation;

        TableOperation(Table table, int ... indices) {
            this.operation = new Operation(table, indices);
        }

        public Table leftJoin(TableOperation rightJoinIndices, boolean compareNullsEqual) {
            return new Table(Table.leftJoin(this.operation.table.nativeHandle, this.operation.indices, rightJoinIndices.operation.table.nativeHandle, rightJoinIndices.operation.indices, compareNullsEqual));
        }

        public Table leftJoin(TableOperation rightJoinIndices) {
            return this.leftJoin(rightJoinIndices, true);
        }

        public Table innerJoin(TableOperation rightJoinIndices, boolean compareNullsEqual) {
            return new Table(Table.innerJoin(this.operation.table.nativeHandle, this.operation.indices, rightJoinIndices.operation.table.nativeHandle, rightJoinIndices.operation.indices, compareNullsEqual));
        }

        public Table innerJoin(TableOperation rightJoinIndices) {
            return this.innerJoin(rightJoinIndices, true);
        }

        public Table fullJoin(TableOperation rightJoinIndices, boolean compareNullsEqual) {
            return new Table(Table.fullJoin(this.operation.table.nativeHandle, this.operation.indices, rightJoinIndices.operation.table.nativeHandle, rightJoinIndices.operation.indices, compareNullsEqual));
        }

        public Table fullJoin(TableOperation rightJoinIndices) {
            return this.fullJoin(rightJoinIndices, true);
        }

        public Table leftSemiJoin(TableOperation rightJoinIndices, boolean compareNullsEqual) {
            return new Table(Table.leftSemiJoin(this.operation.table.nativeHandle, this.operation.indices, rightJoinIndices.operation.table.nativeHandle, rightJoinIndices.operation.indices, compareNullsEqual));
        }

        public Table leftSemiJoin(TableOperation rightJoinIndices) {
            return this.leftSemiJoin(rightJoinIndices, true);
        }

        public Table leftAntiJoin(TableOperation rightJoinIndices, boolean compareNullsEqual) {
            return new Table(Table.leftAntiJoin(this.operation.table.nativeHandle, this.operation.indices, rightJoinIndices.operation.table.nativeHandle, rightJoinIndices.operation.indices, compareNullsEqual));
        }

        public Table leftAntiJoin(TableOperation rightJoinIndices) {
            return this.leftAntiJoin(rightJoinIndices, true);
        }

        public PartitionedTable hashPartition(int numberOfPartitions) {
            return this.hashPartition(HashType.MURMUR3, numberOfPartitions);
        }

        public PartitionedTable hashPartition(HashType type, int numberOfPartitions) {
            int[] partitionOffsets = new int[numberOfPartitions];
            return new PartitionedTable(new Table(Table.hashPartition(this.operation.table.nativeHandle, this.operation.indices, type.nativeId, partitionOffsets.length, partitionOffsets)), partitionOffsets);
        }

        @Deprecated
        public PartitionedTable partition(int numberOfPartitions) {
            return this.hashPartition(numberOfPartitions);
        }
    }

    public static final class GroupByOperation {
        private final Operation operation;
        private final GroupByOptions groupByOptions;

        GroupByOperation(Table table, GroupByOptions groupByOptions, int ... indices) {
            this.operation = new Operation(table, indices);
            this.groupByOptions = groupByOptions;
        }

        /*
         * Loose catch block
         */
        public Table aggregate(AggregationOnColumn ... aggregates) {
            assert (aggregates != null);
            TreeMap<Integer, ColumnOps> groupedOps = new TreeMap<Integer, ColumnOps>();
            int keysLength = this.operation.indices.length;
            int totalOps = 0;
            for (int outputIndex = 0; outputIndex < aggregates.length; ++outputIndex) {
                AggregationOnColumn agg = aggregates[outputIndex];
                ColumnOps ops = groupedOps.computeIfAbsent(agg.getColumnIndex(), idx -> new ColumnOps());
                totalOps += ops.add(agg, outputIndex + keysLength);
            }
            int[] aggColumnIndexes = new int[totalOps];
            long[] aggOperationInstances = new long[totalOps];
            try {
                int opIndex = 0;
                for (Map.Entry entry : groupedOps.entrySet()) {
                    int columnIndex = (Integer)entry.getKey();
                    for (Aggregation operation : ((ColumnOps)entry.getValue()).operations()) {
                        aggColumnIndexes[opIndex] = columnIndex;
                        aggOperationInstances[opIndex] = operation.createNativeInstance();
                        ++opIndex;
                    }
                }
                assert (opIndex == totalOps) : opIndex + " == " + totalOps;
                try (Table aggregate = new Table(Table.groupByAggregate(this.operation.table.nativeHandle, this.operation.indices, aggColumnIndexes, aggOperationInstances, this.groupByOptions.getIgnoreNullKeys(), this.groupByOptions.getKeySorted(), this.groupByOptions.getKeysDescending(), this.groupByOptions.getKeysNullSmallest()));){
                    ColumnVector[] finalCols = new ColumnVector[keysLength + aggregates.length];
                    for (int aggIndex = 0; aggIndex < keysLength; ++aggIndex) {
                        finalCols[aggIndex] = aggregate.getColumn(aggIndex);
                    }
                    int inputColumn = keysLength;
                    for (ColumnOps ops : groupedOps.values()) {
                        for (List<Integer> indices : ops.outputIndices()) {
                            for (int outIndex : indices) {
                                finalCols[outIndex] = aggregate.getColumn(inputColumn);
                            }
                            ++inputColumn;
                        }
                    }
                    Table table = new Table(finalCols);
                    return table;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Aggregation.close(aggOperationInstances);
            }
        }

        /*
         * Loose catch block
         */
        public Table aggregateWindows(AggregationOverWindow ... windowAggregates) {
            TreeMap<Integer, ColumnWindowOps> groupedOps = new TreeMap<Integer, ColumnWindowOps>();
            int totalOps = 0;
            for (int outputIndex = 0; outputIndex < windowAggregates.length; ++outputIndex) {
                AggregationOverWindow agg = windowAggregates[outputIndex];
                if (agg.getWindowOptions().getFrameType() != WindowOptions.FrameType.ROWS) {
                    throw new IllegalArgumentException("Expected ROWS-based window specification. Unexpected window type: " + (Object)((Object)agg.getWindowOptions().getFrameType()));
                }
                ColumnWindowOps ops = groupedOps.computeIfAbsent(agg.getColumnIndex(), idx -> new ColumnWindowOps());
                totalOps += ops.add(agg, outputIndex);
            }
            int[] aggColumnIndexes = new int[totalOps];
            long[] aggInstances = new long[totalOps];
            try {
                int[] aggPrecedingWindows = new int[totalOps];
                int[] aggFollowingWindows = new int[totalOps];
                int[] aggMinPeriods = new int[totalOps];
                long[] defaultOutputs = new long[totalOps];
                int opIndex = 0;
                for (Map.Entry entry : groupedOps.entrySet()) {
                    int columnIndex = (Integer)entry.getKey();
                    for (AggregationOverWindow operation : ((ColumnWindowOps)entry.getValue()).operations()) {
                        aggColumnIndexes[opIndex] = columnIndex;
                        aggInstances[opIndex] = operation.createNativeInstance();
                        Scalar p = operation.getWindowOptions().getPrecedingScalar();
                        aggPrecedingWindows[opIndex] = p == null || !p.isValid() ? 0 : p.getInt();
                        Scalar f = operation.getWindowOptions().getFollowingScalar();
                        aggFollowingWindows[opIndex] = f == null || !f.isValid() ? 1 : f.getInt();
                        aggMinPeriods[opIndex] = operation.getWindowOptions().getMinPeriods();
                        defaultOutputs[opIndex] = operation.getDefaultOutput();
                        ++opIndex;
                    }
                }
                assert (opIndex == totalOps) : opIndex + " == " + totalOps;
                try (Table aggregate = new Table(Table.rollingWindowAggregate(this.operation.table.nativeHandle, this.operation.indices, defaultOutputs, aggColumnIndexes, aggInstances, aggMinPeriods, aggPrecedingWindows, aggFollowingWindows, this.groupByOptions.getIgnoreNullKeys()));){
                    ColumnVector[] finalCols = new ColumnVector[windowAggregates.length];
                    int inputColumn = 0;
                    for (ColumnWindowOps ops : groupedOps.values()) {
                        for (List<Integer> indices : ops.outputIndices()) {
                            for (int outIndex : indices) {
                                finalCols[outIndex] = aggregate.getColumn(inputColumn);
                            }
                            ++inputColumn;
                        }
                    }
                    Table table = new Table(finalCols);
                    return table;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Aggregation.close(aggInstances);
            }
        }

        /*
         * Loose catch block
         */
        public Table aggregateWindowsOverRanges(AggregationOverWindow ... windowAggregates) {
            TreeMap<Integer, ColumnWindowOps> groupedOps = new TreeMap<Integer, ColumnWindowOps>();
            int totalOps = 0;
            for (int outputIndex = 0; outputIndex < windowAggregates.length; ++outputIndex) {
                AggregationOverWindow agg = windowAggregates[outputIndex];
                if (agg.getWindowOptions().getFrameType() != WindowOptions.FrameType.RANGE) {
                    throw new IllegalArgumentException("Expected range-based window specification. Unexpected window type: " + (Object)((Object)agg.getWindowOptions().getFrameType()));
                }
                DType orderByType = this.operation.table.getColumn(agg.getWindowOptions().getOrderByColumnIndex()).getType();
                switch (orderByType.getTypeId()) {
                    case INT8: 
                    case INT16: 
                    case INT32: 
                    case INT64: 
                    case UINT8: 
                    case UINT16: 
                    case UINT32: 
                    case UINT64: 
                    case TIMESTAMP_MILLISECONDS: 
                    case TIMESTAMP_SECONDS: 
                    case TIMESTAMP_DAYS: 
                    case TIMESTAMP_NANOSECONDS: 
                    case TIMESTAMP_MICROSECONDS: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Expected range-based window orderBy's type: integral (Boolean-exclusive) and timestamp");
                    }
                }
                ColumnWindowOps ops = groupedOps.computeIfAbsent(agg.getColumnIndex(), idx -> new ColumnWindowOps());
                totalOps += ops.add(agg, outputIndex);
            }
            int[] aggColumnIndexes = new int[totalOps];
            int[] orderByColumnIndexes = new int[totalOps];
            boolean[] isOrderByOrderAscending = new boolean[totalOps];
            long[] aggInstances = new long[totalOps];
            long[] aggPrecedingWindows = new long[totalOps];
            long[] aggFollowingWindows = new long[totalOps];
            try {
                boolean[] aggPrecedingWindowsUnbounded = new boolean[totalOps];
                boolean[] aggFollowingWindowsUnbounded = new boolean[totalOps];
                int[] aggMinPeriods = new int[totalOps];
                int opIndex = 0;
                for (Map.Entry entry : groupedOps.entrySet()) {
                    int columnIndex = (Integer)entry.getKey();
                    for (AggregationOverWindow op : ((ColumnWindowOps)entry.getValue()).operations()) {
                        aggColumnIndexes[opIndex] = columnIndex;
                        aggInstances[opIndex] = op.createNativeInstance();
                        Scalar p = op.getWindowOptions().getPrecedingScalar();
                        Scalar f = op.getWindowOptions().getFollowingScalar();
                        if (!(p != null && p.isValid() || op.getWindowOptions().isUnboundedPreceding())) {
                            throw new IllegalArgumentException("Some kind of preceding must be set and a preceding column is not currently supported");
                        }
                        if (!(f != null && f.isValid() || op.getWindowOptions().isUnboundedFollowing())) {
                            throw new IllegalArgumentException("some kind of following must be set and a follow column is not currently supported");
                        }
                        aggPrecedingWindows[opIndex] = p == null ? 0L : p.getScalarHandle();
                        aggFollowingWindows[opIndex] = f == null ? 0L : f.getScalarHandle();
                        aggPrecedingWindowsUnbounded[opIndex] = op.getWindowOptions().isUnboundedPreceding();
                        aggFollowingWindowsUnbounded[opIndex] = op.getWindowOptions().isUnboundedFollowing();
                        aggMinPeriods[opIndex] = op.getWindowOptions().getMinPeriods();
                        assert (op.getWindowOptions().getFrameType() == WindowOptions.FrameType.RANGE);
                        orderByColumnIndexes[opIndex] = op.getWindowOptions().getOrderByColumnIndex();
                        isOrderByOrderAscending[opIndex] = op.getWindowOptions().isOrderByOrderAscending();
                        if (op.getDefaultOutput() != 0L) {
                            throw new IllegalArgumentException("Operations with a default output are not supported on time based rolling windows");
                        }
                        ++opIndex;
                    }
                }
                assert (opIndex == totalOps) : opIndex + " == " + totalOps;
                try (Table aggregate = new Table(Table.rangeRollingWindowAggregate(this.operation.table.nativeHandle, this.operation.indices, orderByColumnIndexes, isOrderByOrderAscending, aggColumnIndexes, aggInstances, aggMinPeriods, aggPrecedingWindows, aggFollowingWindows, aggPrecedingWindowsUnbounded, aggFollowingWindowsUnbounded, this.groupByOptions.getIgnoreNullKeys()));){
                    ColumnVector[] finalCols = new ColumnVector[windowAggregates.length];
                    int inputColumn = 0;
                    for (ColumnWindowOps ops : groupedOps.values()) {
                        for (List<Integer> indices : ops.outputIndices()) {
                            for (int outIndex : indices) {
                                finalCols[outIndex] = aggregate.getColumn(inputColumn);
                            }
                            ++inputColumn;
                        }
                    }
                    Table table = new Table(finalCols);
                    return table;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Aggregation.close(aggInstances);
            }
        }

        public ContiguousTable[] contiguousSplitGroups() {
            return Table.contiguousSplitGroups(this.operation.table.nativeHandle, this.operation.indices, this.groupByOptions.getIgnoreNullKeys(), this.groupByOptions.getKeySorted(), this.groupByOptions.getKeysDescending(), this.groupByOptions.getKeysNullSmallest());
        }

        @Deprecated
        public Table aggregateWindowsOverTimeRanges(AggregationOverWindow ... windowAggregates) {
            return this.aggregateWindowsOverRanges(windowAggregates);
        }
    }

    private static final class ColumnWindowOps {
        private final HashMap<AggregationOverWindow, List<Integer>> ops = new HashMap();

        private ColumnWindowOps() {
        }

        public int add(AggregationOverWindow op, int index) {
            int ret = 0;
            List<Integer> indexes = this.ops.get(op);
            if (indexes == null) {
                ++ret;
                indexes = new ArrayList<Integer>();
                this.ops.put(op, indexes);
            }
            indexes.add(index);
            return ret;
        }

        public Set<AggregationOverWindow> operations() {
            return this.ops.keySet();
        }

        public Collection<List<Integer>> outputIndices() {
            return this.ops.values();
        }
    }

    private static final class ColumnOps {
        private final HashMap<Aggregation, List<Integer>> ops = new HashMap();

        private ColumnOps() {
        }

        public int add(Aggregation op, int index) {
            int ret = 0;
            List<Integer> indexes = this.ops.get(op);
            if (indexes == null) {
                ++ret;
                indexes = new ArrayList<Integer>();
                this.ops.put(op, indexes);
            }
            indexes.add(index);
            return ret;
        }

        public Set<Aggregation> operations() {
            return this.ops.keySet();
        }

        public Collection<List<Integer>> outputIndices() {
            return this.ops.values();
        }
    }

    private static final class Operation {
        final int[] indices;
        final Table table;

        Operation(Table table, int ... indices) {
            this.indices = indices;
            this.table = table;
        }
    }

    private static class ArrowIPCStreamedTableReader
    implements StreamedTableReader {
        private final ArrowIPCOptions.NeedGpu callback;
        private long handle;
        private ArrowReaderWrapper provider;

        private ArrowIPCStreamedTableReader(ArrowIPCOptions options, File inputFile) {
            this.provider = null;
            this.handle = Table.readArrowIPCFileBegin(inputFile.getAbsolutePath());
            this.callback = options.getCallback();
        }

        private ArrowIPCStreamedTableReader(ArrowIPCOptions options, HostBufferProvider provider) {
            this.provider = new ArrowReaderWrapper(provider);
            this.handle = Table.readArrowIPCBufferBegin(this.provider);
            this.callback = options.getCallback();
        }

        @Override
        public Table getNextIfAvailable() throws CudfException {
            return this.getNextIfAvailable(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Table getNextIfAvailable(int rowTarget) throws CudfException {
            long arrowTableHandle = Table.readArrowIPCChunkToArrowTable(this.handle, rowTarget);
            try {
                if (arrowTableHandle == 0L) {
                    Table table = null;
                    return table;
                }
                this.callback.needTheGpu();
                Table table = new Table(Table.convertArrowTableToCudf(arrowTableHandle));
                return table;
            }
            finally {
                Table.closeArrowTable(arrowTableHandle);
            }
        }

        @Override
        public void close() throws CudfException {
            if (this.handle != 0L) {
                Table.readArrowIPCEnd(this.handle);
            }
            this.handle = 0L;
            if (this.provider != null) {
                this.provider.close();
                this.provider = null;
            }
        }
    }

    private static class ArrowReaderWrapper
    implements AutoCloseable {
        private HostBufferProvider provider;
        private HostMemoryBuffer buffer;

        private ArrowReaderWrapper(HostBufferProvider provider) {
            this.provider = provider;
            this.buffer = HostMemoryBuffer.allocate(0xA00000L, false);
        }

        public long readInto(long dstAddress, long amount) {
            long totalRead = 0L;
            long amountLeft = amount;
            while (amountLeft > 0L) {
                long amountToCopy = Math.min(amountLeft, this.buffer.length);
                long amountRead = this.provider.readInto(this.buffer, amountToCopy);
                this.buffer.copyToMemory(totalRead + dstAddress, amountRead);
                amountLeft -= amountRead;
                totalRead += amountRead;
                if (amountRead >= amountToCopy) continue;
                amountLeft = 0L;
            }
            return totalRead;
        }

        @Override
        public void close() {
            if (this.provider != null) {
                this.provider.close();
                this.provider = null;
            }
            if (this.buffer != null) {
                this.buffer.close();
                this.buffer = null;
            }
        }
    }

    private static class ArrowIPCTableWriter
    implements TableWriter {
        private final ArrowIPCWriterOptions.DoneOnGpu callback;
        private long handle;
        private HostBufferConsumer consumer;
        private long maxChunkSize;

        private ArrowIPCTableWriter(ArrowIPCWriterOptions options, File outputFile) {
            this.callback = options.getCallback();
            this.consumer = null;
            this.maxChunkSize = options.getMaxChunkSize();
            this.handle = Table.writeArrowIPCFileBegin(options.getColumnNames(), outputFile.getAbsolutePath());
        }

        private ArrowIPCTableWriter(ArrowIPCWriterOptions options, HostBufferConsumer consumer) {
            this.callback = options.getCallback();
            this.consumer = consumer;
            this.maxChunkSize = options.getMaxChunkSize();
            this.handle = Table.writeArrowIPCBufferBegin(options.getColumnNames(), consumer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(Table table) {
            if (this.handle == 0L) {
                throw new IllegalStateException("Writer was already closed");
            }
            long arrowHandle = Table.convertCudfToArrowTable(this.handle, table.nativeHandle);
            try {
                this.callback.doneWithTheGpu(table);
                Table.writeArrowIPCArrowChunk(this.handle, arrowHandle, this.maxChunkSize);
            }
            finally {
                Table.closeArrowTable(arrowHandle);
            }
        }

        @Override
        public void close() throws CudfException {
            if (this.handle != 0L) {
                Table.writeArrowIPCEnd(this.handle);
            }
            this.handle = 0L;
            if (this.consumer != null) {
                this.consumer.done();
                this.consumer = null;
            }
        }
    }

    private static class ORCTableWriter
    implements TableWriter {
        private long handle;
        HostBufferConsumer consumer;

        private ORCTableWriter(ORCWriterOptions options, File outputFile) {
            this.handle = Table.writeORCFileBegin(options.getColumnNames(), options.getColumnNullability(), options.getMetadataKeys(), options.getMetadataValues(), options.getCompressionType().nativeId, outputFile.getAbsolutePath());
            this.consumer = null;
        }

        private ORCTableWriter(ORCWriterOptions options, HostBufferConsumer consumer) {
            this.handle = Table.writeORCBufferBegin(options.getColumnNames(), options.getColumnNullability(), options.getMetadataKeys(), options.getMetadataValues(), options.getCompressionType().nativeId, consumer);
            this.consumer = consumer;
        }

        @Override
        public void write(Table table) {
            if (this.handle == 0L) {
                throw new IllegalStateException("Writer was already closed");
            }
            Table.writeORCChunk(this.handle, table.nativeHandle, table.getDeviceMemorySize());
        }

        @Override
        public void close() throws CudfException {
            if (this.handle != 0L) {
                Table.writeORCEnd(this.handle);
            }
            this.handle = 0L;
            if (this.consumer != null) {
                this.consumer.done();
                this.consumer = null;
            }
        }
    }

    private static class ParquetTableWriter
    implements TableWriter {
        private long handle;
        HostBufferConsumer consumer;

        private ParquetTableWriter(ParquetWriterOptions options, File outputFile) {
            String[] columnNames = options.getFlatColumnNames();
            boolean[] columnNullabilities = options.getFlatIsNullable();
            boolean[] timeInt96Values = options.getFlatIsTimeTypeInt96();
            int[] precisions = options.getFlatPrecision();
            int[] flatNumChildren = options.getFlatNumChildren();
            this.consumer = null;
            this.handle = Table.writeParquetFileBegin(columnNames, options.getTopLevelChildren(), flatNumChildren, columnNullabilities, options.getMetadataKeys(), options.getMetadataValues(), options.getCompressionType().nativeId, options.getStatisticsFrequency().nativeId, timeInt96Values, precisions, outputFile.getAbsolutePath());
        }

        private ParquetTableWriter(ParquetWriterOptions options, HostBufferConsumer consumer) {
            String[] columnNames = options.getFlatColumnNames();
            boolean[] columnNullabilities = options.getFlatIsNullable();
            boolean[] timeInt96Values = options.getFlatIsTimeTypeInt96();
            int[] precisions = options.getFlatPrecision();
            int[] flatNumChildren = options.getFlatNumChildren();
            this.consumer = consumer;
            this.handle = Table.writeParquetBufferBegin(columnNames, options.getTopLevelChildren(), flatNumChildren, columnNullabilities, options.getMetadataKeys(), options.getMetadataValues(), options.getCompressionType().nativeId, options.getStatisticsFrequency().nativeId, timeInt96Values, precisions, consumer);
        }

        @Override
        public void write(Table table) {
            if (this.handle == 0L) {
                throw new IllegalStateException("Writer was already closed");
            }
            Table.writeParquetChunk(this.handle, table.nativeHandle, table.getDeviceMemorySize());
        }

        @Override
        public void close() throws CudfException {
            if (this.handle != 0L) {
                Table.writeParquetEnd(this.handle);
            }
            this.handle = 0L;
            if (this.consumer != null) {
                this.consumer.done();
                this.consumer = null;
            }
        }
    }
}

