/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

public enum UnaryOp {
    SIN(0),
    COS(1),
    TAN(2),
    ARCSIN(3),
    ARCCOS(4),
    ARCTAN(5),
    SINH(6),
    COSH(7),
    TANH(8),
    ARCSINH(9),
    ARCCOSH(10),
    ARCTANH(11),
    EXP(12),
    LOG(13),
    SQRT(14),
    CBRT(15),
    CEIL(16),
    FLOOR(17),
    ABS(18),
    RINT(19),
    BIT_INVERT(20),
    NOT(21);

    private static final UnaryOp[] OPS;
    final int nativeId;

    private UnaryOp(int nativeId) {
        this.nativeId = nativeId;
    }

    static UnaryOp fromNative(int nativeId) {
        for (UnaryOp type : OPS) {
            if (type.nativeId != nativeId) continue;
            return type;
        }
        throw new IllegalArgumentException("Could not translate " + nativeId + " into a UnaryOp");
    }

    static {
        OPS = UnaryOp.values();
    }
}

