/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.Scalar;

public class WindowOptions
implements AutoCloseable {
    private final int minPeriods;
    private final Scalar precedingScalar;
    private final Scalar followingScalar;
    private final ColumnVector precedingCol;
    private final ColumnVector followingCol;
    private final int orderByColumnIndex;
    private final boolean orderByOrderAscending;
    private final FrameType frameType;
    private final boolean isUnboundedPreceding;
    private final boolean isUnboundedFollowing;

    private WindowOptions(Builder builder) {
        this.minPeriods = builder.minPeriods;
        this.precedingScalar = builder.precedingScalar;
        if (this.precedingScalar != null) {
            this.precedingScalar.incRefCount();
        }
        this.followingScalar = builder.followingScalar;
        if (this.followingScalar != null) {
            this.followingScalar.incRefCount();
        }
        this.precedingCol = builder.precedingCol;
        if (this.precedingCol != null) {
            this.precedingCol.incRefCount();
        }
        this.followingCol = builder.followingCol;
        if (this.followingCol != null) {
            this.followingCol.incRefCount();
        }
        this.orderByColumnIndex = builder.orderByColumnIndex;
        this.orderByOrderAscending = builder.orderByOrderAscending;
        this.frameType = this.orderByColumnIndex == -1 ? FrameType.ROWS : FrameType.RANGE;
        this.isUnboundedPreceding = builder.isUnboundedPreceding;
        this.isUnboundedFollowing = builder.isUnboundedFollowing;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof WindowOptions) {
            boolean ret;
            WindowOptions o = (WindowOptions)other;
            boolean bl = ret = this.minPeriods == o.minPeriods && this.orderByColumnIndex == o.orderByColumnIndex && this.orderByOrderAscending == o.orderByOrderAscending && this.frameType == o.frameType && this.isUnboundedPreceding == o.isUnboundedPreceding && this.isUnboundedFollowing == o.isUnboundedFollowing;
            if (this.precedingCol != null) {
                boolean bl2 = ret = ret && this.precedingCol.equals(o.precedingCol);
            }
            if (this.followingCol != null) {
                boolean bl3 = ret = ret && this.followingCol.equals(o.followingCol);
            }
            if (this.precedingScalar != null) {
                boolean bl4 = ret = ret && this.precedingScalar.equals(o.precedingScalar);
            }
            if (this.followingScalar != null) {
                ret = ret && this.followingScalar.equals(o.followingScalar);
            }
            return ret;
        }
        return false;
    }

    public int hashCode() {
        int ret = 7;
        ret = 31 * ret + this.minPeriods;
        ret = 31 * ret + this.orderByColumnIndex;
        ret = 31 * ret + Boolean.hashCode(this.orderByOrderAscending);
        ret = 31 * ret + this.frameType.hashCode();
        if (this.precedingCol != null) {
            ret = 31 * ret + this.precedingCol.hashCode();
        }
        if (this.followingCol != null) {
            ret = 31 * ret + this.followingCol.hashCode();
        }
        if (this.precedingScalar != null) {
            ret = 31 * ret + this.precedingScalar.hashCode();
        }
        if (this.followingScalar != null) {
            ret = 31 * ret + this.followingScalar.hashCode();
        }
        ret = 31 * ret + Boolean.hashCode(this.isUnboundedPreceding);
        ret = 31 * ret + Boolean.hashCode(this.isUnboundedFollowing);
        return ret;
    }

    public static Builder builder() {
        return new Builder();
    }

    int getMinPeriods() {
        return this.minPeriods;
    }

    Scalar getPrecedingScalar() {
        return this.precedingScalar;
    }

    Scalar getFollowingScalar() {
        return this.followingScalar;
    }

    ColumnVector getPrecedingCol() {
        return this.precedingCol;
    }

    ColumnVector getFollowingCol() {
        return this.followingCol;
    }

    @Deprecated
    int getTimestampColumnIndex() {
        return this.getOrderByColumnIndex();
    }

    int getOrderByColumnIndex() {
        return this.orderByColumnIndex;
    }

    @Deprecated
    boolean isTimestampOrderAscending() {
        return this.isOrderByOrderAscending();
    }

    boolean isOrderByOrderAscending() {
        return this.orderByOrderAscending;
    }

    boolean isUnboundedPreceding() {
        return this.isUnboundedPreceding;
    }

    boolean isUnboundedFollowing() {
        return this.isUnboundedFollowing;
    }

    FrameType getFrameType() {
        return this.frameType;
    }

    public synchronized WindowOptions incRefCount() {
        if (this.precedingScalar != null) {
            this.precedingScalar.incRefCount();
        }
        if (this.followingScalar != null) {
            this.followingScalar.incRefCount();
        }
        if (this.precedingCol != null) {
            this.precedingCol.incRefCount();
        }
        if (this.followingCol != null) {
            this.followingCol.incRefCount();
        }
        return this;
    }

    @Override
    public void close() {
        if (this.precedingScalar != null) {
            this.precedingScalar.close();
        }
        if (this.followingScalar != null) {
            this.followingScalar.close();
        }
        if (this.precedingCol != null) {
            this.precedingCol.close();
        }
        if (this.followingCol != null) {
            this.followingCol.close();
        }
    }

    public static class Builder {
        private int minPeriods = 1;
        private Scalar precedingScalar = null;
        private Scalar followingScalar = null;
        private ColumnVector precedingCol = null;
        private ColumnVector followingCol = null;
        private int orderByColumnIndex = -1;
        private boolean orderByOrderAscending = true;
        private boolean isUnboundedPreceding = false;
        private boolean isUnboundedFollowing = false;

        public Builder minPeriods(int minPeriods) {
            if (minPeriods < 0) {
                throw new IllegalArgumentException("Minimum observations must be non negative");
            }
            this.minPeriods = minPeriods;
            return this;
        }

        public Builder window(ColumnVector precedingCol, ColumnVector followingCol) {
            if (precedingCol == null || precedingCol.hasNulls()) {
                throw new IllegalArgumentException("preceding cannot be null or have nulls");
            }
            if (followingCol == null || followingCol.hasNulls()) {
                throw new IllegalArgumentException("following cannot be null or have nulls");
            }
            if (this.isUnboundedPreceding || this.precedingScalar != null) {
                throw new IllegalStateException("preceding has already been set a different way");
            }
            if (this.isUnboundedFollowing || this.followingScalar != null) {
                throw new IllegalStateException("following has already been set a different way");
            }
            this.precedingCol = precedingCol;
            this.followingCol = followingCol;
            return this;
        }

        public Builder window(Scalar precedingScalar, Scalar followingScalar) {
            return this.preceding(precedingScalar).following(followingScalar);
        }

        @Deprecated
        public Builder timestampColumnIndex(int index) {
            return this.orderByColumnIndex(index);
        }

        public Builder orderByColumnIndex(int index) {
            this.orderByColumnIndex = index;
            return this;
        }

        @Deprecated
        public Builder timestampAscending() {
            return this.orderByAscending();
        }

        public Builder orderByAscending() {
            this.orderByOrderAscending = true;
            return this;
        }

        public Builder orderByDescending() {
            this.orderByOrderAscending = false;
            return this;
        }

        @Deprecated
        public Builder timestampDescending() {
            return this.orderByDescending();
        }

        public Builder unboundedPreceding() {
            if (this.precedingCol != null || this.precedingScalar != null) {
                throw new IllegalStateException("preceding has already been set a different way");
            }
            this.isUnboundedPreceding = true;
            return this;
        }

        public Builder unboundedFollowing() {
            if (this.followingCol != null || this.followingScalar != null) {
                throw new IllegalStateException("following has already been set a different way");
            }
            this.isUnboundedFollowing = true;
            return this;
        }

        public Builder preceding(Scalar preceding) {
            if (preceding == null || !preceding.isValid()) {
                throw new IllegalArgumentException("preceding cannot be null");
            }
            if (this.isUnboundedPreceding || this.precedingCol != null) {
                throw new IllegalStateException("preceding has already been set a different way");
            }
            this.precedingScalar = preceding;
            return this;
        }

        public Builder following(Scalar following) {
            if (following == null || !following.isValid()) {
                throw new IllegalArgumentException("following cannot be null");
            }
            if (this.isUnboundedFollowing || this.followingCol != null) {
                throw new IllegalStateException("following has already been set a different way");
            }
            this.followingScalar = following;
            return this;
        }

        public WindowOptions build() {
            return new WindowOptions(this);
        }
    }

    static enum FrameType {
        ROWS,
        RANGE;

    }
}

