/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class WriterOptions {
    private final String[] columnNames;
    private final boolean[] columnNullability;

    <T extends WriterBuilder> WriterOptions(T builder) {
        this.columnNames = builder.columnNames.toArray(new String[builder.columnNames.size()]);
        this.columnNullability = new boolean[builder.columnNullability.size()];
        for (int i = 0; i < builder.columnNullability.size(); ++i) {
            this.columnNullability[i] = builder.columnNullability.get(i);
        }
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public boolean[] getColumnNullability() {
        return this.columnNullability;
    }

    protected static class WriterBuilder<T extends WriterBuilder> {
        final List<String> columnNames = new ArrayList<String>();
        final List<Boolean> columnNullability = new ArrayList<Boolean>();

        protected WriterBuilder() {
        }

        public T withColumnNames(String ... columnNames) {
            this.columnNames.addAll(Arrays.asList(columnNames));
            for (int i = 0; i < columnNames.length; ++i) {
                this.columnNullability.add(true);
            }
            return (T)this;
        }

        public T withNotNullableColumnNames(String ... columnNames) {
            this.columnNames.addAll(Arrays.asList(columnNames));
            for (int i = 0; i < columnNames.length; ++i) {
                this.columnNullability.add(false);
            }
            return (T)this;
        }
    }
}

