/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf.nvcomp;

import ai.rapids.cudf.BaseDeviceMemoryBuffer;
import ai.rapids.cudf.Cuda;
import ai.rapids.cudf.DeviceMemoryBuffer;
import ai.rapids.cudf.HostMemoryBuffer;
import ai.rapids.cudf.nvcomp.NvcompJni;

public class BatchedLZ4Compressor {
    public static long getTempSize(BaseDeviceMemoryBuffer[] inputs, long chunkSize) {
        if (chunkSize <= 0L) {
            throw new IllegalArgumentException("Illegal chunk size: " + chunkSize);
        }
        int numBuffers = inputs.length;
        long[] inputAddrs = new long[numBuffers];
        long[] inputSizes = new long[numBuffers];
        for (int i = 0; i < numBuffers; ++i) {
            BaseDeviceMemoryBuffer buffer = inputs[i];
            inputAddrs[i] = buffer.getAddress();
            inputSizes[i] = buffer.getLength();
        }
        return NvcompJni.batchedLZ4CompressGetTempSize(inputAddrs, inputSizes, chunkSize);
    }

    public static long[] getOutputSizes(BaseDeviceMemoryBuffer[] inputs, long chunkSize, BaseDeviceMemoryBuffer tempBuffer) {
        if (chunkSize <= 0L) {
            throw new IllegalArgumentException("Illegal chunk size: " + chunkSize);
        }
        int numBuffers = inputs.length;
        long[] inputAddrs = new long[numBuffers];
        long[] inputSizes = new long[numBuffers];
        for (int i = 0; i < numBuffers; ++i) {
            BaseDeviceMemoryBuffer buffer = inputs[i];
            inputAddrs[i] = buffer.getAddress();
            inputSizes[i] = buffer.getLength();
        }
        return NvcompJni.batchedLZ4CompressGetOutputSize(inputAddrs, inputSizes, chunkSize, tempBuffer.getAddress(), tempBuffer.getLength());
    }

    public static long getCompressedSizesBufferSize(int numBuffers) {
        return numBuffers * 8;
    }

    public static void compressAsync(HostMemoryBuffer compressedSizesOutputBuffer, BaseDeviceMemoryBuffer[] inputs, long chunkSize, BaseDeviceMemoryBuffer tempBuffer, BaseDeviceMemoryBuffer[] outputs, Cuda.Stream stream) {
        if (chunkSize <= 0L) {
            throw new IllegalArgumentException("Illegal chunk size: " + chunkSize);
        }
        int numBuffers = inputs.length;
        if (outputs.length != numBuffers) {
            throw new IllegalArgumentException("buffer count mismatch, " + numBuffers + " inputs and " + outputs.length + " outputs");
        }
        if (compressedSizesOutputBuffer.getLength() < BatchedLZ4Compressor.getCompressedSizesBufferSize(numBuffers)) {
            throw new IllegalArgumentException("compressed output size buffer must be able to hold at least 8 bytes per buffer, size is only " + compressedSizesOutputBuffer.getLength());
        }
        long[] inputAddrs = new long[numBuffers];
        long[] inputSizes = new long[numBuffers];
        for (int i = 0; i < numBuffers; ++i) {
            BaseDeviceMemoryBuffer buffer = inputs[i];
            inputAddrs[i] = buffer.getAddress();
            inputSizes[i] = buffer.getLength();
        }
        long[] outputAddrs = new long[numBuffers];
        long[] outputSizes = new long[numBuffers];
        for (int i = 0; i < numBuffers; ++i) {
            BaseDeviceMemoryBuffer buffer = outputs[i];
            outputAddrs[i] = buffer.getAddress();
            outputSizes[i] = buffer.getLength();
        }
        NvcompJni.batchedLZ4CompressAsync(compressedSizesOutputBuffer.getAddress(), inputAddrs, inputSizes, chunkSize, tempBuffer.getAddress(), tempBuffer.getLength(), outputAddrs, outputSizes, stream.getStream());
    }

    /*
     * Exception decompiling
     */
    public static BatchedCompressionResult compress(BaseDeviceMemoryBuffer[] inputs, long chunkSize, Cuda.Stream stream) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class BatchedCompressionResult {
        private final DeviceMemoryBuffer[] compressedBuffers;
        private final long[] compressedSizes;

        BatchedCompressionResult(DeviceMemoryBuffer[] buffers, long[] sizes) {
            this.compressedBuffers = buffers;
            this.compressedSizes = sizes;
        }

        public DeviceMemoryBuffer[] getCompressedBuffers() {
            return this.compressedBuffers;
        }

        public long[] getCompressedSizes() {
            return this.compressedSizes;
        }
    }
}

