/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf.nvcomp;

import ai.rapids.cudf.BaseDeviceMemoryBuffer;
import ai.rapids.cudf.Cuda;
import ai.rapids.cudf.MemoryCleaner;
import ai.rapids.cudf.nvcomp.NvcompJni;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Decompressor {
    private static final Logger log = LoggerFactory.getLogger(Decompressor.class);

    public static Metadata getMetadata(BaseDeviceMemoryBuffer buffer, Cuda.Stream stream) {
        long metadata = NvcompJni.decompressGetMetadata(buffer.getAddress(), buffer.getLength(), stream.getStream());
        return new Metadata(metadata);
    }

    public static long getTempSize(Metadata metadata) {
        return NvcompJni.decompressGetTempSize(metadata.getMetadata());
    }

    public static long getOutputSize(Metadata metadata) {
        return NvcompJni.decompressGetOutputSize(metadata.getMetadata());
    }

    public static void decompressAsync(BaseDeviceMemoryBuffer input, BaseDeviceMemoryBuffer tempBuffer, Metadata metadata, BaseDeviceMemoryBuffer output, Cuda.Stream stream) {
        NvcompJni.decompressAsync(input.getAddress(), input.getLength(), tempBuffer.getAddress(), tempBuffer.getLength(), metadata.getMetadata(), output.getAddress(), output.getLength(), stream.getStream());
    }

    public static boolean isLZ4Data(BaseDeviceMemoryBuffer buffer) {
        return NvcompJni.isLZ4Data(buffer.getAddress(), buffer.getLength());
    }

    public static class Metadata
    implements AutoCloseable {
        private final MetadataCleaner cleaner;
        private final long id;
        private boolean closed = false;

        Metadata(long metadata) {
            this.cleaner = new MetadataCleaner(metadata);
            this.id = this.cleaner.id;
            MemoryCleaner.register(this, (MemoryCleaner.Cleaner)this.cleaner);
            this.cleaner.addRef();
        }

        long getMetadata() {
            return this.cleaner.metadata;
        }

        public boolean isLZ4Metadata() {
            return NvcompJni.isLZ4Metadata(this.getMetadata());
        }

        @Override
        public synchronized void close() {
            if (this.closed) {
                this.cleaner.logRefCountDebug("double free " + this);
                throw new IllegalStateException("Close called too many times " + this);
            }
            this.cleaner.delRef();
            this.cleaner.clean(false);
            this.closed = true;
        }

        public String toString() {
            return "DECOMPRESSOR METADATA (ID: " + this.id + " " + Long.toHexString(this.cleaner.metadata) + ")";
        }

        private static class MetadataCleaner
        extends MemoryCleaner.Cleaner {
            private long metadata;

            MetadataCleaner(long metadata) {
                this.metadata = metadata;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected synchronized boolean cleanImpl(boolean logErrorIfNotClean) {
                boolean neededCleanup = false;
                long address = this.metadata;
                if (this.metadata != 0L) {
                    try {
                        NvcompJni.decompressDestroyMetadata(this.metadata);
                    }
                    finally {
                        this.metadata = 0L;
                    }
                    neededCleanup = true;
                }
                if (neededCleanup && logErrorIfNotClean) {
                    log.error("DECOMPRESSOR METADATA WAS LEAKED (Address: " + Long.toHexString(address) + ")");
                    this.logRefCountDebug("Leaked event");
                }
                return neededCleanup;
            }

            @Override
            public boolean isClean() {
                return this.metadata != 0L;
            }
        }
    }
}

