/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf.nvcomp;

import ai.rapids.cudf.BaseDeviceMemoryBuffer;
import ai.rapids.cudf.Cuda;
import ai.rapids.cudf.HostMemoryBuffer;
import ai.rapids.cudf.nvcomp.CompressionType;
import ai.rapids.cudf.nvcomp.NvcompJni;

public class LZ4Compressor {
    public static long getTempSize(BaseDeviceMemoryBuffer input, CompressionType inputType, long chunkSize) {
        if (chunkSize <= 0L) {
            throw new IllegalArgumentException("Illegal chunk size: " + chunkSize);
        }
        return NvcompJni.lz4CompressGetTempSize(input.getAddress(), input.getLength(), inputType.nativeId, chunkSize);
    }

    public static long getOutputSize(BaseDeviceMemoryBuffer input, CompressionType inputType, long chunkSize, BaseDeviceMemoryBuffer tempBuffer) {
        if (chunkSize <= 0L) {
            throw new IllegalArgumentException("Illegal chunk size: " + chunkSize);
        }
        return NvcompJni.lz4CompressGetOutputSize(input.getAddress(), input.getLength(), inputType.nativeId, chunkSize, tempBuffer.getAddress(), tempBuffer.getLength(), false);
    }

    public static long compress(BaseDeviceMemoryBuffer input, CompressionType inputType, long chunkSize, BaseDeviceMemoryBuffer tempBuffer, BaseDeviceMemoryBuffer output, Cuda.Stream stream) {
        if (chunkSize <= 0L) {
            throw new IllegalArgumentException("Illegal chunk size: " + chunkSize);
        }
        return NvcompJni.lz4Compress(input.getAddress(), input.getLength(), inputType.nativeId, chunkSize, tempBuffer.getAddress(), tempBuffer.getLength(), output.getAddress(), output.getLength(), stream.getStream());
    }

    public static void compressAsync(HostMemoryBuffer compressedSizeOutputBuffer, BaseDeviceMemoryBuffer input, CompressionType inputType, long chunkSize, BaseDeviceMemoryBuffer tempBuffer, BaseDeviceMemoryBuffer output, Cuda.Stream stream) {
        if (chunkSize <= 0L) {
            throw new IllegalArgumentException("Illegal chunk size: " + chunkSize);
        }
        if (compressedSizeOutputBuffer.getLength() < 8L) {
            throw new IllegalArgumentException("compressed output size buffer must be able to hold at least 8 bytes, size is only " + compressedSizeOutputBuffer.getLength());
        }
        NvcompJni.lz4CompressAsync(compressedSizeOutputBuffer.getAddress(), input.getAddress(), input.getLength(), inputType.nativeId, chunkSize, tempBuffer.getAddress(), tempBuffer.getLength(), output.getAddress(), output.getLength(), stream.getStream());
    }
}

