/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.scala.spark.rapids;

import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.Scalar;
import java.lang.reflect.Method;
import java.util.Locale;
import ml.dmlc.xgboost4j.java.XGBoostSparkJNI;
import ml.dmlc.xgboost4j.java.spark.rapids.GpuColumnBatch;
import ml.dmlc.xgboost4j.java.spark.rapids.PartitionReaderFactory;
import ml.dmlc.xgboost4j.scala.spark.rapids.ColumnBatchToRow;
import ml.dmlc.xgboost4j.scala.spark.rapids.FilePartitionReaderFactory;
import ml.dmlc.xgboost4j.scala.spark.rapids.GpuCSVPartitionReaderFactory;
import ml.dmlc.xgboost4j.scala.spark.rapids.GpuDataset;
import ml.dmlc.xgboost4j.scala.spark.rapids.GpuOrcPartitionReaderFactory;
import ml.dmlc.xgboost4j.scala.spark.rapids.GpuParquetPartitionReaderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SerializableWritable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.FilePartition;
import org.apache.spark.sql.execution.datasources.FilePartition$;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Double$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.WrappedString;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class GpuDataset$ {
    public static final GpuDataset$ MODULE$;
    private final Log ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$logger;

    static {
        new GpuDataset$();
    }

    public Log ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$logger() {
        return this.ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$logger;
    }

    public <R> Tuple2<R, Object> time(String phase, Function0<R> block) {
        long t0 = System.currentTimeMillis();
        Object result = block.apply();
        long t1 = System.currentTimeMillis();
        return new Tuple2(result, (Object)BoxesRunTime.boxToFloat((float)((float)(t1 - t0) / (float)1000)));
    }

    public <U> Function1<Iterator<GpuColumnBatch>, Iterator<U>> ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$getBatchMapper(Function1<Iterator<GpuColumnBatch>, Iterator<U>> func, ClassTag<U> evidence$2) {
        return new Serializable(func){
            public static final long serialVersionUID = 0L;
            private final Function1 func$1;

            public final Iterator<U> apply(Iterator<GpuColumnBatch> batchIter) {
                return (Iterator)this.func$1.apply(batchIter);
            }
            {
                this.func$1 = func$1;
            }
        };
    }

    public Seq<PartitionedFile> getFiles(FilePartition fp) {
        Seq seq;
        Object object = fp.getClass().getMethod("files", new Class[0]).invoke((Object)fp, new Object[0]);
        if (object instanceof PartitionedFile[]) {
            PartitionedFile[] partitionedFileArray = (PartitionedFile[])object;
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])partitionedFileArray));
        } else {
            seq = (Seq)object;
        }
        return seq;
    }

    public Function1<Iterator<GpuColumnBatch>, Iterator<Object>> ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$maxDoubleMapper(int columnIndex) {
        return new Serializable(columnIndex){
            public static final long serialVersionUID = 0L;
            private final int columnIndex$1;

            public final Iterator<Object> apply(Iterator<GpuColumnBatch> iter) {
                int gpuId = XGBoostSparkJNI.allocateGpuDevice();
                GpuDataset$.MODULE$.ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$logger().debug((Object)new StringBuilder().append((Object)"XGboost maxDoubleMapper get device: ").append((Object)BoxesRunTime.boxToInteger((int)gpuId)).toString());
                double max = Double$.MODULE$.MinValue();
                while (iter.hasNext()) {
                    GpuColumnBatch b = (GpuColumnBatch)iter.next();
                    ColumnVector column = b.getColumnVector(this.columnIndex$1);
                    Scalar scalar = column.max();
                    if (!scalar.isValid()) continue;
                    double tmp = scalar.getDouble();
                    max = max < tmp ? tmp : max;
                }
                return max != Double$.MODULE$.MinValue() ? package$.MODULE$.Iterator().single((Object)BoxesRunTime.boxToDouble((double)max)) : package$.MODULE$.Iterator().empty();
            }
            {
                this.columnIndex$1 = columnIndex$1;
            }
        };
    }

    public StructType numericAsFloats(StructType schema) {
        return new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final StructField apply(StructField x0$5) {
                StructField structField = x0$5;
                if (structField == null) return structField;
                String name = structField.name();
                DataType nt = structField.dataType();
                boolean nullable = structField.nullable();
                Metadata metadata = structField.metadata();
                if (!(nt instanceof NumericType)) return structField;
                return new StructField(name, (DataType)FloatType$.MODULE$, nullable, metadata);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
    }

    public PartitionReaderFactory ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$getPartFileReader(SparkSession sparkSession, Broadcast<SerializableWritable<Configuration>> broadcastedConf, String sourceType, StructType schema, Map<String, String> options, boolean castAllToFloats, StructType castSchema, Integer maxRowsPerChunk) {
        block5: {
            FilePartitionReaderFactory filePartitionReaderFactory;
            block3: {
                String string;
                String dumpPrefix;
                block4: {
                    block2: {
                        dumpPrefix = sparkSession.sessionState().conf().getConfString("spark.rapids.splits.debug-dump-prefix", null);
                        string = sourceType;
                        if (!"csv".equals(string)) break block2;
                        filePartitionReaderFactory = new GpuCSVPartitionReaderFactory(sparkSession.sessionState().conf(), broadcastedConf, schema, schema, new StructType(), options, castAllToFloats, maxRowsPerChunk);
                        break block3;
                    }
                    if (!"parquet".equals(string)) break block4;
                    filePartitionReaderFactory = new GpuParquetPartitionReaderFactory(sparkSession.sessionState().conf(), broadcastedConf, schema, schema, new StructType(), (Filter[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Filter.class)), castAllToFloats, castSchema, dumpPrefix, maxRowsPerChunk);
                    break block3;
                }
                if (!"orc".equals(string)) break block5;
                filePartitionReaderFactory = new GpuOrcPartitionReaderFactory(sparkSession.sessionState().conf(), broadcastedConf, schema, schema, new StructType(), (Filter[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Filter.class)), castAllToFloats, castSchema, dumpPrefix, maxRowsPerChunk);
            }
            return filePartitionReaderFactory;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported source type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourceType})));
    }

    public char toChar(String str) throws IllegalArgumentException {
        char c;
        WrappedString wrappedString;
        block15: {
            int n;
            block7: {
                block14: {
                    Some some;
                    block13: {
                        Some some2;
                        block12: {
                            Some some3;
                            block11: {
                                Some some4;
                                block10: {
                                    Some some5;
                                    block9: {
                                        Some some6;
                                        block8: {
                                            block6: {
                                                int c2;
                                                char c3;
                                                wrappedString = Predef$.MODULE$.wrapString(str);
                                                Some some7 = Seq$.MODULE$.unapplySeq((Seq)wrappedString);
                                                if (!some7.isEmpty() && some7.get() != null && ((SeqLike)some7.get()).lengthCompare(0) == 0) {
                                                    throw new IllegalArgumentException("Delimiter cannot be empty string");
                                                }
                                                Some some8 = Seq$.MODULE$.unapplySeq((Seq)wrappedString);
                                                if (!some8.isEmpty() && some8.get() != null && ((SeqLike)some8.get()).lengthCompare(1) == 0 && '\\' == (c3 = BoxesRunTime.unboxToChar((Object)((SeqLike)some8.get()).apply(0)))) {
                                                    throw new IllegalArgumentException("Single backslash is prohibited. It has special meaning as beginning of an escape sequence. To get the backslash character, pass a string with two backslashes as the delimiter.");
                                                }
                                                Some some9 = Seq$.MODULE$.unapplySeq((Seq)wrappedString);
                                                if (some9.isEmpty() || some9.get() == null || ((SeqLike)some9.get()).lengthCompare(1) != 0) break block6;
                                                n = c2 = BoxesRunTime.unboxToChar((Object)((SeqLike)some9.get()).apply(0));
                                                break block7;
                                            }
                                            Some some10 = Seq$.MODULE$.unapplySeq((Seq)wrappedString);
                                            if (some10.isEmpty() || some10.get() == null || ((SeqLike)some10.get()).lengthCompare(2) != 0) break block8;
                                            char c4 = BoxesRunTime.unboxToChar((Object)((SeqLike)some10.get()).apply(0));
                                            char c5 = BoxesRunTime.unboxToChar((Object)((SeqLike)some10.get()).apply(1));
                                            if ('\\' != c4 || 't' != c5) break block8;
                                            n = 9;
                                            break block7;
                                        }
                                        if ((some6 = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() || some6.get() == null || ((SeqLike)some6.get()).lengthCompare(2) != 0) break block9;
                                        char c6 = BoxesRunTime.unboxToChar((Object)((SeqLike)some6.get()).apply(0));
                                        char c7 = BoxesRunTime.unboxToChar((Object)((SeqLike)some6.get()).apply(1));
                                        if ('\\' != c6 || 'r' != c7) break block9;
                                        n = 13;
                                        break block7;
                                    }
                                    if ((some5 = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() || some5.get() == null || ((SeqLike)some5.get()).lengthCompare(2) != 0) break block10;
                                    char c8 = BoxesRunTime.unboxToChar((Object)((SeqLike)some5.get()).apply(0));
                                    char c9 = BoxesRunTime.unboxToChar((Object)((SeqLike)some5.get()).apply(1));
                                    if ('\\' != c8 || 'b' != c9) break block10;
                                    n = 8;
                                    break block7;
                                }
                                if ((some4 = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() || some4.get() == null || ((SeqLike)some4.get()).lengthCompare(2) != 0) break block11;
                                char c10 = BoxesRunTime.unboxToChar((Object)((SeqLike)some4.get()).apply(0));
                                char c11 = BoxesRunTime.unboxToChar((Object)((SeqLike)some4.get()).apply(1));
                                if ('\\' != c10 || 'f' != c11) break block11;
                                n = 12;
                                break block7;
                            }
                            if ((some3 = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() || some3.get() == null || ((SeqLike)some3.get()).lengthCompare(2) != 0) break block12;
                            char c12 = BoxesRunTime.unboxToChar((Object)((SeqLike)some3.get()).apply(0));
                            char c13 = BoxesRunTime.unboxToChar((Object)((SeqLike)some3.get()).apply(1));
                            if ('\\' != c12 || '\"' != c13) break block12;
                            n = 34;
                            break block7;
                        }
                        if ((some2 = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() || some2.get() == null || ((SeqLike)some2.get()).lengthCompare(2) != 0) break block13;
                        char c14 = BoxesRunTime.unboxToChar((Object)((SeqLike)some2.get()).apply(0));
                        char c15 = BoxesRunTime.unboxToChar((Object)((SeqLike)some2.get()).apply(1));
                        if ('\\' != c14 || '\'' != c15) break block13;
                        n = 39;
                        break block7;
                    }
                    if ((some = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block14;
                    char c16 = BoxesRunTime.unboxToChar((Object)((SeqLike)some.get()).apply(0));
                    char c17 = BoxesRunTime.unboxToChar((Object)((SeqLike)some.get()).apply(1));
                    if ('\\' != c16 || '\\' != c17) break block14;
                    n = 92;
                    break block7;
                }
                String string = str;
                String string2 = "\u0000";
                if (string != null ? !string.equals(string2) : string2 != null) break block15;
                n = 0;
            }
            return (char)n;
        }
        Some some = Seq$.MODULE$.unapplySeq((Seq)wrappedString);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0 && '\\' == (c = BoxesRunTime.unboxToChar((Object)((SeqLike)some.get()).apply(0)))) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported special character for delimiter: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str})));
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Delimiter cannot be more than one character: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str})));
    }

    public boolean getBool(String paramName, String paramVal) {
        block4: {
            boolean bl;
            block3: {
                String lowerParamVal;
                block2: {
                    String string = lowerParamVal = paramVal.toLowerCase(Locale.ROOT);
                    String string2 = "true";
                    if (string != null ? !string.equals(string2) : string2 != null) break block2;
                    bl = true;
                    break block3;
                }
                String string = lowerParamVal;
                String string3 = "false";
                if (string != null ? !string.equals(string3) : string3 != null) break block4;
                bl = false;
            }
            return bl;
        }
        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " flag can be true or false"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{paramName})));
    }

    public FilePartition ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$createFilePartition(int size, Seq<PartitionedFile> files) {
        FilePartition filePartition;
        try {
            filePartition = new FilePartition(size, files);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$logger().debug((Object)"FilePartition, normal Apache Spark version failed");
            try {
                Method fpClass = FilePartition$.MODULE$.getClass().getMethod("apply", Integer.TYPE, Seq.class, Seq.class);
                filePartition = (FilePartition)fpClass.invoke((Object)FilePartition$.MODULE$, new Integer(size), files, Seq$.MODULE$.empty());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Method fpClass = FilePartition$.MODULE$.getClass().getMethod("apply", Integer.TYPE, PartitionedFile[].class);
                filePartition = (FilePartition)fpClass.invoke((Object)FilePartition$.MODULE$, new Integer(size), Array$.MODULE$.apply(files, ClassTag$.MODULE$.apply(PartitionedFile.class)));
            }
        }
        return filePartition;
    }

    public Function1<Iterator<GpuColumnBatch>, Iterator<Tuple2<Object, Object>>> getColumnRowNumberMapper() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterator<Tuple2<Object, Object>> apply(Iterator<GpuColumnBatch> iter) {
                long totalRows = 0L;
                int columns = 0;
                boolean isFirstBunch = true;
                while (iter.hasNext()) {
                    GpuColumnBatch batch = (GpuColumnBatch)iter.next();
                    totalRows += batch.getNumRows();
                    if (!isFirstBunch) continue;
                    isFirstBunch = false;
                    columns = batch.getNumColumns();
                }
                return isFirstBunch ? package$.MODULE$.Iterator().empty() : package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcIJ.sp(columns, totalRows)}));
            }
        };
    }

    public Function1<Iterator<GpuColumnBatch>, Iterator<Row>> columnBatchToRows() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterator<Row> apply(Iterator<GpuColumnBatch> iter) {
                ColumnBatchToRow columnBatchToRow = new ColumnBatchToRow();
                while (iter.hasNext()) {
                    GpuColumnBatch batch = (GpuColumnBatch)iter.next();
                    columnBatchToRow.appendColumnBatch(batch);
                }
                return columnBatchToRow.toIterator();
            }
        };
    }

    public Option<Seq<FilePartition>> $lessinit$greater$default$6() {
        return None$.MODULE$;
    }

    private GpuDataset$() {
        MODULE$ = this;
        this.ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$logger = LogFactory.getLog(GpuDataset.class);
    }
}

