/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.apache.orc.impl.writer;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.shaded.apache.orc.TypeDescription;
import org.shaded.apache.orc.impl.Utf8Utils;
import org.shaded.apache.orc.impl.writer.StringBaseTreeWriter;
import org.shaded.apache.orc.impl.writer.WriterContext;
import org.shaded.apache.orc.storage.ql.exec.vector.BytesColumnVector;
import org.shaded.apache.orc.storage.ql.exec.vector.ColumnVector;

public class CharTreeWriter
extends StringBaseTreeWriter {
    private final int maxLength;
    private final byte[] padding;

    CharTreeWriter(int columnId, TypeDescription schema, WriterContext writer, boolean nullable) throws IOException {
        super(columnId, schema, writer, nullable);
        this.maxLength = schema.getMaxLength();
        this.padding = new byte[6 * this.maxLength];
    }

    @Override
    public void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
        super.writeBatch(vector, offset, length);
        BytesColumnVector vec = (BytesColumnVector)vector;
        if (vector.isRepeating) {
            if (vector.noNulls || !vector.isNull[0]) {
                this.writePadded(vec, 0, length);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                if (!vec.noNulls && vec.isNull[i + offset]) continue;
                this.writePadded(vec, i + offset, 1);
            }
        }
    }

    private void writePadded(BytesColumnVector vec, int row, int repeats) throws IOException {
        int ptrLength;
        int ptrOffset;
        byte[] ptr;
        int charLength = Utf8Utils.charLength(vec.vector[row], vec.start[row], vec.length[row]);
        if (charLength >= this.maxLength) {
            ptr = vec.vector[row];
            ptrOffset = vec.start[row];
            ptrLength = Utf8Utils.truncateBytesTo(this.maxLength, vec.vector[row], vec.start[row], vec.length[row]);
        } else {
            ptr = this.padding;
            ptrLength = vec.length[row] + (this.maxLength - charLength);
            ptrOffset = 0;
            System.arraycopy(vec.vector[row], vec.start[row], ptr, 0, vec.length[row]);
            Arrays.fill(ptr, vec.length[row], ptrLength, (byte)32);
        }
        if (this.useDictionaryEncoding) {
            int id = this.dictionary.add(ptr, ptrOffset, ptrLength);
            for (int i = 0; i < repeats; ++i) {
                this.rows.add(id);
            }
        } else {
            for (int i = 0; i < repeats; ++i) {
                this.directStreamOutput.write(ptr, ptrOffset, ptrLength);
                this.lengthOutput.write(ptrLength);
            }
        }
        this.indexStatistics.updateString(ptr, ptrOffset, ptrLength, repeats);
        if (this.createBloomFilter) {
            if (this.bloomFilter != null) {
                this.bloomFilter.addString(new String(ptr, ptrOffset, ptrLength, StandardCharsets.UTF_8));
            }
            this.bloomFilterUtf8.addBytes(ptr, ptrOffset, ptrLength);
        }
    }
}

