/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.apache.orc.mapreduce;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.shaded.apache.orc.OrcFile;
import org.shaded.apache.orc.Writer;
import org.shaded.apache.orc.mapreduce.OrcMapreduceRecordWriter;

public class OrcOutputFormat<V extends Writable>
extends FileOutputFormat<NullWritable, V> {
    private static final String EXTENSION = ".orc";
    public static final String SKIP_TEMP_DIRECTORY = "orc.mapreduce.output.skip-temporary-directory";

    public RecordWriter<NullWritable, V> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException {
        Configuration conf = taskAttemptContext.getConfiguration();
        Path filename = this.getDefaultWorkFile(taskAttemptContext, EXTENSION);
        Writer writer = OrcFile.createWriter(filename, org.shaded.apache.orc.mapred.OrcOutputFormat.buildOptions(conf));
        return new OrcMapreduceRecordWriter(writer);
    }

    public Path getDefaultWorkFile(TaskAttemptContext context, String extension2) throws IOException {
        if (context.getConfiguration().getBoolean(SKIP_TEMP_DIRECTORY, false)) {
            return new Path(OrcOutputFormat.getOutputPath((JobContext)context), OrcOutputFormat.getUniqueFile((TaskAttemptContext)context, (String)OrcOutputFormat.getOutputName((JobContext)context), (String)extension2));
        }
        return super.getDefaultWorkFile(context, extension2);
    }
}

