/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.apache.thrift.transport;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.shaded.apache.thrift.transport.TTransport;
import org.shaded.apache.thrift.transport.TTransportException;

public final class TSimpleFileTransport
extends TTransport {
    private RandomAccessFile file = null;
    private boolean readable;
    private boolean writable;
    private String path_;

    public TSimpleFileTransport(String path, boolean read, boolean write, boolean openFile) throws TTransportException {
        if (path.length() <= 0) {
            throw new TTransportException("No path specified");
        }
        if (!read && !write) {
            throw new TTransportException("Neither READ nor WRITE specified");
        }
        this.readable = read;
        this.writable = write;
        this.path_ = path;
        if (openFile) {
            this.open();
        }
    }

    public TSimpleFileTransport(String path, boolean read, boolean write) throws TTransportException {
        this(path, read, write, true);
    }

    public TSimpleFileTransport(String path) throws TTransportException {
        this(path, true, false, true);
    }

    public boolean isOpen() {
        return this.file != null;
    }

    public void open() throws TTransportException {
        if (this.file == null) {
            try {
                String access = "r";
                if (this.writable) {
                    access = access + "w";
                }
                this.file = new RandomAccessFile(this.path_, access);
            }
            catch (IOException ioe) {
                this.file = null;
                throw new TTransportException(ioe.getMessage());
            }
        }
    }

    public void close() {
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.file = null;
        }
    }

    public int read(byte[] buf, int off, int len) throws TTransportException {
        if (!this.readable) {
            throw new TTransportException("Read operation on write only file");
        }
        int iBytesRead = 0;
        try {
            iBytesRead = this.file.read(buf, off, len);
        }
        catch (IOException ioe) {
            this.file = null;
            throw new TTransportException(ioe.getMessage());
        }
        return iBytesRead;
    }

    public void write(byte[] buf, int off, int len) throws TTransportException {
        try {
            this.file.write(buf, off, len);
        }
        catch (IOException ioe) {
            this.file = null;
            throw new TTransportException(ioe.getMessage());
        }
    }

    public void seek(long offset) throws TTransportException {
        try {
            this.file.seek(offset);
        }
        catch (IOException ex) {
            throw new TTransportException(ex.getMessage());
        }
    }

    public long length() throws TTransportException {
        try {
            return this.file.length();
        }
        catch (IOException ex) {
            throw new TTransportException(ex.getMessage());
        }
    }

    public long getFilePointer() throws TTransportException {
        try {
            return this.file.getFilePointer();
        }
        catch (IOException ex) {
            throw new TTransportException(ex.getMessage());
        }
    }
}

