/*
 * Decompiled with CFR 0.152.
 */
package ai.rev.languageid;

import ai.rev.helpers.ClientHelper;
import ai.rev.languageid.LanguageIdInterface;
import ai.rev.languageid.models.LanguageIdJob;
import ai.rev.languageid.models.LanguageIdJobOptions;
import ai.rev.languageid.models.LanguageIdResult;
import ai.rev.speechtotext.FileStreamRequestBody;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import retrofit2.Retrofit;

public class LanguageIdClient {
    private OkHttpClient client;
    public LanguageIdInterface apiInterface;

    public LanguageIdClient(String accessToken) {
        if (accessToken == null || accessToken.isEmpty()) {
            throw new IllegalArgumentException("Access token must be provided");
        }
        this.client = ClientHelper.createOkHttpClient(accessToken);
        Retrofit retrofit = ClientHelper.createRetrofitInstance(this.client, "languageid", "v1");
        this.apiInterface = (LanguageIdInterface)retrofit.create(LanguageIdInterface.class);
    }

    public void closeConnection() {
        this.client.dispatcher().executorService().shutdown();
        this.client.connectionPool().evictAll();
    }

    public List<LanguageIdJob> getListOfJobs(Integer limit, String startingAfter) throws IOException {
        HashMap<String, String> options = new HashMap<String, String>();
        if (startingAfter != null) {
            options.put("starting_after", startingAfter);
        }
        if (limit != null) {
            options.put("limit", String.valueOf(limit));
        }
        return (List)this.apiInterface.getListOfJobs(options).execute().body();
    }

    public List<LanguageIdJob> getListOfJobs(Integer limit) throws IOException {
        return this.getListOfJobs(limit, null);
    }

    public List<LanguageIdJob> getListOfJobs(String startingAfter) throws IOException {
        return this.getListOfJobs(null, startingAfter);
    }

    public List<LanguageIdJob> getListOfJobs() throws IOException {
        return this.getListOfJobs(null, null);
    }

    public LanguageIdJob getJobDetails(String id) throws IOException {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Job ID must be provided");
        }
        return (LanguageIdJob)this.apiInterface.getJobDetails(id).execute().body();
    }

    public void deleteJob(String id) throws IOException {
        if (id == null) {
            throw new IllegalArgumentException("Job ID must be provided");
        }
        this.apiInterface.deleteJob(id).execute();
    }

    public LanguageIdResult getResultObject(String id) throws IOException {
        return (LanguageIdResult)this.apiInterface.getResultObject(id).execute().body();
    }

    public LanguageIdJob submitJob(LanguageIdJobOptions options) throws IOException {
        return (LanguageIdJob)this.apiInterface.submitJob(options).execute().body();
    }

    public LanguageIdJob submitJobLocalFile(String filePath, LanguageIdJobOptions options) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException("File path must be provided");
        }
        if (options == null) {
            options = new LanguageIdJobOptions();
        }
        File file = new File(filePath);
        return this.submitMultipartRequest(new FileInputStream(file.getAbsoluteFile()), file.getName(), options);
    }

    public LanguageIdJob submitJobLocalFile(InputStream inputStream, String fileName, LanguageIdJobOptions options) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("File stream must be provided");
        }
        if (options == null) {
            options = new LanguageIdJobOptions();
        }
        if (fileName == null) {
            fileName = "audio_file";
        }
        return this.submitMultipartRequest(inputStream, fileName, options);
    }

    public LanguageIdJob submitJobLocalFile(InputStream inputStream) throws IOException {
        return this.submitJobLocalFile(inputStream, null, null);
    }

    public LanguageIdJob submitJobLocalFile(InputStream inputStream, String fileName) throws IOException {
        return this.submitJobLocalFile(inputStream, fileName, null);
    }

    public LanguageIdJob submitJobLocalFile(InputStream inputStream, LanguageIdJobOptions options) throws IOException {
        return this.submitJobLocalFile(inputStream, null, options);
    }

    private LanguageIdJob submitMultipartRequest(InputStream inputStream, String fileName, LanguageIdJobOptions options) throws IOException {
        RequestBody fileRequest = FileStreamRequestBody.create(inputStream, MediaType.parse((String)"audio/*"));
        MultipartBody.Part filePart = MultipartBody.Part.createFormData((String)"media", (String)fileName, (RequestBody)fileRequest);
        return (LanguageIdJob)this.apiInterface.submitJobLocalFile(filePart, options).execute().body();
    }
}

