/*
 * Decompiled with CFR 0.152.
 */
package ai.salmonbrain.ruleofthumb;

import ai.salmonbrain.ruleofthumb.BaseStatTest;
import ai.salmonbrain.ruleofthumb.BaseStatTest$class;
import ai.salmonbrain.ruleofthumb.CI;
import ai.salmonbrain.ruleofthumb.CentralTendency$;
import ai.salmonbrain.ruleofthumb.StatResult;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.stat.descriptive.rank.Median;
import org.apache.commons.math3.stat.inference.MannWhitneyUTest;
import scala.Predef$;
import scala.math.Ordering;
import scala.math.package$;

public final class MannWhitneyTest$
implements BaseStatTest {
    public static final MannWhitneyTest$ MODULE$;
    private final Median median;
    private final NormalDistribution normalDistribution;
    private final double EPS;

    static {
        new MannWhitneyTest$();
    }

    @Override
    public NormalDistribution normalDistribution() {
        return this.normalDistribution;
    }

    @Override
    public double EPS() {
        return this.EPS;
    }

    @Override
    public void ai$salmonbrain$ruleofthumb$BaseStatTest$_setter_$normalDistribution_$eq(NormalDistribution x$1) {
        this.normalDistribution = x$1;
    }

    @Override
    public void ai$salmonbrain$ruleofthumb$BaseStatTest$_setter_$EPS_$eq(double x$1) {
        this.EPS = x$1;
    }

    @Override
    public long sampleSizeEstimation() {
        return BaseStatTest$class.sampleSizeEstimation(this);
    }

    @Override
    public double square(double x) {
        return BaseStatTest$class.square(this, x);
    }

    public Median median() {
        return this.median;
    }

    public StatResult mannWhitneyTest(double[] control, double[] treatment, double alpha, double beta) {
        Predef$.MODULE$.assert(alpha < 1.0);
        MannWhitneyUTest mannWhitneyUTest = new MannWhitneyUTest();
        double uStatistic = mannWhitneyUTest.mannWhitneyU(control, treatment);
        double pValue = mannWhitneyUTest.mannWhitneyUTest(control, treatment);
        double controlMedian = this.median().evaluate(control);
        double treatmentMedian = this.median().evaluate(treatment);
        double treatmentMedianVariance = this.medianVariance(treatment);
        double controlMedianVariance = this.medianVariance(control);
        double std = package$.MODULE$.sqrt(treatmentMedianVariance + controlMedianVariance);
        int size = package$.MODULE$.max(control.length, treatment.length);
        CI ci = new CI(controlMedian, controlMedianVariance, treatmentMedian, treatmentMedianVariance, std, this.normalDistribution().inverseCumulativeProbability(alpha / (double)2), this.normalDistribution().inverseCumulativeProbability(1.0 - alpha / (double)2), size);
        long sampleSize = this.sampleSizeEstimation(alpha, beta, treatmentMedian, controlMedian, treatment.length, control.length);
        return new StatResult(uStatistic, pValue, sampleSize, controlMedian, treatmentMedian, controlMedianVariance, treatmentMedianVariance, ci.lowerPercent(), ci.upperPercent(), CentralTendency$.MODULE$.MEDIAN().toString());
    }

    public double medianVariance(double[] values) {
        double[] sorted = (double[])Predef$.MODULE$.doubleArrayOps(values).sorted((Ordering)Ordering.Double$.MODULE$);
        double y1 = sorted[sorted.length - this.alpha(sorted.length)];
        double y2 = sorted[this.alpha(sorted.length) - 1];
        double zed = this.zeta(sorted.length);
        return this.square(y1 - y2) / ((double)4 * this.square(zed));
    }

    private int alpha(int length) {
        return (int)package$.MODULE$.round(((double)length + 1.0) / (double)2 - package$.MODULE$.sqrt((double)length));
    }

    private double aBinomial(int length) {
        return new BinomialDistribution(length, 0.5).cumulativeProbability(this.alpha(length) - 1) * (double)2;
    }

    private double zeta(int length) {
        return this.normalDistribution().inverseCumulativeProbability(1.0 - this.aBinomial(length) / (double)2);
    }

    public long sampleSizeEstimation(double alpha, double beta, double medianTreatment, double medianControl, int treatmentSize, int controlSize) {
        double nominator = package$.MODULE$.ceil(this.square(this.normalDistribution().inverseCumulativeProbability(1.0 - alpha / (double)2) + this.normalDistribution().inverseCumulativeProbability(1.0 - beta)));
        double denominator = this.square(medianTreatment - medianControl) / (double)(treatmentSize + controlSize);
        return (long)(nominator / denominator);
    }

    private MannWhitneyTest$() {
        MODULE$ = this;
        BaseStatTest$class.$init$(this);
        this.median = new Median();
    }
}

