/*
 * Decompiled with CFR 0.152.
 */
package ai.salmonbrain.ruleofthumb;

import ai.salmonbrain.inputs.AccessLogTransformer;
import ai.salmonbrain.inputs.ClickhouseDataSource$;
import ai.salmonbrain.inputs.CsvHelper$;
import ai.salmonbrain.inputs.NginxRawLogTransformer;
import ai.salmonbrain.ruleofthumb.AccessLogConfig;
import ai.salmonbrain.ruleofthumb.AutoStatisticsTransformer;
import ai.salmonbrain.ruleofthumb.ClickhouseConfig;
import ai.salmonbrain.ruleofthumb.Config;
import ai.salmonbrain.ruleofthumb.CumulativeMetricTransformer;
import ai.salmonbrain.ruleofthumb.Input$;
import ai.salmonbrain.ruleofthumb.OutlierRemoveTransformer;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.Transformer;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Enumeration;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;

public final class ReportBuilder$ {
    public static final ReportBuilder$ MODULE$;

    static {
        new ReportBuilder$();
    }

    public Dataset<Row> buildReport(Config config, SparkSession spark) {
        Enumeration.Value value;
        block7: {
            Dataset<Row> dataset;
            block6: {
                block5: {
                    value = config.input();
                    Enumeration.Value value2 = Input$.MODULE$.Files();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block5;
                    dataset = this.readFiles(spark, config);
                    break block6;
                }
                Enumeration.Value value4 = Input$.MODULE$.Clickhouse();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block7;
                dataset = this.readClickhouse(spark, config);
            }
            Dataset<Row> events = dataset;
            Option<AccessLogConfig> option = config.accessLog();
            if (option instanceof Some) {
                AccessLogConfig value6;
                AccessLogConfig accessLogConfig;
                Some some = (Some)option;
                AccessLogConfig accessLogConfig2 = accessLogConfig = (value6 = (AccessLogConfig)some.x());
                AccessLogTransformer accessLogTransformer = new AccessLogTransformer();
                accessLogTransformer.setexperimentUidExpression(accessLogConfig2.experimentUid());
                accessLogTransformer.setMetricNameExpression(accessLogConfig2.metricName());
                accessLogTransformer.setMetricValueExpression(accessLogConfig2.metricValue());
                accessLogTransformer.setVariantIdExpression(accessLogConfig2.variantId());
                Pipeline statPipeline = new Pipeline().setStages((PipelineStage[])new Transformer[]{accessLogTransformer, new CumulativeMetricTransformer().setNumeratorNames((String[])((Object[])new String[]{"clicks"})).setDenominatorNames((String[])((Object[])new String[]{"views"})).setRatioNames((String[])((Object[])new String[]{"ctr"})), new OutlierRemoveTransformer(), new AutoStatisticsTransformer()});
                return statPipeline.fit(events).transform(events);
            }
            if (None$.MODULE$.equals(option)) {
                throw new IllegalArgumentException("Access log config required");
            }
            throw new MatchError(option);
        }
        throw new MatchError((Object)value);
    }

    public Dataset<Row> readFiles(SparkSession spark, Config config) {
        Predef$.MODULE$.assert(config.files().nonEmpty());
        Dataset<Row> csv = CsvHelper$.MODULE$.readCsv(spark, config.files());
        return new NginxRawLogTransformer().transform(csv);
    }

    public Dataset<Row> readClickhouse(SparkSession spark, Config config) {
        Predef$.MODULE$.assert(config.clickhouse() != null);
        ClickhouseDataSource$ source = ClickhouseDataSource$.MODULE$;
        return source.readData(spark, (ClickhouseConfig)config.clickhouse().get());
    }

    private ReportBuilder$() {
        MODULE$ = this;
    }
}

