/*
 * Decompiled with CFR 0.152.
 */
package ai.salmonbrain.ruleofthumb;

import ai.salmonbrain.ruleofthumb.BaseStatTest;
import ai.salmonbrain.ruleofthumb.BaseStatTest$class;
import ai.salmonbrain.ruleofthumb.CI;
import ai.salmonbrain.ruleofthumb.DescriptiveStat;
import ai.salmonbrain.ruleofthumb.StatResult;
import ai.salmonbrain.ruleofthumb.StatResult$;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.moment.Variance;
import org.apache.spark.sql.Row;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class WelchTTest$
implements BaseStatTest {
    public static final WelchTTest$ MODULE$;
    private Mean mean;
    private Variance variance;
    private final NormalDistribution normalDistribution;
    private final double EPS;
    private volatile byte bitmap$0;

    static {
        new WelchTTest$();
    }

    private Mean mean$lzycompute() {
        WelchTTest$ welchTTest$ = this;
        synchronized (welchTTest$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.mean = new Mean();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.mean;
        }
    }

    private Variance variance$lzycompute() {
        WelchTTest$ welchTTest$ = this;
        synchronized (welchTTest$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.variance = new Variance();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.variance;
        }
    }

    @Override
    public NormalDistribution normalDistribution() {
        return this.normalDistribution;
    }

    @Override
    public double EPS() {
        return this.EPS;
    }

    @Override
    public void ai$salmonbrain$ruleofthumb$BaseStatTest$_setter_$normalDistribution_$eq(NormalDistribution x$1) {
        this.normalDistribution = x$1;
    }

    @Override
    public void ai$salmonbrain$ruleofthumb$BaseStatTest$_setter_$EPS_$eq(double x$1) {
        this.EPS = x$1;
    }

    @Override
    public long sampleSizeEstimation() {
        return BaseStatTest$class.sampleSizeEstimation(this);
    }

    @Override
    public double square(double x) {
        return BaseStatTest$class.square(this, x);
    }

    public Mean mean() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.mean$lzycompute() : this.mean;
    }

    public Variance variance() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.variance$lzycompute() : this.variance;
    }

    public StatResult welchTTest(double[] control, double[] treatment, double alpha, double beta) {
        DescriptiveStat controlData = new DescriptiveStat(this.mean().evaluate(control), this.variance().evaluate(control), control.length);
        DescriptiveStat treatmentData = new DescriptiveStat(this.mean().evaluate(treatment), this.variance().evaluate(treatment), treatment.length);
        return this.welchTTest(controlData, treatmentData, alpha, beta);
    }

    public StatResult welchTTest(DescriptiveStat controlData, DescriptiveStat treatmentData, double alpha, double beta) {
        Predef$.MODULE$.assert(alpha < 1.0 && alpha > 0.0);
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(controlData.variance(), treatmentData.variance());
        if (sp2 != null) {
            Tuple2.mcDD.sp sp3;
            double controlVariance = sp2._1$mcD$sp();
            double treatmentVariance = sp2._2$mcD$sp();
            Tuple2.mcDD.sp sp4 = sp3 = new Tuple2.mcDD.sp(controlVariance, treatmentVariance);
            double controlVariance2 = sp4._1$mcD$sp();
            double treatmentVariance2 = sp4._2$mcD$sp();
            Tuple2.mcJJ.sp sp5 = new Tuple2.mcJJ.sp(controlData.length(), treatmentData.length());
            if (sp5 != null) {
                Tuple2.mcJJ.sp sp6;
                long controlSampleSize = sp5._1$mcJ$sp();
                long treatmentSampleSize = sp5._2$mcJ$sp();
                Tuple2.mcJJ.sp sp7 = sp6 = new Tuple2.mcJJ.sp(controlSampleSize, treatmentSampleSize);
                long controlSampleSize2 = sp7._1$mcJ$sp();
                long treatmentSampleSize2 = sp7._2$mcJ$sp();
                Tuple2.mcDD.sp sp8 = new Tuple2.mcDD.sp(controlData.mean(), treatmentData.mean());
                if (sp8 != null) {
                    StatResult statResult;
                    Tuple2.mcDD.sp sp9;
                    double controlMean = sp8._1$mcD$sp();
                    double treatmentMean = sp8._2$mcD$sp();
                    Tuple2.mcDD.sp sp10 = sp9 = new Tuple2.mcDD.sp(controlMean, treatmentMean);
                    double controlMean2 = sp10._1$mcD$sp();
                    double treatmentMean2 = sp10._2$mcD$sp();
                    Tuple2.mcDD.sp sp11 = new Tuple2.mcDD.sp(controlVariance2, treatmentVariance2);
                    if (sp11._1$mcD$sp() < this.EPS() || sp11._2$mcD$sp() < this.EPS()) {
                        statResult = new StatResult(Double.NaN, Double.NaN, 0L, controlMean2, treatmentMean2, controlVariance2, treatmentVariance2, Double.NaN, Double.NaN, StatResult$.MODULE$.apply$default$10());
                    } else {
                        double qt = controlVariance2 / (double)controlSampleSize2 + treatmentVariance2 / (double)treatmentSampleSize2;
                        double std = package$.MODULE$.sqrt(qt);
                        double t = (controlMean2 - treatmentMean2) / std;
                        double df = this.square(qt) / (this.square(controlVariance2) / (this.square(controlSampleSize2) * (double)(controlSampleSize2 - 1L)) + this.square(treatmentVariance2) / (this.square(treatmentSampleSize2) * (double)(treatmentSampleSize2 - 1L)));
                        TDistribution tDistribution = new TDistribution(df);
                        double p = 2.0 * tDistribution.cumulativeProbability(-package$.MODULE$.abs(t));
                        long size = package$.MODULE$.max(controlSampleSize2, treatmentSampleSize2);
                        CI ci = new CI(controlMean2, controlVariance2, treatmentMean2, treatmentVariance2, std, tDistribution.inverseCumulativeProbability(alpha / (double)2), tDistribution.inverseCumulativeProbability(1.0 - alpha / (double)2), size);
                        long sampleSize = this.sampleSizeEstimation(alpha, beta, controlMean2, treatmentMean2, (controlVariance2 + treatmentVariance2) / (double)2);
                        statResult = new StatResult(t, p, sampleSize, controlMean2, treatmentMean2, controlVariance2, treatmentVariance2, ci.lowerPercent(), ci.upperPercent(), StatResult$.MODULE$.apply$default$10());
                    }
                    return statResult;
                }
                throw new MatchError((Object)sp8);
            }
            throw new MatchError((Object)sp5);
        }
        throw new MatchError((Object)sp2);
    }

    public StatResult welchTTest(Row control, Row treatment, double alpha, double beta) {
        DescriptiveStat controlData = new DescriptiveStat(BoxesRunTime.unboxToDouble((Object)control.getAs("mean")), BoxesRunTime.unboxToDouble((Object)control.getAs("variance")), BoxesRunTime.unboxToLong((Object)control.getAs("length")));
        DescriptiveStat treatmentData = new DescriptiveStat(BoxesRunTime.unboxToDouble((Object)treatment.getAs("mean")), BoxesRunTime.unboxToDouble((Object)treatment.getAs("variance")), BoxesRunTime.unboxToLong((Object)treatment.getAs("length")));
        return this.welchTTest(controlData, treatmentData, alpha, beta);
    }

    public long sampleSizeEstimation(double alpha, double beta, double controlCentralTendency, double treatmentCentralTendency, double commonVariance) {
        double nominator = (double)2 * package$.MODULE$.ceil(this.square(this.normalDistribution().inverseCumulativeProbability(1.0 - alpha / (double)2) + this.normalDistribution().inverseCumulativeProbability(1.0 - beta)));
        double denominator = this.square(treatmentCentralTendency - controlCentralTendency) / commonVariance;
        return denominator < this.EPS() ? 0L : (long)(nominator / denominator);
    }

    private WelchTTest$() {
        MODULE$ = this;
        BaseStatTest$class.$init$(this);
    }
}

