package com.scandocai.scandocsdk

import android.graphics.Bitmap

public sealed class ScanDocEvent {
    data class ValidationInProgress(val infoCode: String) : ScanDocEvent()
    object ExtractionInProgress : ScanDocEvent()
    data class Extracted(
        val documentImages: List<Bitmap>?,
        val faceImage: Bitmap?,
        val signatureImage: Bitmap?,
        val fields: Map<ExtractedFieldType, String?>
    ) : ScanDocEvent()
    data class NetworkError(val error: ScanDocEventError) : ScanDocEvent()
}

public enum class ScanDocEventError {
    BadServerResponse,
    UnableToAuthenticate,
    CannotParseResponse,
    BadUrl
}

public enum class ExtractedFieldType(val value: String) {
    Name("Name"),
    Surname("Surname"),
    BirthDate("BirthDate"),
    Gender("Gender"),
    PlaceOfBirth("PlaceOfBirth"),
    Nationality("Nationality"),
    DocumentNumber("DocumentNumber"),
    IssuedDate("IssuedDate"),
    ExpiryDate("ExpiryDate"),
    CountryOfIssue("CountryOfIssue"),
    IssuingAuthority("IssuingAuthority"),
    AddressCountry("AddressCountry"),
    AddressZip("AddressZip"),
    AddressCity("AddressCity"),
    AddressCounty("AddressCounty"),
    AddressStreet("AddressStreet"),
    PersonalIdentificationNumber("PersonalIdentificationNumber"),
    GivenName("GivenName"),
    FamilyName("FamilyName"),
    MothersGivenName("MothersGivenName"),
    MothersFamilyName("MothersFamilyName"),
    SecondLastName("SecondLastName"),
    Address("Address"),
    PlaceOfIssue("PlaceOfIssue"),
    FathersGivenName("FathersGivenName"),
    FathersFamilyName("FathersFamilyName");
}