package com.scandocai.scandocsdk.models

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
internal data class ExtractionRequest(
    @SerialName("AcceptTermsAndConditions") val acceptTermsAndConditions: Boolean,
    @SerialName("DataFields") val dataFields: ExtractionDataFieldsRequest,
    @SerialName("Settings") val settings: ExtractionSettingsRequest
)

@Serializable
internal data class ExtractionDataFieldsRequest(
    @SerialName("FrontImage") val frontImage: String?,
    @SerialName("FrontImageType") val frontImageType: String?,
    @SerialName("FrontImageCropped") val frontImageCropped: Boolean?,
    @SerialName("BackImage") val backImage: String?,
    @SerialName("BackImageType") val backImageType: String?,
    @SerialName("BackImageCropped") val backImageCropped: Boolean?
)

@Serializable
internal data class ExtractionSettingsRequest(
    @SerialName("IgnoreBackImage") val ignoreBackImage: Boolean,
    @SerialName("ShouldReturnDocumentImage") val shouldReturnDocumentImage: Boolean,
    @SerialName("ShouldReturnFaceIfDetected") val shouldReturnFaceIfDetected: Boolean,
    @SerialName("ShouldReturnSignatureIfDetected") val shouldReturnSignatureIfDetected: Boolean,
    @SerialName("SkipDocumentSizeCheck") val skipDocumentsSizeCheck: Boolean,
    @SerialName("SkipImageSizeCheck") val skipImageSizeCheck: Boolean,
    @SerialName("CanStoreImages") val canStoreImages: Boolean,
    @SerialName("EnforceDocsSameCountryTypeSeries") val enforceDocsSameCountryTypeSeries: Boolean,
    @SerialName("CaseSensitiveOutput") val caseSensitiveOutput: Boolean,
//    @SerialName("FaceImageResize") val faceImageResize: String?,
//    @SerialName("SignatureImageResize") val signatureImageResize: String?,
//    @SerialName("SegmentedImageResize") val segmentedImageResize: String?,
    @SerialName("StoreFaceImage") val storeFaceImage: Boolean,
    @SerialName("DontUseValidation") val dontUseValidation: Boolean
)
